// config/predefinedOptions.js

// Daftar region yang ingin Anda tawarkan kepada pengguna.
// 'name' adalah teks yang muncul di tombol, 'slug' adalah ID untuk API.
const ALLOWED_REGIONS = [
    { name: 'Singapore', slug: 'sgp1' },
    { name: 'New York', slug: 'nyc3' },
    { name: 'Frankfurt', slug: 'fra1' },
    { name: 'London', slug: 'lon1' },
    { name: 'Amsterdam', slug: 'ams3' },
    { name: 'Atlanta', slug: 'atl1' },
    { name: 'Bangalore', slug: 'blr1' },
    { name: 'San Francisco', slug: 'sfo2' },
    { name: 'Sydney', slug: 'syd1' },
    { name: 'Toronto', slug: 'tor1' },
];

// Daftar ukuran yang ingin Anda tawarkan.
// price_monthly_usd: Harga asli dari DO.
// price_min_idr: Harga JUAL minimal (1 hari) dalam Rupiah.
// price_max_idr: Harga JUAL maksimal (30 hari) dalam Rupiah.
const ALLOWED_SIZES = [
    // Harga ini adalah default dan bisa diubah oleh admin via bot.
    { slug: 's-2vcpu-2gb', memory: 2048, vcpus: 2, disk: 60, price_monthly_usd: 18.0, price_min_idr: 5000, price_max_idr: 45000 },
    { slug: 's-2vcpu-4gb', memory: 4096, vcpus: 2, disk: 80, price_monthly_usd: 24.0, price_min_idr: 7000, price_max_idr: 65000 },
    { slug: 's-4vcpu-8gb', memory: 8192, vcpus: 4, disk: 160, price_monthly_usd: 48.0, price_min_idr: 8000, price_max_idr: 80000 },
    { slug: 's-4vcpu-16gb-amd', memory: 16384, vcpus: 4, disk: 200, price_monthly_usd: 84.0, price_min_idr: 10000, price_max_idr: 100000 },
];


module.exports = {
    ALLOWED_REGIONS,
    ALLOWED_SIZES
};
