// config/pricing.js

/**
 * Menghitung total harga jual berdasarkan harga minimal (1 hari) dan maksimal (30 hari).
 * Harga dihitung menggunakan interpolasi linear.
 * @param {number} priceMinIdr Harga jual minimal (1 hari) dalam Rupiah.
 * @param {number} priceMaxIdr Harga jual maksimal (30 hari) dalam Rupiah.
 * @param {number} days Jumlah hari.
 * @returns {number} Total harga jual dalam IDR.
 */
function calculateTotalPrice(priceMinIdr, priceMaxIdr, days) {
    if (!priceMinIdr || !priceMaxIdr || !days || days < 1 || days > 30) {
        return 0;
    }

    if (days === 1) {
        return priceMinIdr;
    }
    if (days === 30) {
        return priceMaxIdr;
    }

    // Menghitung kenaikan harga per hari
    const dailyIncrease = (priceMaxIdr - priceMinIdr) / (30 - 1);

    // Menghitung harga untuk durasi yang diminta
    const calculatedPrice = priceMinIdr + ((days - 1) * dailyIncrease);

    // Pembulatan ke ratusan terdekat untuk hasil yang lebih rapi
    return Math.ceil(calculatedPrice / 100) * 100;
}

module.exports = {
    calculateTotalPrice
};
