import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosResponseWithHTTP2, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace discoveryengine_v1 {
    export interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Discovery Engine API
     *
     * Discovery Engine API.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const discoveryengine = google.discoveryengine('v1');
     * ```
     */
    export class Discoveryengine {
        context: APIRequestContext;
        media: Resource$Media;
        projects: Resource$Projects;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * Information to read/write to blobstore2.
     */
    export interface Schema$GdataBlobstore2Info {
        /**
         * The blob generation id.
         */
        blobGeneration?: string | null;
        /**
         * The blob id, e.g., /blobstore/prod/playground/scotty
         */
        blobId?: string | null;
        /**
         * Read handle passed from Bigstore -\> Scotty for a GCS download. This is a signed, serialized blobstore2.ReadHandle proto which must never be set outside of Bigstore, and is not applicable to non-GCS media downloads.
         */
        downloadReadHandle?: string | null;
        /**
         * The blob read token. Needed to read blobs that have not been replicated. Might not be available until the final call.
         */
        readToken?: string | null;
        /**
         * Metadata passed from Blobstore -\> Scotty for a new GCS upload. This is a signed, serialized blobstore2.BlobMetadataContainer proto which must never be consumed outside of Bigstore, and is not applicable to non-GCS media uploads.
         */
        uploadMetadataContainer?: string | null;
    }
    /**
     * A sequence of media data references representing composite data. Introduced to support Bigstore composite objects. For details, visit http://go/bigstore-composites.
     */
    export interface Schema$GdataCompositeMedia {
        /**
         * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info instead. For now, any v2 blob will also be represented in this field as v1 BlobRef.
         */
        blobRef?: string | null;
        /**
         * Blobstore v2 info, set if reference_type is BLOBSTORE_REF and it refers to a v2 blob.
         */
        blobstore2Info?: Schema$GdataBlobstore2Info;
        /**
         * A binary data reference for a media download. Serves as a technology-agnostic binary reference in some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto. Storing it as bytes is a hack to get around the fact that the cosmo proto (as well as others it includes) doesn't support JavaScript. This prevents us from including the actual type of this field.
         */
        cosmoBinaryReference?: string | null;
        /**
         * crc32.c hash for the payload.
         */
        crc32cHash?: number | null;
        /**
         * Media data, set if reference_type is INLINE
         */
        inline?: string | null;
        /**
         * Size of the data, in bytes
         */
        length?: string | null;
        /**
         * MD5 hash for the payload.
         */
        md5Hash?: string | null;
        /**
         * Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
         */
        objectId?: Schema$GdataObjectId;
        /**
         * Path to the data, set if reference_type is PATH
         */
        path?: string | null;
        /**
         * Describes what the field reference contains.
         */
        referenceType?: string | null;
        /**
         * SHA-1 hash for the payload.
         */
        sha1Hash?: string | null;
    }
    /**
     * Detailed Content-Type information from Scotty. The Content-Type of the media will typically be filled in by the header or Scotty's best_guess, but this extended information provides the backend with more information so that it can make a better decision if needed. This is only used on media upload requests from Scotty.
     */
    export interface Schema$GdataContentTypeInfo {
        /**
         * Scotty's best guess of what the content type of the file is.
         */
        bestGuess?: string | null;
        /**
         * The content type of the file derived by looking at specific bytes (i.e. "magic bytes") of the actual file.
         */
        fromBytes?: string | null;
        /**
         * The content type of the file derived from the file extension of the original file name used by the client.
         */
        fromFileName?: string | null;
        /**
         * The content type of the file as specified in the request headers, multipart headers, or RUPIO start request.
         */
        fromHeader?: string | null;
        /**
         * The content type of the file derived from the file extension of the URL path. The URL path is assumed to represent a file name (which is typically only true for agents that are providing a REST API).
         */
        fromUrlPath?: string | null;
    }
    /**
     * Backend response for a Diff get checksums response. For details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
     */
    export interface Schema$GdataDiffChecksumsResponse {
        /**
         * Exactly one of these fields must be populated. If checksums_location is filled, the server will return the corresponding contents to the user. If object_location is filled, the server will calculate the checksums based on the content there and return that to the user. For details on the format of the checksums, see http://go/scotty-diff-protocol.
         */
        checksumsLocation?: Schema$GdataCompositeMedia;
        /**
         * The chunk size of checksums. Must be a multiple of 256KB.
         */
        chunkSizeBytes?: string | null;
        /**
         * If set, calculate the checksums based on the contents and return them to the caller.
         */
        objectLocation?: Schema$GdataCompositeMedia;
        /**
         * The total size of the server object.
         */
        objectSizeBytes?: string | null;
        /**
         * The object version of the object the checksums are being returned for.
         */
        objectVersion?: string | null;
    }
    /**
     * Backend response for a Diff download response. For details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
     */
    export interface Schema$GdataDiffDownloadResponse {
        /**
         * The original object location.
         */
        objectLocation?: Schema$GdataCompositeMedia;
    }
    /**
     * A Diff upload request. For details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
     */
    export interface Schema$GdataDiffUploadRequest {
        /**
         * The location of the checksums for the new object. Agents must clone the object located here, as the upload server will delete the contents once a response is received. For details on the format of the checksums, see http://go/scotty-diff-protocol.
         */
        checksumsInfo?: Schema$GdataCompositeMedia;
        /**
         * The location of the new object. Agents must clone the object located here, as the upload server will delete the contents once a response is received.
         */
        objectInfo?: Schema$GdataCompositeMedia;
        /**
         * The object version of the object that is the base version the incoming diff script will be applied to. This field will always be filled in.
         */
        objectVersion?: string | null;
    }
    /**
     * Backend response for a Diff upload request. For details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
     */
    export interface Schema$GdataDiffUploadResponse {
        /**
         * The object version of the object at the server. Must be included in the end notification response. The version in the end notification response must correspond to the new version of the object that is now stored at the server, after the upload.
         */
        objectVersion?: string | null;
        /**
         * The location of the original file for a diff upload request. Must be filled in if responding to an upload start notification.
         */
        originalObject?: Schema$GdataCompositeMedia;
    }
    /**
     * Backend response for a Diff get version response. For details on the Scotty Diff protocol, visit http://go/scotty-diff-protocol.
     */
    export interface Schema$GdataDiffVersionResponse {
        /**
         * The total size of the server object.
         */
        objectSizeBytes?: string | null;
        /**
         * The version of the object stored at the server.
         */
        objectVersion?: string | null;
    }
    /**
     * Parameters specific to media downloads.
     */
    export interface Schema$GdataDownloadParameters {
        /**
         * A boolean to be returned in the response to Scotty. Allows/disallows gzip encoding of the payload content when the server thinks it's advantageous (hence, does not guarantee compression) which allows Scotty to GZip the response to the client.
         */
        allowGzipCompression?: boolean | null;
        /**
         * Determining whether or not Apiary should skip the inclusion of any Content-Range header on its response to Scotty.
         */
        ignoreRange?: boolean | null;
    }
    /**
     * A reference to data stored on the filesystem, on GFS or in blobstore.
     */
    export interface Schema$GdataMedia {
        /**
         * Deprecated, use one of explicit hash type fields instead. Algorithm used for calculating the hash. As of 2011/01/21, "MD5" is the only possible value for this field. New values may be added at any time.
         */
        algorithm?: string | null;
        /**
         * Use object_id instead.
         */
        bigstoreObjectRef?: string | null;
        /**
         * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info instead. For now, any v2 blob will also be represented in this field as v1 BlobRef.
         */
        blobRef?: string | null;
        /**
         * Blobstore v2 info, set if reference_type is BLOBSTORE_REF and it refers to a v2 blob.
         */
        blobstore2Info?: Schema$GdataBlobstore2Info;
        /**
         * A composite media composed of one or more media objects, set if reference_type is COMPOSITE_MEDIA. The media length field must be set to the sum of the lengths of all composite media objects. Note: All composite media must have length specified.
         */
        compositeMedia?: Schema$GdataCompositeMedia[];
        /**
         * MIME type of the data
         */
        contentType?: string | null;
        /**
         * Extended content type information provided for Scotty uploads.
         */
        contentTypeInfo?: Schema$GdataContentTypeInfo;
        /**
         * A binary data reference for a media download. Serves as a technology-agnostic binary reference in some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto. Storing it as bytes is a hack to get around the fact that the cosmo proto (as well as others it includes) doesn't support JavaScript. This prevents us from including the actual type of this field.
         */
        cosmoBinaryReference?: string | null;
        /**
         * For Scotty Uploads: Scotty-provided hashes for uploads For Scotty Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY TEAM.) A Hash provided by the agent to be used to verify the data being downloaded. Currently only supported for inline payloads. Further, only crc32c_hash is currently supported.
         */
        crc32cHash?: number | null;
        /**
         * Set if reference_type is DIFF_CHECKSUMS_RESPONSE.
         */
        diffChecksumsResponse?: Schema$GdataDiffChecksumsResponse;
        /**
         * Set if reference_type is DIFF_DOWNLOAD_RESPONSE.
         */
        diffDownloadResponse?: Schema$GdataDiffDownloadResponse;
        /**
         * Set if reference_type is DIFF_UPLOAD_REQUEST.
         */
        diffUploadRequest?: Schema$GdataDiffUploadRequest;
        /**
         * Set if reference_type is DIFF_UPLOAD_RESPONSE.
         */
        diffUploadResponse?: Schema$GdataDiffUploadResponse;
        /**
         * Set if reference_type is DIFF_VERSION_RESPONSE.
         */
        diffVersionResponse?: Schema$GdataDiffVersionResponse;
        /**
         * Parameters for a media download.
         */
        downloadParameters?: Schema$GdataDownloadParameters;
        /**
         * Original file name
         */
        filename?: string | null;
        /**
         * Deprecated, use one of explicit hash type fields instead. These two hash related fields will only be populated on Scotty based media uploads and will contain the content of the hash group in the NotificationRequest: http://cs/#google3/blobstore2/api/scotty/service/proto/upload_listener.proto&q=class:Hash Hex encoded hash value of the uploaded media.
         */
        hash?: string | null;
        /**
         * For Scotty uploads only. If a user sends a hash code and the backend has requested that Scotty verify the upload against the client hash, Scotty will perform the check on behalf of the backend and will reject it if the hashes don't match. This is set to true if Scotty performed this verification.
         */
        hashVerified?: boolean | null;
        /**
         * Media data, set if reference_type is INLINE
         */
        inline?: string | null;
        /**
         * |is_potential_retry| is set false only when Scotty is certain that it has not sent the request before. When a client resumes an upload, this field must be set true in agent calls, because Scotty cannot be certain that it has never sent the request before due to potential failure in the session state persistence.
         */
        isPotentialRetry?: boolean | null;
        /**
         * Size of the data, in bytes
         */
        length?: string | null;
        /**
         * Scotty-provided MD5 hash for an upload.
         */
        md5Hash?: string | null;
        /**
         * Media id to forward to the operation GetMedia. Can be set if reference_type is GET_MEDIA.
         */
        mediaId?: string | null;
        /**
         * Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
         */
        objectId?: Schema$GdataObjectId;
        /**
         * Path to the data, set if reference_type is PATH
         */
        path?: string | null;
        /**
         * Describes what the field reference contains.
         */
        referenceType?: string | null;
        /**
         * Scotty-provided SHA1 hash for an upload.
         */
        sha1Hash?: string | null;
        /**
         * Scotty-provided SHA256 hash for an upload.
         */
        sha256Hash?: string | null;
        /**
         * Time at which the media data was last updated, in milliseconds since UNIX epoch
         */
        timestamp?: string | null;
        /**
         * A unique fingerprint/version id for the media data
         */
        token?: string | null;
    }
    /**
     * This is a copy of the tech.blob.ObjectId proto, which could not be used directly here due to transitive closure issues with JavaScript support; see http://b/8801763.
     */
    export interface Schema$GdataObjectId {
        /**
         * The name of the bucket to which this object belongs.
         */
        bucketName?: string | null;
        /**
         * Generation of the object. Generations are monotonically increasing across writes, allowing them to be be compared to determine which generation is newer. If this is omitted in a request, then you are requesting the live object. See http://go/bigstore-versions
         */
        generation?: string | null;
        /**
         * The name of the object.
         */
        objectName?: string | null;
    }
    /**
     * `Distribution` contains summary statistics for a population of values. It optionally contains a histogram representing the distribution of those values across a set of buckets. The summary statistics are the count, mean, sum of the squared deviation from the mean, the minimum, and the maximum of the set of population of values. The histogram is based on a sequence of buckets and gives a count of values that fall into each bucket. The boundaries of the buckets are given either explicitly or by formulas for buckets of fixed or exponentially increasing widths. Although it is not forbidden, it is generally a bad idea to include non-finite values (infinities or NaNs) in the population of values, as this will render the `mean` and `sum_of_squared_deviation` fields meaningless.
     */
    export interface Schema$GoogleApiDistribution {
        /**
         * The number of values in each bucket of the histogram, as described in `bucket_options`. If the distribution does not have a histogram, then omit this field. If there is a histogram, then the sum of the values in `bucket_counts` must equal the value in the `count` field of the distribution. If present, `bucket_counts` should contain N values, where N is the number of buckets specified in `bucket_options`. If you supply fewer than N values, the remaining values are assumed to be 0. The order of the values in `bucket_counts` follows the bucket numbering schemes described for the three bucket types. The first value must be the count for the underflow bucket (number 0). The next N-2 values are the counts for the finite buckets (number 1 through N-2). The N'th value in `bucket_counts` is the count for the overflow bucket (number N-1).
         */
        bucketCounts?: string[] | null;
        /**
         * Defines the histogram bucket boundaries. If the distribution does not contain a histogram, then omit this field.
         */
        bucketOptions?: Schema$GoogleApiDistributionBucketOptions;
        /**
         * The number of values in the population. Must be non-negative. This value must equal the sum of the values in `bucket_counts` if a histogram is provided.
         */
        count?: string | null;
        /**
         * Must be in increasing order of `value` field.
         */
        exemplars?: Schema$GoogleApiDistributionExemplar[];
        /**
         * The arithmetic mean of the values in the population. If `count` is zero then this field must be zero.
         */
        mean?: number | null;
        /**
         * If specified, contains the range of the population values. The field must not be present if the `count` is zero.
         */
        range?: Schema$GoogleApiDistributionRange;
        /**
         * The sum of squared deviations from the mean of the values in the population. For values x_i this is: Sum[i=1..n]((x_i - mean)^2) Knuth, "The Art of Computer Programming", Vol. 2, page 232, 3rd edition describes Welford's method for accumulating this sum in one pass. If `count` is zero then this field must be zero.
         */
        sumOfSquaredDeviation?: number | null;
    }
    /**
     * `BucketOptions` describes the bucket boundaries used to create a histogram for the distribution. The buckets can be in a linear sequence, an exponential sequence, or each bucket can be specified explicitly. `BucketOptions` does not include the number of values in each bucket. A bucket has an inclusive lower bound and exclusive upper bound for the values that are counted for that bucket. The upper bound of a bucket must be strictly greater than the lower bound. The sequence of N buckets for a distribution consists of an underflow bucket (number 0), zero or more finite buckets (number 1 through N - 2) and an overflow bucket (number N - 1). The buckets are contiguous: the lower bound of bucket i (i \> 0) is the same as the upper bound of bucket i - 1. The buckets span the whole range of finite values: lower bound of the underflow bucket is -infinity and the upper bound of the overflow bucket is +infinity. The finite buckets are so-called because both bounds are finite.
     */
    export interface Schema$GoogleApiDistributionBucketOptions {
        /**
         * The explicit buckets.
         */
        explicitBuckets?: Schema$GoogleApiDistributionBucketOptionsExplicit;
        /**
         * The exponential buckets.
         */
        exponentialBuckets?: Schema$GoogleApiDistributionBucketOptionsExponential;
        /**
         * The linear bucket.
         */
        linearBuckets?: Schema$GoogleApiDistributionBucketOptionsLinear;
    }
    /**
     * Specifies a set of buckets with arbitrary widths. There are `size(bounds) + 1` (= N) buckets. Bucket `i` has the following boundaries: Upper bound (0 <= i < N-1): bounds[i] Lower bound (1 <= i < N); bounds[i - 1] The `bounds` field must contain at least one element. If `bounds` has only one element, then there are no finite buckets, and that single element is the common boundary of the overflow and underflow buckets.
     */
    export interface Schema$GoogleApiDistributionBucketOptionsExplicit {
        /**
         * The values must be monotonically increasing.
         */
        bounds?: number[] | null;
    }
    /**
     * Specifies an exponential sequence of buckets that have a width that is proportional to the value of the lower bound. Each bucket represents a constant relative uncertainty on a specific value in the bucket. There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the following boundaries: Upper bound (0 <= i < N-1): scale * (growth_factor ^ i). Lower bound (1 <= i < N): scale * (growth_factor ^ (i - 1)).
     */
    export interface Schema$GoogleApiDistributionBucketOptionsExponential {
        /**
         * Must be greater than 1.
         */
        growthFactor?: number | null;
        /**
         * Must be greater than 0.
         */
        numFiniteBuckets?: number | null;
        /**
         * Must be greater than 0.
         */
        scale?: number | null;
    }
    /**
     * Specifies a linear sequence of buckets that all have the same width (except overflow and underflow). Each bucket represents a constant absolute uncertainty on the specific value in the bucket. There are `num_finite_buckets + 2` (= N) buckets. Bucket `i` has the following boundaries: Upper bound (0 <= i < N-1): offset + (width * i). Lower bound (1 <= i < N): offset + (width * (i - 1)).
     */
    export interface Schema$GoogleApiDistributionBucketOptionsLinear {
        /**
         * Must be greater than 0.
         */
        numFiniteBuckets?: number | null;
        /**
         * Lower bound of the first bucket.
         */
        offset?: number | null;
        /**
         * Must be greater than 0.
         */
        width?: number | null;
    }
    /**
     * Exemplars are example points that may be used to annotate aggregated distribution values. They are metadata that gives information about a particular value added to a Distribution bucket, such as a trace ID that was active when a value was added. They may contain further information, such as a example values and timestamps, origin, etc.
     */
    export interface Schema$GoogleApiDistributionExemplar {
        /**
         * Contextual information about the example value. Examples are: Trace: type.googleapis.com/google.monitoring.v3.SpanContext Literal string: type.googleapis.com/google.protobuf.StringValue Labels dropped during aggregation: type.googleapis.com/google.monitoring.v3.DroppedLabels There may be only a single attachment of any given message type in a single exemplar, and this is enforced by the system.
         */
        attachments?: Array<{
            [key: string]: any;
        }> | null;
        /**
         * The observation (sampling) time of the above value.
         */
        timestamp?: string | null;
        /**
         * Value of the exemplar point. This value determines to which bucket the exemplar belongs.
         */
        value?: number | null;
    }
    /**
     * The range of the population values.
     */
    export interface Schema$GoogleApiDistributionRange {
        /**
         * The maximum of the population values.
         */
        max?: number | null;
        /**
         * The minimum of the population values.
         */
        min?: number | null;
    }
    /**
     * Message that represents an arbitrary HTTP body. It should only be used for payload formats that can't be represented as JSON, such as raw binary or an HTML page. This message can be used both in streaming and non-streaming API methods in the request as well as the response. It can be used as a top-level request field, which is convenient if one wants to extract parameters from either the URL or HTTP template into the request fields and also want access to the raw HTTP body. Example: message GetResourceRequest { // A unique request id. string request_id = 1; // The raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; \} service ResourceService { rpc GetResource(GetResourceRequest) returns (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty); \} Example with streaming methods: service CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns (stream google.api.HttpBody); \} Use of this type only changes how the request and response bodies are handled, all other features will continue to work unchanged.
     */
    export interface Schema$GoogleApiHttpBody {
        /**
         * The HTTP Content-Type header value specifying the content type of the body.
         */
        contentType?: string | null;
        /**
         * The HTTP request/response body as raw binary.
         */
        data?: string | null;
        /**
         * Application specific response metadata. Must be set in the first response for streaming APIs.
         */
        extensions?: Array<{
            [key: string]: any;
        }> | null;
    }
    /**
     * A specific metric, identified by specifying values for all of the labels of a `MetricDescriptor`.
     */
    export interface Schema$GoogleApiMetric {
        /**
         * The set of label values that uniquely identify this metric. All labels listed in the `MetricDescriptor` must be assigned values.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * An existing metric type, see google.api.MetricDescriptor. For example, `custom.googleapis.com/invoice/paid/amount`.
         */
        type?: string | null;
    }
    /**
     * An object representing a resource that can be used for monitoring, logging, billing, or other purposes. Examples include virtual machine instances, databases, and storage devices such as disks. The `type` field identifies a MonitoredResourceDescriptor object that describes the resource's schema. Information in the `labels` field identifies the actual resource and its attributes according to the schema. For example, a particular Compute Engine VM instance could be represented by the following object, because the MonitoredResourceDescriptor for `"gce_instance"` has labels `"project_id"`, `"instance_id"` and `"zone"`: { "type": "gce_instance", "labels": { "project_id": "my-project", "instance_id": "12345678901234", "zone": "us-central1-a" \}\}
     */
    export interface Schema$GoogleApiMonitoredResource {
        /**
         * Required. Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels `"project_id"`, `"instance_id"`, and `"zone"`.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * Required. The monitored resource type. This field must match the `type` field of a MonitoredResourceDescriptor object. For example, the type of a Compute Engine VM instance is `gce_instance`. Some descriptors include the service name in the type; for example, the type of a Datastream stream is `datastream.googleapis.com/Stream`.
         */
        type?: string | null;
    }
    /**
     * Auxiliary metadata for a MonitoredResource object. MonitoredResource objects contain the minimum set of information to uniquely identify a monitored resource instance. There is some other useful auxiliary metadata. Monitoring and Logging use an ingestion pipeline to extract metadata for cloud resources of all types, and store the metadata in this message.
     */
    export interface Schema$GoogleApiMonitoredResourceMetadata {
        /**
         * Output only. Values for predefined system metadata labels. System labels are a kind of metadata extracted by Google, including "machine_image", "vpc", "subnet_id", "security_group", "name", etc. System label values can be only strings, Boolean values, or a list of strings. For example: { "name": "my-test-instance", "security_group": ["a", "b", "c"], "spot_instance": false \}
         */
        systemLabels?: {
            [key: string]: any;
        } | null;
        /**
         * Output only. A map of user-defined metadata labels.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
    }
    /**
     * The error payload that is populated on LRO sync APIs, including the following: * `google.cloud.discoveryengine.v1main.DataConnectorService.SetUpDataConnector` * `google.cloud.discoveryengine.v1main.DataConnectorService.StartConnectorRun`
     */
    export interface Schema$GoogleCloudDiscoveryengineLoggingConnectorRunErrorContext {
        /**
         * The full resource name of the Connector Run. Format: `projects/x/locations/x/collections/x/dataConnector/connectorRuns/x`. The `connector_run_id` is system-generated.
         */
        connectorRun?: string | null;
        /**
         * The full resource name of the DataConnector. Format: `projects/x/locations/x/collections/x/dataConnector`.
         */
        dataConnector?: string | null;
        /**
         * The time when the connector run ended.
         */
        endTime?: string | null;
        /**
         * The entity to sync for the connector run.
         */
        entity?: string | null;
        /**
         * The operation resource name of the LRO to sync the connector.
         */
        operation?: string | null;
        /**
         * The time when the connector run started.
         */
        startTime?: string | null;
        /**
         * The type of sync run. Can be one of the following: * `FULL` * `INCREMENTAL`
         */
        syncType?: string | null;
    }
    /**
     * A description of the context in which an error occurred.
     */
    export interface Schema$GoogleCloudDiscoveryengineLoggingErrorContext {
        /**
         * The HTTP request which was processed when the error was triggered.
         */
        httpRequest?: Schema$GoogleCloudDiscoveryengineLoggingHttpRequestContext;
        /**
         * The location in the source code where the decision was made to report the error, usually the place where it was logged.
         */
        reportLocation?: Schema$GoogleCloudDiscoveryengineLoggingSourceLocation;
    }
    /**
     * An error log which is reported to the Error Reporting system.
     */
    export interface Schema$GoogleCloudDiscoveryengineLoggingErrorLog {
        /**
         * The error payload that is populated on LRO connector sync APIs.
         */
        connectorRunPayload?: Schema$GoogleCloudDiscoveryengineLoggingConnectorRunErrorContext;
        /**
         * A description of the context in which the error occurred.
         */
        context?: Schema$GoogleCloudDiscoveryengineLoggingErrorContext;
        /**
         * The error payload that is populated on LRO import APIs.
         */
        importPayload?: Schema$GoogleCloudDiscoveryengineLoggingImportErrorContext;
        /**
         * A message describing the error.
         */
        message?: string | null;
        /**
         * The API request payload, represented as a protocol buffer. Most API request types are supported—for example: * `type.googleapis.com/google.cloud.discoveryengine.v1alpha.DocumentService.CreateDocumentRequest` * `type.googleapis.com/google.cloud.discoveryengine.v1alpha.UserEventService.WriteUserEventRequest`
         */
        requestPayload?: {
            [key: string]: any;
        } | null;
        /**
         * The API response payload, represented as a protocol buffer. This is used to log some "soft errors", where the response is valid but we consider there are some quality issues like unjoined events. The following API responses are supported, and no PII is included: * `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend` * `google.cloud.discoveryengine.v1alpha.UserEventService.WriteUserEvent` * `google.cloud.discoveryengine.v1alpha.UserEventService.CollectUserEvent`
         */
        responsePayload?: {
            [key: string]: any;
        } | null;
        /**
         * The service context in which this error has occurred.
         */
        serviceContext?: Schema$GoogleCloudDiscoveryengineLoggingServiceContext;
        /**
         * The RPC status associated with the error log.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * HTTP request data that is related to a reported error.
     */
    export interface Schema$GoogleCloudDiscoveryengineLoggingHttpRequestContext {
        /**
         * The HTTP response status code for the request.
         */
        responseStatusCode?: number | null;
    }
    /**
     * The error payload that is populated on LRO import APIs, including the following: * `google.cloud.discoveryengine.v1alpha.DocumentService.ImportDocuments` * `google.cloud.discoveryengine.v1alpha.UserEventService.ImportUserEvents`
     */
    export interface Schema$GoogleCloudDiscoveryengineLoggingImportErrorContext {
        /**
         * The detailed content which caused the error on importing a document.
         */
        document?: string | null;
        /**
         * Google Cloud Storage file path of the import source. Can be set for batch operation error.
         */
        gcsPath?: string | null;
        /**
         * Line number of the content in file. Should be empty for permission or batch operation error.
         */
        lineNumber?: string | null;
        /**
         * The operation resource name of the LRO.
         */
        operation?: string | null;
        /**
         * The detailed content which caused the error on importing a user event.
         */
        userEvent?: string | null;
    }
    /**
     * Describes a running service that sends errors.
     */
    export interface Schema$GoogleCloudDiscoveryengineLoggingServiceContext {
        /**
         * An identifier of the service—for example, `discoveryengine.googleapis.com`.
         */
        service?: string | null;
    }
    /**
     * Indicates a location in the source code of the service for which errors are reported.
     */
    export interface Schema$GoogleCloudDiscoveryengineLoggingSourceLocation {
        /**
         * Human-readable name of a function or method—for example, `google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend`.
         */
        functionName?: string | null;
    }
    /**
     * Request message for CompletionService.AdvancedCompleteQuery method. .
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequest {
        /**
         * Optional. Specification to boost suggestions matching the condition.
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpec;
        /**
         * Optional. Experiment ids for this request.
         */
        experimentIds?: string[] | null;
        /**
         * Indicates if tail suggestions should be returned if there are no suggestions that match the full query. Even if set to true, if there are suggestions that match the full query, those are returned and no tail suggestions are returned.
         */
        includeTailSuggestions?: boolean | null;
        /**
         * Required. The typeahead input used to fetch suggestions. Maximum length is 128 characters. The query can not be empty for most of the suggestion types. If it is empty, an `INVALID_ARGUMENT` error is returned. The exception is when the suggestion_types contains only the type `RECENT_SEARCH`, the query can be an empty string. The is called "zero prefix" feature, which returns user's recently searched queries given the empty query.
         */
        query?: string | null;
        /**
         * Specifies the autocomplete query model, which only applies to the QUERY SuggestionType. This overrides any model specified in the Configuration \> Autocomplete section of the Cloud console. Currently supported values: * `document` - Using suggestions generated from user-imported documents. * `search-history` - Using suggestions generated from the past history of SearchService.Search API calls. Do not use it when there is no traffic for Search API. * `user-event` - Using suggestions generated from user-imported search events. * `document-completable` - Using suggestions taken directly from user-imported document fields marked as completable. Default values: * `document` is the default model for regular dataStores. * `search-history` is the default model for site search dataStores.
         */
        queryModel?: string | null;
        /**
         * Optional. Suggestion types to return. If empty or unspecified, query suggestions are returned. Only one suggestion type is supported at the moment.
         */
        suggestionTypes?: string[] | null;
        /**
         * Optional. Specification of each suggestion type.
         */
        suggestionTypeSpecs?: Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestSuggestionTypeSpec[];
        /**
         * Optional. Information about the end user. This should be the same identifier information as UserEvent.user_info and SearchRequest.user_info.
         */
        userInfo?: Schema$GoogleCloudDiscoveryengineV1UserInfo;
        /**
         * A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. This field should NOT have a fixed value such as `unknown_visitor`. This should be the same identifier as UserEvent.user_pseudo_id and SearchRequest.user_pseudo_id. The field must be a UTF-8 encoded string with a length limit of 128
         */
        userPseudoId?: string | null;
    }
    /**
     * Specification to boost suggestions based on the condtion of the suggestion.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpec {
        /**
         * Condition boost specifications. If a suggestion matches multiple conditions in the specifications, boost values from these specifications are all applied and combined in a non-linear way. Maximum number of specifications is 20. Note: Currently only support language condition boost.
         */
        conditionBoostSpecs?: Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoostSpec[];
    }
    /**
     * Boost applies to suggestions which match a condition.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestBoostSpecConditionBoostSpec {
        /**
         * Strength of the boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the suggestions a big promotion. However, it does not necessarily mean that the top result will be a boosted suggestion. Setting to -1.0 gives the suggestions a big demotion. However, other suggestions that are relevant might still be shown. Setting to 0.0 means no boost applied. The boosting condition is ignored.
         */
        boost?: number | null;
        /**
         * An expression which specifies a boost condition. The syntax is the same as [filter expression syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax). Currently, the only supported condition is a list of BCP-47 lang codes. Example: * To boost suggestions in languages `en` or `fr`: `(lang_code: ANY("en", "fr"))`
         */
        condition?: string | null;
    }
    /**
     * Specification of each suggestion type.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequestSuggestionTypeSpec {
        /**
         * Optional. Maximum number of suggestions to return for each suggestion type.
         */
        maxSuggestions?: number | null;
        /**
         * Optional. Suggestion type.
         */
        suggestionType?: string | null;
    }
    /**
     * Response message for CompletionService.AdvancedCompleteQuery method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse {
        /**
         * Results of the matched content suggestions. The result list is ordered and the first result is the top suggestion.
         */
        contentSuggestions?: Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion[];
        /**
         * Results of the matched people suggestions. The result list is ordered and the first result is the top suggestion.
         */
        peopleSuggestions?: Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion[];
        /**
         * Results of the matched query suggestions. The result list is ordered and the first result is a top suggestion.
         */
        querySuggestions?: Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion[];
        /**
         * Results of the matched "recent search" suggestions. The result list is ordered and the first result is the top suggestion.
         */
        recentSearchSuggestions?: Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggestion[];
        /**
         * True if the returned suggestions are all tail suggestions. For tail matching to be triggered, include_tail_suggestions in the request must be true and there must be no suggestions that match the full query.
         */
        tailMatchTriggered?: boolean | null;
    }
    /**
     * Suggestions as content.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseContentSuggestion {
        /**
         * The type of the content suggestion.
         */
        contentType?: string | null;
        /**
         * The name of the dataStore that this suggestion belongs to.
         */
        dataStore?: string | null;
        /**
         * The destination uri of the content suggestion.
         */
        destinationUri?: string | null;
        /**
         * The document data snippet in the suggestion. Only a subset of fields will be populated.
         */
        document?: Schema$GoogleCloudDiscoveryengineV1Document;
        /**
         * The icon uri of the content suggestion.
         */
        iconUri?: string | null;
        /**
         * The score of each suggestion. The score is in the range of [0, 1].
         */
        score?: number | null;
        /**
         * The suggestion for the query.
         */
        suggestion?: string | null;
    }
    /**
     * Suggestions as people.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponsePersonSuggestion {
        /**
         * The name of the dataStore that this suggestion belongs to.
         */
        dataStore?: string | null;
        /**
         * The destination uri of the person suggestion.
         */
        destinationUri?: string | null;
        /**
         * The photo uri of the person suggestion.
         */
        displayPhotoUri?: string | null;
        /**
         * The document data snippet in the suggestion. Only a subset of fields is populated.
         */
        document?: Schema$GoogleCloudDiscoveryengineV1Document;
        /**
         * The type of the person.
         */
        personType?: string | null;
        /**
         * The score of each suggestion. The score is in the range of [0, 1].
         */
        score?: number | null;
        /**
         * The suggestion for the query.
         */
        suggestion?: string | null;
    }
    /**
     * Suggestions as search queries.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseQuerySuggestion {
        /**
         * The unique document field paths that serve as the source of this suggestion if it was generated from completable fields. This field is only populated for the document-completable model.
         */
        completableFieldPaths?: string[] | null;
        /**
         * The name of the dataStore that this suggestion belongs to.
         */
        dataStore?: string[] | null;
        /**
         * The score of each suggestion. The score is in the range of [0, 1].
         */
        score?: number | null;
        /**
         * The suggestion for the query.
         */
        suggestion?: string | null;
    }
    /**
     * Suggestions from recent search history.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponseRecentSearchSuggestion {
        /**
         * The time when this recent rearch happened.
         */
        recentSearchTime?: string | null;
        /**
         * The score of each suggestion. The score is in the range of [0, 1].
         */
        score?: number | null;
        /**
         * The suggestion for the query.
         */
        suggestion?: string | null;
    }
    /**
     * Configuration data for advance site search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig {
        /**
         * If set true, automatic refresh is disabled for the DataStore.
         */
        disableAutomaticRefresh?: boolean | null;
        /**
         * If set true, initial indexing is disabled for the DataStore.
         */
        disableInitialIndex?: boolean | null;
    }
    /**
     * AlloyDB source import data from.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AlloyDbSource {
        /**
         * Required. The AlloyDB cluster to copy the data from with a length limit of 256 characters.
         */
        clusterId?: string | null;
        /**
         * Required. The AlloyDB database to copy the data from with a length limit of 256 characters.
         */
        databaseId?: string | null;
        /**
         * Intermediate Cloud Storage directory used for the import with a length limit of 2,000 characters. Can be specified if one wants to have the AlloyDB export to a specific Cloud Storage directory. Ensure that the AlloyDB service account has the necessary Cloud Storage Admin permissions to access the specified Cloud Storage directory.
         */
        gcsStagingDir?: string | null;
        /**
         * Required. The AlloyDB location to copy the data from with a length limit of 256 characters.
         */
        locationId?: string | null;
        /**
         * The project ID that contains the AlloyDB source. Has a length limit of 128 characters. If not specified, inherits the project ID from the parent request.
         */
        projectId?: string | null;
        /**
         * Required. The AlloyDB table to copy the data from with a length limit of 256 characters.
         */
        tableId?: string | null;
    }
    /**
     * Access Control Configuration.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAclConfig {
        /**
         * Identity provider config.
         */
        idpConfig?: Schema$GoogleCloudDiscoveryengineV1alphaIdpConfig;
        /**
         * Immutable. The full resource name of the acl configuration. Format: `projects/{project\}/locations/{location\}/aclConfig`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
    }
    /**
     * Informations to support actions on the connector.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaActionConfig {
        /**
         * Required. Params needed to support actions in the format of (Key, Value) pairs. Required parameters for sources that support OAUTH, i.e. `gmail`, `google_calendar`, `jira`, `workday`, `salesforce`, `confluence`: * Key: `client_id` * Value: type STRING. The client ID for the service provider to identify your application. * Key: `client_secret` * Value:type STRING. The client secret generated by the application's authorization server.
         */
        actionParams?: {
            [key: string]: any;
        } | null;
        /**
         * Output only. The connector contains the necessary parameters and is configured to support actions.
         */
        isActionConfigured?: boolean | null;
        /**
         * Optional. The Service Directory resource name (projects/x/locations/x/namespaces/x/services/x) representing a VPC network endpoint used to connect to the data source's `instance_uri`, defined in DataConnector.params. Required when VPC Service Controls are enabled.
         */
        serviceName?: string | null;
        /**
         * Optional. Whether to use static secrets for the connector. If true, the secrets provided in the action_params will be ignored.
         */
        useStaticSecrets?: boolean | null;
    }
    /**
     * Configuration data for advance site search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig {
        /**
         * If set true, automatic refresh is disabled for the DataStore.
         */
        disableAutomaticRefresh?: boolean | null;
        /**
         * If set true, initial indexing is disabled for the DataStore.
         */
        disableInitialIndex?: boolean | null;
    }
    /**
     * The connector level alert config.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAlertPolicyConfig {
        /**
         * Optional. The enrollment states of each alert.
         */
        alertEnrollments?: Schema$GoogleCloudDiscoveryengineV1alphaAlertPolicyConfigAlertEnrollment[];
        /**
         * Immutable. The fully qualified resource name of the AlertPolicy.
         */
        alertPolicyName?: string | null;
    }
    /**
     * The alert enrollment status.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAlertPolicyConfigAlertEnrollment {
        /**
         * Immutable. The id of an alert.
         */
        alertId?: string | null;
        /**
         * Required. The enrollment status of a customer.
         */
        enrollState?: string | null;
    }
    /**
     * Defines an answer.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswer {
        /**
         * Additional answer-skipped reasons. This provides the reason for ignored cases. If nothing is skipped, this field is not set.
         */
        answerSkippedReasons?: string[] | null;
        /**
         * The textual answer.
         */
        answerText?: string | null;
        /**
         * List of blob attachments in the answer.
         */
        blobAttachments?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment[];
        /**
         * Citations.
         */
        citations?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerCitation[];
        /**
         * Output only. Answer completed timestamp.
         */
        completeTime?: string | null;
        /**
         * Output only. Answer creation timestamp.
         */
        createTime?: string | null;
        /**
         * A score in the range of [0, 1] describing how grounded the answer is by the reference chunks.
         */
        groundingScore?: number | null;
        /**
         * Optional. Grounding supports.
         */
        groundingSupports?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport[];
        /**
         * Immutable. Fully qualified name `projects/{project\}/locations/global/collections/{collection\}/engines/{engine\}/sessions/x/answers/x`
         */
        name?: string | null;
        /**
         * Query understanding information.
         */
        queryUnderstandingInfo?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo;
        /**
         * References.
         */
        references?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerReference[];
        /**
         * Suggested related questions.
         */
        relatedQuestions?: string[] | null;
        /**
         * Optional. Safety ratings.
         */
        safetyRatings?: Schema$GoogleCloudDiscoveryengineV1alphaSafetyRating[];
        /**
         * The state of the answer generation.
         */
        state?: string | null;
        /**
         * Answer generation steps.
         */
        steps?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerStep[];
    }
    /**
     * Stores binarydata attached to text answer, e.g. image, video, audio, etc.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment {
        /**
         * Output only. The attribution type of the blob.
         */
        attributionType?: string | null;
        /**
         * Output only. The mime type and data of the blob.
         */
        data?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob;
    }
    /**
     * The media type and data of the blob.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob {
        /**
         * Output only. Raw bytes.
         */
        data?: string | null;
        /**
         * Output only. The media type (MIME type) of the generated or retrieved data.
         */
        mimeType?: string | null;
    }
    /**
     * Citation info for a segment.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerCitation {
        /**
         * End of the attributed segment, exclusive. Measured in bytes (UTF-8 unicode). If there are multi-byte characters,such as non-ASCII characters, the index measurement is longer than the string length.
         */
        endIndex?: string | null;
        /**
         * Citation sources for the attributed segment.
         */
        sources?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerCitationSource[];
        /**
         * Index indicates the start of the segment, measured in bytes (UTF-8 unicode). If there are multi-byte characters,such as non-ASCII characters, the index measurement is longer than the string length.
         */
        startIndex?: string | null;
    }
    /**
     * Citation source.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerCitationSource {
        /**
         * ID of the citation source.
         */
        referenceId?: string | null;
    }
    /**
     * Grounding support for a claim in `answer_text`.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerGroundingSupport {
        /**
         * Required. End of the claim, exclusive.
         */
        endIndex?: string | null;
        /**
         * Indicates that this claim required grounding check. When the system decided this claim didn't require attribution/grounding check, this field is set to false. In that case, no grounding check was done for the claim and therefore `grounding_score`, `sources` is not returned.
         */
        groundingCheckRequired?: boolean | null;
        /**
         * A score in the range of [0, 1] describing how grounded is a specific claim by the references. Higher value means that the claim is better supported by the reference chunks.
         */
        groundingScore?: number | null;
        /**
         * Optional. Citation sources for the claim.
         */
        sources?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerCitationSource[];
        /**
         * Required. Index indicates the start of the claim, measured in bytes (UTF-8 unicode).
         */
        startIndex?: string | null;
    }
    /**
     * Query understanding information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfo {
        /**
         * Query classification information.
         */
        queryClassificationInfo?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo[];
    }
    /**
     * Query classification information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerQueryUnderstandingInfoQueryClassificationInfo {
        /**
         * Classification output.
         */
        positive?: boolean | null;
        /**
         * Query classification type.
         */
        type?: string | null;
    }
    /**
     * Reference.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerReference {
        /**
         * Chunk information.
         */
        chunkInfo?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo;
        /**
         * Structured document information.
         */
        structuredDocumentInfo?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo;
        /**
         * Unstructured document information.
         */
        unstructuredDocumentInfo?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo;
    }
    /**
     * Chunk information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfo {
        /**
         * Output only. Stores indexes of blobattachments linked to this chunk.
         */
        blobAttachmentIndexes?: string[] | null;
        /**
         * Chunk resource name.
         */
        chunk?: string | null;
        /**
         * Chunk textual content.
         */
        content?: string | null;
        /**
         * Document metadata.
         */
        documentMetadata?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata;
        /**
         * The relevance of the chunk for a given query. Values range from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is for informational purpose only. It may change for the same query and chunk at any time due to a model retraining or change in implementation.
         */
        relevanceScore?: number | null;
    }
    /**
     * Document metadata.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceChunkInfoDocumentMetadata {
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
        /**
         * The structured JSON metadata for the document. It is populated from the struct data from the Chunk in search result.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Title.
         */
        title?: string | null;
        /**
         * URI for the document.
         */
        uri?: string | null;
    }
    /**
     * Structured search information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceStructuredDocumentInfo {
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * Structured search data.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Output only. The title of the document.
         */
        title?: string | null;
        /**
         * Output only. The URI of the document.
         */
        uri?: string | null;
    }
    /**
     * Unstructured document information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfo {
        /**
         * List of cited chunk contents derived from document content.
         */
        chunkContents?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent[];
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * The structured JSON metadata for the document. It is populated from the struct data from the Chunk in search result.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Title.
         */
        title?: string | null;
        /**
         * URI for the document.
         */
        uri?: string | null;
    }
    /**
     * Chunk content.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerReferenceUnstructuredDocumentInfoChunkContent {
        /**
         * Output only. Stores indexes of blobattachments linked to this chunk.
         */
        blobAttachmentIndexes?: string[] | null;
        /**
         * Chunk textual content.
         */
        content?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
        /**
         * The relevance of the chunk for a given query. Values range from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is for informational purpose only. It may change for the same query and chunk at any time due to a model retraining or change in implementation.
         */
        relevanceScore?: number | null;
    }
    /**
     * Step information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerStep {
        /**
         * Actions.
         */
        actions?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepAction[];
        /**
         * The description of the step.
         */
        description?: string | null;
        /**
         * The state of the step.
         */
        state?: string | null;
        /**
         * The thought of the step.
         */
        thought?: string | null;
    }
    /**
     * Action.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepAction {
        /**
         * Observation.
         */
        observation?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation;
        /**
         * Search action.
         */
        searchAction?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction;
    }
    /**
     * Observation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservation {
        /**
         * Search results observed by the search action, it can be snippets info or chunk info, depending on the citation type set by the user.
         */
        searchResults?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult[];
    }
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResult {
        /**
         * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on, populate chunk info.
         */
        chunkInfo?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo[];
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * If citation_type is DOCUMENT_LEVEL_CITATION, populate document level snippets.
         */
        snippetInfo?: Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo[];
        /**
         * Data representation. The structured JSON data for the document. It's populated from the struct data from the Document, or the Chunk in search result.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Title.
         */
        title?: string | null;
        /**
         * URI for the document.
         */
        uri?: string | null;
    }
    /**
     * Chunk information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultChunkInfo {
        /**
         * Chunk resource name.
         */
        chunk?: string | null;
        /**
         * Chunk textual content.
         */
        content?: string | null;
        /**
         * The relevance of the chunk for a given query. Values range from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is for informational purpose only. It may change for the same query and chunk at any time due to a model retraining or change in implementation.
         */
        relevanceScore?: number | null;
    }
    /**
     * Snippet information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionObservationSearchResultSnippetInfo {
        /**
         * Snippet content.
         */
        snippet?: string | null;
        /**
         * Status of the snippet defined by the search team.
         */
        snippetStatus?: string | null;
    }
    /**
     * Search action.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaAnswerStepActionSearchAction {
        /**
         * The query to search.
         */
        query?: string | null;
    }
    /**
     * The configuration for the BAP connector.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaBAPConfig {
        /**
         * Required. The supported connector modes for the associated BAP connection.
         */
        supportedConnectorModes?: string[] | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.BatchCreateTargetSites operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.BatchCreateTargetSites method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaBatchCreateTargetSitesResponse {
        /**
         * TargetSites created.
         */
        targetSites?: Schema$GoogleCloudDiscoveryengineV1alphaTargetSite[];
    }
    /**
     * Metadata related to the progress of the UserLicenseService.BatchUpdateUserLicenses operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of user licenses that failed to be updated.
         */
        failureCount?: string | null;
        /**
         * Count of user licenses successfully updated.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for UserLicenseService.BatchUpdateUserLicenses method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaBatchUpdateUserLicensesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * UserLicenses successfully updated.
         */
        userLicenses?: Schema$GoogleCloudDiscoveryengineV1alphaUserLicense[];
    }
    /**
     * Configurations used to enable CMEK data encryption with Cloud KMS keys.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCmekConfig {
        /**
         * Output only. The default CmekConfig for the Customer.
         */
        isDefault?: boolean | null;
        /**
         * Required. KMS key resource name which will be used to encrypt resources `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{keyId\}`.
         */
        kmsKey?: string | null;
        /**
         * Output only. KMS key version resource name which will be used to encrypt resources `/cryptoKeyVersions/{keyVersion\}`.
         */
        kmsKeyVersion?: string | null;
        /**
         * Output only. The timestamp of the last key rotation.
         */
        lastRotationTimestampMicros?: string | null;
        /**
         * Required. The name of the CmekConfig of the form `projects/{project\}/locations/{location\}/cmekConfig` or `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         */
        name?: string | null;
        /**
         * Output only. Whether the NotebookLM Corpus is ready to be used.
         */
        notebooklmState?: string | null;
        /**
         * Optional. Single-regional CMEKs that are required for some VAIS features.
         */
        singleRegionKeys?: Schema$GoogleCloudDiscoveryengineV1alphaSingleRegionKey[];
        /**
         * Output only. The states of the CmekConfig.
         */
        state?: string | null;
    }
    /**
     * Collection is a container for configuring resources and access to a set of DataStores.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCollection {
        /**
         * Output only. Timestamp the Collection was created at.
         */
        createTime?: string | null;
        /**
         * Output only. The data connector, if present, manages the connection for data stores in the Collection. To set up the connector, use DataConnectorService.SetUpDataConnector method, which creates a new Collection while setting up the DataConnector singleton resource. Setting up connector on an existing Collection is not supported. This output only field contains a subset of the DataConnector fields, including `name`, `data_source`, `entities.entity_name` and `entities.data_store`. To get more details about a data connector, use the DataConnectorService.GetDataConnector method.
         */
        dataConnector?: Schema$GoogleCloudDiscoveryengineV1alphaDataConnector;
        /**
         * Required. The Collection display name. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        displayName?: string | null;
        /**
         * Immutable. The full resource name of the Collection. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
    }
    /**
     * Defines circumstances to be checked before allowing a behavior
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCondition {
        /**
         * Range of time(s) specifying when condition is active. Maximum of 10 time ranges.
         */
        activeTimeRange?: Schema$GoogleCloudDiscoveryengineV1alphaConditionTimeRange[];
        /**
         * Optional. Query regex to match the whole search query. Cannot be set when Condition.query_terms is set. Only supported for Basic Site Search promotion serving controls.
         */
        queryRegex?: string | null;
        /**
         * Search only A list of terms to match the query on. Cannot be set when Condition.query_regex is set. Maximum of 10 query terms.
         */
        queryTerms?: Schema$GoogleCloudDiscoveryengineV1alphaConditionQueryTerm[];
    }
    /**
     * Matcher for search request query
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaConditionQueryTerm {
        /**
         * Whether the search query needs to exactly match the query term.
         */
        fullMatch?: boolean | null;
        /**
         * The specific query value to match against Must be lowercase, must be UTF-8. Can have at most 3 space separated terms if full_match is true. Cannot be an empty string. Maximum length of 5000 characters.
         */
        value?: string | null;
    }
    /**
     * Used for time-dependent conditions.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaConditionTimeRange {
        /**
         * End of time range. Range is inclusive. Must be in the future.
         */
        endTime?: string | null;
        /**
         * Start of time range. Range is inclusive.
         */
        startTime?: string | null;
    }
    /**
     * A data sync run of DataConnector. After DataConnector is successfully initialized, data syncs are scheduled at DataConnector.refresh_interval. A ConnectorRun represents a data sync either in the past or onging that the moment. //
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaConnectorRun {
        /**
         * Output only. The time when the connector run ended.
         */
        endTime?: string | null;
        /**
         * Output only. The details of the entities synced at the ConnectorRun. Each ConnectorRun consists of syncing one or more entities.
         */
        entityRuns?: Schema$GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRun[];
        /**
         * Contains info about errors incurred during the sync. Only exist if running into an error state. Contains error code and error message. Use with the `state` field.
         */
        errors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The time when the connector run was most recently paused.
         */
        latestPauseTime?: string | null;
        /**
         * Output only. The full resource name of the Connector Run. Format: `projects/x/locations/x/collections/x/dataConnector/connectorRuns/x`. The `connector_run_id` is system-generated.
         */
        name?: string | null;
        /**
         * Output only. The time when the connector run started.
         */
        startTime?: string | null;
        /**
         * Output only. The state of the sync run.
         */
        state?: string | null;
        /**
         * Timestamp at which the connector run sync state was last updated.
         */
        stateUpdateTime?: string | null;
        /**
         * Output only. The trigger for this ConnectorRun.
         */
        trigger?: string | null;
    }
    /**
     * Represents an entity that was synced in this ConnectorRun.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRun {
        /**
         * Optional. The number of documents deleted.
         */
        deletedRecordCount?: string | null;
        /**
         * The name of the source entity.
         */
        entityName?: string | null;
        /**
         * Optional. The total number of documents failed at sync at indexing stage.
         */
        errorRecordCount?: string | null;
        /**
         * The errors from the entity's sync run. Only exist if running into an error state. Contains error code and error message.
         */
        errors?: Schema$GoogleRpcStatus[];
        /**
         * Optional. The number of documents extracted from connector source, ready to be ingested to VAIS.
         */
        extractedRecordCount?: string | null;
        /**
         * Optional. The number of documents indexed.
         */
        indexedRecordCount?: string | null;
        /**
         * Metadata to generate the progress bar.
         */
        progress?: Schema$GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress;
        /**
         * Optional. The number of documents scheduled to be crawled/extracted from connector source. This only applies to third party connectors.
         */
        scheduledRecordCount?: string | null;
        /**
         * Optional. The number of requests sent to 3p API.
         */
        sourceApiRequestCount?: string | null;
        /**
         * The state of the entity's sync run.
         */
        state?: string | null;
        /**
         * Timestamp at which the entity sync state was last updated.
         */
        stateUpdateTime?: string | null;
        /**
         * The timestamp for either extracted_documents_count, indexed_documents_count and error_documents_count was last updated.
         */
        statsUpdateTime?: string | null;
        /**
         * Sync type of this run.
         */
        syncType?: string | null;
    }
    /**
     * Represents the progress of a sync run.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaConnectorRunEntityRunProgress {
        /**
         * The current progress.
         */
        currentCount?: string | null;
        /**
         * Derived. The percentile of the progress.current_count / total_count. The value is between [0, 1.0] inclusive.
         */
        percentile?: number | null;
        /**
         * The total.
         */
        totalCount?: string | null;
    }
    /**
     * Defines a conditioned behavior to employ during serving. Must be attached to a ServingConfig to be considered at serving time. Permitted actions dependent on `SolutionType`.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaControl {
        /**
         * Output only. List of all ServingConfig IDs this control is attached to. May take up to 10 minutes to update after changes.
         */
        associatedServingConfigIds?: string[] | null;
        /**
         * Defines a boost-type control
         */
        boostAction?: Schema$GoogleCloudDiscoveryengineV1alphaControlBoostAction;
        /**
         * Determines when the associated action will trigger. Omit to always apply the action. Currently only a single condition may be specified. Otherwise an INVALID ARGUMENT error is thrown.
         */
        conditions?: Schema$GoogleCloudDiscoveryengineV1alphaCondition[];
        /**
         * Required. Human readable name. The identifier used in UI views. Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        displayName?: string | null;
        /**
         * Defines a filter-type control Currently not supported by Recommendation
         */
        filterAction?: Schema$GoogleCloudDiscoveryengineV1alphaControlFilterAction;
        /**
         * Immutable. Fully qualified name `projects/x/locations/global/dataStore/x/controls/x`
         */
        name?: string | null;
        /**
         * Promote certain links based on predefined trigger queries.
         */
        promoteAction?: Schema$GoogleCloudDiscoveryengineV1alphaControlPromoteAction;
        /**
         * Defines a redirect-type control.
         */
        redirectAction?: Schema$GoogleCloudDiscoveryengineV1alphaControlRedirectAction;
        /**
         * Required. Immutable. What solution the control belongs to. Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT error is thrown.
         */
        solutionType?: string | null;
        /**
         * Treats a group of terms as synonyms of one another.
         */
        synonymsAction?: Schema$GoogleCloudDiscoveryengineV1alphaControlSynonymsAction;
        /**
         * Specifies the use case for the control. Affects what condition fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only allow one use case per control. Must be set when solution_type is SolutionType.SOLUTION_TYPE_SEARCH.
         */
        useCases?: string[] | null;
    }
    /**
     * Adjusts order of products in returned list.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaControlBoostAction {
        /**
         * Strength of the boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0 (No-op).
         */
        boost?: number | null;
        /**
         * Required. Specifies which data store's documents can be boosted by this control. Full data store name e.g. projects/123/locations/global/collections/default_collection/dataStores/default_data_store
         */
        dataStore?: string | null;
        /**
         * Required. Specifies which products to apply the boost to. If no filter is provided all products will be boosted (No-op). Syntax documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        filter?: string | null;
        /**
         * Optional. Strength of the boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0 (No-op).
         */
        fixedBoost?: number | null;
        /**
         * Optional. Complex specification for custom ranking based on customer defined attribute value.
         */
        interpolationBoostSpec?: Schema$GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpec;
    }
    /**
     * Specification for custom ranking based on customer specified attribute value. It provides more controls for customized ranking than the simple (condition, boost) combination above.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpec {
        /**
         * Optional. The attribute type to be used to determine the boost amount. The attribute value can be derived from the field value of the specified field_name. In the case of numerical it is straightforward i.e. attribute_value = numerical_field_value. In the case of freshness however, attribute_value = (time.now() - datetime_field_value).
         */
        attributeType?: string | null;
        /**
         * Optional. The control points used to define the curve. The monotonic function (defined through the interpolation_type above) passes through the control points listed here.
         */
        controlPoints?: Schema$GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecControlPoint[];
        /**
         * Optional. The name of the field whose value will be used to determine the boost amount.
         */
        fieldName?: string | null;
        /**
         * Optional. The interpolation type to be applied to connect the control points listed below.
         */
        interpolationType?: string | null;
    }
    /**
     * The control points used to define the curve. The curve defined through these control points can only be monotonically increasing or decreasing(constant values are acceptable).
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaControlBoostActionInterpolationBoostSpecControlPoint {
        /**
         * Optional. Can be one of: 1. The numerical field value. 2. The duration spec for freshness: The value must be formatted as an XSD `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value). The pattern for this is: `nDnM]`.
         */
        attributeValue?: string | null;
        /**
         * Optional. The value between -1 to 1 by which to boost the score if the attribute_value evaluates to the value specified above.
         */
        boostAmount?: number | null;
    }
    /**
     * Specified which products may be included in results. Uses same filter as boost.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaControlFilterAction {
        /**
         * Required. Specifies which data store's documents can be filtered by this control. Full data store name e.g. projects/123/locations/global/collections/default_collection/dataStores/default_data_store
         */
        dataStore?: string | null;
        /**
         * Required. A filter to apply on the matching condition results. Required Syntax documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        filter?: string | null;
    }
    /**
     * Promote certain links based on some trigger queries. Example: Promote shoe store link when searching for `shoe` keyword. The link can be outside of associated data store.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaControlPromoteAction {
        /**
         * Required. Data store with which this promotion is attached to.
         */
        dataStore?: string | null;
        /**
         * Required. Promotion attached to this action.
         */
        searchLinkPromotion?: Schema$GoogleCloudDiscoveryengineV1alphaSearchLinkPromotion;
    }
    /**
     * Redirects a shopper to the provided URI.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaControlRedirectAction {
        /**
         * Required. The URI to which the shopper will be redirected. Required. URI must have length equal or less than 2000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        redirectUri?: string | null;
    }
    /**
     * Creates a set of terms that will act as synonyms of one another. Example: "happy" will also be considered as "glad", "glad" will also be considered as "happy".
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaControlSynonymsAction {
        /**
         * Defines a set of synonyms. Can specify up to 100 synonyms. Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
         */
        synonyms?: string[] | null;
    }
    /**
     * The historical crawl rate timeseries data, used for monitoring.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries {
        /**
         * The QPS of the crawl rate.
         */
        qpsTimeSeries?: Schema$GoogleMonitoringV3TimeSeries;
    }
    /**
     * Metadata related to the progress of the DataStoreService.CreateDataStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCreateDataStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the EngineService.CreateEngine operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCreateEngineMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for EvaluationService.CreateEvaluation method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCreateEvaluationMetadata {
    }
    /**
     * Metadata for Create Schema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCreateSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.CreateSitemap operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCreateSitemapMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.CreateTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCreateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Defines custom fine tuning spec.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec {
        /**
         * Whether or not to enable and include custom fine tuned search adaptor model.
         */
        enableSearchAdaptor?: boolean | null;
    }
    /**
     * Manages the connection to external data sources for all data stores grouped under a Collection. It's a singleton resource of Collection. The initialization is only supported through DataConnectorService.SetUpDataConnector method, which will create a new Collection and initialize its DataConnector.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDataConnector {
        /**
         * Optional. Whether the connector will be created with an ACL config. Currently this field only affects Cloud Storage and BigQuery connectors.
         */
        aclEnabled?: boolean | null;
        /**
         * Optional. Action configurations to make the connector support actions.
         */
        actionConfig?: Schema$GoogleCloudDiscoveryengineV1alphaActionConfig;
        /**
         * Output only. State of the action connector. This reflects whether the action connector is initializing, active or has encountered errors.
         */
        actionState?: string | null;
        /**
         * Optional. The connector level alert config.
         */
        alertPolicyConfigs?: Schema$GoogleCloudDiscoveryengineV1alphaAlertPolicyConfig[];
        /**
         * Optional. Indicates whether the connector is disabled for auto run. It can be used to pause periodical and real time sync. Update: with the introduction of incremental_sync_disabled, auto_run_disabled is used to pause/disable only full syncs
         */
        autoRunDisabled?: boolean | null;
        /**
         * Optional. The configuration for establishing a BAP connection.
         */
        bapConfig?: Schema$GoogleCloudDiscoveryengineV1alphaBAPConfig;
        /**
         * Output only. User actions that must be completed before the connector can start syncing data.
         */
        blockingReasons?: string[] | null;
        /**
         * Optional. The modes enabled for this connector. Default state is CONNECTOR_MODE_UNSPECIFIED.
         */
        connectorModes?: string[] | null;
        /**
         * Output only. The type of connector. Each source can only map to one type. For example, salesforce, confluence and jira have THIRD_PARTY connector type. It is not mutable once set by system.
         */
        connectorType?: string | null;
        /**
         * Optional. Whether the END USER AUTHENTICATION connector is created in SaaS.
         */
        createEuaSaas?: boolean | null;
        /**
         * Output only. Timestamp the DataConnector was created at.
         */
        createTime?: string | null;
        /**
         * Required. The name of the data source. Supported values: `salesforce`, `jira`, `confluence`, `bigquery`.
         */
        dataSource?: string | null;
        /**
         * Optional. Any target destinations used to connect to third-party services.
         */
        destinationConfigs?: Schema$GoogleCloudDiscoveryengineV1alphaDestinationConfig[];
        /**
         * Optional. Any params and credentials used specifically for EUA connectors.
         */
        endUserConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDataConnectorEndUserConfig;
        /**
         * List of entities from the connected data source to ingest.
         */
        entities?: Schema$GoogleCloudDiscoveryengineV1alphaDataConnectorSourceEntity[];
        /**
         * Output only. The errors from initialization or from the latest connector run.
         */
        errors?: Schema$GoogleRpcStatus[];
        /**
         * Optional. If the connector is a hybrid connector, determines whether ingestion is enabled and appropriate resources are provisioned during connector creation. If the connector is not a hybrid connector, this field is ignored.
         */
        hybridIngestionDisabled?: boolean | null;
        /**
         * The refresh interval to sync the Access Control List information for the documents ingested by this connector. If not set, the access control list will be refreshed at the default interval of 30 minutes. The identity refresh interval can be at least 30 minutes and at most 7 days.
         */
        identityRefreshInterval?: string | null;
        /**
         * The configuration for the identity data synchronization runs. This contains the refresh interval to sync the Access Control List information for the documents ingested by this connector.
         */
        identityScheduleConfig?: Schema$GoogleCloudDiscoveryengineV1alphaIdentityScheduleConfig;
        /**
         * Optional. The refresh interval specifically for incremental data syncs. If unset, incremental syncs will use the default from env, set to 3hrs. The minimum is 30 minutes and maximum is 7 days. Applicable to only 3P connectors. When the refresh interval is set to the same value as the incremental refresh interval, incremental sync will be disabled.
         */
        incrementalRefreshInterval?: string | null;
        /**
         * Optional. Indicates whether incremental syncs are paused for this connector. This is independent of auto_run_disabled. Applicable to only 3P connectors. When the refresh interval is set to the same value as the incremental refresh interval, incremental sync will be disabled, i.e. set to true.
         */
        incrementalSyncDisabled?: boolean | null;
        /**
         * Input only. The KMS key to be used to protect the DataStores managed by this connector. Must be set for requests that need to comply with CMEK Org Policy protections. If this field is set and processed successfully, the DataStores created by this connector will be protected by the KMS key.
         */
        kmsKeyName?: string | null;
        /**
         * Output only. For periodic connectors only, the last time a data sync was completed.
         */
        lastSyncTime?: string | null;
        /**
         * Output only. The most recent timestamp when this DataConnector was paused, affecting all functionalities such as data synchronization. Pausing a connector has the following effects: - All functionalities, including data synchronization, are halted. - Any ongoing data synchronization job will be canceled. - No future data synchronization runs will be scheduled nor can be triggered.
         */
        latestPauseTime?: string | null;
        /**
         * Output only. The full resource name of the Data Connector. Format: `projects/x/locations/x/collections/x/dataConnector`.
         */
        name?: string | null;
        /**
         * Defines the scheduled time for the next data synchronization. This field requires hour , minute, and time_zone from the [IANA Time Zone Database](https://www.iana.org/time-zones). This is utilized when the data connector has a refresh interval greater than 1 day. When the hours or minutes are not specified, we will assume a sync time of 0:00. The user must provide a time zone to avoid ambiguity.
         */
        nextSyncTime?: Schema$GoogleTypeDateTime;
        /**
         * Required. Params needed to access the source in the format of (Key, Value) pairs. Required parameters for all data sources: * Key: `instance_uri` * Value: type STRING. The uri to access the data source. Required parameters for sources that support OAUTH, i.e. `salesforce`: * Key: `client_id` * Value: type STRING. The client ID for the third party service provider to identify your application. * Key: `client_secret` * Value:type STRING. The client secret generated by the third party authorization server. * Key: `access_token` * Value: type STRING. OAuth token for UCS to access to the protected resource. * Key: `refresh_token` * Value: type STRING. OAuth refresh token for UCS to obtain a new access token without user interaction. Required parameters for sources that support basic API token auth, i.e. `jira`, `confluence`: * Key: `user_account` * Value: type STRING. The username or email with the source. * Key: `api_token` * Value: type STRING. The API token generated for the source account, that is used for authenticating anywhere where you would have used a password. Example: ```json { "instance_uri": "https://xxx.atlassian.net", "user_account": "xxxx.xxx@xxx.com", "api_token": "test-token" \} ``` Optional parameter to specify the authorization type to use for multiple authorization types support: * Key: `auth_type` * Value: type STRING. The authorization type for the data source. Supported values: `BASIC_AUTH`, `OAUTH`, `OAUTH_ACCESS_TOKEN`, `OAUTH_TWO_LEGGED`, `OAUTH_JWT_BEARER`, `OAUTH_PASSWORD_GRANT`, `JWT`, `API_TOKEN`, `FEDERATED_CREDENTIAL`.
         */
        params?: {
            [key: string]: any;
        } | null;
        /**
         * Output only. The tenant project ID associated with private connectivity connectors. This project must be allowlisted by in order for the connector to function.
         */
        privateConnectivityProjectId?: string | null;
        /**
         * Output only. real-time sync state
         */
        realtimeState?: string | null;
        /**
         * Optional. The configuration for realtime sync.
         */
        realtimeSyncConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfig;
        /**
         * Required. The refresh interval for data sync. If duration is set to 0, the data will be synced in real time. The streaming feature is not supported yet. The minimum is 30 minutes and maximum is 7 days. When the refresh interval is set to the same value as the incremental refresh interval, incremental sync will be disabled.
         */
        refreshInterval?: string | null;
        /**
         * Output only. State of the connector.
         */
        state?: string | null;
        /**
         * Output only. The static IP addresses used by this connector.
         */
        staticIpAddresses?: string[] | null;
        /**
         * Optional. Whether customer has enabled static IP addresses for this connector.
         */
        staticIpEnabled?: boolean | null;
        /**
         * The data synchronization mode supported by the data connector.
         */
        syncMode?: string | null;
        /**
         * Output only. Timestamp the DataConnector was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Any params and credentials used specifically for EUA connectors.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDataConnectorEndUserConfig {
        /**
         * Optional. Any additional parameters needed for EUA.
         */
        additionalParams?: {
            [key: string]: any;
        } | null;
        /**
         * Optional. Any authentication parameters specific to EUA connectors.
         */
        authParams?: {
            [key: string]: any;
        } | null;
        /**
         * Optional. The tenant project the connector is connected to.
         */
        tenant?: Schema$GoogleCloudDiscoveryengineV1alphaTenant;
    }
    /**
     * The configuration for realtime sync to store additional params for realtime sync.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfig {
        /**
         * Optional. The ID of the Secret Manager secret used for webhook secret.
         */
        realtimeSyncSecret?: string | null;
        /**
         * Optional. Streaming error details.
         */
        streamingError?: Schema$GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfigStreamingError;
        /**
         * Optional. Webhook url for the connector to specify additional params for realtime sync.
         */
        webhookUri?: string | null;
    }
    /**
     * Streaming error details.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDataConnectorRealtimeSyncConfigStreamingError {
        /**
         * Optional. Error details.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Optional. Streaming error.
         */
        streamingErrorReason?: string | null;
    }
    /**
     * Represents an entity in the data source. For example, the `Account` object in Salesforce.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDataConnectorSourceEntity {
        /**
         * Output only. The full resource name of the associated data store for the source entity. Format: `projects/x/locations/x/collections/x/dataStores/x`. When the connector is initialized by the DataConnectorService.SetUpDataConnector method, a DataStore is automatically created for each source entity.
         */
        dataStore?: string | null;
        /**
         * The name of the entity. Supported values by data source: * Salesforce: `Lead`, `Opportunity`, `Contact`, `Account`, `Case`, `Contract`, `Campaign` * Jira: `Issue` * Confluence: `Content`, `Space`
         */
        entityName?: string | null;
        /**
         * Optional. Configuration for `HEALTHCARE_FHIR` vertical.
         */
        healthcareFhirConfig?: Schema$GoogleCloudDiscoveryengineV1alphaHealthcareFhirConfig;
        /**
         * Attributes for indexing. Key: Field name. Value: The key property to map a field to, such as `title`, and `description`. Supported key properties: * `title`: The title for data record. This would be displayed on search results. * `description`: The description for data record. This would be displayed on search results.
         */
        keyPropertyMappings?: {
            [key: string]: string;
        } | null;
        /**
         * The parameters for the entity to facilitate data ingestion. E.g. for BigQuery connectors: * Key: `document_id_column` * Value: type STRING. The value of the column ID.
         */
        params?: {
            [key: string]: any;
        } | null;
        /**
         * Optional. The start schema to use for the DataStore created from this SourceEntity. If unset, a default vertical specialized schema will be used. This field is only used by SetUpDataConnector API, and will be ignored if used in other APIs. This field will be omitted from all API responses including GetDataConnector API. To retrieve a schema of a DataStore, use SchemaService.GetSchema API instead. The provided schema will be validated against certain rules on schema. Learn more from [this doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
         */
        startingSchema?: Schema$GoogleCloudDiscoveryengineV1alphaSchema;
    }
    /**
     * DataStore captures global settings and configs at the DataStore level.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDataStore {
        /**
         * Immutable. Whether data in the DataStore has ACL information. If set to `true`, the source data must have ACL. ACL will be ingested when data is ingested by DocumentService.ImportDocuments methods. When ACL is enabled for the DataStore, Document can't be accessed by calling DocumentService.GetDocument or DocumentService.ListDocuments. Currently ACL is only supported in `GENERIC` industry vertical with non-`PUBLIC_WEBSITE` content config.
         */
        aclEnabled?: boolean | null;
        /**
         * Optional. Configuration for advanced site search.
         */
        advancedSiteSearchConfig?: Schema$GoogleCloudDiscoveryengineV1alphaAdvancedSiteSearchConfig;
        /**
         * Output only. Data size estimation for billing.
         */
        billingEstimation?: Schema$GoogleCloudDiscoveryengineV1alphaDataStoreBillingEstimation;
        /**
         * Output only. CMEK-related information for the DataStore.
         */
        cmekConfig?: Schema$GoogleCloudDiscoveryengineV1alphaCmekConfig;
        /**
         * Immutable. The content config of the data store. If this field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
         */
        contentConfig?: string | null;
        /**
         * Output only. Timestamp the DataStore was created at.
         */
        createTime?: string | null;
        /**
         * Output only. The id of the default Schema associated to this data store.
         */
        defaultSchemaId?: string | null;
        /**
         * Required. The data store display name. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        displayName?: string | null;
        /**
         * Configuration for Document understanding and enrichment.
         */
        documentProcessingConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig;
        /**
         * Optional. Configuration for `HEALTHCARE_FHIR` vertical.
         */
        healthcareFhirConfig?: Schema$GoogleCloudDiscoveryengineV1alphaHealthcareFhirConfig;
        /**
         * Immutable. The fully qualified resource name of the associated IdentityMappingStore. This field can only be set for acl_enabled DataStores with `THIRD_PARTY` or `GSUITE` IdP. Format: `projects/{project\}/locations/{location\}/identityMappingStores/{identity_mapping_store\}`.
         */
        identityMappingStore?: string | null;
        /**
         * Output only. Data store level identity provider config.
         */
        idpConfig?: Schema$GoogleCloudDiscoveryengineV1alphaIdpConfig;
        /**
         * Immutable. The industry vertical that the data store registers.
         */
        industryVertical?: string | null;
        /**
         * Optional. If set, this DataStore is an Infobot FAQ DataStore.
         */
        isInfobotFaqDataStore?: boolean | null;
        /**
         * Input only. The KMS key to be used to protect this DataStore at creation time. Must be set for requests that need to comply with CMEK Org Policy protections. If this field is set and processed successfully, the DataStore will be protected by the KMS key, as indicated in the cmek_config field.
         */
        kmsKeyName?: string | null;
        /**
         * Language info for DataStore.
         */
        languageInfo?: Schema$GoogleCloudDiscoveryengineV1alphaLanguageInfo;
        /**
         * Immutable. Identifier. The full resource name of the data store. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * Optional. Configuration for Natural Language Query Understanding.
         */
        naturalLanguageQueryUnderstandingConfig?: Schema$GoogleCloudDiscoveryengineV1alphaNaturalLanguageQueryUnderstandingConfig;
        /**
         * Optional. Stores serving config at DataStore level.
         */
        servingConfigDataStore?: Schema$GoogleCloudDiscoveryengineV1alphaDataStoreServingConfigDataStore;
        /**
         * The solutions that the data store enrolls. Available solutions for each industry_vertical: * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be enrolled.
         */
        solutionTypes?: string[] | null;
        /**
         * The start schema to use for this DataStore when provisioning it. If unset, a default vertical specialized schema will be used. This field is only used by CreateDataStore API, and will be ignored if used in other APIs. This field will be omitted from all API responses including CreateDataStore API. To retrieve a schema of a DataStore, use SchemaService.GetSchema API instead. The provided schema will be validated against certain rules on schema. Learn more from [this doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
         */
        startingSchema?: Schema$GoogleCloudDiscoveryengineV1alphaSchema;
        /**
         * Config to store data store type configuration for workspace data. This must be set when DataStore.content_config is set as DataStore.ContentConfig.GOOGLE_WORKSPACE.
         */
        workspaceConfig?: Schema$GoogleCloudDiscoveryengineV1alphaWorkspaceConfig;
    }
    /**
     * Estimation of data size per data store.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDataStoreBillingEstimation {
        /**
         * Data size for structured data in terms of bytes.
         */
        structuredDataSize?: string | null;
        /**
         * Last updated timestamp for structured data.
         */
        structuredDataUpdateTime?: string | null;
        /**
         * Data size for unstructured data in terms of bytes.
         */
        unstructuredDataSize?: string | null;
        /**
         * Last updated timestamp for unstructured data.
         */
        unstructuredDataUpdateTime?: string | null;
        /**
         * Data size for websites in terms of bytes.
         */
        websiteDataSize?: string | null;
        /**
         * Last updated timestamp for websites.
         */
        websiteDataUpdateTime?: string | null;
    }
    /**
     * Stores information regarding the serving configurations at DataStore level.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDataStoreServingConfigDataStore {
        /**
         * Optional. If set true, the DataStore will not be available for serving search requests.
         */
        disabledForServing?: boolean | null;
    }
    /**
     * The historical dedicated crawl rate timeseries data, used for monitoring. Dedicated crawl is used by Vertex AI to crawl the user's website when dedicate crawl is set.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDedicatedCrawlRateTimeSeries {
        /**
         * Vertex AI's error rate time series of auto-refresh dedicated crawl.
         */
        autoRefreshCrawlErrorRate?: Schema$GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries;
        /**
         * Vertex AI's dedicated crawl rate time series of auto-refresh, which is the crawl rate of Google-CloudVertexBot when dedicate crawl is set, and the crawl rate is for best effort use cases like refreshing urls periodically.
         */
        autoRefreshCrawlRate?: Schema$GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries;
        /**
         * Vertex AI's error rate time series of user triggered dedicated crawl.
         */
        userTriggeredCrawlErrorRate?: Schema$GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries;
        /**
         * Vertex AI's dedicated crawl rate time series of user triggered crawl, which is the crawl rate of Google-CloudVertexBot when dedicate crawl is set, and user triggered crawl rate is for deterministic use cases like crawling urls or sitemaps specified by users.
         */
        userTriggeredCrawlRate?: Schema$GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries;
    }
    /**
     * Metadata related to the progress of the CmekConfigService.DeleteCmekConfig operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteCmekConfigMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the CollectionService.UpdateCollection operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteCollectionMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the DataStoreService.DeleteDataStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteDataStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the EngineService.DeleteEngine operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteEngineMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the IdentityMappingStoreService.DeleteIdentityMappingStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteIdentityMappingStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for DeleteSchema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request for DeleteSession method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteSessionRequest {
        /**
         * Required. The resource name of the Session to delete. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/sessions/{session_id\}`
         */
        name?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DeleteSitemap operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteSitemapMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DeleteTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDeleteTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Defines target endpoints used to connect to third-party sources.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDestinationConfig {
        /**
         * Optional. The destinations for the corresponding key.
         */
        destinations?: Schema$GoogleCloudDiscoveryengineV1alphaDestinationConfigDestination[];
        /**
         * Optional. Unique destination identifier that is supported by the connector.
         */
        key?: string | null;
        /**
         * Optional. Additional parameters for this destination config.
         */
        params?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Defines a target endpoint
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDestinationConfigDestination {
        /**
         * Publicly routable host.
         */
        host?: string | null;
        /**
         * Optional. Target port number accepted by the destination.
         */
        port?: number | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDisableAdvancedSiteSearchResponse {
    }
    /**
     * A singleton resource of DataStore. If it's empty when DataStore is created and DataStore is set to DataStore.ContentConfig.CONTENT_REQUIRED, the default parser will default to digital parser.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfig {
        /**
         * Whether chunking mode is enabled.
         */
        chunkingConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig;
        /**
         * Configurations for default Document parser. If not specified, we will configure it as default DigitalParsingConfig, and the default parsing config will be applied to all file types for Document parsing.
         */
        defaultParsingConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig;
        /**
         * The full resource name of the Document Processing Config. Format: `projects/x/locations/x/collections/x/dataStores/x/documentProcessingConfig`.
         */
        name?: string | null;
        /**
         * Map from file type to override the default parsing configuration based on the file type. Supported keys: * `pdf`: Override parsing config for PDF files, either digital parsing, ocr parsing or layout parsing is supported. * `html`: Override parsing config for HTML files, only digital parsing and layout parsing are supported. * `docx`: Override parsing config for DOCX files, only digital parsing and layout parsing are supported. * `pptx`: Override parsing config for PPTX files, only digital parsing and layout parsing are supported. * `xlsm`: Override parsing config for XLSM files, only digital parsing and layout parsing are supported. * `xlsx`: Override parsing config for XLSX files, only digital parsing and layout parsing are supported.
         */
        parsingConfigOverrides?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig;
        } | null;
    }
    /**
     * Configuration for chunking config.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfig {
        /**
         * Configuration for the layout based chunking.
         */
        layoutBasedChunkingConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig;
    }
    /**
     * Configuration for the layout based chunking.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig {
        /**
         * The token size limit for each chunk. Supported values: 100-500 (inclusive). Default value: 500.
         */
        chunkSize?: number | null;
        /**
         * Whether to include appending different levels of headings to chunks from the middle of the document to prevent context loss. Default value: False.
         */
        includeAncestorHeadings?: boolean | null;
    }
    /**
     * Related configurations applied to a specific type of document parser.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfig {
        /**
         * Configurations applied to digital parser.
         */
        digitalParsingConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigDigitalParsingConfig;
        /**
         * Configurations applied to layout parser.
         */
        layoutParsingConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigLayoutParsingConfig;
        /**
         * Configurations applied to OCR parser. Currently it only applies to PDFs.
         */
        ocrParsingConfig?: Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig;
    }
    /**
     * The digital parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigDigitalParsingConfig {
    }
    /**
     * The layout parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigLayoutParsingConfig {
        /**
         * Optional. If true, the processed document will be made available for the GetProcessedDocument API.
         */
        enableGetProcessedDocument?: boolean | null;
        /**
         * Optional. If true, the LLM based annotation is added to the image during parsing.
         */
        enableImageAnnotation?: boolean | null;
        /**
         * Optional. If true, the LLM based annotation is added to the table during parsing.
         */
        enableTableAnnotation?: boolean | null;
        /**
         * Optional. List of HTML classes to exclude from the parsed content.
         */
        excludeHtmlClasses?: string[] | null;
        /**
         * Optional. List of HTML elements to exclude from the parsed content.
         */
        excludeHtmlElements?: string[] | null;
        /**
         * Optional. List of HTML ids to exclude from the parsed content.
         */
        excludeHtmlIds?: string[] | null;
        /**
         * Optional. Contains the required structure types to extract from the document. Supported values: * `shareholder-structure`
         */
        structuredContentTypes?: string[] | null;
    }
    /**
     * The OCR parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaDocumentProcessingConfigParsingConfigOcrParsingConfig {
        /**
         * [DEPRECATED] This field is deprecated. To use the additional enhanced document elements processing, please switch to `layout_parsing_config`.
         */
        enhancedDocumentElements?: string[] | null;
        /**
         * If true, will use native text instead of OCR text on pages containing native text.
         */
        useNativeText?: boolean | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEnableAdvancedSiteSearchResponse {
    }
    /**
     * Metadata that describes the training and serving parameters of an Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngine {
        /**
         * Configurations for the Chat Engine. Only applicable if solution_type is SOLUTION_TYPE_CHAT.
         */
        chatEngineConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig;
        /**
         * Output only. Additional information of the Chat Engine. Only applicable if solution_type is SOLUTION_TYPE_CHAT.
         */
        chatEngineMetadata?: Schema$GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata;
        /**
         * Common config spec that specifies the metadata of the engine.
         */
        commonConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineCommonConfig;
        /**
         * Output only. Timestamp the Recommendation Engine was created at.
         */
        createTime?: string | null;
        /**
         * Optional. The data stores associated with this engine. For SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store. If solution_type is SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be associated here. Note that when used in CreateEngineRequest, one DataStore id must be provided as the system will use it for necessary initializations.
         */
        dataStoreIds?: string[] | null;
        /**
         * Optional. Whether to disable analytics for searches performed on this engine.
         */
        disableAnalytics?: boolean | null;
        /**
         * Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
         */
        displayName?: string | null;
        /**
         * Optional. Feature config for the engine to opt in or opt out of features. Supported keys: * `*`: all features, if it's present, all other feature state settings are ignored. * `agent-gallery` * `no-code-agent-builder` * `prompt-gallery` * `model-selector` * `notebook-lm` * `people-search` * `people-search-org-chart` * `bi-directional-audio` * `feedback` * `session-sharing` * `personalization-memory` - Enables personalization based on user preferences.
         */
        features?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: Vertical on Engine has to match vertical of the DataStore linked to the engine.
         */
        industryVertical?: string | null;
        /**
         * Configurations for the Media Engine. Only applicable on the data stores with solution_type SOLUTION_TYPE_RECOMMENDATION and IndustryVertical.MEDIA vertical.
         */
        mediaRecommendationEngineConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig;
        /**
         * Immutable. Identifier. The fully qualified resource name of the engine. This field must be a UTF-8 encoded string with a length limit of 1024 characters. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}` engine should be 1-63 characters, and valid characters are /a-z0-9x/. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        name?: string | null;
        /**
         * Output only. Additional information of a recommendation engine. Only applicable if solution_type is SOLUTION_TYPE_RECOMMENDATION.
         */
        recommendationMetadata?: Schema$GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata;
        /**
         * Configurations for the Search Engine. Only applicable if solution_type is SOLUTION_TYPE_SEARCH.
         */
        searchEngineConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig;
        /**
         * Additional config specs for a `similar-items` engine.
         */
        similarDocumentsConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig;
        /**
         * Required. The solutions of the engine.
         */
        solutionType?: string | null;
        /**
         * Output only. Timestamp the Recommendation Engine was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Configurations for a Chat Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfig {
        /**
         * The configurationt generate the Dialogflow agent that is associated to this Engine. Note that these configurations are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
         */
        agentCreationConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig;
        /**
         * Optional. If the flag set to true, we allow the agent and engine are in different locations, otherwise the agent and engine are required to be in the same location. The flag is set to false by default. Note that the `allow_cross_region` are one-time consumed by and passed to EngineService.CreateEngine. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
         */
        allowCrossRegion?: boolean | null;
        /**
         * The resource name of an exist Dialogflow agent to link to this Chat Engine. Customers can either provide `agent_creation_config` to create agent or provide an agent name that links the agent with the Chat engine. Format: `projects//locations//agents/`. Note that the `dialogflow_agent_to_link` are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation. Use ChatEngineMetadata.dialogflow_agent for actual agent association after Engine is created.
         */
        dialogflowAgentToLink?: string | null;
    }
    /**
     * Configurations for generating a Dialogflow agent. Note that these configurations are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineChatEngineConfigAgentCreationConfig {
        /**
         * Name of the company, organization or other entity that the agent represents. Used for knowledge connector LLM prompt and for knowledge search.
         */
        business?: string | null;
        /**
         * Required. The default language of the agent as a language tag. See [Language Support](https://cloud.google.com/dialogflow/docs/reference/language) for a list of the currently supported language codes.
         */
        defaultLanguageCode?: string | null;
        /**
         * Agent location for Agent creation, supported values: global/us/eu. If not provided, us Engine will create Agent using us-central-1 by default; eu Engine will create Agent using eu-west-1 by default.
         */
        location?: string | null;
        /**
         * Required. The time zone of the agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
         */
        timeZone?: string | null;
    }
    /**
     * Additional information of a Chat Engine. Fields in this message are output only.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineChatEngineMetadata {
        /**
         * The resource name of a Dialogflow agent, that this Chat Engine refers to. Format: `projects//locations//agents/`.
         */
        dialogflowAgent?: string | null;
    }
    /**
     * Common configurations for an Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineCommonConfig {
        /**
         * The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.
         */
        companyName?: string | null;
    }
    /**
     * Additional config specs for a Media Recommendation engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfig {
        /**
         * Optional. Additional engine features config.
         */
        engineFeaturesConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigEngineFeaturesConfig;
        /**
         * The optimization objective. e.g., `cvr`. This field together with optimization_objective describe engine metadata to use to control engine training and serving. Currently supported values: `ctr`, `cvr`. If not specified, we choose default based on engine type. Default depends on type of recommendation: `recommended-for-you` =\> `ctr` `others-you-may-like` =\> `ctr`
         */
        optimizationObjective?: string | null;
        /**
         * Name and value of the custom threshold for cvr optimization_objective. For target_field `watch-time`, target_field_value must be an integer value indicating the media progress time in seconds between (0, 86400] (excludes 0, includes 86400) (e.g., 90). For target_field `watch-percentage`, the target_field_value must be a valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g., 0.5).
         */
        optimizationObjectiveConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig;
        /**
         * The training state that the engine is in (e.g. `TRAINING` or `PAUSED`). Since part of the cost of running the service is frequency of training - this can be used to determine when to train engine in order to control cost. If not specified: the default value for `CreateEngine` method is `TRAINING`. The default value for `UpdateEngine` method is to keep the state the same as before.
         */
        trainingState?: string | null;
        /**
         * Required. The type of engine. e.g., `recommended-for-you`. This field together with optimization_objective describe engine metadata to use to control engine training and serving. Currently supported values: `recommended-for-you`, `others-you-may-like`, `more-like-this`, `most-popular-items`.
         */
        type?: string | null;
    }
    /**
     * More feature configs of the selected engine type.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigEngineFeaturesConfig {
        /**
         * Most popular engine feature config.
         */
        mostPopularConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigMostPopularFeatureConfig;
        /**
         * Recommended for you engine feature config.
         */
        recommendedForYouConfig?: Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig;
    }
    /**
     * Feature configurations that are required for creating a Most Popular engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigMostPopularFeatureConfig {
        /**
         * The time window of which the engine is queried at training and prediction time. Positive integers only. The value translates to the last X days of events. Currently required for the `most-popular-items` engine.
         */
        timeWindowDays?: string | null;
    }
    /**
     * Custom threshold for `cvr` optimization_objective.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig {
        /**
         * Required. The name of the field to target. Currently supported values: `watch-percentage`, `watch-time`.
         */
        targetField?: string | null;
        /**
         * Required. The threshold to be applied to the target (e.g., 0.5).
         */
        targetFieldValueFloat?: number | null;
    }
    /**
     * Additional feature configurations for creating a `recommended-for-you` engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig {
        /**
         * The type of event with which the engine is queried at prediction time. If set to `generic`, only `view-item`, `media-play`,and `media-complete` will be used as `context-event` in engine training. If set to `view-home-page`, `view-home-page` will also be used as `context-events` in addition to `view-item`, `media-play`, and `media-complete`. Currently supported for the `recommended-for-you` engine. Currently supported values: `view-home-page`, `generic`.
         */
        contextEventType?: string | null;
    }
    /**
     * Additional information of a recommendation engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineRecommendationMetadata {
        /**
         * Output only. The state of data requirements for this engine: `DATA_OK` and `DATA_ERROR`. Engine cannot be trained if the data is in `DATA_ERROR` state. Engine can have `DATA_ERROR` state even if serving state is `ACTIVE`: engines were trained successfully before, but cannot be refreshed because the underlying engine no longer has sufficient data for training.
         */
        dataState?: string | null;
        /**
         * Output only. The timestamp when the latest successful training finished. Only applicable on Media Recommendation engines.
         */
        lastTrainTime?: string | null;
        /**
         * Output only. The timestamp when the latest successful tune finished. Only applicable on Media Recommendation engines.
         */
        lastTuneTime?: string | null;
        /**
         * Output only. The serving state of the engine: `ACTIVE`, `NOT_ACTIVE`.
         */
        servingState?: string | null;
        /**
         * Output only. The latest tune operation id associated with the engine. Only applicable on Media Recommendation engines. If present, this operation id can be used to determine if there is an ongoing tune for this engine. To check the operation status, send the GetOperation request with this operation id in the engine resource format. If no tuning has happened for this engine, the string is empty.
         */
        tuningOperation?: string | null;
    }
    /**
     * Configurations for a Search Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineSearchEngineConfig {
        /**
         * The add-on that this search engine enables.
         */
        searchAddOns?: string[] | null;
        /**
         * The search feature tier of this engine. Different tiers might have different pricing. To learn more, check the pricing documentation. Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
         */
        searchTier?: string | null;
    }
    /**
     * Additional config specs for a `similar-items` engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEngineSimilarDocumentsEngineConfig {
    }
    /**
     * Metadata related to the progress of the EstimateDataSize operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEstimateDataSizeMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
    }
    /**
     * Response of the EstimateDataSize request. If the long running operation was successful, then this message is returned by the google.longrunning.Operations.response field if the operation was successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEstimateDataSizeResponse {
        /**
         * Data size in terms of bytes.
         */
        dataSizeBytes?: string | null;
        /**
         * Total number of documents.
         */
        documentCount?: string | null;
    }
    /**
     * An evaluation is a single execution (or run) of an evaluation process. It encapsulates the state of the evaluation and the resulting data.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEvaluation {
        /**
         * Output only. Timestamp the Evaluation was created at.
         */
        createTime?: string | null;
        /**
         * Output only. Timestamp the Evaluation was completed at.
         */
        endTime?: string | null;
        /**
         * Output only. The error that occurred during evaluation. Only populated when the evaluation's state is FAILED.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Required. The specification of the evaluation.
         */
        evaluationSpec?: Schema$GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpec;
        /**
         * Identifier. The full resource name of the Evaluation, in the format of `projects/{project\}/locations/{location\}/evaluations/{evaluation\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * Output only. The metrics produced by the evaluation, averaged across all SampleQuerys in the SampleQuerySet. Only populated when the evaluation's state is SUCCEEDED.
         */
        qualityMetrics?: Schema$GoogleCloudDiscoveryengineV1alphaQualityMetrics;
        /**
         * Output only. The state of the evaluation.
         */
        state?: string | null;
    }
    /**
     * Describes the specification of the evaluation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpec {
        /**
         * Optional. The specification of the query set.
         */
        querySetSpec?: Schema$GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpecQuerySetSpec;
        /**
         * Required. The search request that is used to perform the evaluation. Only the following fields within SearchRequest are supported; if any other fields are provided, an UNSUPPORTED error will be returned: * SearchRequest.serving_config * SearchRequest.branch * SearchRequest.canonical_filter * SearchRequest.query_expansion_spec * SearchRequest.spell_correction_spec * SearchRequest.content_search_spec * SearchRequest.user_pseudo_id
         */
        searchRequest?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequest;
    }
    /**
     * Describes the specification of the query set.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaEvaluationEvaluationSpecQuerySetSpec {
        /**
         * Optional. The full resource name of the SampleQuerySet used for the evaluation, in the format of `projects/{project\}/locations/{location\}/sampleQuerySets/{sampleQuerySet\}`.
         */
        sampleQuerySet?: string | null;
    }
    /**
     * Metadata related to the progress of the Export operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaExportMetricsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the ExportMetricsRequest. If the long running operation was successful, then this message is returned by the google.longrunning.Operations.response field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaExportMetricsResponse {
    }
    /**
     * Configurations for fields of a schema. For example, configuring a field is indexable, or searchable.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaFieldConfig {
        /**
         * If this field is set, only the corresponding source will be indexed for this field. Otherwise, the values from different sources are merged. Assuming a page with `` in meta tag, and `` in page map: if this enum is set to METATAGS, we will only index ``; if this enum is not set, we will merge them and index ``.
         */
        advancedSiteSearchDataSources?: string[] | null;
        /**
         * If completable_option is COMPLETABLE_ENABLED, field values are directly used and returned as suggestions for Autocomplete in CompletionService.CompleteQuery. If completable_option is unset, the server behavior defaults to COMPLETABLE_DISABLED for fields that support setting completable options, which are just `string` fields. For those fields that do not support setting completable options, the server will skip completable option setting, and setting completable_option for those fields will throw `INVALID_ARGUMENT` error.
         */
        completableOption?: string | null;
        /**
         * If dynamic_facetable_option is DYNAMIC_FACETABLE_ENABLED, field values are available for dynamic facet. Could only be DYNAMIC_FACETABLE_DISABLED if FieldConfig.indexable_option is INDEXABLE_DISABLED. Otherwise, an `INVALID_ARGUMENT` error will be returned. If dynamic_facetable_option is unset, the server behavior defaults to DYNAMIC_FACETABLE_DISABLED for fields that support setting dynamic facetable options. For those fields that do not support setting dynamic facetable options, such as `object` and `boolean`, the server will skip dynamic facetable option setting, and setting dynamic_facetable_option for those fields will throw `INVALID_ARGUMENT` error.
         */
        dynamicFacetableOption?: string | null;
        /**
         * Required. Field path of the schema field. For example: `title`, `description`, `release_info.release_year`.
         */
        fieldPath?: string | null;
        /**
         * Output only. Raw type of the field.
         */
        fieldType?: string | null;
        /**
         * If indexable_option is INDEXABLE_ENABLED, field values are indexed so that it can be filtered or faceted in SearchService.Search. If indexable_option is unset, the server behavior defaults to INDEXABLE_DISABLED for fields that support setting indexable options. For those fields that do not support setting indexable options, such as `object` and `boolean` and key properties, the server will skip indexable_option setting, and setting indexable_option for those fields will throw `INVALID_ARGUMENT` error.
         */
        indexableOption?: string | null;
        /**
         * Output only. Type of the key property that this field is mapped to. Empty string if this is not annotated as mapped to a key property. Example types are `title`, `description`. Full list is defined by `keyPropertyMapping` in the schema field annotation. If the schema field has a `KeyPropertyMapping` annotation, `indexable_option` and `searchable_option` of this field cannot be modified.
         */
        keyPropertyType?: string | null;
        /**
         * Optional. The metatag name found in the HTML page. If user defines this field, the value of this metatag name will be used to extract metatag. If the user does not define this field, the FieldConfig.field_path will be used to extract metatag.
         */
        metatagName?: string | null;
        /**
         * If recs_filterable_option is FILTERABLE_ENABLED, field values are filterable by filter expression in RecommendationService.Recommend. If FILTERABLE_ENABLED but the field type is numerical, field values are not filterable by text queries in RecommendationService.Recommend. Only textual fields are supported. If recs_filterable_option is unset, the default setting is FILTERABLE_DISABLED for fields that support setting filterable options. When a field set to [FILTERABLE_DISABLED] is filtered, a warning is generated and an empty result is returned.
         */
        recsFilterableOption?: string | null;
        /**
         * If retrievable_option is RETRIEVABLE_ENABLED, field values are included in the search results. If retrievable_option is unset, the server behavior defaults to RETRIEVABLE_DISABLED for fields that support setting retrievable options. For those fields that do not support setting retrievable options, such as `object` and `boolean`, the server will skip retrievable option setting, and setting retrievable_option for those fields will throw `INVALID_ARGUMENT` error.
         */
        retrievableOption?: string | null;
        /**
         * Field paths for indexing custom attribute from schema.org data. More details of schema.org and its defined types can be found at [schema.org](https://schema.org). It is only used on advanced site search schema. Currently only support full path from root. The full path to a field is constructed by concatenating field names, starting from `_root`, with a period `.` as the delimiter. Examples: * Publish date of the root: _root.datePublished * Publish date of the reviews: _root.review.datePublished
         */
        schemaOrgPaths?: string[] | null;
        /**
         * If searchable_option is SEARCHABLE_ENABLED, field values are searchable by text queries in SearchService.Search. If SEARCHABLE_ENABLED but field type is numerical, field values will not be searchable by text queries in SearchService.Search, as there are no text values associated to numerical fields. If searchable_option is unset, the server behavior defaults to SEARCHABLE_DISABLED for fields that support setting searchable options. Only `string` fields that have no key property mapping support setting searchable_option. For those fields that do not support setting searchable options, the server will skip searchable option setting, and setting searchable_option for those fields will throw `INVALID_ARGUMENT` error.
         */
        searchableOption?: string | null;
    }
    /**
     * Request for GetSession method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaGetSessionRequest {
        /**
         * Optional. If set to true, the full session including all answer details will be returned.
         */
        includeAnswerDetails?: boolean | null;
        /**
         * Required. The resource name of the Session to get. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/sessions/{session_id\}`
         */
        name?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.GetUriPatternDocumentData method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaGetUriPatternDocumentDataResponse {
        /**
         * Document data keyed by URI pattern. For example: document_data_map = { "www.url1.com/x": { "Categories": ["category1", "category2"] \}, "www.url2.com/x": { "Categories": ["category3"] \} \}
         */
        documentDataMap?: {
            [key: string]: {
                [key: string]: any;
            };
        } | null;
    }
    /**
     * Config to data store for `HEALTHCARE_FHIR` vertical.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaHealthcareFhirConfig {
        /**
         * Whether to enable configurable schema for `HEALTHCARE_FHIR` vertical. If set to `true`, the predefined healthcare fhir schema can be extended for more customized searching and filtering.
         */
        enableConfigurableSchema?: boolean | null;
        /**
         * Whether to enable static indexing for `HEALTHCARE_FHIR` batch ingestion. If set to `true`, the batch ingestion will be processed in a static indexing mode which is slower but more capable of handling larger volume.
         */
        enableStaticIndexingForBatchIngestion?: boolean | null;
    }
    /**
     * IdentityMappingEntry LongRunningOperation metadata for IdentityMappingStoreService.ImportIdentityMappings and IdentityMappingStoreService.PurgeIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaIdentityMappingEntryOperationMetadata {
        /**
         * The number of IdentityMappingEntries that failed to be processed.
         */
        failureCount?: string | null;
        /**
         * The number of IdentityMappingEntries that were successfully processed.
         */
        successCount?: string | null;
        /**
         * The total number of IdentityMappingEntries that were processed.
         */
        totalCount?: string | null;
    }
    /**
     * The configuration for the identity data synchronization runs.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaIdentityScheduleConfig {
        /**
         * Optional. The UTC time when the next data sync is expected to start for the Data Connector. Customers are only able to specify the hour and minute to schedule the data sync. This is utilized when the data connector has a refresh interval greater than 1 day.
         */
        nextSyncTime?: Schema$GoogleTypeDateTime;
        /**
         * Optional. The refresh interval to sync the Access Control List information for the documents ingested by this connector. If not set, the access control list will be refreshed at the default interval of 30 minutes. The identity refresh interval can be at least 30 minutes and at most 7 days.
         */
        refreshInterval?: string | null;
    }
    /**
     * Identity Provider Config.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaIdpConfig {
        /**
         * External Identity provider config.
         */
        externalIdpConfig?: Schema$GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig;
        /**
         * Identity provider type configured.
         */
        idpType?: string | null;
    }
    /**
     * Third party IDP Config.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaIdpConfigExternalIdpConfig {
        /**
         * Workforce pool name. Example: "locations/global/workforcePools/pool_id"
         */
        workforcePoolName?: string | null;
    }
    /**
     * Metadata related to the progress of the ImportCompletionSuggestions operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of CompletionSuggestions that failed to be imported.
         */
        failureCount?: string | null;
        /**
         * Count of CompletionSuggestions successfully imported.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the CompletionService.ImportCompletionSuggestions method. If the long running operation is done, this message is returned by the google.longrunning.Operations.response field if the operation is successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportCompletionSuggestionsResponse {
        /**
         * The desired location of errors incurred during the Import.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1alphaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Metadata related to the progress of the ImportDocuments operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportDocumentsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were processed successfully.
         */
        successCount?: string | null;
        /**
         * Total count of entries that were processed.
         */
        totalCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the ImportDocumentsRequest. If the long running operation is done, then this message is returned by the google.longrunning.Operations.response field if the operation was successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportDocumentsResponse {
        /**
         * Echoes the destination for the complete errors in the request if set.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1alphaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Configuration of destination for Import related errors.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportErrorConfig {
        /**
         * Cloud Storage prefix for import errors. This must be an empty, existing Cloud Storage directory. Import errors are written to sharded files in this directory, one per line, as a JSON-encoded `google.rpc.Status` message.
         */
        gcsPrefix?: string | null;
    }
    /**
     * Response message for IdentityMappingStoreService.ImportIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportIdentityMappingsResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Metadata related to the progress of the ImportSampleQueries operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportSampleQueriesMetadata {
        /**
         * ImportSampleQueries operation create time.
         */
        createTime?: string | null;
        /**
         * Count of SampleQuerys that failed to be imported.
         */
        failureCount?: string | null;
        /**
         * Count of SampleQuerys successfully imported.
         */
        successCount?: string | null;
        /**
         * Total count of SampleQuerys that were processed.
         */
        totalCount?: string | null;
        /**
         * ImportSampleQueries operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the SampleQueryService.ImportSampleQueries method. If the long running operation is done, this message is returned by the google.longrunning.Operations.response field if the operation is successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportSampleQueriesResponse {
        /**
         * The desired location of errors incurred during the Import.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1alphaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Metadata related to the progress of the ImportSuggestionDenyListEntries operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CompletionService.ImportSuggestionDenyListEntries method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportSuggestionDenyListEntriesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Count of deny list entries that failed to be imported.
         */
        failedEntriesCount?: string | null;
        /**
         * Count of deny list entries successfully imported.
         */
        importedEntriesCount?: string | null;
    }
    /**
     * Metadata related to the progress of the Import operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportUserEventsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were processed successfully.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the ImportUserEventsRequest. If the long running operation was successful, then this message is returned by the google.longrunning.Operations.response field if the operation was successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaImportUserEventsResponse {
        /**
         * Echoes the destination for the complete errors if this field was set in the request.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1alphaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Count of user events imported with complete existing Documents.
         */
        joinedEventsCount?: string | null;
        /**
         * Count of user events imported, but with Document information not found in the existing Branch.
         */
        unjoinedEventsCount?: string | null;
    }
    /**
     * A floating point interval.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaInterval {
        /**
         * Exclusive upper bound.
         */
        exclusiveMaximum?: number | null;
        /**
         * Exclusive lower bound.
         */
        exclusiveMinimum?: number | null;
        /**
         * Inclusive upper bound.
         */
        maximum?: number | null;
        /**
         * Inclusive lower bound.
         */
        minimum?: number | null;
    }
    /**
     * Language info for DataStore.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaLanguageInfo {
        /**
         * Output only. Language part of normalized_language_code. E.g.: `en-US` -\> `en`, `zh-Hans-HK` -\> `zh`, `en` -\> `en`.
         */
        language?: string | null;
        /**
         * The language code for the DataStore.
         */
        languageCode?: string | null;
        /**
         * Output only. This is the normalized form of language_code. E.g.: language_code of `en-GB`, `en_GB`, `en-UK` or `en-gb` will have normalized_language_code of `en-GB`.
         */
        normalizedLanguageCode?: string | null;
        /**
         * Output only. Region part of normalized_language_code, if present. E.g.: `en-US` -\> `US`, `zh-Hans-HK` -\> `HK`, `en` -\> ``.
         */
        region?: string | null;
    }
    /**
     * Request for ListSessions method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaListSessionsRequest {
        /**
         * A comma-separated list of fields to filter by, in EBNF grammar. The supported fields are: * `user_pseudo_id` * `state` * `display_name` * `starred` * `is_pinned` * `labels` * `create_time` * `update_time` Examples: * `user_pseudo_id = some_id` * `display_name = "some_name"` * `starred = true` * `is_pinned=true AND (NOT labels:hidden)` * `create_time \> "1970-01-01T12:00:00Z"`
         */
        filter?: string | null;
        /**
         * A comma-separated list of fields to order by, sorted in ascending order. Use "desc" after a field name for descending. Supported fields: * `update_time` * `create_time` * `session_name` * `is_pinned` Example: * `update_time desc` * `create_time` * `is_pinned desc,update_time desc`: list sessions by is_pinned first, then by update_time.
         */
        orderBy?: string | null;
        /**
         * Maximum number of results to return. If unspecified, defaults to 50. Max allowed value is 1000.
         */
        pageSize?: number | null;
        /**
         * A page token, received from a previous `ListSessions` call. Provide this to retrieve the subsequent page.
         */
        pageToken?: string | null;
        /**
         * Required. The data store resource name. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}`
         */
        parent?: string | null;
    }
    /**
     * Response for ListSessions method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaListSessionsResponse {
        /**
         * Pagination token, if not returned indicates the last page.
         */
        nextPageToken?: string | null;
        /**
         * All the Sessions for a given data store.
         */
        sessions?: Schema$GoogleCloudDiscoveryengineV1alphaSession[];
    }
    /**
     * Configuration for Natural Language Query Understanding.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaNaturalLanguageQueryUnderstandingConfig {
        /**
         * Mode of Natural Language Query Understanding. If this field is unset, the behavior defaults to NaturalLanguageQueryUnderstandingConfig.Mode.DISABLED.
         */
        mode?: string | null;
    }
    /**
     * Response message for CrawlRateManagementService.ObtainCrawlRate method. The response contains organcic or dedicated crawl rate time series data for monitoring, depending on whether dedicated crawl rate is set.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaObtainCrawlRateResponse {
        /**
         * The historical dedicated crawl rate timeseries data, used for monitoring.
         */
        dedicatedCrawlRateTimeSeries?: Schema$GoogleCloudDiscoveryengineV1alphaDedicatedCrawlRateTimeSeries;
        /**
         * Errors from service when handling the request.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The historical organic crawl rate timeseries data, used for monitoring.
         */
        organicCrawlRateTimeSeries?: Schema$GoogleCloudDiscoveryengineV1alphaOrganicCrawlRateTimeSeries;
        /**
         * Output only. The state of the response.
         */
        state?: string | null;
    }
    /**
     * The historical organic crawl rate timeseries data, used for monitoring. Organic crawl is auto-determined by Google to crawl the user's website when dedicate crawl is not set. Crawl rate is the QPS of crawl request Google sends to the user's website.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaOrganicCrawlRateTimeSeries {
        /**
         * Google's organic crawl rate time series, which is the sum of all googlebots' crawl rate. Please refer to https://developers.google.com/search/docs/crawling-indexing/overview-google-crawlers for more details about googlebots.
         */
        googleOrganicCrawlRate?: Schema$GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries;
        /**
         * Vertex AI's organic crawl rate time series, which is the crawl rate of Google-CloudVertexBot when dedicate crawl is not set. Please refer to https://developers.google.com/search/docs/crawling-indexing/google-common-crawlers#google-cloudvertexbot for more details about Google-CloudVertexBot.
         */
        vertexAiOrganicCrawlRate?: Schema$GoogleCloudDiscoveryengineV1alphaCrawlRateTimeSeries;
    }
    /**
     * Metadata and configurations for a Google Cloud project in the service.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaProject {
        /**
         * Output only. The timestamp when this project is created.
         */
        createTime?: string | null;
        /**
         * Output only. Full resource name of the project, for example `projects/{project\}`. Note that when making requests, project number and project id are both acceptable, but the server will always respond in project number.
         */
        name?: string | null;
        /**
         * Output only. The timestamp when this project is successfully provisioned. Empty value means this project is still provisioning and is not ready for use.
         */
        provisionCompletionTime?: string | null;
        /**
         * Output only. A map of terms of services. The key is the `id` of ServiceTerms.
         */
        serviceTermsMap?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1alphaProjectServiceTerms;
        } | null;
    }
    /**
     * Metadata about the terms of service.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaProjectServiceTerms {
        /**
         * The last time when the project agreed to the terms of service.
         */
        acceptTime?: string | null;
        /**
         * The last time when the project declined or revoked the agreement to terms of service.
         */
        declineTime?: string | null;
        /**
         * The unique identifier of this terms of service. Available terms: * `GA_DATA_USE_TERMS`: [Terms for data use](https://cloud.google.com/retail/data-use-terms). When using this as `id`, the acceptable version to provide is `2022-11-23`.
         */
        id?: string | null;
        /**
         * Whether the project has accepted/rejected the service terms or it is still pending.
         */
        state?: string | null;
        /**
         * The version string of the terms of service. For acceptable values, see the comments for id above.
         */
        version?: string | null;
    }
    /**
     * Metadata associated with a project provision operation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaProvisionProjectMetadata {
    }
    /**
     * Metadata related to the progress of the PurgeCompletionSuggestions operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CompletionService.PurgeCompletionSuggestions method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaPurgeCompletionSuggestionsResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Whether the completion suggestions were successfully purged.
         */
        purgeSucceeded?: boolean | null;
    }
    /**
     * Metadata related to the progress of the PurgeDocuments operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaPurgeDocumentsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were ignored as entries were not found.
         */
        ignoredCount?: string | null;
        /**
         * Count of entries that were deleted successfully.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for DocumentService.PurgeDocuments method. If the long running operation is successfully done, then this message is returned by the google.longrunning.Operations.response field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaPurgeDocumentsResponse {
        /**
         * The total count of documents purged as a result of the operation.
         */
        purgeCount?: string | null;
        /**
         * A sample of document names that will be deleted. Only populated if `force` is set to false. A max of 100 names will be returned and the names are chosen at random.
         */
        purgeSample?: string[] | null;
    }
    /**
     * Metadata related to the progress of the PurgeSuggestionDenyListEntries operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CompletionService.PurgeSuggestionDenyListEntries method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaPurgeSuggestionDenyListEntriesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Number of suggestion deny list entries purged.
         */
        purgeCount?: string | null;
    }
    /**
     * Metadata related to the progress of the PurgeUserEvents operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaPurgeUserEventsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were deleted successfully.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the PurgeUserEventsRequest. If the long running operation is successfully done, then this message is returned by the google.longrunning.Operations.response field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaPurgeUserEventsResponse {
        /**
         * The total count of events purged as a result of the operation.
         */
        purgeCount?: string | null;
    }
    /**
     * Describes the metrics produced by the evaluation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaQualityMetrics {
        /**
         * Normalized discounted cumulative gain (NDCG) per document, at various top-k cutoff levels. NDCG measures the ranking quality, giving higher relevance to top results. Example (top-3): Suppose SampleQuery with three retrieved documents (D1, D2, D3) and binary relevance judgements (1 for relevant, 0 for not relevant): Retrieved: [D3 (0), D1 (1), D2 (1)] Ideal: [D1 (1), D2 (1), D3 (0)] Calculate NDCG@3 for each SampleQuery: * DCG@3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13 * Ideal DCG@3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63 * NDCG@3: 1.13/1.63 = 0.693
         */
        docNdcg?: Schema$GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics;
        /**
         * Precision per document, at various top-k cutoff levels. Precision is the fraction of retrieved documents that are relevant. Example (top-5): * For a single SampleQuery, If 4 out of 5 retrieved documents in the top-5 are relevant, precision@5 = 4/5 = 0.8
         */
        docPrecision?: Schema$GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics;
        /**
         * Recall per document, at various top-k cutoff levels. Recall is the fraction of relevant documents retrieved out of all relevant documents. Example (top-5): * For a single SampleQuery, If 3 out of 5 relevant documents are retrieved in the top-5, recall@5 = 3/5 = 0.6
         */
        docRecall?: Schema$GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics;
        /**
         * Normalized discounted cumulative gain (NDCG) per page, at various top-k cutoff levels. NDCG measures the ranking quality, giving higher relevance to top results. Example (top-3): Suppose SampleQuery with three retrieved pages (P1, P2, P3) and binary relevance judgements (1 for relevant, 0 for not relevant): Retrieved: [P3 (0), P1 (1), P2 (1)] Ideal: [P1 (1), P2 (1), P3 (0)] Calculate NDCG@3 for SampleQuery: * DCG@3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13 * Ideal DCG@3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63 * NDCG@3: 1.13/1.63 = 0.693
         */
        pageNdcg?: Schema$GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics;
        /**
         * Recall per page, at various top-k cutoff levels. Recall is the fraction of relevant pages retrieved out of all relevant pages. Example (top-5): * For a single SampleQuery, if 3 out of 5 relevant pages are retrieved in the top-5, recall@5 = 3/5 = 0.6
         */
        pageRecall?: Schema$GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics;
    }
    /**
     * Stores the metric values at specific top-k levels.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaQualityMetricsTopkMetrics {
        /**
         * The top-1 value.
         */
        top1?: number | null;
        /**
         * The top-10 value.
         */
        top10?: number | null;
        /**
         * The top-3 value.
         */
        top3?: number | null;
        /**
         * The top-5 value.
         */
        top5?: number | null;
    }
    /**
     * Defines a user inputed query.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaQuery {
        /**
         * Output only. Unique Id for the query.
         */
        queryId?: string | null;
        /**
         * Plain text.
         */
        text?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.RecrawlUris operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaRecrawlUrisMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Unique URIs in the request that have invalid format. Sample limited to 1000.
         */
        invalidUris?: string[] | null;
        /**
         * Total number of unique URIs in the request that have invalid format.
         */
        invalidUrisCount?: number | null;
        /**
         * URIs that have no index meta tag. Sample limited to 1000.
         */
        noindexUris?: string[] | null;
        /**
         * Total number of URIs that have no index meta tag.
         */
        noindexUrisCount?: number | null;
        /**
         * Total number of URIs that have yet to be crawled.
         */
        pendingCount?: number | null;
        /**
         * Total number of URIs that were rejected due to insufficient indexing resources.
         */
        quotaExceededCount?: number | null;
        /**
         * Total number of URIs that have been crawled so far.
         */
        successCount?: number | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
        /**
         * Unique URIs in the request that don't match any TargetSite in the DataStore, only match TargetSites that haven't been fully indexed, or match a TargetSite with type EXCLUDE. Sample limited to 1000.
         */
        urisNotMatchingTargetSites?: string[] | null;
        /**
         * Total number of URIs that don't match any TargetSites.
         */
        urisNotMatchingTargetSitesCount?: number | null;
        /**
         * Total number of unique URIs in the request that are not in invalid_uris.
         */
        validUrisCount?: number | null;
    }
    /**
     * Response message for SiteSearchEngineService.RecrawlUris method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponse {
        /**
         * URIs that were not crawled before the LRO terminated.
         */
        failedUris?: string[] | null;
        /**
         * Details for a sample of up to 10 `failed_uris`.
         */
        failureSamples?: Schema$GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo[];
    }
    /**
     * Details about why a particular URI failed to be crawled. Each FailureInfo contains one FailureReason per CorpusType.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfo {
        /**
         * List of failure reasons by corpus type (e.g. desktop, mobile).
         */
        failureReasons?: Schema$GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason[];
        /**
         * URI that failed to be crawled.
         */
        uri?: string | null;
    }
    /**
     * Details about why crawling failed for a particular CorpusType, e.g., DESKTOP and MOBILE crawling may fail for different reasons.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaRecrawlUrisResponseFailureInfoFailureReason {
        /**
         * DESKTOP, MOBILE, or CORPUS_TYPE_UNSPECIFIED.
         */
        corpusType?: string | null;
        /**
         * Reason why the URI was not crawled.
         */
        errorMessage?: string | null;
    }
    /**
     * Metadata related to the progress of the CrawlRateManagementService.RemoveDedicatedCrawlRate operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaRemoveDedicatedCrawlRateMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CrawlRateManagementService.RemoveDedicatedCrawlRate method. It simply returns the state of the response, and an error message if the state is FAILED.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaRemoveDedicatedCrawlRateResponse {
        /**
         * Errors from service when handling the request.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. The state of the response.
         */
        state?: string | null;
    }
    /**
     * Safety rating corresponding to the generated content.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSafetyRating {
        /**
         * Output only. Indicates whether the content was filtered out because of this rating.
         */
        blocked?: boolean | null;
        /**
         * Output only. Harm category.
         */
        category?: string | null;
        /**
         * Output only. Harm probability levels in the content.
         */
        probability?: string | null;
        /**
         * Output only. Harm probability score.
         */
        probabilityScore?: number | null;
        /**
         * Output only. Harm severity levels in the content.
         */
        severity?: string | null;
        /**
         * Output only. Harm severity score.
         */
        severityScore?: number | null;
    }
    /**
     * Defines the structure and layout of a type of document data.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSchema {
        /**
         * Output only. Configurations for fields of the schema.
         */
        fieldConfigs?: Schema$GoogleCloudDiscoveryengineV1alphaFieldConfig[];
        /**
         * The JSON representation of the schema.
         */
        jsonSchema?: string | null;
        /**
         * Immutable. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * The structured representation of the schema.
         */
        structSchema?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Promotion proto includes uri and other helping information to display the promotion.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchLinkPromotion {
        /**
         * Optional. The Promotion description. Maximum length: 200 characters.
         */
        description?: string | null;
        /**
         * Optional. The Document the user wants to promote. For site search, leave unset and only populate uri. Can be set along with uri.
         */
        document?: string | null;
        /**
         * Optional. The enabled promotion will be returned for any serving configs associated with the parent of the control this promotion is attached to. This flag is used for basic site search only.
         */
        enabled?: boolean | null;
        /**
         * Optional. The promotion thumbnail image url.
         */
        imageUri?: string | null;
        /**
         * Required. The title of the promotion. Maximum length: 160 characters.
         */
        title?: string | null;
        /**
         * Optional. The URL for the page the user wants to promote. Must be set for site search. For other verticals, this is optional.
         */
        uri?: string | null;
    }
    /**
     * Request message for SearchService.Search method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequest {
        /**
         * Boost specification to boost certain documents. For more information on boosting, see [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec;
        /**
         * The branch resource name, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`. Use `default_branch` as the branch ID or leave this field empty, to search documents under the default branch.
         */
        branch?: string | null;
        /**
         * The default filter that is applied when a user performs a search without checking any filters on the search page. The filter applied to every search request when quality improvement such as query expansion is needed. In the case a query does not have a sufficient amount of results this filter will be used to determine whether or not to enable the query expansion flow. The original filter will still be used for the query expanded search. This field is strongly recommended to achieve high search quality. For more information about filter syntax, see SearchRequest.filter.
         */
        canonicalFilter?: string | null;
        /**
         * A specification for configuring the behavior of content search.
         */
        contentSearchSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec;
        /**
         * Custom fine tuning configs. If set, it has higher priority than the configs set in ServingConfig.custom_fine_tuning_spec.
         */
        customFineTuningSpec?: Schema$GoogleCloudDiscoveryengineV1alphaCustomFineTuningSpec;
        /**
         * Specifications that define the specific DataStores to be searched, along with configurations for those data stores. This is only considered for Engines with multiple data stores. For engines with a single data store, the specs directly under SearchRequest should be used.
         */
        dataStoreSpecs?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestDataStoreSpec[];
        /**
         * Optional. Config for display feature, like match highlighting on search results.
         */
        displaySpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestDisplaySpec;
        /**
         * Uses the provided embedding to do additional semantic document retrieval. The retrieval is based on the dot product of SearchRequest.EmbeddingSpec.EmbeddingVector.vector and the document embedding that is provided in SearchRequest.EmbeddingSpec.EmbeddingVector.field_path. If SearchRequest.EmbeddingSpec.EmbeddingVector.field_path is not provided, it will use ServingConfig.EmbeddingConfig.field_path.
         */
        embeddingSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec;
        /**
         * Facet specifications for faceted search. If empty, no facets are returned. A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        facetSpecs?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec[];
        /**
         * The filter syntax consists of an expression language for constructing a predicate from one or more fields of the documents being filtered. Filter expression is case-sensitive. If this field is unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI Search is done by mapping the LHS filter key to a key property defined in the Vertex AI Search backend -- this mapping is defined by the customer in their schema. For example a media customer might have a field 'name' in their schema. In this case the filter would look like this: filter --\> name:'ANY("king kong")' For more information about filtering including syntax and filter operators, see [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
        /**
         * Raw image query.
         */
        imageQuery?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery;
        /**
         * The BCP-47 language code, such as "en-US" or "sr-Latn". For more information, see [Standard fields](https://cloud.google.com/apis/design/standard_fields). This field helps to better interpret the query. If a value isn't specified, the query language code is automatically detected, which may not be accurate.
         */
        languageCode?: string | null;
        /**
         * Config for natural language query understanding capabilities, such as extracting structured field filters from the query. Refer to [this documentation](https://cloud.google.com/generative-ai-app-builder/docs/natural-language-queries) for more information. If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional natural language query understanding will be done.
         */
        naturalLanguageQueryUnderstandingSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestNaturalLanguageQueryUnderstandingSpec;
        /**
         * A 0-indexed integer that specifies the current offset (that is, starting result location, amongst the Documents deemed by the API as relevant) in search results. This field is only considered if page_token is unset. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        offset?: number | null;
        /**
         * The maximum number of results to return for OneBox. This applies to each OneBox type individually. Default number is 10.
         */
        oneBoxPageSize?: number | null;
        /**
         * The order in which documents are returned. Documents can be ordered by a field in an Document object. Leave it unset if ordered by relevance. `order_by` expression is case-sensitive. For more information on ordering the website search results, see [Order web search results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results). For more information on ordering the healthcare search results, see [Order healthcare search results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results). If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         */
        orderBy?: string | null;
        /**
         * Maximum number of Documents to return. The maximum allowed value depends on the data type. Values above the maximum value are coerced to the maximum value. * Websites with basic indexing: Default `10`, Maximum `25`. * Websites with advanced indexing: Default `25`, Maximum `50`. * Other: Default `50`, Maximum `100`. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        pageSize?: number | null;
        /**
         * A page token received from a previous SearchService.Search call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to SearchService.Search must match the call that provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        pageToken?: string | null;
        /**
         * Additional search parameters. For public website search only, supported values are: * `user_country_code`: string. Default empty. If set to non-empty, results are restricted or boosted based on the location provided. For example, `user_country_code: "au"` For available codes see [Country Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes) * `search_type`: double. Default empty. Enables non-webpage searching depending on the value. The only valid non-default value is 1, which enables image searching. For example, `search_type: 1`
         */
        params?: {
            [key: string]: any;
        } | null;
        /**
         * The specification for personalization. Notice that if both ServingConfig.personalization_spec and SearchRequest.personalization_spec are set, SearchRequest.personalization_spec overrides ServingConfig.personalization_spec.
         */
        personalizationSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestPersonalizationSpec;
        /**
         * Raw search query.
         */
        query?: string | null;
        /**
         * The query expansion specification that specifies the conditions under which query expansion occurs.
         */
        queryExpansionSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec;
        /**
         * Optional. The ranking expression controls the customized ranking on retrieval documents. This overrides ServingConfig.ranking_expression. The syntax and supported features depend on the `ranking_expression_backend` value. If `ranking_expression_backend` is not provided, it defaults to `RANK_BY_EMBEDDING`. If ranking_expression_backend is not provided or set to `RANK_BY_EMBEDDING`, it should be a single function or multiple functions that are joined by "+". * ranking_expression = function, { " + ", function \}; Supported functions: * double * relevance_score * double * dotProduct(embedding_field_path) Function variables: * `relevance_score`: pre-defined keywords, used for measure relevance between query and document. * `embedding_field_path`: the document embedding field used with query embedding vector. * `dotProduct`: embedding function between `embedding_field_path` and query embedding vector. Example ranking expression: If document has an embedding field doc_embedding, the ranking expression could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`. If ranking_expression_backend is set to `RANK_BY_FORMULA`, the following expression types (and combinations of those chained using + or * operators) are supported: * `double` * `signal` * `log(signal)` * `exp(signal)` * `rr(signal, double \> 0)` -- reciprocal rank transformation with second argument being a denominator constant. * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise. * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns signal2 | double, else returns signal1. Here are a few examples of ranking formulas that use the supported ranking expression types: - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)` -- mostly rank by the logarithm of `keyword_similarity_score` with slight `semantic_smilarity_score` adjustment. - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 * is_nan(keyword_similarity_score)` -- rank by the exponent of `semantic_similarity_score` filling the value with 0 if it's NaN, also add constant 0.3 adjustment to the final score if `semantic_similarity_score` is NaN. - `0.2 * rr(semantic_similarity_score, 16) + 0.8 * rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank of `keyword_similarity_score` with slight adjustment of reciprocal rank of `semantic_smilarity_score`. The following signals are supported: * `semantic_similarity_score`: semantic similarity adjustment that is calculated using the embeddings generated by a proprietary Google model. This score determines how semantically similar a search query is to a document. * `keyword_similarity_score`: keyword match adjustment uses the Best Match 25 (BM25) ranking function. This score is calculated using a probabilistic model to estimate the probability that a document is relevant to a given query. * `relevance_score`: semantic relevance adjustment that uses a proprietary Google model to determine the meaning and intent behind a user's query in context with the content in the documents. * `pctr_rank`: predicted conversion rate adjustment as a rank use predicted Click-through rate (pCTR) to gauge the relevance and attractiveness of a search result from a user's perspective. A higher pCTR suggests that the result is more likely to satisfy the user's query and intent, making it a valuable signal for ranking. * `freshness_rank`: freshness adjustment as a rank * `document_age`: The time in hours elapsed since the document was last updated, a floating-point number (e.g., 0.25 means 15 minutes). * `topicality_rank`: topicality adjustment as a rank. Uses proprietary Google model to determine the keyword-based overlap between the query and the document. * `base_rank`: the default rank of the result
         */
        rankingExpression?: string | null;
        /**
         * Optional. The backend to use for the ranking expression evaluation.
         */
        rankingExpressionBackend?: string | null;
        /**
         * The Unicode country/region code (CLDR) of a location, such as "US" and "419". For more information, see [Standard fields](https://cloud.google.com/apis/design/standard_fields). If set, then results will be boosted based on the region_code provided.
         */
        regionCode?: string | null;
        /**
         * Optional. The specification for returning the relevance score.
         */
        relevanceScoreSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestRelevanceScoreSpec;
        /**
         * The relevance threshold of the search results. Default to Google defined threshold, leveraging a balance of precision and recall to deliver both highly accurate results and comprehensive coverage of relevant information. This feature is not supported for healthcare search.
         */
        relevanceThreshold?: string | null;
        /**
         * Whether to turn on safe search. This is only supported for website search.
         */
        safeSearch?: boolean | null;
        /**
         * Search as you type configuration. Only supported for the IndustryVertical.MEDIA vertical.
         */
        searchAsYouTypeSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestSearchAsYouTypeSpec;
        /**
         * Required. The resource name of the Search serving config, such as `projects/x/locations/global/collections/default_collection/engines/x/servingConfigs/default_serving_config`, or `projects/x/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`. This field is used to identify the serving configuration name, set of models used to make the search.
         */
        servingConfig?: string | null;
        /**
         * The session resource name. Optional. Session allows users to do multi-turn /search API calls or coordination between /search API calls and /answer API calls. Example #1 (multi-turn /search API calls): Call /search API with the session ID generated in the first call. Here, the previous search query gets considered in query standing. I.e., if the first query is "How did Alphabet do in 2022?" and the current query is "How about 2023?", the current query will be interpreted as "How did Alphabet do in 2023?". Example #2 (coordination between /search API calls and /answer API calls): Call /answer API with the session ID generated in the first call. Here, the answer generation happens in the context of the search results from the first search call. Multi-turn Search feature is currently at private GA stage. Please use v1alpha or v1beta version instead before we launch this feature to public GA. Or ask for allowlisting through Google Support team.
         */
        session?: string | null;
        /**
         * Session specification. Can be used only when `session` is set.
         */
        sessionSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestSessionSpec;
        /**
         * The spell correction specification that specifies the mode under which spell correction takes effect.
         */
        spellCorrectionSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec;
        /**
         * Uses the Engine, ServingConfig and Control freshly read from the database. Note: this skips config cache and introduces dependency on databases, which could significantly increase the API latency. It should only be used for testing, but not serving end users.
         */
        useLatestData?: boolean | null;
        /**
         * Information about the end user. Highly recommended for analytics and personalization. UserInfo.user_agent is used to deduce `device_type` for analytics.
         */
        userInfo?: Schema$GoogleCloudDiscoveryengineV1alphaUserInfo;
        /**
         * The user labels applied to a resource must meet the following requirements: * Each resource can have multiple labels, up to a maximum of 64. * Each label must be a key-value pair. * Keys have a minimum length of 1 character and a maximum length of 63 characters and cannot be empty. Values can be empty and have a maximum length of 63 characters. * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. All characters must use UTF-8 encoding, and international characters are allowed. * The key portion of a label must be unique. However, you can use the same key with multiple resources. * Keys must start with a lowercase letter or international character. See [Google Cloud Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements) for more details.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
        /**
         * A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. This field should NOT have a fixed value such as `unknown_visitor`. This should be the same identifier as UserEvent.user_pseudo_id and CompleteQueryRequest.user_pseudo_id The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        userPseudoId?: string | null;
    }
    /**
     * Boost specification to boost certain documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec {
        /**
         * Condition boost specifications. If a document matches multiple conditions in the specifications, boost scores from these specifications are all applied and combined in a non-linear way. Maximum number of specifications is 20.
         */
        conditionBoostSpecs?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec[];
    }
    /**
     * Boost applies to documents which match a condition.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpec {
        /**
         * Strength of the condition boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the document a big promotion. However, it does not necessarily mean that the boosted document will be the top result at all times, nor that other documents will be excluded. Results could still be shown even when none of them matches the condition. And results that are significantly more relevant to the search query can still trump your heavily favored but irrelevant documents. Setting to -1.0 gives the document a big demotion. However, results that are deeply relevant might still be shown. The document will have an upstream battle to get a fairly high ranking, but it is not blocked out completely. Setting to 0.0 means no boost applied. The boosting condition is ignored. Only one of the (condition, boost) combination or the boost_control_spec below are set. If both are set then the global boost is ignored and the more fine-grained boost_control_spec is applied.
         */
        boost?: number | null;
        /**
         * Complex specification for custom ranking based on customer defined attribute value.
         */
        boostControlSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec;
        /**
         * An expression which specifies a boost condition. The syntax and supported fields are the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Examples: * To boost documents with document ID "doc_1" or "doc_2", and color "Red" or "Blue": `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
         */
        condition?: string | null;
    }
    /**
     * Specification for custom ranking based on customer specified attribute value. It provides more controls for customized ranking than the simple (condition, boost) combination above.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec {
        /**
         * The attribute type to be used to determine the boost amount. The attribute value can be derived from the field value of the specified field_name. In the case of numerical it is straightforward i.e. attribute_value = numerical_field_value. In the case of freshness however, attribute_value = (time.now() - datetime_field_value).
         */
        attributeType?: string | null;
        /**
         * The control points used to define the curve. The monotonic function (defined through the interpolation_type above) passes through the control points listed here.
         */
        controlPoints?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint[];
        /**
         * The name of the field whose value will be used to determine the boost amount.
         */
        fieldName?: string | null;
        /**
         * The interpolation type to be applied to connect the control points listed below.
         */
        interpolationType?: string | null;
    }
    /**
     * The control points used to define the curve. The curve defined through these control points can only be monotonically increasing or decreasing(constant values are acceptable).
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint {
        /**
         * Can be one of: 1. The numerical field value. 2. The duration spec for freshness: The value must be formatted as an XSD `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value). The pattern for this is: `nDnM]`.
         */
        attributeValue?: string | null;
        /**
         * The value between -1 to 1 by which to boost the score if the attribute_value evaluates to the value specified above.
         */
        boostAmount?: number | null;
    }
    /**
     * A specification for configuring the behavior of content search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpec {
        /**
         * Specifies the chunk spec to be returned from the search response. Only available if the SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS
         */
        chunkSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecChunkSpec;
        /**
         * If there is no extractive_content_spec provided, there will be no extractive answer in the search response.
         */
        extractiveContentSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec;
        /**
         * Specifies the search result mode. If unspecified, the search result mode defaults to `DOCUMENTS`.
         */
        searchResultMode?: string | null;
        /**
         * If `snippetSpec` is not specified, snippets are not included in the search response.
         */
        snippetSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec;
        /**
         * If `summarySpec` is not specified, summaries are not included in the search response.
         */
        summarySpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec;
    }
    /**
     * Specifies the chunk spec to be returned from the search response. Only available if the SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecChunkSpec {
        /**
         * The number of next chunks to be returned of the current chunk. The maximum allowed value is 3. If not specified, no next chunks will be returned.
         */
        numNextChunks?: number | null;
        /**
         * The number of previous chunks to be returned of the current chunk. The maximum allowed value is 3. If not specified, no previous chunks will be returned.
         */
        numPreviousChunks?: number | null;
    }
    /**
     * A specification for configuring the extractive content in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecExtractiveContentSpec {
        /**
         * The maximum number of extractive answers returned in each search result. An extractive answer is a verbatim answer extracted from the original document, which provides a precise and contextually relevant answer to the search query. If the number of matching answers is less than the `max_extractive_answer_count`, return all of the answers. Otherwise, return the `max_extractive_answer_count`. At most five answers are returned for each SearchResult.
         */
        maxExtractiveAnswerCount?: number | null;
        /**
         * The max number of extractive segments returned in each search result. Only applied if the DataStore is set to DataStore.ContentConfig.CONTENT_REQUIRED or DataStore.solution_types is SOLUTION_TYPE_CHAT. An extractive segment is a text segment extracted from the original document that is relevant to the search query, and, in general, more verbose than an extractive answer. The segment could then be used as input for LLMs to generate summaries and answers. If the number of matching segments is less than `max_extractive_segment_count`, return all of the segments. Otherwise, return the `max_extractive_segment_count`.
         */
        maxExtractiveSegmentCount?: number | null;
        /**
         * Return at most `num_next_segments` segments after each selected segments.
         */
        numNextSegments?: number | null;
        /**
         * Specifies whether to also include the adjacent from each selected segments. Return at most `num_previous_segments` segments before each selected segments.
         */
        numPreviousSegments?: number | null;
        /**
         * Specifies whether to return the confidence score from the extractive segments in each search result. This feature is available only for new or allowlisted data stores. To allowlist your data store, contact your Customer Engineer. The default value is `false`.
         */
        returnExtractiveSegmentScore?: boolean | null;
    }
    /**
     * A specification for configuring snippets in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSnippetSpec {
        /**
         * [DEPRECATED] This field is deprecated. To control snippet return, use `return_snippet` field. For backwards compatibility, we will return snippet if max_snippet_count \> 0.
         */
        maxSnippetCount?: number | null;
        /**
         * [DEPRECATED] This field is deprecated and will have no affect on the snippet.
         */
        referenceOnly?: boolean | null;
        /**
         * If `true`, then return snippet. If no snippet can be generated, we return "No snippet is available for this page." A `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
         */
        returnSnippet?: boolean | null;
    }
    /**
     * A specification for configuring a summary returned in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpec {
        /**
         * Specifies whether to filter out adversarial queries. The default value is `false`. Google employs search-query classification to detect adversarial queries. No summary is returned if the search query is classified as an adversarial query. For example, a user might ask a question regarding negative comments about the company or submit a query designed to generate unsafe, policy-violating output. If this field is set to `true`, we skip generating summaries for adversarial queries and return fallback messages instead.
         */
        ignoreAdversarialQuery?: boolean | null;
        /**
         * Optional. Specifies whether to filter out jail-breaking queries. The default value is `false`. Google employs search-query classification to detect jail-breaking queries. No summary is returned if the search query is classified as a jail-breaking query. A user might add instructions to the query to change the tone, style, language, content of the answer, or ask the model to act as a different entity, e.g. "Reply in the tone of a competing company's CEO". If this field is set to `true`, we skip generating summaries for jail-breaking queries and return fallback messages instead.
         */
        ignoreJailBreakingQuery?: boolean | null;
        /**
         * Specifies whether to filter out queries that have low relevance. The default value is `false`. If this field is set to `false`, all search results are used regardless of relevance to generate answers. If set to `true`, only queries with high relevance search results will generate answers.
         */
        ignoreLowRelevantContent?: boolean | null;
        /**
         * Specifies whether to filter out queries that are not summary-seeking. The default value is `false`. Google employs search-query classification to detect summary-seeking queries. No summary is returned if the search query is classified as a non-summary seeking query. For example, `why is the sky blue` and `Who is the best soccer player in the world?` are summary-seeking queries, but `SFO airport` and `world cup 2026` are not. They are most likely navigational queries. If this field is set to `true`, we skip generating summaries for non-summary seeking queries and return fallback messages instead.
         */
        ignoreNonSummarySeekingQuery?: boolean | null;
        /**
         * Specifies whether to include citations in the summary. The default value is `false`. When this field is set to `true`, summaries include in-line citation numbers. Example summary including citations: BigQuery is Google Cloud's fully managed and completely serverless enterprise data warehouse [1]. BigQuery supports all data types, works across clouds, and has built-in machine learning and business intelligence, all within a unified platform [2, 3]. The citation numbers refer to the returned search results and are 1-indexed. For example, [1] means that the sentence is attributed to the first search result. [2, 3] means that the sentence is attributed to both the second and third search results.
         */
        includeCitations?: boolean | null;
        /**
         * Language code for Summary. Use language tags defined by [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an experimental feature.
         */
        languageCode?: string | null;
        /**
         * If specified, the spec will be used to modify the prompt provided to the LLM.
         */
        modelPromptSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec;
        /**
         * If specified, the spec will be used to modify the model specification provided to the LLM.
         */
        modelSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec;
        /**
         * Optional. Multimodal specification.
         */
        multimodalSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecMultiModalSpec;
        /**
         * The number of top results to generate the summary from. If the number of results returned is less than `summaryResultCount`, the summary is generated from all of the results. At most 10 results for documents mode, or 50 for chunks mode, can be used to generate a summary. The chunks mode is used when SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
         */
        summaryResultCount?: number | null;
        /**
         * If true, answer will be generated from most relevant chunks from top search results. This feature will improve summary quality. Note that with this feature enabled, not all top search results will be referenced and included in the reference list, so the citation source index only points to the search results listed in the reference list.
         */
        useSemanticChunks?: boolean | null;
    }
    /**
     * Specification of the prompt to use with the model.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelPromptSpec {
        /**
         * Text at the beginning of the prompt that instructs the assistant. Examples are available in the user guide.
         */
        preamble?: string | null;
    }
    /**
     * Specification of the model.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecModelSpec {
        /**
         * The model version used to generate the summary. Supported values are: * `stable`: string. Default value when no value is specified. Uses a generally available, fine-tuned model. For more information, see [Answer generation model versions and lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models). * `preview`: string. (Public preview) Uses a preview model. For more information, see [Answer generation model versions and lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         */
        version?: string | null;
    }
    /**
     * Multimodal specification: Will return an image from specified source. If multiple sources are specified, the pick is a quality based decision.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestContentSearchSpecSummarySpecMultiModalSpec {
        /**
         * Optional. Source of image returned in the answer.
         */
        imageSource?: string | null;
    }
    /**
     * A struct to define data stores to filter on in a search call and configurations for those data stores. Otherwise, an `INVALID_ARGUMENT` error is returned.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestDataStoreSpec {
        /**
         * Optional. Boost specification to boost certain documents. For more information on boosting, see [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestBoostSpec;
        /**
         * Optional. Custom search operators which if specified will be used to filter results from workspace data stores. For more information on custom search operators, see [SearchOperators](https://support.google.com/cloudsearch/answer/6172299).
         */
        customSearchOperators?: string | null;
        /**
         * Required. Full resource name of DataStore, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. The path must include the project number, project id is not supported for this field.
         */
        dataStore?: string | null;
        /**
         * Optional. Filter specification to filter documents in the data store specified by data_store field. For more information on filtering, see [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
    }
    /**
     * Specifies features for display, like match highlighting.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestDisplaySpec {
        /**
         * The condition under which match highlighting should occur.
         */
        matchHighlightingCondition?: string | null;
    }
    /**
     * The specification that uses customized query embedding vector to do semantic document retrieval.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpec {
        /**
         * The embedding vector used for retrieval. Limit to 1.
         */
        embeddingVectors?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector[];
    }
    /**
     * Embedding vector.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestEmbeddingSpecEmbeddingVector {
        /**
         * Embedding field path in schema.
         */
        fieldPath?: string | null;
        /**
         * Query embedding vector.
         */
        vector?: number[] | null;
    }
    /**
     * A facet specification to perform faceted search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpec {
        /**
         * Enables dynamic position for this facet. If set to true, the position of this facet among all facets in the response is determined automatically. If dynamic facets are enabled, it is ordered together. If set to false, the position of this facet in the response is the same as in the request, and it is ranked before the facets with dynamic position enable and all dynamic facets. For example, you may always want to have rating facet returned in the response, but it's not necessarily to always display the rating facet at the top. In that case, you can set enable_dynamic_position to true so that the position of rating facet in response is determined automatically. Another example, assuming you have the following facets in the request: * "rating", enable_dynamic_position = true * "price", enable_dynamic_position = false * "brands", enable_dynamic_position = false And also you have a dynamic facets enabled, which generates a facet `gender`. Then the final order of the facets in the response can be ("price", "brands", "rating", "gender") or ("price", "brands", "gender", "rating") depends on how API orders "gender" and "rating" facets. However, notice that "price" and "brands" are always ranked at first and second position because their enable_dynamic_position is false.
         */
        enableDynamicPosition?: boolean | null;
        /**
         * List of keys to exclude when faceting. By default, FacetKey.key is not excluded from the filter unless it is listed in this field. Listing a facet key in this field allows its values to appear as facet results, even when they are filtered out of search results. Using this field does not affect what search results are returned. For example, suppose there are 100 documents with the color facet "Red" and 200 documents with the color facet "Blue". A query containing the filter "color:ANY("Red")" and having "color" as FacetKey.key would by default return only "Red" documents in the search results, and also return "Red" with count 100 as the only color facet. Although there are also blue documents available, "Blue" would not be shown as an available facet value. If "color" is listed in "excludedFilterKeys", then the query returns the facet values "Red" with count 100 and "Blue" with count 200, because the "color" key is now excluded from the filter. Because this field doesn't affect search results, the search results are still correctly filtered to return only "Red" documents. A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        excludedFilterKeys?: string[] | null;
        /**
         * Required. The facet key specification.
         */
        facetKey?: Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey;
        /**
         * Maximum facet values that are returned for this facet. If unspecified, defaults to 20. The maximum allowed value is 300. Values above 300 are coerced to 300. For aggregation in healthcare search, when the [FacetKey.key] is "healthcare_aggregation_key", the limit will be overridden to 10,000 internally, regardless of the value set here. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        limit?: number | null;
    }
    /**
     * Specifies how a facet is computed.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestFacetSpecFacetKey {
        /**
         * True to make facet keys case insensitive when getting faceting values with prefixes or contains; false otherwise.
         */
        caseInsensitive?: boolean | null;
        /**
         * Only get facet values that contain the given strings. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "contains" to "2022", the "category" facet only contains "Action \> 2022" and "Sci-Fi \> 2022". Only supported on textual fields. Maximum is 10.
         */
        contains?: string[] | null;
        /**
         * Set only if values should be bucketed into intervals. Must be set for facets with numerical values. Must not be set for facet with text values. Maximum number of intervals is 30.
         */
        intervals?: Schema$GoogleCloudDiscoveryengineV1alphaInterval[];
        /**
         * Required. Supported textual and numerical facet keys in Document object, over which the facet values are computed. Facet key is case-sensitive.
         */
        key?: string | null;
        /**
         * The order in which documents are returned. Allowed values are: * "count desc", which means order by SearchResponse.Facet.values.count descending. * "value desc", which means order by SearchResponse.Facet.values.value descending. Only applies to textual facets. If not set, textual values are sorted in [natural order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are sorted in the order given by FacetSpec.FacetKey.intervals.
         */
        orderBy?: string | null;
        /**
         * Only get facet values that start with the given string prefix. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "prefixes" to "Action", the "category" facet only contains "Action \> 2022" and "Action \> 2021". Only supported on textual fields. Maximum is 10.
         */
        prefixes?: string[] | null;
        /**
         * Only get facet for the given restricted values. Only supported on textual fields. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "restricted_values" to "Action \> 2022", the "category" facet only contains "Action \> 2022". Only supported on textual fields. Maximum is 10.
         */
        restrictedValues?: string[] | null;
    }
    /**
     * Specifies the image query input.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestImageQuery {
        /**
         * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and BMP.
         */
        imageBytes?: string | null;
    }
    /**
     * Specification to enable natural language understanding capabilities for search requests.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestNaturalLanguageQueryUnderstandingSpec {
        /**
         * Optional. Controls behavior of how extracted filters are applied to the search. The default behavior depends on the request. For single datastore structured search, the default is `HARD_FILTER`. For multi-datastore search, the default behavior is `SOFT_BOOST`. Location-based filters are always applied as hard filters, and the `SOFT_BOOST` setting will not affect them. This field is only used if SearchRequest.natural_language_query_understanding_spec.filter_extraction_condition is set to FilterExtractionCondition.ENABLED.
         */
        extractedFilterBehavior?: string | null;
        /**
         * The condition under which filter extraction should occur. Server behavior defaults to `DISABLED`.
         */
        filterExtractionCondition?: string | null;
        /**
         * Field names used for location-based filtering, where geolocation filters are detected in natural language search queries. Only valid when the FilterExtractionCondition is set to `ENABLED`. If this field is set, it overrides the field names set in ServingConfig.geo_search_query_detection_field_names.
         */
        geoSearchQueryDetectionFieldNames?: string[] | null;
    }
    /**
     * The specification for personalization.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestPersonalizationSpec {
        /**
         * The personalization mode of the search request. Defaults to Mode.AUTO.
         */
        mode?: string | null;
    }
    /**
     * Specification to determine under which conditions query expansion should occur.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestQueryExpansionSpec {
        /**
         * The condition under which query expansion should occur. Default to Condition.DISABLED.
         */
        condition?: string | null;
        /**
         * Whether to pin unexpanded results. If this field is set to true, unexpanded products are always at the top of the search results, followed by the expanded results.
         */
        pinUnexpandedResults?: boolean | null;
    }
    /**
     * The specification for returning the document relevance score.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestRelevanceScoreSpec {
        /**
         * Optional. Whether to return the relevance score for search results. The higher the score, the more relevant the document is to the query.
         */
        returnRelevanceScore?: boolean | null;
    }
    /**
     * Specification for search as you type in search requests.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestSearchAsYouTypeSpec {
        /**
         * The condition under which search as you type should occur. Default to Condition.DISABLED.
         */
        condition?: string | null;
    }
    /**
     * Session specification. Multi-turn Search feature is currently at private GA stage. Please use v1alpha or v1beta version instead before we launch this feature to public GA. Or ask for allowlisting through Google Support team.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestSessionSpec {
        /**
         * If set, the search result gets stored to the "turn" specified by this query ID. Example: Let's say the session looks like this: session { name: ".../sessions/xxx" turns { query { text: "What is foo?" query_id: ".../questions/yyy" \} answer: "Foo is ..." \} turns { query { text: "How about bar then?" query_id: ".../questions/zzz" \} \} \} The user can call /search API with a request like this: session: ".../sessions/xxx" session_spec { query_id: ".../questions/zzz" \} Then, the API stores the search result, associated with the last turn. The stored search result can be used by a subsequent /answer API call (with the session ID and the query ID specified). Also, it is possible to call /search and /answer in parallel with the same session ID & query ID.
         */
        queryId?: string | null;
        /**
         * The number of top search results to persist. The persisted search results can be used for the subsequent /answer api call. This field is similar to the `summary_result_count` field in SearchRequest.ContentSearchSpec.SummarySpec.summary_result_count. At most 10 results for documents mode, or 50 for chunks mode.
         */
        searchResultPersistenceCount?: number | null;
    }
    /**
     * The specification for query spell correction.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSearchRequestSpellCorrectionSpec {
        /**
         * The mode under which spell correction replaces the original search query. Defaults to Mode.AUTO.
         */
        mode?: string | null;
    }
    /**
     * External session proto definition.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSession {
        /**
         * Optional. The display name of the session. This field is used to identify the session in the UI. By default, the display name is the first turn query text in the session.
         */
        displayName?: string | null;
        /**
         * Output only. The time the session finished.
         */
        endTime?: string | null;
        /**
         * Optional. Whether the session is pinned, pinned session will be displayed on the top of the session list.
         */
        isPinned?: boolean | null;
        /**
         * Immutable. Fully qualified name `projects/{project\}/locations/global/collections/{collection\}/engines/{engine\}/sessions/x`
         */
        name?: string | null;
        /**
         * Output only. The time the session started.
         */
        startTime?: string | null;
        /**
         * The state of the session.
         */
        state?: string | null;
        /**
         * Turns.
         */
        turns?: Schema$GoogleCloudDiscoveryengineV1alphaSessionTurn[];
        /**
         * A unique identifier for tracking users.
         */
        userPseudoId?: string | null;
    }
    /**
     * Represents a turn, including a query from the user and a answer from service.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSessionTurn {
        /**
         * Optional. The resource name of the answer to the user query. Only set if the answer generation (/answer API call) happened in this turn.
         */
        answer?: string | null;
        /**
         * Output only. In ConversationalSearchService.GetSession API, if GetSessionRequest.include_answer_details is set to true, this field will be populated when getting answer query session.
         */
        detailedAnswer?: Schema$GoogleCloudDiscoveryengineV1alphaAnswer;
        /**
         * Optional. The user query. May not be set if this turn is merely regenerating an answer to a different turn
         */
        query?: Schema$GoogleCloudDiscoveryengineV1alphaQuery;
        /**
         * Optional. Represents metadata related to the query config, for example LLM model and version used, model parameters (temperature, grounding parameters, etc.). The prefix "google." is reserved for Google-developed functionality.
         */
        queryConfig?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Metadata related to the progress of the CrawlRateManagementService.SetDedicatedCrawlRate operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSetDedicatedCrawlRateMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CrawlRateManagementService.SetDedicatedCrawlRate method. It simply returns the state of the response, and an error message if the state is FAILED.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSetDedicatedCrawlRateResponse {
        /**
         * Errors from service when handling the request.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. The state of the response.
         */
        state?: string | null;
    }
    /**
     * Metadata for DataConnectorService.SetUpDataConnector method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSetUpDataConnectorMetadata {
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.SetUriPatternDocumentData operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSetUriPatternDocumentDataMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.SetUriPatternDocumentData method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSetUriPatternDocumentDataResponse {
    }
    /**
     * Metadata for single-regional CMEKs.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSingleRegionKey {
        /**
         * Required. Single-regional kms key resource name which will be used to encrypt resources `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{keyId\}`.
         */
        kmsKey?: string | null;
    }
    /**
     * A sitemap for the SiteSearchEngine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSitemap {
        /**
         * Output only. The sitemap's creation time.
         */
        createTime?: string | null;
        /**
         * Output only. The fully qualified resource name of the sitemap. `projects/x/locations/x/collections/x/dataStores/x/siteSearchEngine/sitemaps/x` The `sitemap_id` suffix is system-generated.
         */
        name?: string | null;
        /**
         * Public URI for the sitemap, e.g. `www.example.com/sitemap.xml`.
         */
        uri?: string | null;
    }
    /**
     * Verification information for target sites in advanced site search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo {
        /**
         * Site verification state indicating the ownership and validity.
         */
        siteVerificationState?: string | null;
        /**
         * Latest site verification time.
         */
        verifyTime?: string | null;
    }
    /**
     * A target site for the SiteSearchEngine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaTargetSite {
        /**
         * Immutable. If set to false, a uri_pattern is generated to include all pages whose address contains the provided_uri_pattern. If set to true, an uri_pattern is generated to try to be an exact match of the provided_uri_pattern or just the specific page if the provided_uri_pattern is a specific one. provided_uri_pattern is always normalized to generate the URI pattern to be used by the search engine.
         */
        exactMatch?: boolean | null;
        /**
         * Output only. Failure reason.
         */
        failureReason?: Schema$GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason;
        /**
         * Output only. This is system-generated based on the provided_uri_pattern.
         */
        generatedUriPattern?: string | null;
        /**
         * Output only. Indexing status.
         */
        indexingStatus?: string | null;
        /**
         * Output only. The fully qualified resource name of the target site. `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/siteSearchEngine/targetSites/{target_site\}` The `target_site_id` is system-generated.
         */
        name?: string | null;
        /**
         * Required. Input only. The user provided URI pattern from which the `generated_uri_pattern` is generated.
         */
        providedUriPattern?: string | null;
        /**
         * Output only. Root domain of the provided_uri_pattern.
         */
        rootDomainUri?: string | null;
        /**
         * Output only. Site ownership and validity verification status.
         */
        siteVerificationInfo?: Schema$GoogleCloudDiscoveryengineV1alphaSiteVerificationInfo;
        /**
         * The type of the target site, e.g., whether the site is to be included or excluded.
         */
        type?: string | null;
        /**
         * Output only. The target site's last updated time.
         */
        updateTime?: string | null;
    }
    /**
     * Site search indexing failure reasons.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReason {
        /**
         * Failed due to insufficient quota.
         */
        quotaFailure?: Schema$GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure;
    }
    /**
     * Failed due to insufficient quota.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaTargetSiteFailureReasonQuotaFailure {
        /**
         * This number is an estimation on how much total quota this project needs to successfully complete indexing.
         */
        totalRequiredQuota?: string | null;
    }
    /**
     * Tenant information for a connector source. This includes some of the same information stored in the Credential message, but is limited to only what is needed to provide a list of accessible tenants to the user.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaTenant {
        /**
         * Optional display name for the tenant, e.g. "My Slack Team".
         */
        displayName?: string | null;
        /**
         * The tenant's instance ID. Examples: Jira ("8594f221-9797-5f78-1fa4-485e198d7cd0"), Slack ("T123456").
         */
        id?: string | null;
        /**
         * The URI of the tenant, if applicable. For example, the URI of a Jira instance is https://my-jira-instance.atlassian.net, and a Slack tenant does not have a URI.
         */
        uri?: string | null;
    }
    /**
     * Metadata related to the progress of the TrainCustomModel operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaTrainCustomModelMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the TrainCustomModelRequest. This message is returned by the google.longrunning.Operations.response field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaTrainCustomModelResponse {
        /**
         * Echoes the destination for the complete errors in the request if set.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1alphaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the data.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * The metrics of the trained model.
         */
        metrics?: {
            [key: string]: number;
        } | null;
        /**
         * Fully qualified name of the CustomTuningModel.
         */
        modelName?: string | null;
        /**
         * The trained model status. Possible values are: * **bad-data**: The training data quality is bad. * **no-improvement**: Tuning didn't improve performance. Won't deploy. * **in-progress**: Model training job creation is in progress. * **training**: Model is actively training. * **evaluating**: The model is evaluating trained metrics. * **indexing**: The model trained metrics are indexing. * **ready**: The model is ready for serving.
         */
        modelStatus?: string | null;
    }
    /**
     * Metadata associated with a tune operation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaTuneEngineMetadata {
        /**
         * Required. The resource name of the engine that this tune applies to. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}`
         */
        engine?: string | null;
    }
    /**
     * Response associated with a tune operation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaTuneEngineResponse {
    }
    /**
     * Metadata related to the progress of the CmekConfigService.UpdateCmekConfig operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaUpdateCmekConfigMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the CollectionService.UpdateCollection operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaUpdateCollectionMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for UpdateSchema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaUpdateSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request for UpdateSession method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaUpdateSessionRequest {
        /**
         * Required. The Session to update.
         */
        session?: Schema$GoogleCloudDiscoveryengineV1alphaSession;
        /**
         * Indicates which fields in the provided Session to update. The following are NOT supported: * Session.name If not set or empty, all supported fields are updated.
         */
        updateMask?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.UpdateTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaUpdateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Information of an end user.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaUserInfo {
        /**
         * Optional. IANA time zone, e.g. Europe/Budapest.
         */
        timeZone?: string | null;
        /**
         * User agent as included in the HTTP header. The field must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. This should not be set when using the client side event reporting with GTM or JavaScript tag in UserEventService.CollectUserEvent or if UserEvent.direct_user_request is set.
         */
        userAgent?: string | null;
        /**
         * Highly recommended for logged-in users. Unique identifier for logged-in user, such as a user name. Don't set for anonymous users. Always use a hashed value for this ID. Don't set the field to the same fixed ID for different users. This mixes the event history of those users together, which results in degraded model quality. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        userId?: string | null;
    }
    /**
     * User License information assigned by the admin.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaUserLicense {
        /**
         * Output only. User created timestamp.
         */
        createTime?: string | null;
        /**
         * Output only. User last logged in time. If the user has not logged in yet, this field will be empty.
         */
        lastLoginTime?: string | null;
        /**
         * Output only. License assignment state of the user. If the user is assigned with a license config, the user login will be assigned with the license; If the user's license assignment state is unassigned or unspecified, no license config will be associated to the user;
         */
        licenseAssignmentState?: string | null;
        /**
         * Optional. The full resource name of the Subscription(LicenseConfig) assigned to the user.
         */
        licenseConfig?: string | null;
        /**
         * Output only. User update timestamp.
         */
        updateTime?: string | null;
        /**
         * Required. Immutable. The user principal of the User, could be email address or other prinical identifier. This field is immutable. Admin assign licenses based on the user principal.
         */
        userPrincipal?: string | null;
        /**
         * Optional. The user profile. We user user full name(First name + Last name) as user profile.
         */
        userProfile?: string | null;
    }
    /**
     * Config to store data store type configuration for workspace data
     */
    export interface Schema$GoogleCloudDiscoveryengineV1alphaWorkspaceConfig {
        /**
         * Obfuscated Dasher customer ID.
         */
        dasherCustomerId?: string | null;
        /**
         * Optional. The super admin email address for the workspace that will be used for access token generation. For now we only use it for Native Google Drive connector data ingestion.
         */
        superAdminEmailAddress?: string | null;
        /**
         * Optional. The super admin service account for the workspace that will be used for access token generation. For now we only use it for Native Google Drive connector data ingestion.
         */
        superAdminServiceAccount?: string | null;
        /**
         * The Google Workspace data source.
         */
        type?: string | null;
    }
    /**
     * Defines an answer.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Answer {
        /**
         * Additional answer-skipped reasons. This provides the reason for ignored cases. If nothing is skipped, this field is not set.
         */
        answerSkippedReasons?: string[] | null;
        /**
         * The textual answer.
         */
        answerText?: string | null;
        /**
         * Citations.
         */
        citations?: Schema$GoogleCloudDiscoveryengineV1AnswerCitation[];
        /**
         * Output only. Answer completed timestamp.
         */
        completeTime?: string | null;
        /**
         * Output only. Answer creation timestamp.
         */
        createTime?: string | null;
        /**
         * A score in the range of [0, 1] describing how grounded the answer is by the reference chunks.
         */
        groundingScore?: number | null;
        /**
         * Optional. Grounding supports.
         */
        groundingSupports?: Schema$GoogleCloudDiscoveryengineV1AnswerGroundingSupport[];
        /**
         * Immutable. Fully qualified name `projects/{project\}/locations/global/collections/{collection\}/engines/{engine\}/sessions/x/answers/x`
         */
        name?: string | null;
        /**
         * Query understanding information.
         */
        queryUnderstandingInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo;
        /**
         * References.
         */
        references?: Schema$GoogleCloudDiscoveryengineV1AnswerReference[];
        /**
         * Suggested related questions.
         */
        relatedQuestions?: string[] | null;
        /**
         * Optional. Safety ratings.
         */
        safetyRatings?: Schema$GoogleCloudDiscoveryengineV1SafetyRating[];
        /**
         * The state of the answer generation.
         */
        state?: string | null;
        /**
         * Answer generation steps.
         */
        steps?: Schema$GoogleCloudDiscoveryengineV1AnswerStep[];
    }
    /**
     * Citation info for a segment.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerCitation {
        /**
         * End of the attributed segment, exclusive. Measured in bytes (UTF-8 unicode). If there are multi-byte characters,such as non-ASCII characters, the index measurement is longer than the string length.
         */
        endIndex?: string | null;
        /**
         * Citation sources for the attributed segment.
         */
        sources?: Schema$GoogleCloudDiscoveryengineV1AnswerCitationSource[];
        /**
         * Index indicates the start of the segment, measured in bytes (UTF-8 unicode). If there are multi-byte characters,such as non-ASCII characters, the index measurement is longer than the string length.
         */
        startIndex?: string | null;
    }
    /**
     * Citation source.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerCitationSource {
        /**
         * ID of the citation source.
         */
        referenceId?: string | null;
    }
    /**
     * The specification for answer generation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerGenerationSpec {
        /**
         * Optional. The specification for user specified classifier spec.
         */
        userDefinedClassifierSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec;
    }
    /**
     * The specification for user defined classifier.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerGenerationSpecUserDefinedClassifierSpec {
        /**
         * Optional. Whether or not to enable and include user defined classifier.
         */
        enableUserDefinedClassifier?: boolean | null;
        /**
         * Optional. The model id to be used for the user defined classifier.
         */
        modelId?: string | null;
        /**
         * Optional. The preamble to be used for the user defined classifier.
         */
        preamble?: string | null;
        /**
         * Optional. The seed value to be used for the user defined classifier.
         */
        seed?: number | null;
        /**
         * Optional. The task marker to be used for the user defined classifier.
         */
        taskMarker?: string | null;
        /**
         * Optional. The temperature value to be used for the user defined classifier.
         */
        temperature?: number | null;
        /**
         * Optional. The top-k value to be used for the user defined classifier.
         */
        topK?: string | null;
        /**
         * Optional. The top-p value to be used for the user defined classifier.
         */
        topP?: number | null;
    }
    /**
     * Grounding support for a claim in `answer_text`.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerGroundingSupport {
        /**
         * Required. End of the claim, exclusive.
         */
        endIndex?: string | null;
        /**
         * Indicates that this claim required grounding check. When the system decided this claim didn't require attribution/grounding check, this field is set to false. In that case, no grounding check was done for the claim and therefore `grounding_score`, `sources` is not returned.
         */
        groundingCheckRequired?: boolean | null;
        /**
         * A score in the range of [0, 1] describing how grounded is a specific claim by the references. Higher value means that the claim is better supported by the reference chunks.
         */
        groundingScore?: number | null;
        /**
         * Optional. Citation sources for the claim.
         */
        sources?: Schema$GoogleCloudDiscoveryengineV1AnswerCitationSource[];
        /**
         * Required. Index indicates the start of the claim, measured in bytes (UTF-8 unicode).
         */
        startIndex?: string | null;
    }
    /**
     * Request message for ConversationalSearchService.AnswerQuery method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequest {
        /**
         * Answer generation specification.
         */
        answerGenerationSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec;
        /**
         * Deprecated: This field is deprecated. Streaming Answer API will be supported. Asynchronous mode control. If enabled, the response will be returned with answer/session resource name without final answer. The API users need to do the polling to get the latest status of answer/session by calling ConversationalSearchService.GetAnswer or ConversationalSearchService.GetSession method.
         */
        asynchronousMode?: boolean | null;
        /**
         * Optional. End user specification.
         */
        endUserSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpec;
        /**
         * Optional. Grounding specification.
         */
        groundingSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestGroundingSpec;
        /**
         * Required. Current user query.
         */
        query?: Schema$GoogleCloudDiscoveryengineV1Query;
        /**
         * Query understanding specification.
         */
        queryUnderstandingSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec;
        /**
         * Related questions specification.
         */
        relatedQuestionsSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec;
        /**
         * Model specification.
         */
        safetySpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec;
        /**
         * Search specification.
         */
        searchSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec;
        /**
         * The session resource name. Not required. When session field is not set, the API is in sessionless mode. We support auto session mode: users can use the wildcard symbol `-` as session ID. A new ID will be automatically generated and assigned.
         */
        session?: string | null;
        /**
         * The user labels applied to a resource must meet the following requirements: * Each resource can have multiple labels, up to a maximum of 64. * Each label must be a key-value pair. * Keys have a minimum length of 1 character and a maximum length of 63 characters and cannot be empty. Values can be empty and have a maximum length of 63 characters. * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. All characters must use UTF-8 encoding, and international characters are allowed. * The key portion of a label must be unique. However, you can use the same key with multiple resources. * Keys must start with a lowercase letter or international character. See [Google Cloud Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements) for more details.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
        /**
         * A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. This field should NOT have a fixed value such as `unknown_visitor`. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        userPseudoId?: string | null;
    }
    /**
     * Answer generation specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpec {
        /**
         * Language code for Answer. Use language tags defined by [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an experimental feature.
         */
        answerLanguageCode?: string | null;
        /**
         * Specifies whether to filter out adversarial queries. The default value is `false`. Google employs search-query classification to detect adversarial queries. No answer is returned if the search query is classified as an adversarial query. For example, a user might ask a question regarding negative comments about the company or submit a query designed to generate unsafe, policy-violating output. If this field is set to `true`, we skip generating answers for adversarial queries and return fallback messages instead.
         */
        ignoreAdversarialQuery?: boolean | null;
        /**
         * Optional. Specifies whether to filter out jail-breaking queries. The default value is `false`. Google employs search-query classification to detect jail-breaking queries. No summary is returned if the search query is classified as a jail-breaking query. A user might add instructions to the query to change the tone, style, language, content of the answer, or ask the model to act as a different entity, e.g. "Reply in the tone of a competing company's CEO". If this field is set to `true`, we skip generating summaries for jail-breaking queries and return fallback messages instead.
         */
        ignoreJailBreakingQuery?: boolean | null;
        /**
         * Specifies whether to filter out queries that have low relevance. If this field is set to `false`, all search results are used regardless of relevance to generate answers. If set to `true` or unset, the behavior will be determined automatically by the service.
         */
        ignoreLowRelevantContent?: boolean | null;
        /**
         * Specifies whether to filter out queries that are not answer-seeking. The default value is `false`. Google employs search-query classification to detect answer-seeking queries. No answer is returned if the search query is classified as a non-answer seeking query. If this field is set to `true`, we skip generating answers for non-answer seeking queries and return fallback messages instead.
         */
        ignoreNonAnswerSeekingQuery?: boolean | null;
        /**
         * Specifies whether to include citation metadata in the answer. The default value is `false`.
         */
        includeCitations?: boolean | null;
        /**
         * Answer generation model specification.
         */
        modelSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec;
        /**
         * Answer generation prompt specification.
         */
        promptSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec;
    }
    /**
     * Answer Generation Model specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecModelSpec {
        /**
         * Model version. If not set, it will use the default stable model. Allowed values are: stable, preview.
         */
        modelVersion?: string | null;
    }
    /**
     * Answer generation prompt specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestAnswerGenerationSpecPromptSpec {
        /**
         * Customized preamble.
         */
        preamble?: string | null;
    }
    /**
     * End user specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpec {
        /**
         * Optional. End user metadata.
         */
        endUserMetadata?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaData[];
    }
    /**
     * End user metadata.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaData {
        /**
         * Chunk information.
         */
        chunkInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfo;
    }
    /**
     * Chunk information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfo {
        /**
         * Chunk textual content. It is limited to 8000 characters.
         */
        content?: string | null;
        /**
         * Metadata of the document from the current chunk.
         */
        documentMetadata?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfoDocumentMetadata;
    }
    /**
     * Document metadata contains the information of the document of the current chunk.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestEndUserSpecEndUserMetaDataChunkInfoDocumentMetadata {
        /**
         * Title of the document.
         */
        title?: string | null;
    }
    /**
     * Grounding specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestGroundingSpec {
        /**
         * Optional. Specifies whether to enable the filtering based on grounding score and at what level.
         */
        filteringLevel?: string | null;
        /**
         * Optional. Specifies whether to include grounding_supports in the answer. The default value is `false`. When this field is set to `true`, returned answer will have `grounding_score` and will contain GroundingSupports for each claim.
         */
        includeGroundingSupports?: boolean | null;
    }
    /**
     * Query understanding specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpec {
        /**
         * Optional. Whether to disable spell correction. The default value is `false`.
         */
        disableSpellCorrection?: boolean | null;
        /**
         * Query classification specification.
         */
        queryClassificationSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec;
        /**
         * Query rephraser specification.
         */
        queryRephraserSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec;
    }
    /**
     * Query classification specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryClassificationSpec {
        /**
         * Enabled query classification types.
         */
        types?: string[] | null;
    }
    /**
     * Query rephraser specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpec {
        /**
         * Disable query rephraser.
         */
        disable?: boolean | null;
        /**
         * Max rephrase steps. The max number is 5 steps. If not set or set to < 1, it will be set to 1 by default.
         */
        maxRephraseSteps?: number | null;
        /**
         * Optional. Query Rephraser Model specification.
         */
        modelSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec;
    }
    /**
     * Query Rephraser Model specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestQueryUnderstandingSpecQueryRephraserSpecModelSpec {
        /**
         * Optional. Enabled query rephraser model type. If not set, it will use LARGE by default.
         */
        modelType?: string | null;
    }
    /**
     * Related questions specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestRelatedQuestionsSpec {
        /**
         * Enable related questions feature if true.
         */
        enable?: boolean | null;
    }
    /**
     * Safety specification. There are two use cases: 1. when only safety_spec.enable is set, the BLOCK_LOW_AND_ABOVE threshold will be applied for all categories. 2. when safety_spec.enable is set and some safety_settings are set, only specified safety_settings are applied.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpec {
        /**
         * Enable the safety filtering on the answer response. It is false by default.
         */
        enable?: boolean | null;
        /**
         * Optional. Safety settings. This settings are effective only when the safety_spec.enable is true.
         */
        safetySettings?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpecSafetySetting[];
    }
    /**
     * Safety settings.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSafetySpecSafetySetting {
        /**
         * Required. Harm category.
         */
        category?: string | null;
        /**
         * Required. The harm block threshold.
         */
        threshold?: string | null;
    }
    /**
     * Search specification.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpec {
        /**
         * Search parameters.
         */
        searchParams?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams;
        /**
         * Search result list.
         */
        searchResultList?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList;
    }
    /**
     * Search parameters.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchParams {
        /**
         * Boost specification to boost certain documents in search results which may affect the answer query response. For more information on boosting, see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpec;
        /**
         * Specs defining dataStores to filter on in a search call and configurations for those dataStores. This is only considered for engines with multiple dataStores use case. For single dataStore within an engine, they should use the specs at the top level.
         */
        dataStoreSpecs?: Schema$GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec[];
        /**
         * The filter syntax consists of an expression language for constructing a predicate from one or more fields of the documents being filtered. Filter expression is case-sensitive. This will be used to filter search results which may affect the Answer response. If this field is unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI Search is done by mapping the LHS filter key to a key property defined in the Vertex AI Search backend -- this mapping is defined by the customer in their schema. For example a media customers might have a field 'name' in their schema. In this case the filter would look like this: filter --\> name:'ANY("king kong")' For more information about filtering including syntax and filter operators, see [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
        /**
         * Number of search results to return. The default value is 10.
         */
        maxReturnResults?: number | null;
        /**
         * The order in which documents are returned. Documents can be ordered by a field in an Document object. Leave it unset if ordered by relevance. `order_by` expression is case-sensitive. For more information on ordering, see [Ordering](https://cloud.google.com/retail/docs/filter-and-order#order) If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         */
        orderBy?: string | null;
        /**
         * Specifies the search result mode. If unspecified, the search result mode defaults to `DOCUMENTS`. See [parse and chunk documents](https://cloud.google.com/generative-ai-app-builder/docs/parse-chunk-documents)
         */
        searchResultMode?: string | null;
    }
    /**
     * Search result list.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultList {
        /**
         * Search results.
         */
        searchResults?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult[];
    }
    /**
     * Search result.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResult {
        /**
         * Chunk information.
         */
        chunkInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo;
        /**
         * Unstructured document information.
         */
        unstructuredDocumentInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo;
    }
    /**
     * Chunk information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfo {
        /**
         * Chunk resource name.
         */
        chunk?: string | null;
        /**
         * Chunk textual content.
         */
        content?: string | null;
        /**
         * Metadata of the document from the current chunk.
         */
        documentMetadata?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata;
    }
    /**
     * Document metadata contains the information of the document of the current chunk.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultChunkInfoDocumentMetadata {
        /**
         * Title of the document.
         */
        title?: string | null;
        /**
         * Uri of the document.
         */
        uri?: string | null;
    }
    /**
     * Unstructured document information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfo {
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * List of document contexts. The content will be used for Answer Generation. This is supposed to be the main content of the document that can be long and comprehensive.
         */
        documentContexts?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext[];
        /**
         * Deprecated: This field is deprecated and will have no effect on the Answer generation. Please use document_contexts and extractive_segments fields. List of extractive answers.
         */
        extractiveAnswers?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer[];
        /**
         * List of extractive segments.
         */
        extractiveSegments?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment[];
        /**
         * Title.
         */
        title?: string | null;
        /**
         * URI for the document.
         */
        uri?: string | null;
    }
    /**
     * Document context.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoDocumentContext {
        /**
         * Document content to be used for answer generation.
         */
        content?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
    }
    /**
     * Extractive answer. [Guide](https://cloud.google.com/generative-ai-app-builder/docs/snippets#get-answers)
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveAnswer {
        /**
         * Extractive answer content.
         */
        content?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
    }
    /**
     * Extractive segment. [Guide](https://cloud.google.com/generative-ai-app-builder/docs/snippets#extractive-segments) Answer generation will only use it if document_contexts is empty. This is supposed to be shorter snippets.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryRequestSearchSpecSearchResultListSearchResultUnstructuredDocumentInfoExtractiveSegment {
        /**
         * Extractive segment content.
         */
        content?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
    }
    /**
     * Response message for ConversationalSearchService.AnswerQuery method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryResponse {
        /**
         * Answer resource object. If AnswerQueryRequest.QueryUnderstandingSpec.QueryRephraserSpec.max_rephrase_steps is greater than 1, use Answer.name to fetch answer information using ConversationalSearchService.GetAnswer API.
         */
        answer?: Schema$GoogleCloudDiscoveryengineV1Answer;
        /**
         * A global unique ID used for logging.
         */
        answerQueryToken?: string | null;
        /**
         * Session resource object. It will be only available when session field is set and valid in the AnswerQueryRequest request.
         */
        session?: Schema$GoogleCloudDiscoveryengineV1Session;
    }
    /**
     * Query understanding information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfo {
        /**
         * Query classification information.
         */
        queryClassificationInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo[];
    }
    /**
     * Query classification information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerQueryUnderstandingInfoQueryClassificationInfo {
        /**
         * Classification output.
         */
        positive?: boolean | null;
        /**
         * Query classification type.
         */
        type?: string | null;
    }
    /**
     * Reference.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerReference {
        /**
         * Chunk information.
         */
        chunkInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo;
        /**
         * Structured document information.
         */
        structuredDocumentInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerReferenceStructuredDocumentInfo;
        /**
         * Unstructured document information.
         */
        unstructuredDocumentInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo;
    }
    /**
     * Chunk information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfo {
        /**
         * Chunk resource name.
         */
        chunk?: string | null;
        /**
         * Chunk textual content.
         */
        content?: string | null;
        /**
         * Document metadata.
         */
        documentMetadata?: Schema$GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata;
        /**
         * The relevance of the chunk for a given query. Values range from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is for informational purpose only. It may change for the same query and chunk at any time due to a model retraining or change in implementation.
         */
        relevanceScore?: number | null;
    }
    /**
     * Document metadata.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerReferenceChunkInfoDocumentMetadata {
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
        /**
         * The structured JSON metadata for the document. It is populated from the struct data from the Chunk in search result.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Title.
         */
        title?: string | null;
        /**
         * URI for the document.
         */
        uri?: string | null;
    }
    /**
     * Structured search information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerReferenceStructuredDocumentInfo {
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * Structured search data.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Output only. The title of the document.
         */
        title?: string | null;
        /**
         * Output only. The URI of the document.
         */
        uri?: string | null;
    }
    /**
     * Unstructured document information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfo {
        /**
         * List of cited chunk contents derived from document content.
         */
        chunkContents?: Schema$GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent[];
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * The structured JSON metadata for the document. It is populated from the struct data from the Chunk in search result.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Title.
         */
        title?: string | null;
        /**
         * URI for the document.
         */
        uri?: string | null;
    }
    /**
     * Chunk content.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerReferenceUnstructuredDocumentInfoChunkContent {
        /**
         * Chunk textual content.
         */
        content?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
        /**
         * The relevance of the chunk for a given query. Values range from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is for informational purpose only. It may change for the same query and chunk at any time due to a model retraining or change in implementation.
         */
        relevanceScore?: number | null;
    }
    /**
     * Step information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerStep {
        /**
         * Actions.
         */
        actions?: Schema$GoogleCloudDiscoveryengineV1AnswerStepAction[];
        /**
         * The description of the step.
         */
        description?: string | null;
        /**
         * The state of the step.
         */
        state?: string | null;
        /**
         * The thought of the step.
         */
        thought?: string | null;
    }
    /**
     * Action.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerStepAction {
        /**
         * Observation.
         */
        observation?: Schema$GoogleCloudDiscoveryengineV1AnswerStepActionObservation;
        /**
         * Search action.
         */
        searchAction?: Schema$GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction;
    }
    /**
     * Observation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerStepActionObservation {
        /**
         * Search results observed by the search action, it can be snippets info or chunk info, depending on the citation type set by the user.
         */
        searchResults?: Schema$GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult[];
    }
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResult {
        /**
         * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on, populate chunk info.
         */
        chunkInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo[];
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * If citation_type is DOCUMENT_LEVEL_CITATION, populate document level snippets.
         */
        snippetInfo?: Schema$GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo[];
        /**
         * Data representation. The structured JSON data for the document. It's populated from the struct data from the Document, or the Chunk in search result.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Title.
         */
        title?: string | null;
        /**
         * URI for the document.
         */
        uri?: string | null;
    }
    /**
     * Chunk information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultChunkInfo {
        /**
         * Chunk resource name.
         */
        chunk?: string | null;
        /**
         * Chunk textual content.
         */
        content?: string | null;
        /**
         * The relevance of the chunk for a given query. Values range from 0.0 (completely irrelevant) to 1.0 (completely relevant). This value is for informational purpose only. It may change for the same query and chunk at any time due to a model retraining or change in implementation.
         */
        relevanceScore?: number | null;
    }
    /**
     * Snippet information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerStepActionObservationSearchResultSnippetInfo {
        /**
         * Snippet content.
         */
        snippet?: string | null;
        /**
         * Status of the snippet defined by the search team.
         */
        snippetStatus?: string | null;
    }
    /**
     * Search action.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AnswerStepActionSearchAction {
        /**
         * The query to search.
         */
        query?: string | null;
    }
    /**
     * AssistAnswer resource, main part of AssistResponse.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistAnswer {
        /**
         * Reasons for not answering the assist call.
         */
        assistSkippedReasons?: string[] | null;
        /**
         * Immutable. Identifier. Resource name of the `AssistAnswer`. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}/sessions/{session\}/assistAnswers/{assist_answer\}` This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * Replies of the assistant.
         */
        replies?: Schema$GoogleCloudDiscoveryengineV1AssistAnswerReply[];
        /**
         * State of the answer generation.
         */
        state?: string | null;
    }
    /**
     * One part of the multi-part response of the assist call.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistAnswerReply {
        /**
         * Possibly grounded response text or media from the assistant.
         */
        groundedContent?: Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContent;
    }
    /**
     * Discovery Engine Assistant resource.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Assistant {
        /**
         * Optional. Customer policy for the assistant.
         */
        customerPolicy?: Schema$GoogleCloudDiscoveryengineV1AssistantCustomerPolicy;
        /**
         * Optional. Note: not implemented yet. Use enabled_actions instead. The enabled tools on this assistant. The keys are connector name, for example "projects/{projectId\}/locations/{locationId\}/collections/{collectionId\}/dataconnector The values consist of admin enabled tools towards the connector instance. Admin can selectively enable multiple tools on any of the connector instances that they created in the project. For example {"jira1ConnectorName": [(toolId1, "createTicket"), (toolId2, "transferTicket")], "gmail1ConnectorName": [(toolId3, "sendEmail"),..] \}
         */
        enabledTools?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1AssistantToolList;
        } | null;
        /**
         * Optional. Configuration for the generation of the assistant response.
         */
        generationConfig?: Schema$GoogleCloudDiscoveryengineV1AssistantGenerationConfig;
        /**
         * Immutable. Resource name of the assistant. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}/assistants/{assistant\}` It must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * Optional. The type of web grounding to use.
         */
        webGroundingType?: string | null;
    }
    /**
     * Multi-modal content.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantContent {
        /**
         * Result of executing an ExecutableCode.
         */
        codeExecutionResult?: Schema$GoogleCloudDiscoveryengineV1AssistantContentCodeExecutionResult;
        /**
         * Code generated by the model that is meant to be executed.
         */
        executableCode?: Schema$GoogleCloudDiscoveryengineV1AssistantContentExecutableCode;
        /**
         * A file, e.g., an audio summary.
         */
        file?: Schema$GoogleCloudDiscoveryengineV1AssistantContentFile;
        /**
         * Inline binary data.
         */
        inlineData?: Schema$GoogleCloudDiscoveryengineV1AssistantContentBlob;
        /**
         * The producer of the content. Can be "model" or "user".
         */
        role?: string | null;
        /**
         * Inline text.
         */
        text?: string | null;
        /**
         * Optional. Indicates if the part is thought from the model.
         */
        thought?: boolean | null;
    }
    /**
     * Inline blob.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantContentBlob {
        /**
         * Required. Raw bytes.
         */
        data?: string | null;
        /**
         * Required. The media type (MIME type) of the generated data.
         */
        mimeType?: string | null;
    }
    /**
     * Result of executing ExecutableCode.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantContentCodeExecutionResult {
        /**
         * Required. Outcome of the code execution.
         */
        outcome?: string | null;
        /**
         * Optional. Contains stdout when code execution is successful, stderr or other description otherwise.
         */
        output?: string | null;
    }
    /**
     * Code generated by the model that is meant to be executed by the model.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantContentExecutableCode {
        /**
         * Required. The code content. Currently only supports Python.
         */
        code?: string | null;
    }
    /**
     * A file, e.g., an audio summary.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantContentFile {
        /**
         * Required. The file ID.
         */
        fileId?: string | null;
        /**
         * Required. The media type (MIME type) of the file.
         */
        mimeType?: string | null;
    }
    /**
     * Customer-defined policy for the assistant.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantCustomerPolicy {
        /**
         * Optional. List of banned phrases.
         */
        bannedPhrases?: Schema$GoogleCloudDiscoveryengineV1AssistantCustomerPolicyBannedPhrase[];
    }
    /**
     * Definition of a customer-defined banned phrase. A banned phrase is not allowed to appear in the user query or the LLM response, or else the answer will be refused.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantCustomerPolicyBannedPhrase {
        /**
         * Optional. If true, diacritical marks (e.g., accents, umlauts) are ignored when matching banned phrases. For example, "cafe" would match "café".
         */
        ignoreDiacritics?: boolean | null;
        /**
         * Optional. Match type for the banned phrase.
         */
        matchType?: string | null;
        /**
         * Required. The raw string content to be banned.
         */
        phrase?: string | null;
    }
    /**
     * Configuration for the generation of the assistant response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantGenerationConfig {
        /**
         * The default language to use for the generation of the assistant response. Use an ISO 639-1 language code such as `en`. If not specified, the language will be automatically detected.
         */
        defaultLanguage?: string | null;
        /**
         * System instruction, also known as the prompt preamble for LLM calls. See also https://cloud.google.com/vertex-ai/generative-ai/docs/learn/prompts/system-instructions
         */
        systemInstruction?: Schema$GoogleCloudDiscoveryengineV1AssistantGenerationConfigSystemInstruction;
    }
    /**
     * System instruction, also known as the prompt preamble for LLM calls.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantGenerationConfigSystemInstruction {
        /**
         * Optional. Additional system instruction that will be added to the default system instruction.
         */
        additionalSystemInstruction?: string | null;
    }
    /**
     * A piece of content and possibly its grounding information. Not all content needs grounding. Phrases like "Of course, I will gladly search it for you." do not need grounding.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContent {
        /**
         * The content.
         */
        content?: Schema$GoogleCloudDiscoveryengineV1AssistantContent;
        /**
         * Metadata for grounding based on text sources.
         */
        textGroundingMetadata?: Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadata;
    }
    /**
     * Grounding details for text sources.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadata {
        /**
         * References for the grounded text.
         */
        references?: Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReference[];
        /**
         * Grounding information for parts of the text.
         */
        segments?: Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegment[];
    }
    /**
     * Referenced content and related document metadata.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReference {
        /**
         * Referenced text content.
         */
        content?: string | null;
        /**
         * Document metadata.
         */
        documentMetadata?: Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata;
    }
    /**
     * Document metadata.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataReferenceDocumentMetadata {
        /**
         * Document resource name.
         */
        document?: string | null;
        /**
         * Domain name from the document URI. Note that the `uri` field may contain a URL that redirects to the actual website, in which case this will contain the domain name of the target site.
         */
        domain?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
        /**
         * Title.
         */
        title?: string | null;
        /**
         * URI for the document. It may contain a URL that redirects to the actual website.
         */
        uri?: string | null;
    }
    /**
     * Grounding information for a segment of the text.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantGroundedContentTextGroundingMetadataSegment {
        /**
         * End of the segment, exclusive.
         */
        endIndex?: string | null;
        /**
         * Score for the segment.
         */
        groundingScore?: number | null;
        /**
         * References for the segment.
         */
        referenceIndices?: number[] | null;
        /**
         * Zero-based index indicating the start of the segment, measured in bytes of a UTF-8 string (i.e. characters encoded on multiple bytes have a length of more than one).
         */
        startIndex?: string | null;
        /**
         * The text segment itself.
         */
        text?: string | null;
    }
    /**
     * Information to identify a tool.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantToolInfo {
        /**
         * The display name of the tool.
         */
        toolDisplayName?: string | null;
        /**
         * The name of the tool as defined by DataConnectorService.QueryAvailableActions. Note: it's using `action` in the DataConnectorService apis, but they are the same as the `tool` here.
         */
        toolName?: string | null;
    }
    /**
     * The enabled tools on a connector
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistantToolList {
        /**
         * The list of tools with corresponding tool information.
         */
        toolInfo?: Schema$GoogleCloudDiscoveryengineV1AssistantToolInfo[];
    }
    /**
     * User metadata of the request.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1AssistUserMetadata {
        /**
         * Optional. Preferred language to be used for answering if language detection fails. Also used as the language of error messages created by actions, regardless of language detection results.
         */
        preferredLanguageCode?: string | null;
        /**
         * Optional. IANA time zone, e.g. Europe/Budapest.
         */
        timeZone?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.BatchCreateTargetSites operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchCreateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for SiteSearchEngineService.BatchCreateTargetSites method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchCreateTargetSitesRequest {
        /**
         * Required. The request message specifying the resources to create. A maximum of 20 TargetSites can be created in a batch.
         */
        requests?: Schema$GoogleCloudDiscoveryengineV1CreateTargetSiteRequest[];
    }
    /**
     * Response message for SiteSearchEngineService.BatchCreateTargetSites method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchCreateTargetSitesResponse {
        /**
         * TargetSites created.
         */
        targetSites?: Schema$GoogleCloudDiscoveryengineV1TargetSite[];
    }
    /**
     * Response message for DocumentService.BatchGetDocumentsMetadata method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse {
        /**
         * The metadata of the Documents.
         */
        documentsMetadata?: Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadata[];
    }
    /**
     * The metadata of a Document.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadata {
        /**
         * The data ingestion source of the Document. Allowed values are: * `batch`: Data ingested via Batch API, e.g., ImportDocuments. * `streaming` Data ingested via Streaming API, e.g., FHIR streaming.
         */
        dataIngestionSource?: string | null;
        /**
         * The timestamp of the last time the Document was last indexed.
         */
        lastRefreshedTime?: string | null;
        /**
         * The value of the matcher that was used to match the Document.
         */
        matcherValue?: Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue;
        /**
         * The state of the document.
         */
        state?: string | null;
    }
    /**
     * The value of the matcher that was used to match the Document.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponseDocumentMetadataMatcherValue {
        /**
         * Format: projects/{project\}/locations/{location\}/datasets/{dataset\}/fhirStores/{fhir_store\}/fhir/{resource_type\}/{fhir_resource_id\}
         */
        fhirResource?: string | null;
        /**
         * If match by URI, the URI of the Document.
         */
        uri?: string | null;
    }
    /**
     * Metadata related to the progress of the UserLicenseService.BatchUpdateUserLicenses operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of user licenses that failed to be updated.
         */
        failureCount?: string | null;
        /**
         * Count of user licenses successfully updated.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for UserLicenseService.BatchUpdateUserLicenses method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequest {
        /**
         * Optional. If true, if user licenses removed associated license config, the user license will be deleted. By default which is false, the user license will be updated to unassigned state.
         */
        deleteUnassignedUserLicenses?: boolean | null;
        /**
         * The inline source for the input content for document embeddings.
         */
        inlineSource?: Schema$GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequestInlineSource;
    }
    /**
     * The inline source for the input config for BatchUpdateUserLicenses method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesRequestInlineSource {
        /**
         * Optional. The list of fields to update.
         */
        updateMask?: string | null;
        /**
         * Required. A list of user licenses to update. Each user license must have a valid UserLicense.user_principal.
         */
        userLicenses?: Schema$GoogleCloudDiscoveryengineV1UserLicense[];
    }
    /**
     * Response message for UserLicenseService.BatchUpdateUserLicenses method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchUpdateUserLicensesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * UserLicenses successfully updated.
         */
        userLicenses?: Schema$GoogleCloudDiscoveryengineV1UserLicense[];
    }
    /**
     * Request message for SiteSearchEngineService.BatchVerifyTargetSites method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BatchVerifyTargetSitesRequest {
    }
    /**
     * Configuration data for advance site search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaAdvancedSiteSearchConfig {
        /**
         * If set true, automatic refresh is disabled for the DataStore.
         */
        disableAutomaticRefresh?: boolean | null;
        /**
         * If set true, initial indexing is disabled for the DataStore.
         */
        disableInitialIndex?: boolean | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.BatchCreateTargetSites operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaBatchCreateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.BatchCreateTargetSites method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaBatchCreateTargetSitesResponse {
        /**
         * TargetSites created.
         */
        targetSites?: Schema$GoogleCloudDiscoveryengineV1betaTargetSite[];
    }
    /**
     * Metadata related to the progress of the UserLicenseService.BatchUpdateUserLicenses operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaBatchUpdateUserLicensesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of user licenses that failed to be updated.
         */
        failureCount?: string | null;
        /**
         * Count of user licenses successfully updated.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for UserLicenseService.BatchUpdateUserLicenses method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaBatchUpdateUserLicensesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * UserLicenses successfully updated.
         */
        userLicenses?: Schema$GoogleCloudDiscoveryengineV1betaUserLicense[];
    }
    /**
     * Configurations used to enable CMEK data encryption with Cloud KMS keys.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCmekConfig {
        /**
         * Output only. The default CmekConfig for the Customer.
         */
        isDefault?: boolean | null;
        /**
         * Required. KMS key resource name which will be used to encrypt resources `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{keyId\}`.
         */
        kmsKey?: string | null;
        /**
         * Output only. KMS key version resource name which will be used to encrypt resources `/cryptoKeyVersions/{keyVersion\}`.
         */
        kmsKeyVersion?: string | null;
        /**
         * Output only. The timestamp of the last key rotation.
         */
        lastRotationTimestampMicros?: string | null;
        /**
         * Required. The name of the CmekConfig of the form `projects/{project\}/locations/{location\}/cmekConfig` or `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         */
        name?: string | null;
        /**
         * Output only. Whether the NotebookLM Corpus is ready to be used.
         */
        notebooklmState?: string | null;
        /**
         * Optional. Single-regional CMEKs that are required for some VAIS features.
         */
        singleRegionKeys?: Schema$GoogleCloudDiscoveryengineV1betaSingleRegionKey[];
        /**
         * Output only. The states of the CmekConfig.
         */
        state?: string | null;
    }
    /**
     * Defines circumstances to be checked before allowing a behavior
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCondition {
        /**
         * Range of time(s) specifying when condition is active. Maximum of 10 time ranges.
         */
        activeTimeRange?: Schema$GoogleCloudDiscoveryengineV1betaConditionTimeRange[];
        /**
         * Optional. Query regex to match the whole search query. Cannot be set when Condition.query_terms is set. Only supported for Basic Site Search promotion serving controls.
         */
        queryRegex?: string | null;
        /**
         * Search only A list of terms to match the query on. Cannot be set when Condition.query_regex is set. Maximum of 10 query terms.
         */
        queryTerms?: Schema$GoogleCloudDiscoveryengineV1betaConditionQueryTerm[];
    }
    /**
     * Matcher for search request query
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaConditionQueryTerm {
        /**
         * Whether the search query needs to exactly match the query term.
         */
        fullMatch?: boolean | null;
        /**
         * The specific query value to match against Must be lowercase, must be UTF-8. Can have at most 3 space separated terms if full_match is true. Cannot be an empty string. Maximum length of 5000 characters.
         */
        value?: string | null;
    }
    /**
     * Used for time-dependent conditions.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaConditionTimeRange {
        /**
         * End of time range. Range is inclusive. Must be in the future.
         */
        endTime?: string | null;
        /**
         * Start of time range. Range is inclusive.
         */
        startTime?: string | null;
    }
    /**
     * Defines a conditioned behavior to employ during serving. Must be attached to a ServingConfig to be considered at serving time. Permitted actions dependent on `SolutionType`.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaControl {
        /**
         * Output only. List of all ServingConfig IDs this control is attached to. May take up to 10 minutes to update after changes.
         */
        associatedServingConfigIds?: string[] | null;
        /**
         * Defines a boost-type control
         */
        boostAction?: Schema$GoogleCloudDiscoveryengineV1betaControlBoostAction;
        /**
         * Determines when the associated action will trigger. Omit to always apply the action. Currently only a single condition may be specified. Otherwise an INVALID ARGUMENT error is thrown.
         */
        conditions?: Schema$GoogleCloudDiscoveryengineV1betaCondition[];
        /**
         * Required. Human readable name. The identifier used in UI views. Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        displayName?: string | null;
        /**
         * Defines a filter-type control Currently not supported by Recommendation
         */
        filterAction?: Schema$GoogleCloudDiscoveryengineV1betaControlFilterAction;
        /**
         * Immutable. Fully qualified name `projects/x/locations/global/dataStore/x/controls/x`
         */
        name?: string | null;
        /**
         * Promote certain links based on predefined trigger queries.
         */
        promoteAction?: Schema$GoogleCloudDiscoveryengineV1betaControlPromoteAction;
        /**
         * Defines a redirect-type control.
         */
        redirectAction?: Schema$GoogleCloudDiscoveryengineV1betaControlRedirectAction;
        /**
         * Required. Immutable. What solution the control belongs to. Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT error is thrown.
         */
        solutionType?: string | null;
        /**
         * Treats a group of terms as synonyms of one another.
         */
        synonymsAction?: Schema$GoogleCloudDiscoveryengineV1betaControlSynonymsAction;
        /**
         * Specifies the use case for the control. Affects what condition fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only allow one use case per control. Must be set when solution_type is SolutionType.SOLUTION_TYPE_SEARCH.
         */
        useCases?: string[] | null;
    }
    /**
     * Adjusts order of products in returned list.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaControlBoostAction {
        /**
         * Strength of the boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0 (No-op).
         */
        boost?: number | null;
        /**
         * Required. Specifies which data store's documents can be boosted by this control. Full data store name e.g. projects/123/locations/global/collections/default_collection/dataStores/default_data_store
         */
        dataStore?: string | null;
        /**
         * Required. Specifies which products to apply the boost to. If no filter is provided all products will be boosted (No-op). Syntax documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        filter?: string | null;
        /**
         * Optional. Strength of the boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0 (No-op).
         */
        fixedBoost?: number | null;
        /**
         * Optional. Complex specification for custom ranking based on customer defined attribute value.
         */
        interpolationBoostSpec?: Schema$GoogleCloudDiscoveryengineV1betaControlBoostActionInterpolationBoostSpec;
    }
    /**
     * Specification for custom ranking based on customer specified attribute value. It provides more controls for customized ranking than the simple (condition, boost) combination above.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaControlBoostActionInterpolationBoostSpec {
        /**
         * Optional. The attribute type to be used to determine the boost amount. The attribute value can be derived from the field value of the specified field_name. In the case of numerical it is straightforward i.e. attribute_value = numerical_field_value. In the case of freshness however, attribute_value = (time.now() - datetime_field_value).
         */
        attributeType?: string | null;
        /**
         * Optional. The control points used to define the curve. The monotonic function (defined through the interpolation_type above) passes through the control points listed here.
         */
        controlPoints?: Schema$GoogleCloudDiscoveryengineV1betaControlBoostActionInterpolationBoostSpecControlPoint[];
        /**
         * Optional. The name of the field whose value will be used to determine the boost amount.
         */
        fieldName?: string | null;
        /**
         * Optional. The interpolation type to be applied to connect the control points listed below.
         */
        interpolationType?: string | null;
    }
    /**
     * The control points used to define the curve. The curve defined through these control points can only be monotonically increasing or decreasing(constant values are acceptable).
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaControlBoostActionInterpolationBoostSpecControlPoint {
        /**
         * Optional. Can be one of: 1. The numerical field value. 2. The duration spec for freshness: The value must be formatted as an XSD `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value). The pattern for this is: `nDnM]`.
         */
        attributeValue?: string | null;
        /**
         * Optional. The value between -1 to 1 by which to boost the score if the attribute_value evaluates to the value specified above.
         */
        boostAmount?: number | null;
    }
    /**
     * Specified which products may be included in results. Uses same filter as boost.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaControlFilterAction {
        /**
         * Required. Specifies which data store's documents can be filtered by this control. Full data store name e.g. projects/123/locations/global/collections/default_collection/dataStores/default_data_store
         */
        dataStore?: string | null;
        /**
         * Required. A filter to apply on the matching condition results. Required Syntax documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        filter?: string | null;
    }
    /**
     * Promote certain links based on some trigger queries. Example: Promote shoe store link when searching for `shoe` keyword. The link can be outside of associated data store.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaControlPromoteAction {
        /**
         * Required. Data store with which this promotion is attached to.
         */
        dataStore?: string | null;
        /**
         * Required. Promotion attached to this action.
         */
        searchLinkPromotion?: Schema$GoogleCloudDiscoveryengineV1betaSearchLinkPromotion;
    }
    /**
     * Redirects a shopper to the provided URI.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaControlRedirectAction {
        /**
         * Required. The URI to which the shopper will be redirected. Required. URI must have length equal or less than 2000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        redirectUri?: string | null;
    }
    /**
     * Creates a set of terms that will act as synonyms of one another. Example: "happy" will also be considered as "glad", "glad" will also be considered as "happy".
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaControlSynonymsAction {
        /**
         * Defines a set of synonyms. Can specify up to 100 synonyms. Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
         */
        synonyms?: string[] | null;
    }
    /**
     * The historical crawl rate timeseries data, used for monitoring.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCrawlRateTimeSeries {
        /**
         * The QPS of the crawl rate.
         */
        qpsTimeSeries?: Schema$GoogleMonitoringV3TimeSeries;
    }
    /**
     * Metadata related to the progress of the DataStoreService.CreateDataStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCreateDataStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the EngineService.CreateEngine operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCreateEngineMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for EvaluationService.CreateEvaluation method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCreateEvaluationMetadata {
    }
    /**
     * Metadata for Create Schema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCreateSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.CreateSitemap operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCreateSitemapMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.CreateTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaCreateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * DataStore captures global settings and configs at the DataStore level.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDataStore {
        /**
         * Immutable. Whether data in the DataStore has ACL information. If set to `true`, the source data must have ACL. ACL will be ingested when data is ingested by DocumentService.ImportDocuments methods. When ACL is enabled for the DataStore, Document can't be accessed by calling DocumentService.GetDocument or DocumentService.ListDocuments. Currently ACL is only supported in `GENERIC` industry vertical with non-`PUBLIC_WEBSITE` content config.
         */
        aclEnabled?: boolean | null;
        /**
         * Optional. Configuration for advanced site search.
         */
        advancedSiteSearchConfig?: Schema$GoogleCloudDiscoveryengineV1betaAdvancedSiteSearchConfig;
        /**
         * Output only. Data size estimation for billing.
         */
        billingEstimation?: Schema$GoogleCloudDiscoveryengineV1betaDataStoreBillingEstimation;
        /**
         * Output only. CMEK-related information for the DataStore.
         */
        cmekConfig?: Schema$GoogleCloudDiscoveryengineV1betaCmekConfig;
        /**
         * Immutable. The content config of the data store. If this field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
         */
        contentConfig?: string | null;
        /**
         * Output only. Timestamp the DataStore was created at.
         */
        createTime?: string | null;
        /**
         * Output only. The id of the default Schema associated to this data store.
         */
        defaultSchemaId?: string | null;
        /**
         * Required. The data store display name. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        displayName?: string | null;
        /**
         * Configuration for Document understanding and enrichment.
         */
        documentProcessingConfig?: Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig;
        /**
         * Optional. Configuration for `HEALTHCARE_FHIR` vertical.
         */
        healthcareFhirConfig?: Schema$GoogleCloudDiscoveryengineV1betaHealthcareFhirConfig;
        /**
         * Immutable. The fully qualified resource name of the associated IdentityMappingStore. This field can only be set for acl_enabled DataStores with `THIRD_PARTY` or `GSUITE` IdP. Format: `projects/{project\}/locations/{location\}/identityMappingStores/{identity_mapping_store\}`.
         */
        identityMappingStore?: string | null;
        /**
         * Immutable. The industry vertical that the data store registers.
         */
        industryVertical?: string | null;
        /**
         * Optional. If set, this DataStore is an Infobot FAQ DataStore.
         */
        isInfobotFaqDataStore?: boolean | null;
        /**
         * Input only. The KMS key to be used to protect this DataStore at creation time. Must be set for requests that need to comply with CMEK Org Policy protections. If this field is set and processed successfully, the DataStore will be protected by the KMS key, as indicated in the cmek_config field.
         */
        kmsKeyName?: string | null;
        /**
         * Language info for DataStore.
         */
        languageInfo?: Schema$GoogleCloudDiscoveryengineV1betaLanguageInfo;
        /**
         * Immutable. Identifier. The full resource name of the data store. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * Optional. Configuration for Natural Language Query Understanding.
         */
        naturalLanguageQueryUnderstandingConfig?: Schema$GoogleCloudDiscoveryengineV1betaNaturalLanguageQueryUnderstandingConfig;
        /**
         * Optional. Stores serving config at DataStore level.
         */
        servingConfigDataStore?: Schema$GoogleCloudDiscoveryengineV1betaDataStoreServingConfigDataStore;
        /**
         * The solutions that the data store enrolls. Available solutions for each industry_vertical: * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be enrolled.
         */
        solutionTypes?: string[] | null;
        /**
         * The start schema to use for this DataStore when provisioning it. If unset, a default vertical specialized schema will be used. This field is only used by CreateDataStore API, and will be ignored if used in other APIs. This field will be omitted from all API responses including CreateDataStore API. To retrieve a schema of a DataStore, use SchemaService.GetSchema API instead. The provided schema will be validated against certain rules on schema. Learn more from [this doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
         */
        startingSchema?: Schema$GoogleCloudDiscoveryengineV1betaSchema;
        /**
         * Config to store data store type configuration for workspace data. This must be set when DataStore.content_config is set as DataStore.ContentConfig.GOOGLE_WORKSPACE.
         */
        workspaceConfig?: Schema$GoogleCloudDiscoveryengineV1betaWorkspaceConfig;
    }
    /**
     * Estimation of data size per data store.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDataStoreBillingEstimation {
        /**
         * Data size for structured data in terms of bytes.
         */
        structuredDataSize?: string | null;
        /**
         * Last updated timestamp for structured data.
         */
        structuredDataUpdateTime?: string | null;
        /**
         * Data size for unstructured data in terms of bytes.
         */
        unstructuredDataSize?: string | null;
        /**
         * Last updated timestamp for unstructured data.
         */
        unstructuredDataUpdateTime?: string | null;
        /**
         * Data size for websites in terms of bytes.
         */
        websiteDataSize?: string | null;
        /**
         * Last updated timestamp for websites.
         */
        websiteDataUpdateTime?: string | null;
    }
    /**
     * Stores information regarding the serving configurations at DataStore level.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDataStoreServingConfigDataStore {
        /**
         * Optional. If set true, the DataStore will not be available for serving search requests.
         */
        disabledForServing?: boolean | null;
    }
    /**
     * The historical dedicated crawl rate timeseries data, used for monitoring. Dedicated crawl is used by Vertex AI to crawl the user's website when dedicate crawl is set.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDedicatedCrawlRateTimeSeries {
        /**
         * Vertex AI's error rate time series of auto-refresh dedicated crawl.
         */
        autoRefreshCrawlErrorRate?: Schema$GoogleCloudDiscoveryengineV1betaCrawlRateTimeSeries;
        /**
         * Vertex AI's dedicated crawl rate time series of auto-refresh, which is the crawl rate of Google-CloudVertexBot when dedicate crawl is set, and the crawl rate is for best effort use cases like refreshing urls periodically.
         */
        autoRefreshCrawlRate?: Schema$GoogleCloudDiscoveryengineV1betaCrawlRateTimeSeries;
        /**
         * Vertex AI's error rate time series of user triggered dedicated crawl.
         */
        userTriggeredCrawlErrorRate?: Schema$GoogleCloudDiscoveryengineV1betaCrawlRateTimeSeries;
        /**
         * Vertex AI's dedicated crawl rate time series of user triggered crawl, which is the crawl rate of Google-CloudVertexBot when dedicate crawl is set, and user triggered crawl rate is for deterministic use cases like crawling urls or sitemaps specified by users.
         */
        userTriggeredCrawlRate?: Schema$GoogleCloudDiscoveryengineV1betaCrawlRateTimeSeries;
    }
    /**
     * Metadata related to the progress of the DataStoreService.DeleteDataStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDeleteDataStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the EngineService.DeleteEngine operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDeleteEngineMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the IdentityMappingStoreService.DeleteIdentityMappingStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDeleteIdentityMappingStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for DeleteSchema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDeleteSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DeleteSitemap operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDeleteSitemapMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DeleteTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDeleteTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDisableAdvancedSiteSearchResponse {
    }
    /**
     * A singleton resource of DataStore. If it's empty when DataStore is created and DataStore is set to DataStore.ContentConfig.CONTENT_REQUIRED, the default parser will default to digital parser.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfig {
        /**
         * Whether chunking mode is enabled.
         */
        chunkingConfig?: Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig;
        /**
         * Configurations for default Document parser. If not specified, we will configure it as default DigitalParsingConfig, and the default parsing config will be applied to all file types for Document parsing.
         */
        defaultParsingConfig?: Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig;
        /**
         * The full resource name of the Document Processing Config. Format: `projects/x/locations/x/collections/x/dataStores/x/documentProcessingConfig`.
         */
        name?: string | null;
        /**
         * Map from file type to override the default parsing configuration based on the file type. Supported keys: * `pdf`: Override parsing config for PDF files, either digital parsing, ocr parsing or layout parsing is supported. * `html`: Override parsing config for HTML files, only digital parsing and layout parsing are supported. * `docx`: Override parsing config for DOCX files, only digital parsing and layout parsing are supported. * `pptx`: Override parsing config for PPTX files, only digital parsing and layout parsing are supported. * `xlsm`: Override parsing config for XLSM files, only digital parsing and layout parsing are supported. * `xlsx`: Override parsing config for XLSX files, only digital parsing and layout parsing are supported.
         */
        parsingConfigOverrides?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig;
        } | null;
    }
    /**
     * Configuration for chunking config.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfig {
        /**
         * Configuration for the layout based chunking.
         */
        layoutBasedChunkingConfig?: Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig;
    }
    /**
     * Configuration for the layout based chunking.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig {
        /**
         * The token size limit for each chunk. Supported values: 100-500 (inclusive). Default value: 500.
         */
        chunkSize?: number | null;
        /**
         * Whether to include appending different levels of headings to chunks from the middle of the document to prevent context loss. Default value: False.
         */
        includeAncestorHeadings?: boolean | null;
    }
    /**
     * Related configurations applied to a specific type of document parser.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfig {
        /**
         * Configurations applied to digital parser.
         */
        digitalParsingConfig?: Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigDigitalParsingConfig;
        /**
         * Configurations applied to layout parser.
         */
        layoutParsingConfig?: Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigLayoutParsingConfig;
        /**
         * Configurations applied to OCR parser. Currently it only applies to PDFs.
         */
        ocrParsingConfig?: Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig;
    }
    /**
     * The digital parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigDigitalParsingConfig {
    }
    /**
     * The layout parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigLayoutParsingConfig {
        /**
         * Optional. If true, the processed document will be made available for the GetProcessedDocument API.
         */
        enableGetProcessedDocument?: boolean | null;
        /**
         * Optional. If true, the LLM based annotation is added to the image during parsing.
         */
        enableImageAnnotation?: boolean | null;
        /**
         * Optional. If true, the LLM based annotation is added to the table during parsing.
         */
        enableTableAnnotation?: boolean | null;
        /**
         * Optional. List of HTML classes to exclude from the parsed content.
         */
        excludeHtmlClasses?: string[] | null;
        /**
         * Optional. List of HTML elements to exclude from the parsed content.
         */
        excludeHtmlElements?: string[] | null;
        /**
         * Optional. List of HTML ids to exclude from the parsed content.
         */
        excludeHtmlIds?: string[] | null;
        /**
         * Optional. Contains the required structure types to extract from the document. Supported values: * `shareholder-structure`
         */
        structuredContentTypes?: string[] | null;
    }
    /**
     * The OCR parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaDocumentProcessingConfigParsingConfigOcrParsingConfig {
        /**
         * [DEPRECATED] This field is deprecated. To use the additional enhanced document elements processing, please switch to `layout_parsing_config`.
         */
        enhancedDocumentElements?: string[] | null;
        /**
         * If true, will use native text instead of OCR text on pages containing native text.
         */
        useNativeText?: boolean | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEnableAdvancedSiteSearchResponse {
    }
    /**
     * Metadata that describes the training and serving parameters of an Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngine {
        /**
         * Configurations for the Chat Engine. Only applicable if solution_type is SOLUTION_TYPE_CHAT.
         */
        chatEngineConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig;
        /**
         * Output only. Additional information of the Chat Engine. Only applicable if solution_type is SOLUTION_TYPE_CHAT.
         */
        chatEngineMetadata?: Schema$GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata;
        /**
         * Common config spec that specifies the metadata of the engine.
         */
        commonConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineCommonConfig;
        /**
         * Output only. Timestamp the Recommendation Engine was created at.
         */
        createTime?: string | null;
        /**
         * Optional. The data stores associated with this engine. For SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store. If solution_type is SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be associated here. Note that when used in CreateEngineRequest, one DataStore id must be provided as the system will use it for necessary initializations.
         */
        dataStoreIds?: string[] | null;
        /**
         * Optional. Whether to disable analytics for searches performed on this engine.
         */
        disableAnalytics?: boolean | null;
        /**
         * Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
         */
        displayName?: string | null;
        /**
         * Optional. Feature config for the engine to opt in or opt out of features. Supported keys: * `*`: all features, if it's present, all other feature state settings are ignored. * `agent-gallery` * `no-code-agent-builder` * `prompt-gallery` * `model-selector` * `notebook-lm` * `people-search` * `people-search-org-chart` * `bi-directional-audio` * `feedback` * `session-sharing` * `personalization-memory` - Enables personalization based on user preferences.
         */
        features?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: Vertical on Engine has to match vertical of the DataStore linked to the engine.
         */
        industryVertical?: string | null;
        /**
         * Configurations for the Media Engine. Only applicable on the data stores with solution_type SOLUTION_TYPE_RECOMMENDATION and IndustryVertical.MEDIA vertical.
         */
        mediaRecommendationEngineConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfig;
        /**
         * Immutable. Identifier. The fully qualified resource name of the engine. This field must be a UTF-8 encoded string with a length limit of 1024 characters. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}` engine should be 1-63 characters, and valid characters are /a-z0-9x/. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        name?: string | null;
        /**
         * Configurations for the Search Engine. Only applicable if solution_type is SOLUTION_TYPE_SEARCH.
         */
        searchEngineConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig;
        /**
         * Required. The solutions of the engine.
         */
        solutionType?: string | null;
        /**
         * Output only. Timestamp the Recommendation Engine was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Configurations for a Chat Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineChatEngineConfig {
        /**
         * The configurationt generate the Dialogflow agent that is associated to this Engine. Note that these configurations are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
         */
        agentCreationConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig;
        /**
         * Optional. If the flag set to true, we allow the agent and engine are in different locations, otherwise the agent and engine are required to be in the same location. The flag is set to false by default. Note that the `allow_cross_region` are one-time consumed by and passed to EngineService.CreateEngine. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
         */
        allowCrossRegion?: boolean | null;
        /**
         * The resource name of an exist Dialogflow agent to link to this Chat Engine. Customers can either provide `agent_creation_config` to create agent or provide an agent name that links the agent with the Chat engine. Format: `projects//locations//agents/`. Note that the `dialogflow_agent_to_link` are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation. Use ChatEngineMetadata.dialogflow_agent for actual agent association after Engine is created.
         */
        dialogflowAgentToLink?: string | null;
    }
    /**
     * Configurations for generating a Dialogflow agent. Note that these configurations are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineChatEngineConfigAgentCreationConfig {
        /**
         * Name of the company, organization or other entity that the agent represents. Used for knowledge connector LLM prompt and for knowledge search.
         */
        business?: string | null;
        /**
         * Required. The default language of the agent as a language tag. See [Language Support](https://cloud.google.com/dialogflow/docs/reference/language) for a list of the currently supported language codes.
         */
        defaultLanguageCode?: string | null;
        /**
         * Agent location for Agent creation, supported values: global/us/eu. If not provided, us Engine will create Agent using us-central-1 by default; eu Engine will create Agent using eu-west-1 by default.
         */
        location?: string | null;
        /**
         * Required. The time zone of the agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
         */
        timeZone?: string | null;
    }
    /**
     * Additional information of a Chat Engine. Fields in this message are output only.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineChatEngineMetadata {
        /**
         * The resource name of a Dialogflow agent, that this Chat Engine refers to. Format: `projects//locations//agents/`.
         */
        dialogflowAgent?: string | null;
    }
    /**
     * Common configurations for an Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineCommonConfig {
        /**
         * The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.
         */
        companyName?: string | null;
    }
    /**
     * Additional config specs for a Media Recommendation engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfig {
        /**
         * Optional. Additional engine features config.
         */
        engineFeaturesConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfigEngineFeaturesConfig;
        /**
         * The optimization objective. e.g., `cvr`. This field together with optimization_objective describe engine metadata to use to control engine training and serving. Currently supported values: `ctr`, `cvr`. If not specified, we choose default based on engine type. Default depends on type of recommendation: `recommended-for-you` =\> `ctr` `others-you-may-like` =\> `ctr`
         */
        optimizationObjective?: string | null;
        /**
         * Name and value of the custom threshold for cvr optimization_objective. For target_field `watch-time`, target_field_value must be an integer value indicating the media progress time in seconds between (0, 86400] (excludes 0, includes 86400) (e.g., 90). For target_field `watch-percentage`, the target_field_value must be a valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g., 0.5).
         */
        optimizationObjectiveConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig;
        /**
         * The training state that the engine is in (e.g. `TRAINING` or `PAUSED`). Since part of the cost of running the service is frequency of training - this can be used to determine when to train engine in order to control cost. If not specified: the default value for `CreateEngine` method is `TRAINING`. The default value for `UpdateEngine` method is to keep the state the same as before.
         */
        trainingState?: string | null;
        /**
         * Required. The type of engine. e.g., `recommended-for-you`. This field together with optimization_objective describe engine metadata to use to control engine training and serving. Currently supported values: `recommended-for-you`, `others-you-may-like`, `more-like-this`, `most-popular-items`.
         */
        type?: string | null;
    }
    /**
     * More feature configs of the selected engine type.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfigEngineFeaturesConfig {
        /**
         * Most popular engine feature config.
         */
        mostPopularConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfigMostPopularFeatureConfig;
        /**
         * Recommended for you engine feature config.
         */
        recommendedForYouConfig?: Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig;
    }
    /**
     * Feature configurations that are required for creating a Most Popular engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfigMostPopularFeatureConfig {
        /**
         * The time window of which the engine is queried at training and prediction time. Positive integers only. The value translates to the last X days of events. Currently required for the `most-popular-items` engine.
         */
        timeWindowDays?: string | null;
    }
    /**
     * Custom threshold for `cvr` optimization_objective.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfigOptimizationObjectiveConfig {
        /**
         * Required. The name of the field to target. Currently supported values: `watch-percentage`, `watch-time`.
         */
        targetField?: string | null;
        /**
         * Required. The threshold to be applied to the target (e.g., 0.5).
         */
        targetFieldValueFloat?: number | null;
    }
    /**
     * Additional feature configurations for creating a `recommended-for-you` engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig {
        /**
         * The type of event with which the engine is queried at prediction time. If set to `generic`, only `view-item`, `media-play`,and `media-complete` will be used as `context-event` in engine training. If set to `view-home-page`, `view-home-page` will also be used as `context-events` in addition to `view-item`, `media-play`, and `media-complete`. Currently supported for the `recommended-for-you` engine. Currently supported values: `view-home-page`, `generic`.
         */
        contextEventType?: string | null;
    }
    /**
     * Configurations for a Search Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEngineSearchEngineConfig {
        /**
         * The add-on that this search engine enables.
         */
        searchAddOns?: string[] | null;
        /**
         * The search feature tier of this engine. Different tiers might have different pricing. To learn more, check the pricing documentation. Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
         */
        searchTier?: string | null;
    }
    /**
     * An evaluation is a single execution (or run) of an evaluation process. It encapsulates the state of the evaluation and the resulting data.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEvaluation {
        /**
         * Output only. Timestamp the Evaluation was created at.
         */
        createTime?: string | null;
        /**
         * Output only. Timestamp the Evaluation was completed at.
         */
        endTime?: string | null;
        /**
         * Output only. The error that occurred during evaluation. Only populated when the evaluation's state is FAILED.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Required. The specification of the evaluation.
         */
        evaluationSpec?: Schema$GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpec;
        /**
         * Identifier. The full resource name of the Evaluation, in the format of `projects/{project\}/locations/{location\}/evaluations/{evaluation\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * Output only. The metrics produced by the evaluation, averaged across all SampleQuerys in the SampleQuerySet. Only populated when the evaluation's state is SUCCEEDED.
         */
        qualityMetrics?: Schema$GoogleCloudDiscoveryengineV1betaQualityMetrics;
        /**
         * Output only. The state of the evaluation.
         */
        state?: string | null;
    }
    /**
     * Describes the specification of the evaluation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpec {
        /**
         * Optional. The specification of the query set.
         */
        querySetSpec?: Schema$GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpecQuerySetSpec;
        /**
         * Required. The search request that is used to perform the evaluation. Only the following fields within SearchRequest are supported; if any other fields are provided, an UNSUPPORTED error will be returned: * SearchRequest.serving_config * SearchRequest.branch * SearchRequest.canonical_filter * SearchRequest.query_expansion_spec * SearchRequest.spell_correction_spec * SearchRequest.content_search_spec * SearchRequest.user_pseudo_id
         */
        searchRequest?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequest;
    }
    /**
     * Describes the specification of the query set.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaEvaluationEvaluationSpecQuerySetSpec {
        /**
         * Optional. The full resource name of the SampleQuerySet used for the evaluation, in the format of `projects/{project\}/locations/{location\}/sampleQuerySets/{sampleQuerySet\}`.
         */
        sampleQuerySet?: string | null;
    }
    /**
     * Config to data store for `HEALTHCARE_FHIR` vertical.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaHealthcareFhirConfig {
        /**
         * Whether to enable configurable schema for `HEALTHCARE_FHIR` vertical. If set to `true`, the predefined healthcare fhir schema can be extended for more customized searching and filtering.
         */
        enableConfigurableSchema?: boolean | null;
        /**
         * Whether to enable static indexing for `HEALTHCARE_FHIR` batch ingestion. If set to `true`, the batch ingestion will be processed in a static indexing mode which is slower but more capable of handling larger volume.
         */
        enableStaticIndexingForBatchIngestion?: boolean | null;
    }
    /**
     * IdentityMappingEntry LongRunningOperation metadata for IdentityMappingStoreService.ImportIdentityMappings and IdentityMappingStoreService.PurgeIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaIdentityMappingEntryOperationMetadata {
        /**
         * The number of IdentityMappingEntries that failed to be processed.
         */
        failureCount?: string | null;
        /**
         * The number of IdentityMappingEntries that were successfully processed.
         */
        successCount?: string | null;
        /**
         * The total number of IdentityMappingEntries that were processed.
         */
        totalCount?: string | null;
    }
    /**
     * Metadata related to the progress of the ImportCompletionSuggestions operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of CompletionSuggestions that failed to be imported.
         */
        failureCount?: string | null;
        /**
         * Count of CompletionSuggestions successfully imported.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the CompletionService.ImportCompletionSuggestions method. If the long running operation is done, this message is returned by the google.longrunning.Operations.response field if the operation is successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportCompletionSuggestionsResponse {
        /**
         * The desired location of errors incurred during the Import.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1betaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Metadata related to the progress of the ImportDocuments operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportDocumentsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were processed successfully.
         */
        successCount?: string | null;
        /**
         * Total count of entries that were processed.
         */
        totalCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the ImportDocumentsRequest. If the long running operation is done, then this message is returned by the google.longrunning.Operations.response field if the operation was successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportDocumentsResponse {
        /**
         * Echoes the destination for the complete errors in the request if set.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1betaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Configuration of destination for Import related errors.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportErrorConfig {
        /**
         * Cloud Storage prefix for import errors. This must be an empty, existing Cloud Storage directory. Import errors are written to sharded files in this directory, one per line, as a JSON-encoded `google.rpc.Status` message.
         */
        gcsPrefix?: string | null;
    }
    /**
     * Response message for IdentityMappingStoreService.ImportIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportIdentityMappingsResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Metadata related to the progress of the ImportSampleQueries operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportSampleQueriesMetadata {
        /**
         * ImportSampleQueries operation create time.
         */
        createTime?: string | null;
        /**
         * Count of SampleQuerys that failed to be imported.
         */
        failureCount?: string | null;
        /**
         * Count of SampleQuerys successfully imported.
         */
        successCount?: string | null;
        /**
         * Total count of SampleQuerys that were processed.
         */
        totalCount?: string | null;
        /**
         * ImportSampleQueries operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the SampleQueryService.ImportSampleQueries method. If the long running operation is done, this message is returned by the google.longrunning.Operations.response field if the operation is successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportSampleQueriesResponse {
        /**
         * The desired location of errors incurred during the Import.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1betaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Metadata related to the progress of the ImportSuggestionDenyListEntries operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CompletionService.ImportSuggestionDenyListEntries method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportSuggestionDenyListEntriesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Count of deny list entries that failed to be imported.
         */
        failedEntriesCount?: string | null;
        /**
         * Count of deny list entries successfully imported.
         */
        importedEntriesCount?: string | null;
    }
    /**
     * Metadata related to the progress of the Import operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportUserEventsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were processed successfully.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the ImportUserEventsRequest. If the long running operation was successful, then this message is returned by the google.longrunning.Operations.response field if the operation was successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaImportUserEventsResponse {
        /**
         * Echoes the destination for the complete errors if this field was set in the request.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1betaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Count of user events imported with complete existing Documents.
         */
        joinedEventsCount?: string | null;
        /**
         * Count of user events imported, but with Document information not found in the existing Branch.
         */
        unjoinedEventsCount?: string | null;
    }
    /**
     * A floating point interval.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaInterval {
        /**
         * Exclusive upper bound.
         */
        exclusiveMaximum?: number | null;
        /**
         * Exclusive lower bound.
         */
        exclusiveMinimum?: number | null;
        /**
         * Inclusive upper bound.
         */
        maximum?: number | null;
        /**
         * Inclusive lower bound.
         */
        minimum?: number | null;
    }
    /**
     * Language info for DataStore.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaLanguageInfo {
        /**
         * Output only. Language part of normalized_language_code. E.g.: `en-US` -\> `en`, `zh-Hans-HK` -\> `zh`, `en` -\> `en`.
         */
        language?: string | null;
        /**
         * The language code for the DataStore.
         */
        languageCode?: string | null;
        /**
         * Output only. This is the normalized form of language_code. E.g.: language_code of `en-GB`, `en_GB`, `en-UK` or `en-gb` will have normalized_language_code of `en-GB`.
         */
        normalizedLanguageCode?: string | null;
        /**
         * Output only. Region part of normalized_language_code, if present. E.g.: `en-US` -\> `US`, `zh-Hans-HK` -\> `HK`, `en` -\> ``.
         */
        region?: string | null;
    }
    /**
     * Configuration for Natural Language Query Understanding.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaNaturalLanguageQueryUnderstandingConfig {
        /**
         * Mode of Natural Language Query Understanding. If this field is unset, the behavior defaults to NaturalLanguageQueryUnderstandingConfig.Mode.DISABLED.
         */
        mode?: string | null;
    }
    /**
     * Response message for CrawlRateManagementService.ObtainCrawlRate method. The response contains organcic or dedicated crawl rate time series data for monitoring, depending on whether dedicated crawl rate is set.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaObtainCrawlRateResponse {
        /**
         * The historical dedicated crawl rate timeseries data, used for monitoring.
         */
        dedicatedCrawlRateTimeSeries?: Schema$GoogleCloudDiscoveryengineV1betaDedicatedCrawlRateTimeSeries;
        /**
         * Errors from service when handling the request.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The historical organic crawl rate timeseries data, used for monitoring.
         */
        organicCrawlRateTimeSeries?: Schema$GoogleCloudDiscoveryengineV1betaOrganicCrawlRateTimeSeries;
        /**
         * Output only. The state of the response.
         */
        state?: string | null;
    }
    /**
     * The historical organic crawl rate timeseries data, used for monitoring. Organic crawl is auto-determined by Google to crawl the user's website when dedicate crawl is not set. Crawl rate is the QPS of crawl request Google sends to the user's website.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaOrganicCrawlRateTimeSeries {
        /**
         * Google's organic crawl rate time series, which is the sum of all googlebots' crawl rate. Please refer to https://developers.google.com/search/docs/crawling-indexing/overview-google-crawlers for more details about googlebots.
         */
        googleOrganicCrawlRate?: Schema$GoogleCloudDiscoveryengineV1betaCrawlRateTimeSeries;
        /**
         * Vertex AI's organic crawl rate time series, which is the crawl rate of Google-CloudVertexBot when dedicate crawl is not set. Please refer to https://developers.google.com/search/docs/crawling-indexing/google-common-crawlers#google-cloudvertexbot for more details about Google-CloudVertexBot.
         */
        vertexAiOrganicCrawlRate?: Schema$GoogleCloudDiscoveryengineV1betaCrawlRateTimeSeries;
    }
    /**
     * Metadata and configurations for a Google Cloud project in the service.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaProject {
        /**
         * Output only. The timestamp when this project is created.
         */
        createTime?: string | null;
        /**
         * Output only. Full resource name of the project, for example `projects/{project\}`. Note that when making requests, project number and project id are both acceptable, but the server will always respond in project number.
         */
        name?: string | null;
        /**
         * Output only. The timestamp when this project is successfully provisioned. Empty value means this project is still provisioning and is not ready for use.
         */
        provisionCompletionTime?: string | null;
        /**
         * Output only. A map of terms of services. The key is the `id` of ServiceTerms.
         */
        serviceTermsMap?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1betaProjectServiceTerms;
        } | null;
    }
    /**
     * Metadata about the terms of service.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaProjectServiceTerms {
        /**
         * The last time when the project agreed to the terms of service.
         */
        acceptTime?: string | null;
        /**
         * The last time when the project declined or revoked the agreement to terms of service.
         */
        declineTime?: string | null;
        /**
         * The unique identifier of this terms of service. Available terms: * `GA_DATA_USE_TERMS`: [Terms for data use](https://cloud.google.com/retail/data-use-terms). When using this as `id`, the acceptable version to provide is `2022-11-23`.
         */
        id?: string | null;
        /**
         * Whether the project has accepted/rejected the service terms or it is still pending.
         */
        state?: string | null;
        /**
         * The version string of the terms of service. For acceptable values, see the comments for id above.
         */
        version?: string | null;
    }
    /**
     * Metadata associated with a project provision operation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaProvisionProjectMetadata {
    }
    /**
     * Metadata related to the progress of the PurgeDocuments operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaPurgeDocumentsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were ignored as entries were not found.
         */
        ignoredCount?: string | null;
        /**
         * Count of entries that were deleted successfully.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for DocumentService.PurgeDocuments method. If the long running operation is successfully done, then this message is returned by the google.longrunning.Operations.response field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaPurgeDocumentsResponse {
        /**
         * The total count of documents purged as a result of the operation.
         */
        purgeCount?: string | null;
        /**
         * A sample of document names that will be deleted. Only populated if `force` is set to false. A max of 100 names will be returned and the names are chosen at random.
         */
        purgeSample?: string[] | null;
    }
    /**
     * Metadata related to the progress of the PurgeSuggestionDenyListEntries operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CompletionService.PurgeSuggestionDenyListEntries method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaPurgeSuggestionDenyListEntriesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Number of suggestion deny list entries purged.
         */
        purgeCount?: string | null;
    }
    /**
     * Describes the metrics produced by the evaluation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaQualityMetrics {
        /**
         * Normalized discounted cumulative gain (NDCG) per document, at various top-k cutoff levels. NDCG measures the ranking quality, giving higher relevance to top results. Example (top-3): Suppose SampleQuery with three retrieved documents (D1, D2, D3) and binary relevance judgements (1 for relevant, 0 for not relevant): Retrieved: [D3 (0), D1 (1), D2 (1)] Ideal: [D1 (1), D2 (1), D3 (0)] Calculate NDCG@3 for each SampleQuery: * DCG@3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13 * Ideal DCG@3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63 * NDCG@3: 1.13/1.63 = 0.693
         */
        docNdcg?: Schema$GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics;
        /**
         * Precision per document, at various top-k cutoff levels. Precision is the fraction of retrieved documents that are relevant. Example (top-5): * For a single SampleQuery, If 4 out of 5 retrieved documents in the top-5 are relevant, precision@5 = 4/5 = 0.8
         */
        docPrecision?: Schema$GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics;
        /**
         * Recall per document, at various top-k cutoff levels. Recall is the fraction of relevant documents retrieved out of all relevant documents. Example (top-5): * For a single SampleQuery, If 3 out of 5 relevant documents are retrieved in the top-5, recall@5 = 3/5 = 0.6
         */
        docRecall?: Schema$GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics;
        /**
         * Normalized discounted cumulative gain (NDCG) per page, at various top-k cutoff levels. NDCG measures the ranking quality, giving higher relevance to top results. Example (top-3): Suppose SampleQuery with three retrieved pages (P1, P2, P3) and binary relevance judgements (1 for relevant, 0 for not relevant): Retrieved: [P3 (0), P1 (1), P2 (1)] Ideal: [P1 (1), P2 (1), P3 (0)] Calculate NDCG@3 for SampleQuery: * DCG@3: 0/log2(1+1) + 1/log2(2+1) + 1/log2(3+1) = 1.13 * Ideal DCG@3: 1/log2(1+1) + 1/log2(2+1) + 0/log2(3+1) = 1.63 * NDCG@3: 1.13/1.63 = 0.693
         */
        pageNdcg?: Schema$GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics;
        /**
         * Recall per page, at various top-k cutoff levels. Recall is the fraction of relevant pages retrieved out of all relevant pages. Example (top-5): * For a single SampleQuery, if 3 out of 5 relevant pages are retrieved in the top-5, recall@5 = 3/5 = 0.6
         */
        pageRecall?: Schema$GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics;
    }
    /**
     * Stores the metric values at specific top-k levels.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaQualityMetricsTopkMetrics {
        /**
         * The top-1 value.
         */
        top1?: number | null;
        /**
         * The top-10 value.
         */
        top10?: number | null;
        /**
         * The top-3 value.
         */
        top3?: number | null;
        /**
         * The top-5 value.
         */
        top5?: number | null;
    }
    /**
     * Metadata related to the progress of the CrawlRateManagementService.RemoveDedicatedCrawlRate operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaRemoveDedicatedCrawlRateMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CrawlRateManagementService.RemoveDedicatedCrawlRate method. It simply returns the state of the response, and an error message if the state is FAILED.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaRemoveDedicatedCrawlRateResponse {
        /**
         * Errors from service when handling the request.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. The state of the response.
         */
        state?: string | null;
    }
    /**
     * Defines the structure and layout of a type of document data.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSchema {
        /**
         * The JSON representation of the schema.
         */
        jsonSchema?: string | null;
        /**
         * Immutable. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * The structured representation of the schema.
         */
        structSchema?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Promotion proto includes uri and other helping information to display the promotion.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchLinkPromotion {
        /**
         * Optional. The Promotion description. Maximum length: 200 characters.
         */
        description?: string | null;
        /**
         * Optional. The Document the user wants to promote. For site search, leave unset and only populate uri. Can be set along with uri.
         */
        document?: string | null;
        /**
         * Optional. The enabled promotion will be returned for any serving configs associated with the parent of the control this promotion is attached to. This flag is used for basic site search only.
         */
        enabled?: boolean | null;
        /**
         * Optional. The promotion thumbnail image url.
         */
        imageUri?: string | null;
        /**
         * Required. The title of the promotion. Maximum length: 160 characters.
         */
        title?: string | null;
        /**
         * Optional. The URL for the page the user wants to promote. Must be set for site search. For other verticals, this is optional.
         */
        uri?: string | null;
    }
    /**
     * Request message for SearchService.Search method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequest {
        /**
         * Boost specification to boost certain documents. For more information on boosting, see [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec;
        /**
         * The branch resource name, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`. Use `default_branch` as the branch ID or leave this field empty, to search documents under the default branch.
         */
        branch?: string | null;
        /**
         * The default filter that is applied when a user performs a search without checking any filters on the search page. The filter applied to every search request when quality improvement such as query expansion is needed. In the case a query does not have a sufficient amount of results this filter will be used to determine whether or not to enable the query expansion flow. The original filter will still be used for the query expanded search. This field is strongly recommended to achieve high search quality. For more information about filter syntax, see SearchRequest.filter.
         */
        canonicalFilter?: string | null;
        /**
         * A specification for configuring the behavior of content search.
         */
        contentSearchSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpec;
        /**
         * Specifications that define the specific DataStores to be searched, along with configurations for those data stores. This is only considered for Engines with multiple data stores. For engines with a single data store, the specs directly under SearchRequest should be used.
         */
        dataStoreSpecs?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestDataStoreSpec[];
        /**
         * Optional. Config for display feature, like match highlighting on search results.
         */
        displaySpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestDisplaySpec;
        /**
         * Uses the provided embedding to do additional semantic document retrieval. The retrieval is based on the dot product of SearchRequest.EmbeddingSpec.EmbeddingVector.vector and the document embedding that is provided in SearchRequest.EmbeddingSpec.EmbeddingVector.field_path. If SearchRequest.EmbeddingSpec.EmbeddingVector.field_path is not provided, it will use ServingConfig.EmbeddingConfig.field_path.
         */
        embeddingSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpec;
        /**
         * Facet specifications for faceted search. If empty, no facets are returned. A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        facetSpecs?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpec[];
        /**
         * The filter syntax consists of an expression language for constructing a predicate from one or more fields of the documents being filtered. Filter expression is case-sensitive. If this field is unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI Search is done by mapping the LHS filter key to a key property defined in the Vertex AI Search backend -- this mapping is defined by the customer in their schema. For example a media customer might have a field 'name' in their schema. In this case the filter would look like this: filter --\> name:'ANY("king kong")' For more information about filtering including syntax and filter operators, see [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
        /**
         * Raw image query.
         */
        imageQuery?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestImageQuery;
        /**
         * The BCP-47 language code, such as "en-US" or "sr-Latn". For more information, see [Standard fields](https://cloud.google.com/apis/design/standard_fields). This field helps to better interpret the query. If a value isn't specified, the query language code is automatically detected, which may not be accurate.
         */
        languageCode?: string | null;
        /**
         * Config for natural language query understanding capabilities, such as extracting structured field filters from the query. Refer to [this documentation](https://cloud.google.com/generative-ai-app-builder/docs/natural-language-queries) for more information. If `naturalLanguageQueryUnderstandingSpec` is not specified, no additional natural language query understanding will be done.
         */
        naturalLanguageQueryUnderstandingSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestNaturalLanguageQueryUnderstandingSpec;
        /**
         * A 0-indexed integer that specifies the current offset (that is, starting result location, amongst the Documents deemed by the API as relevant) in search results. This field is only considered if page_token is unset. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        offset?: number | null;
        /**
         * The maximum number of results to return for OneBox. This applies to each OneBox type individually. Default number is 10.
         */
        oneBoxPageSize?: number | null;
        /**
         * The order in which documents are returned. Documents can be ordered by a field in an Document object. Leave it unset if ordered by relevance. `order_by` expression is case-sensitive. For more information on ordering the website search results, see [Order web search results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results). For more information on ordering the healthcare search results, see [Order healthcare search results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results). If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         */
        orderBy?: string | null;
        /**
         * Maximum number of Documents to return. The maximum allowed value depends on the data type. Values above the maximum value are coerced to the maximum value. * Websites with basic indexing: Default `10`, Maximum `25`. * Websites with advanced indexing: Default `25`, Maximum `50`. * Other: Default `50`, Maximum `100`. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        pageSize?: number | null;
        /**
         * A page token received from a previous SearchService.Search call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to SearchService.Search must match the call that provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        pageToken?: string | null;
        /**
         * Additional search parameters. For public website search only, supported values are: * `user_country_code`: string. Default empty. If set to non-empty, results are restricted or boosted based on the location provided. For example, `user_country_code: "au"` For available codes see [Country Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes) * `search_type`: double. Default empty. Enables non-webpage searching depending on the value. The only valid non-default value is 1, which enables image searching. For example, `search_type: 1`
         */
        params?: {
            [key: string]: any;
        } | null;
        /**
         * The specification for personalization. Notice that if both ServingConfig.personalization_spec and SearchRequest.personalization_spec are set, SearchRequest.personalization_spec overrides ServingConfig.personalization_spec.
         */
        personalizationSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestPersonalizationSpec;
        /**
         * Raw search query.
         */
        query?: string | null;
        /**
         * The query expansion specification that specifies the conditions under which query expansion occurs.
         */
        queryExpansionSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestQueryExpansionSpec;
        /**
         * Optional. The ranking expression controls the customized ranking on retrieval documents. This overrides ServingConfig.ranking_expression. The syntax and supported features depend on the `ranking_expression_backend` value. If `ranking_expression_backend` is not provided, it defaults to `RANK_BY_EMBEDDING`. If ranking_expression_backend is not provided or set to `RANK_BY_EMBEDDING`, it should be a single function or multiple functions that are joined by "+". * ranking_expression = function, { " + ", function \}; Supported functions: * double * relevance_score * double * dotProduct(embedding_field_path) Function variables: * `relevance_score`: pre-defined keywords, used for measure relevance between query and document. * `embedding_field_path`: the document embedding field used with query embedding vector. * `dotProduct`: embedding function between `embedding_field_path` and query embedding vector. Example ranking expression: If document has an embedding field doc_embedding, the ranking expression could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`. If ranking_expression_backend is set to `RANK_BY_FORMULA`, the following expression types (and combinations of those chained using + or * operators) are supported: * `double` * `signal` * `log(signal)` * `exp(signal)` * `rr(signal, double \> 0)` -- reciprocal rank transformation with second argument being a denominator constant. * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise. * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns signal2 | double, else returns signal1. Here are a few examples of ranking formulas that use the supported ranking expression types: - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)` -- mostly rank by the logarithm of `keyword_similarity_score` with slight `semantic_smilarity_score` adjustment. - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 * is_nan(keyword_similarity_score)` -- rank by the exponent of `semantic_similarity_score` filling the value with 0 if it's NaN, also add constant 0.3 adjustment to the final score if `semantic_similarity_score` is NaN. - `0.2 * rr(semantic_similarity_score, 16) + 0.8 * rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank of `keyword_similarity_score` with slight adjustment of reciprocal rank of `semantic_smilarity_score`. The following signals are supported: * `semantic_similarity_score`: semantic similarity adjustment that is calculated using the embeddings generated by a proprietary Google model. This score determines how semantically similar a search query is to a document. * `keyword_similarity_score`: keyword match adjustment uses the Best Match 25 (BM25) ranking function. This score is calculated using a probabilistic model to estimate the probability that a document is relevant to a given query. * `relevance_score`: semantic relevance adjustment that uses a proprietary Google model to determine the meaning and intent behind a user's query in context with the content in the documents. * `pctr_rank`: predicted conversion rate adjustment as a rank use predicted Click-through rate (pCTR) to gauge the relevance and attractiveness of a search result from a user's perspective. A higher pCTR suggests that the result is more likely to satisfy the user's query and intent, making it a valuable signal for ranking. * `freshness_rank`: freshness adjustment as a rank * `document_age`: The time in hours elapsed since the document was last updated, a floating-point number (e.g., 0.25 means 15 minutes). * `topicality_rank`: topicality adjustment as a rank. Uses proprietary Google model to determine the keyword-based overlap between the query and the document. * `base_rank`: the default rank of the result
         */
        rankingExpression?: string | null;
        /**
         * Optional. The backend to use for the ranking expression evaluation.
         */
        rankingExpressionBackend?: string | null;
        /**
         * The Unicode country/region code (CLDR) of a location, such as "US" and "419". For more information, see [Standard fields](https://cloud.google.com/apis/design/standard_fields). If set, then results will be boosted based on the region_code provided.
         */
        regionCode?: string | null;
        /**
         * Optional. The specification for returning the relevance score.
         */
        relevanceScoreSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestRelevanceScoreSpec;
        /**
         * The relevance threshold of the search results. Default to Google defined threshold, leveraging a balance of precision and recall to deliver both highly accurate results and comprehensive coverage of relevant information. This feature is not supported for healthcare search.
         */
        relevanceThreshold?: string | null;
        /**
         * Whether to turn on safe search. This is only supported for website search.
         */
        safeSearch?: boolean | null;
        /**
         * Search as you type configuration. Only supported for the IndustryVertical.MEDIA vertical.
         */
        searchAsYouTypeSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestSearchAsYouTypeSpec;
        /**
         * Required. The resource name of the Search serving config, such as `projects/x/locations/global/collections/default_collection/engines/x/servingConfigs/default_serving_config`, or `projects/x/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`. This field is used to identify the serving configuration name, set of models used to make the search.
         */
        servingConfig?: string | null;
        /**
         * The session resource name. Optional. Session allows users to do multi-turn /search API calls or coordination between /search API calls and /answer API calls. Example #1 (multi-turn /search API calls): Call /search API with the session ID generated in the first call. Here, the previous search query gets considered in query standing. I.e., if the first query is "How did Alphabet do in 2022?" and the current query is "How about 2023?", the current query will be interpreted as "How did Alphabet do in 2023?". Example #2 (coordination between /search API calls and /answer API calls): Call /answer API with the session ID generated in the first call. Here, the answer generation happens in the context of the search results from the first search call. Multi-turn Search feature is currently at private GA stage. Please use v1alpha or v1beta version instead before we launch this feature to public GA. Or ask for allowlisting through Google Support team.
         */
        session?: string | null;
        /**
         * Session specification. Can be used only when `session` is set.
         */
        sessionSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestSessionSpec;
        /**
         * The spell correction specification that specifies the mode under which spell correction takes effect.
         */
        spellCorrectionSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestSpellCorrectionSpec;
        /**
         * Information about the end user. Highly recommended for analytics and personalization. UserInfo.user_agent is used to deduce `device_type` for analytics.
         */
        userInfo?: Schema$GoogleCloudDiscoveryengineV1betaUserInfo;
        /**
         * The user labels applied to a resource must meet the following requirements: * Each resource can have multiple labels, up to a maximum of 64. * Each label must be a key-value pair. * Keys have a minimum length of 1 character and a maximum length of 63 characters and cannot be empty. Values can be empty and have a maximum length of 63 characters. * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. All characters must use UTF-8 encoding, and international characters are allowed. * The key portion of a label must be unique. However, you can use the same key with multiple resources. * Keys must start with a lowercase letter or international character. See [Google Cloud Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements) for more details.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
        /**
         * A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. This field should NOT have a fixed value such as `unknown_visitor`. This should be the same identifier as UserEvent.user_pseudo_id and CompleteQueryRequest.user_pseudo_id The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        userPseudoId?: string | null;
    }
    /**
     * Boost specification to boost certain documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec {
        /**
         * Condition boost specifications. If a document matches multiple conditions in the specifications, boost scores from these specifications are all applied and combined in a non-linear way. Maximum number of specifications is 20.
         */
        conditionBoostSpecs?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec[];
    }
    /**
     * Boost applies to documents which match a condition.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpec {
        /**
         * Strength of the condition boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the document a big promotion. However, it does not necessarily mean that the boosted document will be the top result at all times, nor that other documents will be excluded. Results could still be shown even when none of them matches the condition. And results that are significantly more relevant to the search query can still trump your heavily favored but irrelevant documents. Setting to -1.0 gives the document a big demotion. However, results that are deeply relevant might still be shown. The document will have an upstream battle to get a fairly high ranking, but it is not blocked out completely. Setting to 0.0 means no boost applied. The boosting condition is ignored. Only one of the (condition, boost) combination or the boost_control_spec below are set. If both are set then the global boost is ignored and the more fine-grained boost_control_spec is applied.
         */
        boost?: number | null;
        /**
         * Complex specification for custom ranking based on customer defined attribute value.
         */
        boostControlSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec;
        /**
         * An expression which specifies a boost condition. The syntax and supported fields are the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Examples: * To boost documents with document ID "doc_1" or "doc_2", and color "Red" or "Blue": `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
         */
        condition?: string | null;
    }
    /**
     * Specification for custom ranking based on customer specified attribute value. It provides more controls for customized ranking than the simple (condition, boost) combination above.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpec {
        /**
         * The attribute type to be used to determine the boost amount. The attribute value can be derived from the field value of the specified field_name. In the case of numerical it is straightforward i.e. attribute_value = numerical_field_value. In the case of freshness however, attribute_value = (time.now() - datetime_field_value).
         */
        attributeType?: string | null;
        /**
         * The control points used to define the curve. The monotonic function (defined through the interpolation_type above) passes through the control points listed here.
         */
        controlPoints?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint[];
        /**
         * The name of the field whose value will be used to determine the boost amount.
         */
        fieldName?: string | null;
        /**
         * The interpolation type to be applied to connect the control points listed below.
         */
        interpolationType?: string | null;
    }
    /**
     * The control points used to define the curve. The curve defined through these control points can only be monotonically increasing or decreasing(constant values are acceptable).
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint {
        /**
         * Can be one of: 1. The numerical field value. 2. The duration spec for freshness: The value must be formatted as an XSD `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value). The pattern for this is: `nDnM]`.
         */
        attributeValue?: string | null;
        /**
         * The value between -1 to 1 by which to boost the score if the attribute_value evaluates to the value specified above.
         */
        boostAmount?: number | null;
    }
    /**
     * A specification for configuring the behavior of content search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpec {
        /**
         * Specifies the chunk spec to be returned from the search response. Only available if the SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS
         */
        chunkSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecChunkSpec;
        /**
         * If there is no extractive_content_spec provided, there will be no extractive answer in the search response.
         */
        extractiveContentSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecExtractiveContentSpec;
        /**
         * Specifies the search result mode. If unspecified, the search result mode defaults to `DOCUMENTS`.
         */
        searchResultMode?: string | null;
        /**
         * If `snippetSpec` is not specified, snippets are not included in the search response.
         */
        snippetSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSnippetSpec;
        /**
         * If `summarySpec` is not specified, summaries are not included in the search response.
         */
        summarySpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpec;
    }
    /**
     * Specifies the chunk spec to be returned from the search response. Only available if the SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecChunkSpec {
        /**
         * The number of next chunks to be returned of the current chunk. The maximum allowed value is 3. If not specified, no next chunks will be returned.
         */
        numNextChunks?: number | null;
        /**
         * The number of previous chunks to be returned of the current chunk. The maximum allowed value is 3. If not specified, no previous chunks will be returned.
         */
        numPreviousChunks?: number | null;
    }
    /**
     * A specification for configuring the extractive content in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecExtractiveContentSpec {
        /**
         * The maximum number of extractive answers returned in each search result. An extractive answer is a verbatim answer extracted from the original document, which provides a precise and contextually relevant answer to the search query. If the number of matching answers is less than the `max_extractive_answer_count`, return all of the answers. Otherwise, return the `max_extractive_answer_count`. At most five answers are returned for each SearchResult.
         */
        maxExtractiveAnswerCount?: number | null;
        /**
         * The max number of extractive segments returned in each search result. Only applied if the DataStore is set to DataStore.ContentConfig.CONTENT_REQUIRED or DataStore.solution_types is SOLUTION_TYPE_CHAT. An extractive segment is a text segment extracted from the original document that is relevant to the search query, and, in general, more verbose than an extractive answer. The segment could then be used as input for LLMs to generate summaries and answers. If the number of matching segments is less than `max_extractive_segment_count`, return all of the segments. Otherwise, return the `max_extractive_segment_count`.
         */
        maxExtractiveSegmentCount?: number | null;
        /**
         * Return at most `num_next_segments` segments after each selected segments.
         */
        numNextSegments?: number | null;
        /**
         * Specifies whether to also include the adjacent from each selected segments. Return at most `num_previous_segments` segments before each selected segments.
         */
        numPreviousSegments?: number | null;
        /**
         * Specifies whether to return the confidence score from the extractive segments in each search result. This feature is available only for new or allowlisted data stores. To allowlist your data store, contact your Customer Engineer. The default value is `false`.
         */
        returnExtractiveSegmentScore?: boolean | null;
    }
    /**
     * A specification for configuring snippets in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSnippetSpec {
        /**
         * [DEPRECATED] This field is deprecated. To control snippet return, use `return_snippet` field. For backwards compatibility, we will return snippet if max_snippet_count \> 0.
         */
        maxSnippetCount?: number | null;
        /**
         * [DEPRECATED] This field is deprecated and will have no affect on the snippet.
         */
        referenceOnly?: boolean | null;
        /**
         * If `true`, then return snippet. If no snippet can be generated, we return "No snippet is available for this page." A `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
         */
        returnSnippet?: boolean | null;
    }
    /**
     * A specification for configuring a summary returned in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpec {
        /**
         * Specifies whether to filter out adversarial queries. The default value is `false`. Google employs search-query classification to detect adversarial queries. No summary is returned if the search query is classified as an adversarial query. For example, a user might ask a question regarding negative comments about the company or submit a query designed to generate unsafe, policy-violating output. If this field is set to `true`, we skip generating summaries for adversarial queries and return fallback messages instead.
         */
        ignoreAdversarialQuery?: boolean | null;
        /**
         * Optional. Specifies whether to filter out jail-breaking queries. The default value is `false`. Google employs search-query classification to detect jail-breaking queries. No summary is returned if the search query is classified as a jail-breaking query. A user might add instructions to the query to change the tone, style, language, content of the answer, or ask the model to act as a different entity, e.g. "Reply in the tone of a competing company's CEO". If this field is set to `true`, we skip generating summaries for jail-breaking queries and return fallback messages instead.
         */
        ignoreJailBreakingQuery?: boolean | null;
        /**
         * Specifies whether to filter out queries that have low relevance. The default value is `false`. If this field is set to `false`, all search results are used regardless of relevance to generate answers. If set to `true`, only queries with high relevance search results will generate answers.
         */
        ignoreLowRelevantContent?: boolean | null;
        /**
         * Specifies whether to filter out queries that are not summary-seeking. The default value is `false`. Google employs search-query classification to detect summary-seeking queries. No summary is returned if the search query is classified as a non-summary seeking query. For example, `why is the sky blue` and `Who is the best soccer player in the world?` are summary-seeking queries, but `SFO airport` and `world cup 2026` are not. They are most likely navigational queries. If this field is set to `true`, we skip generating summaries for non-summary seeking queries and return fallback messages instead.
         */
        ignoreNonSummarySeekingQuery?: boolean | null;
        /**
         * Specifies whether to include citations in the summary. The default value is `false`. When this field is set to `true`, summaries include in-line citation numbers. Example summary including citations: BigQuery is Google Cloud's fully managed and completely serverless enterprise data warehouse [1]. BigQuery supports all data types, works across clouds, and has built-in machine learning and business intelligence, all within a unified platform [2, 3]. The citation numbers refer to the returned search results and are 1-indexed. For example, [1] means that the sentence is attributed to the first search result. [2, 3] means that the sentence is attributed to both the second and third search results.
         */
        includeCitations?: boolean | null;
        /**
         * Language code for Summary. Use language tags defined by [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an experimental feature.
         */
        languageCode?: string | null;
        /**
         * If specified, the spec will be used to modify the prompt provided to the LLM.
         */
        modelPromptSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelPromptSpec;
        /**
         * If specified, the spec will be used to modify the model specification provided to the LLM.
         */
        modelSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelSpec;
        /**
         * Optional. Multimodal specification.
         */
        multimodalSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecMultiModalSpec;
        /**
         * The number of top results to generate the summary from. If the number of results returned is less than `summaryResultCount`, the summary is generated from all of the results. At most 10 results for documents mode, or 50 for chunks mode, can be used to generate a summary. The chunks mode is used when SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
         */
        summaryResultCount?: number | null;
        /**
         * If true, answer will be generated from most relevant chunks from top search results. This feature will improve summary quality. Note that with this feature enabled, not all top search results will be referenced and included in the reference list, so the citation source index only points to the search results listed in the reference list.
         */
        useSemanticChunks?: boolean | null;
    }
    /**
     * Specification of the prompt to use with the model.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelPromptSpec {
        /**
         * Text at the beginning of the prompt that instructs the assistant. Examples are available in the user guide.
         */
        preamble?: string | null;
    }
    /**
     * Specification of the model.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecModelSpec {
        /**
         * The model version used to generate the summary. Supported values are: * `stable`: string. Default value when no value is specified. Uses a generally available, fine-tuned model. For more information, see [Answer generation model versions and lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models). * `preview`: string. (Public preview) Uses a preview model. For more information, see [Answer generation model versions and lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         */
        version?: string | null;
    }
    /**
     * Multimodal specification: Will return an image from specified source. If multiple sources are specified, the pick is a quality based decision.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestContentSearchSpecSummarySpecMultiModalSpec {
        /**
         * Optional. Source of image returned in the answer.
         */
        imageSource?: string | null;
    }
    /**
     * A struct to define data stores to filter on in a search call and configurations for those data stores. Otherwise, an `INVALID_ARGUMENT` error is returned.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestDataStoreSpec {
        /**
         * Optional. Boost specification to boost certain documents. For more information on boosting, see [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestBoostSpec;
        /**
         * Optional. Custom search operators which if specified will be used to filter results from workspace data stores. For more information on custom search operators, see [SearchOperators](https://support.google.com/cloudsearch/answer/6172299).
         */
        customSearchOperators?: string | null;
        /**
         * Required. Full resource name of DataStore, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. The path must include the project number, project id is not supported for this field.
         */
        dataStore?: string | null;
        /**
         * Optional. Filter specification to filter documents in the data store specified by data_store field. For more information on filtering, see [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
    }
    /**
     * Specifies features for display, like match highlighting.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestDisplaySpec {
        /**
         * The condition under which match highlighting should occur.
         */
        matchHighlightingCondition?: string | null;
    }
    /**
     * The specification that uses customized query embedding vector to do semantic document retrieval.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpec {
        /**
         * The embedding vector used for retrieval. Limit to 1.
         */
        embeddingVectors?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector[];
    }
    /**
     * Embedding vector.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestEmbeddingSpecEmbeddingVector {
        /**
         * Embedding field path in schema.
         */
        fieldPath?: string | null;
        /**
         * Query embedding vector.
         */
        vector?: number[] | null;
    }
    /**
     * A facet specification to perform faceted search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpec {
        /**
         * Enables dynamic position for this facet. If set to true, the position of this facet among all facets in the response is determined automatically. If dynamic facets are enabled, it is ordered together. If set to false, the position of this facet in the response is the same as in the request, and it is ranked before the facets with dynamic position enable and all dynamic facets. For example, you may always want to have rating facet returned in the response, but it's not necessarily to always display the rating facet at the top. In that case, you can set enable_dynamic_position to true so that the position of rating facet in response is determined automatically. Another example, assuming you have the following facets in the request: * "rating", enable_dynamic_position = true * "price", enable_dynamic_position = false * "brands", enable_dynamic_position = false And also you have a dynamic facets enabled, which generates a facet `gender`. Then the final order of the facets in the response can be ("price", "brands", "rating", "gender") or ("price", "brands", "gender", "rating") depends on how API orders "gender" and "rating" facets. However, notice that "price" and "brands" are always ranked at first and second position because their enable_dynamic_position is false.
         */
        enableDynamicPosition?: boolean | null;
        /**
         * List of keys to exclude when faceting. By default, FacetKey.key is not excluded from the filter unless it is listed in this field. Listing a facet key in this field allows its values to appear as facet results, even when they are filtered out of search results. Using this field does not affect what search results are returned. For example, suppose there are 100 documents with the color facet "Red" and 200 documents with the color facet "Blue". A query containing the filter "color:ANY("Red")" and having "color" as FacetKey.key would by default return only "Red" documents in the search results, and also return "Red" with count 100 as the only color facet. Although there are also blue documents available, "Blue" would not be shown as an available facet value. If "color" is listed in "excludedFilterKeys", then the query returns the facet values "Red" with count 100 and "Blue" with count 200, because the "color" key is now excluded from the filter. Because this field doesn't affect search results, the search results are still correctly filtered to return only "Red" documents. A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        excludedFilterKeys?: string[] | null;
        /**
         * Required. The facet key specification.
         */
        facetKey?: Schema$GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpecFacetKey;
        /**
         * Maximum facet values that are returned for this facet. If unspecified, defaults to 20. The maximum allowed value is 300. Values above 300 are coerced to 300. For aggregation in healthcare search, when the [FacetKey.key] is "healthcare_aggregation_key", the limit will be overridden to 10,000 internally, regardless of the value set here. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        limit?: number | null;
    }
    /**
     * Specifies how a facet is computed.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestFacetSpecFacetKey {
        /**
         * True to make facet keys case insensitive when getting faceting values with prefixes or contains; false otherwise.
         */
        caseInsensitive?: boolean | null;
        /**
         * Only get facet values that contain the given strings. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "contains" to "2022", the "category" facet only contains "Action \> 2022" and "Sci-Fi \> 2022". Only supported on textual fields. Maximum is 10.
         */
        contains?: string[] | null;
        /**
         * Set only if values should be bucketed into intervals. Must be set for facets with numerical values. Must not be set for facet with text values. Maximum number of intervals is 30.
         */
        intervals?: Schema$GoogleCloudDiscoveryengineV1betaInterval[];
        /**
         * Required. Supported textual and numerical facet keys in Document object, over which the facet values are computed. Facet key is case-sensitive.
         */
        key?: string | null;
        /**
         * The order in which documents are returned. Allowed values are: * "count desc", which means order by SearchResponse.Facet.values.count descending. * "value desc", which means order by SearchResponse.Facet.values.value descending. Only applies to textual facets. If not set, textual values are sorted in [natural order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are sorted in the order given by FacetSpec.FacetKey.intervals.
         */
        orderBy?: string | null;
        /**
         * Only get facet values that start with the given string prefix. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "prefixes" to "Action", the "category" facet only contains "Action \> 2022" and "Action \> 2021". Only supported on textual fields. Maximum is 10.
         */
        prefixes?: string[] | null;
        /**
         * Only get facet for the given restricted values. Only supported on textual fields. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "restricted_values" to "Action \> 2022", the "category" facet only contains "Action \> 2022". Only supported on textual fields. Maximum is 10.
         */
        restrictedValues?: string[] | null;
    }
    /**
     * Specifies the image query input.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestImageQuery {
        /**
         * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and BMP.
         */
        imageBytes?: string | null;
    }
    /**
     * Specification to enable natural language understanding capabilities for search requests.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestNaturalLanguageQueryUnderstandingSpec {
        /**
         * Optional. Controls behavior of how extracted filters are applied to the search. The default behavior depends on the request. For single datastore structured search, the default is `HARD_FILTER`. For multi-datastore search, the default behavior is `SOFT_BOOST`. Location-based filters are always applied as hard filters, and the `SOFT_BOOST` setting will not affect them. This field is only used if SearchRequest.natural_language_query_understanding_spec.filter_extraction_condition is set to FilterExtractionCondition.ENABLED.
         */
        extractedFilterBehavior?: string | null;
        /**
         * The condition under which filter extraction should occur. Server behavior defaults to `DISABLED`.
         */
        filterExtractionCondition?: string | null;
        /**
         * Field names used for location-based filtering, where geolocation filters are detected in natural language search queries. Only valid when the FilterExtractionCondition is set to `ENABLED`. If this field is set, it overrides the field names set in ServingConfig.geo_search_query_detection_field_names.
         */
        geoSearchQueryDetectionFieldNames?: string[] | null;
    }
    /**
     * The specification for personalization.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestPersonalizationSpec {
        /**
         * The personalization mode of the search request. Defaults to Mode.AUTO.
         */
        mode?: string | null;
    }
    /**
     * Specification to determine under which conditions query expansion should occur.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestQueryExpansionSpec {
        /**
         * The condition under which query expansion should occur. Default to Condition.DISABLED.
         */
        condition?: string | null;
        /**
         * Whether to pin unexpanded results. If this field is set to true, unexpanded products are always at the top of the search results, followed by the expanded results.
         */
        pinUnexpandedResults?: boolean | null;
    }
    /**
     * The specification for returning the document relevance score.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestRelevanceScoreSpec {
        /**
         * Optional. Whether to return the relevance score for search results. The higher the score, the more relevant the document is to the query.
         */
        returnRelevanceScore?: boolean | null;
    }
    /**
     * Specification for search as you type in search requests.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestSearchAsYouTypeSpec {
        /**
         * The condition under which search as you type should occur. Default to Condition.DISABLED.
         */
        condition?: string | null;
    }
    /**
     * Session specification. Multi-turn Search feature is currently at private GA stage. Please use v1alpha or v1beta version instead before we launch this feature to public GA. Or ask for allowlisting through Google Support team.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestSessionSpec {
        /**
         * If set, the search result gets stored to the "turn" specified by this query ID. Example: Let's say the session looks like this: session { name: ".../sessions/xxx" turns { query { text: "What is foo?" query_id: ".../questions/yyy" \} answer: "Foo is ..." \} turns { query { text: "How about bar then?" query_id: ".../questions/zzz" \} \} \} The user can call /search API with a request like this: session: ".../sessions/xxx" session_spec { query_id: ".../questions/zzz" \} Then, the API stores the search result, associated with the last turn. The stored search result can be used by a subsequent /answer API call (with the session ID and the query ID specified). Also, it is possible to call /search and /answer in parallel with the same session ID & query ID.
         */
        queryId?: string | null;
        /**
         * The number of top search results to persist. The persisted search results can be used for the subsequent /answer api call. This field is similar to the `summary_result_count` field in SearchRequest.ContentSearchSpec.SummarySpec.summary_result_count. At most 10 results for documents mode, or 50 for chunks mode.
         */
        searchResultPersistenceCount?: number | null;
    }
    /**
     * The specification for query spell correction.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSearchRequestSpellCorrectionSpec {
        /**
         * The mode under which spell correction replaces the original search query. Defaults to Mode.AUTO.
         */
        mode?: string | null;
    }
    /**
     * Metadata related to the progress of the CrawlRateManagementService.SetDedicatedCrawlRate operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSetDedicatedCrawlRateMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response message for CrawlRateManagementService.SetDedicatedCrawlRate method. It simply returns the state of the response, and an error message if the state is FAILED.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSetDedicatedCrawlRateResponse {
        /**
         * Errors from service when handling the request.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Output only. The state of the response.
         */
        state?: string | null;
    }
    /**
     * Metadata for single-regional CMEKs.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSingleRegionKey {
        /**
         * Required. Single-regional kms key resource name which will be used to encrypt resources `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{keyId\}`.
         */
        kmsKey?: string | null;
    }
    /**
     * A sitemap for the SiteSearchEngine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSitemap {
        /**
         * Output only. The sitemap's creation time.
         */
        createTime?: string | null;
        /**
         * Output only. The fully qualified resource name of the sitemap. `projects/x/locations/x/collections/x/dataStores/x/siteSearchEngine/sitemaps/x` The `sitemap_id` suffix is system-generated.
         */
        name?: string | null;
        /**
         * Public URI for the sitemap, e.g. `www.example.com/sitemap.xml`.
         */
        uri?: string | null;
    }
    /**
     * Verification information for target sites in advanced site search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaSiteVerificationInfo {
        /**
         * Site verification state indicating the ownership and validity.
         */
        siteVerificationState?: string | null;
        /**
         * Latest site verification time.
         */
        verifyTime?: string | null;
    }
    /**
     * A target site for the SiteSearchEngine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaTargetSite {
        /**
         * Immutable. If set to false, a uri_pattern is generated to include all pages whose address contains the provided_uri_pattern. If set to true, an uri_pattern is generated to try to be an exact match of the provided_uri_pattern or just the specific page if the provided_uri_pattern is a specific one. provided_uri_pattern is always normalized to generate the URI pattern to be used by the search engine.
         */
        exactMatch?: boolean | null;
        /**
         * Output only. Failure reason.
         */
        failureReason?: Schema$GoogleCloudDiscoveryengineV1betaTargetSiteFailureReason;
        /**
         * Output only. This is system-generated based on the provided_uri_pattern.
         */
        generatedUriPattern?: string | null;
        /**
         * Output only. Indexing status.
         */
        indexingStatus?: string | null;
        /**
         * Output only. The fully qualified resource name of the target site. `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/siteSearchEngine/targetSites/{target_site\}` The `target_site_id` is system-generated.
         */
        name?: string | null;
        /**
         * Required. Input only. The user provided URI pattern from which the `generated_uri_pattern` is generated.
         */
        providedUriPattern?: string | null;
        /**
         * Output only. Root domain of the provided_uri_pattern.
         */
        rootDomainUri?: string | null;
        /**
         * Output only. Site ownership and validity verification status.
         */
        siteVerificationInfo?: Schema$GoogleCloudDiscoveryengineV1betaSiteVerificationInfo;
        /**
         * The type of the target site, e.g., whether the site is to be included or excluded.
         */
        type?: string | null;
        /**
         * Output only. The target site's last updated time.
         */
        updateTime?: string | null;
    }
    /**
     * Site search indexing failure reasons.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaTargetSiteFailureReason {
        /**
         * Failed due to insufficient quota.
         */
        quotaFailure?: Schema$GoogleCloudDiscoveryengineV1betaTargetSiteFailureReasonQuotaFailure;
    }
    /**
     * Failed due to insufficient quota.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaTargetSiteFailureReasonQuotaFailure {
        /**
         * This number is an estimation on how much total quota this project needs to successfully complete indexing.
         */
        totalRequiredQuota?: string | null;
    }
    /**
     * Metadata related to the progress of the TrainCustomModel operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaTrainCustomModelMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Response of the TrainCustomModelRequest. This message is returned by the google.longrunning.Operations.response field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaTrainCustomModelResponse {
        /**
         * Echoes the destination for the complete errors in the request if set.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1betaImportErrorConfig;
        /**
         * A sample of errors encountered while processing the data.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * The metrics of the trained model.
         */
        metrics?: {
            [key: string]: number;
        } | null;
        /**
         * Fully qualified name of the CustomTuningModel.
         */
        modelName?: string | null;
        /**
         * The trained model status. Possible values are: * **bad-data**: The training data quality is bad. * **no-improvement**: Tuning didn't improve performance. Won't deploy. * **in-progress**: Model training job creation is in progress. * **training**: Model is actively training. * **evaluating**: The model is evaluating trained metrics. * **indexing**: The model trained metrics are indexing. * **ready**: The model is ready for serving.
         */
        modelStatus?: string | null;
    }
    /**
     * Metadata associated with a tune operation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaTuneEngineMetadata {
        /**
         * Required. The resource name of the engine that this tune applies to. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}`
         */
        engine?: string | null;
    }
    /**
     * Response associated with a tune operation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaTuneEngineResponse {
    }
    /**
     * Metadata for UpdateSchema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaUpdateSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.UpdateTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaUpdateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Information of an end user.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaUserInfo {
        /**
         * Optional. IANA time zone, e.g. Europe/Budapest.
         */
        timeZone?: string | null;
        /**
         * User agent as included in the HTTP header. The field must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. This should not be set when using the client side event reporting with GTM or JavaScript tag in UserEventService.CollectUserEvent or if UserEvent.direct_user_request is set.
         */
        userAgent?: string | null;
        /**
         * Highly recommended for logged-in users. Unique identifier for logged-in user, such as a user name. Don't set for anonymous users. Always use a hashed value for this ID. Don't set the field to the same fixed ID for different users. This mixes the event history of those users together, which results in degraded model quality. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        userId?: string | null;
    }
    /**
     * User License information assigned by the admin.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaUserLicense {
        /**
         * Output only. User created timestamp.
         */
        createTime?: string | null;
        /**
         * Output only. User last logged in time. If the user has not logged in yet, this field will be empty.
         */
        lastLoginTime?: string | null;
        /**
         * Output only. License assignment state of the user. If the user is assigned with a license config, the user login will be assigned with the license; If the user's license assignment state is unassigned or unspecified, no license config will be associated to the user;
         */
        licenseAssignmentState?: string | null;
        /**
         * Optional. The full resource name of the Subscription(LicenseConfig) assigned to the user.
         */
        licenseConfig?: string | null;
        /**
         * Output only. User update timestamp.
         */
        updateTime?: string | null;
        /**
         * Required. Immutable. The user principal of the User, could be email address or other prinical identifier. This field is immutable. Admin assign licenses based on the user principal.
         */
        userPrincipal?: string | null;
        /**
         * Optional. The user profile. We user user full name(First name + Last name) as user profile.
         */
        userProfile?: string | null;
    }
    /**
     * Config to store data store type configuration for workspace data
     */
    export interface Schema$GoogleCloudDiscoveryengineV1betaWorkspaceConfig {
        /**
         * Obfuscated Dasher customer ID.
         */
        dasherCustomerId?: string | null;
        /**
         * Optional. The super admin email address for the workspace that will be used for access token generation. For now we only use it for Native Google Drive connector data ingestion.
         */
        superAdminEmailAddress?: string | null;
        /**
         * Optional. The super admin service account for the workspace that will be used for access token generation. For now we only use it for Native Google Drive connector data ingestion.
         */
        superAdminServiceAccount?: string | null;
        /**
         * The Google Workspace data source.
         */
        type?: string | null;
    }
    /**
     * BigQuery source import data from.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BigQuerySource {
        /**
         * The schema to use when parsing the data from the source. Supported values for user event imports: * `user_event` (default): One UserEvent per row. Supported values for document imports: * `document` (default): One Document format per row. Each document must have a valid Document.id and one of Document.json_data or Document.struct_data. * `custom`: One custom data per row in arbitrary format that conforms to the defined Schema of the data store. This can only be used by the GENERIC Data Store vertical.
         */
        dataSchema?: string | null;
        /**
         * Required. The BigQuery data set to copy the data from with a length limit of 1,024 characters.
         */
        datasetId?: string | null;
        /**
         * Intermediate Cloud Storage directory used for the import with a length limit of 2,000 characters. Can be specified if one wants to have the BigQuery export to a specific Cloud Storage directory.
         */
        gcsStagingDir?: string | null;
        /**
         * BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
         */
        partitionDate?: Schema$GoogleTypeDate;
        /**
         * The project ID or the project number that contains the BigQuery source. Has a length limit of 128 characters. If not specified, inherits the project ID from the parent request.
         */
        projectId?: string | null;
        /**
         * Required. The BigQuery table to copy the data from with a length limit of 1,024 characters.
         */
        tableId?: string | null;
    }
    /**
     * The Bigtable Options object that contains information to support the import.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BigtableOptions {
        /**
         * The mapping from family names to an object that contains column families level information for the given column family. If a family is not present in this map it will be ignored.
         */
        families?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily;
        } | null;
        /**
         * The field name used for saving row key value in the document. The name has to match the pattern `a-zA-Z0-9*`.
         */
        keyFieldName?: string | null;
    }
    /**
     * The column of the Bigtable.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn {
        /**
         * The encoding mode of the values when the type is not `STRING`. Acceptable encoding values are: * `TEXT`: indicates values are alphanumeric text strings. * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes` family of functions. This can be overridden for a specific column by listing that column in `columns` and specifying an encoding for it.
         */
        encoding?: string | null;
        /**
         * The field name to use for this column in the document. The name has to match the pattern `a-zA-Z0-9*`. If not set, it is parsed from the qualifier bytes with best effort. However, due to different naming patterns, field name collisions could happen, where parsing behavior is undefined.
         */
        fieldName?: string | null;
        /**
         * Required. Qualifier of the column. If it cannot be decoded with utf-8, use a base-64 encoded string instead.
         */
        qualifier?: string | null;
        /**
         * The type of values in this column family. The values are expected to be encoded using `HBase Bytes.toBytes` function when the encoding value is set to `BINARY`.
         */
        type?: string | null;
    }
    /**
     * The column family of the Bigtable.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumnFamily {
        /**
         * The list of objects that contains column level information for each column. If a column is not present in this list it will be ignored.
         */
        columns?: Schema$GoogleCloudDiscoveryengineV1BigtableOptionsBigtableColumn[];
        /**
         * The encoding mode of the values when the type is not STRING. Acceptable encoding values are: * `TEXT`: indicates values are alphanumeric text strings. * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes` family of functions. This can be overridden for a specific column by listing that column in `columns` and specifying an encoding for it.
         */
        encoding?: string | null;
        /**
         * The field name to use for this column family in the document. The name has to match the pattern `a-zA-Z0-9*`. If not set, it is parsed from the family name with best effort. However, due to different naming patterns, field name collisions could happen, where parsing behavior is undefined.
         */
        fieldName?: string | null;
        /**
         * The type of values in this column family. The values are expected to be encoded using `HBase Bytes.toBytes` function when the encoding value is set to `BINARY`.
         */
        type?: string | null;
    }
    /**
     * The Cloud Bigtable source for importing data.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1BigtableSource {
        /**
         * Required. Bigtable options that contains information needed when parsing data into typed structures. For example, column type annotations.
         */
        bigtableOptions?: Schema$GoogleCloudDiscoveryengineV1BigtableOptions;
        /**
         * Required. The instance ID of the Cloud Bigtable that needs to be imported.
         */
        instanceId?: string | null;
        /**
         * The project ID that contains the Bigtable source. Has a length limit of 128 characters. If not specified, inherits the project ID from the parent request.
         */
        projectId?: string | null;
        /**
         * Required. The table ID of the Cloud Bigtable that needs to be imported.
         */
        tableId?: string | null;
    }
    /**
     * Request message for GroundedGenerationService.CheckGrounding method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CheckGroundingRequest {
        /**
         * Answer candidate to check. It can have a maximum length of 4096 tokens.
         */
        answerCandidate?: string | null;
        /**
         * List of facts for the grounding check. We support up to 200 facts.
         */
        facts?: Schema$GoogleCloudDiscoveryengineV1GroundingFact[];
        /**
         * Configuration of the grounding check.
         */
        groundingSpec?: Schema$GoogleCloudDiscoveryengineV1CheckGroundingSpec;
        /**
         * The user labels applied to a resource must meet the following requirements: * Each resource can have multiple labels, up to a maximum of 64. * Each label must be a key-value pair. * Keys have a minimum length of 1 character and a maximum length of 63 characters and cannot be empty. Values can be empty and have a maximum length of 63 characters. * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. All characters must use UTF-8 encoding, and international characters are allowed. * The key portion of a label must be unique. However, you can use the same key with multiple resources. * Keys must start with a lowercase letter or international character. See [Google Cloud Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements) for more details.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Response message for the GroundedGenerationService.CheckGrounding method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CheckGroundingResponse {
        /**
         * List of facts cited across all claims in the answer candidate. These are derived from the facts supplied in the request.
         */
        citedChunks?: Schema$GoogleCloudDiscoveryengineV1FactChunk[];
        /**
         * List of facts cited across all claims in the answer candidate. These are derived from the facts supplied in the request.
         */
        citedFacts?: Schema$GoogleCloudDiscoveryengineV1CheckGroundingResponseCheckGroundingFactChunk[];
        /**
         * Claim texts and citation info across all claims in the answer candidate.
         */
        claims?: Schema$GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim[];
        /**
         * The support score for the input answer candidate. Higher the score, higher is the fraction of claims that are supported by the provided facts. This is always set when a response is returned.
         */
        supportScore?: number | null;
    }
    /**
     * Fact chunk for grounding check.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CheckGroundingResponseCheckGroundingFactChunk {
        /**
         * Text content of the fact chunk. Can be at most 10K characters long.
         */
        chunkText?: string | null;
    }
    /**
     * Text and citation info for a claim in the answer candidate.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CheckGroundingResponseClaim {
        /**
         * A list of indices (into 'cited_chunks') specifying the citations associated with the claim. For instance [1,3,4] means that cited_chunks[1], cited_chunks[3], cited_chunks[4] are the facts cited supporting for the claim. A citation to a fact indicates that the claim is supported by the fact.
         */
        citationIndices?: number[] | null;
        /**
         * Text for the claim in the answer candidate. Always provided regardless of whether citations or anti-citations are found.
         */
        claimText?: string | null;
        /**
         * Position indicating the end of the claim in the answer candidate, exclusive, in bytes. Note that this is not measured in characters and, therefore, must be rendered as such. For example, if the claim text contains non-ASCII characters, the start and end positions vary when measured in characters (programming-language-dependent) and when measured in bytes (programming-language-independent).
         */
        endPos?: number | null;
        /**
         * Indicates that this claim required grounding check. When the system decided this claim doesn't require attribution/grounding check, this field will be set to false. In that case, no grounding check was done for the claim and therefore citation_indices should not be returned.
         */
        groundingCheckRequired?: boolean | null;
        /**
         * Confidence score for the claim in the answer candidate, in the range of [0, 1]. This is set only when `CheckGroundingRequest.grounding_spec.enable_claim_level_score` is true.
         */
        score?: number | null;
        /**
         * Position indicating the start of the claim in the answer candidate, measured in bytes. Note that this is not measured in characters and, therefore, must be rendered in the user interface keeping in mind that some characters may take more than one byte. For example, if the claim text contains non-ASCII characters, the start and end positions vary when measured in characters (programming-language-dependent) and when measured in bytes (programming-language-independent).
         */
        startPos?: number | null;
    }
    /**
     * Specification for the grounding check.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CheckGroundingSpec {
        /**
         * The threshold (in [0,1]) used for determining whether a fact must be cited for a claim in the answer candidate. Choosing a higher threshold will lead to fewer but very strong citations, while choosing a lower threshold may lead to more but somewhat weaker citations. If unset, the threshold will default to 0.6.
         */
        citationThreshold?: number | null;
        /**
         * The control flag that enables claim-level grounding score in the response.
         */
        enableClaimLevelScore?: boolean | null;
    }
    /**
     * Chunk captures all raw metadata information of items to be recommended or searched in the chunk mode.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Chunk {
        /**
         * Output only. Annotation contents if the current chunk contains annotations.
         */
        annotationContents?: string[] | null;
        /**
         * Output only. The annotation metadata includes structured content in the current chunk.
         */
        annotationMetadata?: Schema$GoogleCloudDiscoveryengineV1ChunkAnnotationMetadata[];
        /**
         * Output only. Metadata of the current chunk.
         */
        chunkMetadata?: Schema$GoogleCloudDiscoveryengineV1ChunkChunkMetadata;
        /**
         * Content is a string from a document (parsed content).
         */
        content?: string | null;
        /**
         * Output only. Image Data URLs if the current chunk contains images. Data URLs are composed of four parts: a prefix (data:), a MIME type indicating the type of data, an optional base64 token if non-textual, and the data itself: data:,
         */
        dataUrls?: string[] | null;
        /**
         * Output only. This field is OUTPUT_ONLY. It contains derived data that are not in the original input document.
         */
        derivedStructData?: {
            [key: string]: any;
        } | null;
        /**
         * Metadata of the document from the current chunk.
         */
        documentMetadata?: Schema$GoogleCloudDiscoveryengineV1ChunkDocumentMetadata;
        /**
         * Unique chunk ID of the current chunk.
         */
        id?: string | null;
        /**
         * The full resource name of the chunk. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}/documents/{document_id\}/chunks/{chunk_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * Page span of the chunk.
         */
        pageSpan?: Schema$GoogleCloudDiscoveryengineV1ChunkPageSpan;
        /**
         * Output only. Represents the relevance score based on similarity. Higher score indicates higher chunk relevance. The score is in range [-1.0, 1.0]. Only populated on SearchResponse.
         */
        relevanceScore?: number | null;
    }
    /**
     * The annotation metadata includes structured content in the current chunk.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ChunkAnnotationMetadata {
        /**
         * Output only. Image id is provided if the structured content is based on an image.
         */
        imageId?: string | null;
        /**
         * Output only. The structured content information.
         */
        structuredContent?: Schema$GoogleCloudDiscoveryengineV1ChunkStructuredContent;
    }
    /**
     * Metadata of the current chunk. This field is only populated on SearchService.Search API.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ChunkChunkMetadata {
        /**
         * The next chunks of the current chunk. The number is controlled by SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks. This field is only populated on SearchService.Search API.
         */
        nextChunks?: Schema$GoogleCloudDiscoveryengineV1Chunk[];
        /**
         * The previous chunks of the current chunk. The number is controlled by SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks. This field is only populated on SearchService.Search API.
         */
        previousChunks?: Schema$GoogleCloudDiscoveryengineV1Chunk[];
    }
    /**
     * Document metadata contains the information of the document of the current chunk.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ChunkDocumentMetadata {
        /**
         * The mime type of the document. https://www.iana.org/assignments/media-types/media-types.xhtml.
         */
        mimeType?: string | null;
        /**
         * Data representation. The structured JSON data for the document. It should conform to the registered Schema or an `INVALID_ARGUMENT` error is thrown.
         */
        structData?: {
            [key: string]: any;
        } | null;
        /**
         * Title of the document.
         */
        title?: string | null;
        /**
         * Uri of the document.
         */
        uri?: string | null;
    }
    /**
     * Page span of the chunk.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ChunkPageSpan {
        /**
         * The end page of the chunk.
         */
        pageEnd?: number | null;
        /**
         * The start page of the chunk.
         */
        pageStart?: number | null;
    }
    /**
     * The structured content information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ChunkStructuredContent {
        /**
         * Output only. The content of the structured content.
         */
        content?: string | null;
        /**
         * Output only. The structure type of the structured content.
         */
        structureType?: string | null;
    }
    /**
     * Cloud SQL source import data from.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CloudSqlSource {
        /**
         * Required. The Cloud SQL database to copy the data from with a length limit of 256 characters.
         */
        databaseId?: string | null;
        /**
         * Intermediate Cloud Storage directory used for the import with a length limit of 2,000 characters. Can be specified if one wants to have the Cloud SQL export to a specific Cloud Storage directory. Ensure that the Cloud SQL service account has the necessary Cloud Storage Admin permissions to access the specified Cloud Storage directory.
         */
        gcsStagingDir?: string | null;
        /**
         * Required. The Cloud SQL instance to copy the data from with a length limit of 256 characters.
         */
        instanceId?: string | null;
        /**
         * Option for serverless export. Enabling this option will incur additional cost. More info can be found [here](https://cloud.google.com/sql/pricing#serverless).
         */
        offload?: boolean | null;
        /**
         * The project ID that contains the Cloud SQL source. Has a length limit of 128 characters. If not specified, inherits the project ID from the parent request.
         */
        projectId?: string | null;
        /**
         * Required. The Cloud SQL table to copy the data from with a length limit of 256 characters.
         */
        tableId?: string | null;
    }
    /**
     * Configurations used to enable CMEK data encryption with Cloud KMS keys.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CmekConfig {
        /**
         * Output only. The default CmekConfig for the Customer.
         */
        isDefault?: boolean | null;
        /**
         * Required. KMS key resource name which will be used to encrypt resources `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{keyId\}`.
         */
        kmsKey?: string | null;
        /**
         * Output only. KMS key version resource name which will be used to encrypt resources `/cryptoKeyVersions/{keyVersion\}`.
         */
        kmsKeyVersion?: string | null;
        /**
         * Output only. The timestamp of the last key rotation.
         */
        lastRotationTimestampMicros?: string | null;
        /**
         * Required. The name of the CmekConfig of the form `projects/{project\}/locations/{location\}/cmekConfig` or `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         */
        name?: string | null;
        /**
         * Output only. Whether the NotebookLM Corpus is ready to be used.
         */
        notebooklmState?: string | null;
        /**
         * Optional. Single-regional CMEKs that are required for some VAIS features.
         */
        singleRegionKeys?: Schema$GoogleCloudDiscoveryengineV1SingleRegionKey[];
        /**
         * Output only. The states of the CmekConfig.
         */
        state?: string | null;
    }
    /**
     * Response message for CompletionService.CompleteQuery method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CompleteQueryResponse {
        /**
         * Results of the matched query suggestions. The result list is ordered and the first result is a top suggestion.
         */
        querySuggestions?: Schema$GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion[];
        /**
         * True if the returned suggestions are all tail suggestions. For tail matching to be triggered, include_tail_suggestions in the request must be true and there must be no suggestions that match the full query.
         */
        tailMatchTriggered?: boolean | null;
    }
    /**
     * Suggestions as search queries.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CompleteQueryResponseQuerySuggestion {
        /**
         * The unique document field paths that serve as the source of this suggestion if it was generated from completable fields. This field is only populated for the document-completable model.
         */
        completableFieldPaths?: string[] | null;
        /**
         * The suggestion for the query.
         */
        suggestion?: string | null;
    }
    /**
     * Detailed completion information including completion attribution token and clicked completion info.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CompletionInfo {
        /**
         * End user selected CompleteQueryResponse.QuerySuggestion.suggestion position, starting from 0.
         */
        selectedPosition?: number | null;
        /**
         * End user selected CompleteQueryResponse.QuerySuggestion.suggestion.
         */
        selectedSuggestion?: string | null;
    }
    /**
     * Autocomplete suggestions that are imported from Customer.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CompletionSuggestion {
        /**
         * Alternative matching phrases for this suggestion.
         */
        alternativePhrases?: string[] | null;
        /**
         * Frequency of this suggestion. Will be used to rank suggestions when score is not available.
         */
        frequency?: string | null;
        /**
         * Global score of this suggestion. Control how this suggestion would be scored / ranked.
         */
        globalScore?: number | null;
        /**
         * If two suggestions have the same groupId, they will not be returned together. Instead the one ranked higher will be returned. This can be used to deduplicate semantically identical suggestions.
         */
        groupId?: string | null;
        /**
         * The score of this suggestion within its group.
         */
        groupScore?: number | null;
        /**
         * BCP-47 language code of this suggestion.
         */
        languageCode?: string | null;
        /**
         * Required. The suggestion text.
         */
        suggestion?: string | null;
    }
    /**
     * Defines circumstances to be checked before allowing a behavior
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Condition {
        /**
         * Range of time(s) specifying when condition is active. Maximum of 10 time ranges.
         */
        activeTimeRange?: Schema$GoogleCloudDiscoveryengineV1ConditionTimeRange[];
        /**
         * Optional. Query regex to match the whole search query. Cannot be set when Condition.query_terms is set. Only supported for Basic Site Search promotion serving controls.
         */
        queryRegex?: string | null;
        /**
         * Search only A list of terms to match the query on. Cannot be set when Condition.query_regex is set. Maximum of 10 query terms.
         */
        queryTerms?: Schema$GoogleCloudDiscoveryengineV1ConditionQueryTerm[];
    }
    /**
     * Matcher for search request query
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ConditionQueryTerm {
        /**
         * Whether the search query needs to exactly match the query term.
         */
        fullMatch?: boolean | null;
        /**
         * The specific query value to match against Must be lowercase, must be UTF-8. Can have at most 3 space separated terms if full_match is true. Cannot be an empty string. Maximum length of 5000 characters.
         */
        value?: string | null;
    }
    /**
     * Used for time-dependent conditions.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ConditionTimeRange {
        /**
         * End of time range. Range is inclusive. Must be in the future.
         */
        endTime?: string | null;
        /**
         * Start of time range. Range is inclusive.
         */
        startTime?: string | null;
    }
    /**
     * Defines a conditioned behavior to employ during serving. Must be attached to a ServingConfig to be considered at serving time. Permitted actions dependent on `SolutionType`.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Control {
        /**
         * Output only. List of all ServingConfig IDs this control is attached to. May take up to 10 minutes to update after changes.
         */
        associatedServingConfigIds?: string[] | null;
        /**
         * Defines a boost-type control
         */
        boostAction?: Schema$GoogleCloudDiscoveryengineV1ControlBoostAction;
        /**
         * Determines when the associated action will trigger. Omit to always apply the action. Currently only a single condition may be specified. Otherwise an INVALID ARGUMENT error is thrown.
         */
        conditions?: Schema$GoogleCloudDiscoveryengineV1Condition[];
        /**
         * Required. Human readable name. The identifier used in UI views. Must be UTF-8 encoded string. Length limit is 128 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        displayName?: string | null;
        /**
         * Defines a filter-type control Currently not supported by Recommendation
         */
        filterAction?: Schema$GoogleCloudDiscoveryengineV1ControlFilterAction;
        /**
         * Immutable. Fully qualified name `projects/x/locations/global/dataStore/x/controls/x`
         */
        name?: string | null;
        /**
         * Promote certain links based on predefined trigger queries.
         */
        promoteAction?: Schema$GoogleCloudDiscoveryengineV1ControlPromoteAction;
        /**
         * Defines a redirect-type control.
         */
        redirectAction?: Schema$GoogleCloudDiscoveryengineV1ControlRedirectAction;
        /**
         * Required. Immutable. What solution the control belongs to. Must be compatible with vertical of resource. Otherwise an INVALID ARGUMENT error is thrown.
         */
        solutionType?: string | null;
        /**
         * Treats a group of terms as synonyms of one another.
         */
        synonymsAction?: Schema$GoogleCloudDiscoveryengineV1ControlSynonymsAction;
        /**
         * Specifies the use case for the control. Affects what condition fields can be set. Only applies to SOLUTION_TYPE_SEARCH. Currently only allow one use case per control. Must be set when solution_type is SolutionType.SOLUTION_TYPE_SEARCH.
         */
        useCases?: string[] | null;
    }
    /**
     * Adjusts order of products in returned list.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ControlBoostAction {
        /**
         * Strength of the boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0 (No-op).
         */
        boost?: number | null;
        /**
         * Required. Specifies which data store's documents can be boosted by this control. Full data store name e.g. projects/123/locations/global/collections/default_collection/dataStores/default_data_store
         */
        dataStore?: string | null;
        /**
         * Required. Specifies which products to apply the boost to. If no filter is provided all products will be boosted (No-op). Syntax documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        filter?: string | null;
        /**
         * Optional. Strength of the boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0 (No-op).
         */
        fixedBoost?: number | null;
        /**
         * Optional. Complex specification for custom ranking based on customer defined attribute value.
         */
        interpolationBoostSpec?: Schema$GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpec;
    }
    /**
     * Specification for custom ranking based on customer specified attribute value. It provides more controls for customized ranking than the simple (condition, boost) combination above.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpec {
        /**
         * Optional. The attribute type to be used to determine the boost amount. The attribute value can be derived from the field value of the specified field_name. In the case of numerical it is straightforward i.e. attribute_value = numerical_field_value. In the case of freshness however, attribute_value = (time.now() - datetime_field_value).
         */
        attributeType?: string | null;
        /**
         * Optional. The control points used to define the curve. The monotonic function (defined through the interpolation_type above) passes through the control points listed here.
         */
        controlPoints?: Schema$GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPoint[];
        /**
         * Optional. The name of the field whose value will be used to determine the boost amount.
         */
        fieldName?: string | null;
        /**
         * Optional. The interpolation type to be applied to connect the control points listed below.
         */
        interpolationType?: string | null;
    }
    /**
     * The control points used to define the curve. The curve defined through these control points can only be monotonically increasing or decreasing(constant values are acceptable).
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ControlBoostActionInterpolationBoostSpecControlPoint {
        /**
         * Optional. Can be one of: 1. The numerical field value. 2. The duration spec for freshness: The value must be formatted as an XSD `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value). The pattern for this is: `nDnM]`.
         */
        attributeValue?: string | null;
        /**
         * Optional. The value between -1 to 1 by which to boost the score if the attribute_value evaluates to the value specified above.
         */
        boostAmount?: number | null;
    }
    /**
     * Specified which products may be included in results. Uses same filter as boost.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ControlFilterAction {
        /**
         * Required. Specifies which data store's documents can be filtered by this control. Full data store name e.g. projects/123/locations/global/collections/default_collection/dataStores/default_data_store
         */
        dataStore?: string | null;
        /**
         * Required. A filter to apply on the matching condition results. Required Syntax documentation: https://cloud.google.com/retail/docs/filter-and-order Maximum length is 5000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        filter?: string | null;
    }
    /**
     * Promote certain links based on some trigger queries. Example: Promote shoe store link when searching for `shoe` keyword. The link can be outside of associated data store.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ControlPromoteAction {
        /**
         * Required. Data store with which this promotion is attached to.
         */
        dataStore?: string | null;
        /**
         * Required. Promotion attached to this action.
         */
        searchLinkPromotion?: Schema$GoogleCloudDiscoveryengineV1SearchLinkPromotion;
    }
    /**
     * Redirects a shopper to the provided URI.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ControlRedirectAction {
        /**
         * Required. The URI to which the shopper will be redirected. Required. URI must have length equal or less than 2000 characters. Otherwise an INVALID ARGUMENT error is thrown.
         */
        redirectUri?: string | null;
    }
    /**
     * Creates a set of terms that will act as synonyms of one another. Example: "happy" will also be considered as "glad", "glad" will also be considered as "happy".
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ControlSynonymsAction {
        /**
         * Defines a set of synonyms. Can specify up to 100 synonyms. Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is thrown.
         */
        synonyms?: string[] | null;
    }
    /**
     * External conversation proto definition.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Conversation {
        /**
         * Output only. The time the conversation finished.
         */
        endTime?: string | null;
        /**
         * Conversation messages.
         */
        messages?: Schema$GoogleCloudDiscoveryengineV1ConversationMessage[];
        /**
         * Immutable. Fully qualified name `projects/{project\}/locations/global/collections/{collection\}/dataStore/x/conversations/x` or `projects/{project\}/locations/global/collections/{collection\}/engines/x/conversations/x`.
         */
        name?: string | null;
        /**
         * Output only. The time the conversation started.
         */
        startTime?: string | null;
        /**
         * The state of the Conversation.
         */
        state?: string | null;
        /**
         * A unique identifier for tracking users.
         */
        userPseudoId?: string | null;
    }
    /**
     * Defines context of the conversation
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ConversationContext {
        /**
         * The current active document the user opened. It contains the document resource reference.
         */
        activeDocument?: string | null;
        /**
         * The current list of documents the user is seeing. It contains the document resource references.
         */
        contextDocuments?: string[] | null;
    }
    /**
     * Defines a conversation message.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ConversationMessage {
        /**
         * Output only. Message creation timestamp.
         */
        createTime?: string | null;
        /**
         * Search reply.
         */
        reply?: Schema$GoogleCloudDiscoveryengineV1Reply;
        /**
         * User text input.
         */
        userInput?: Schema$GoogleCloudDiscoveryengineV1TextInput;
    }
    /**
     * Request message for ConversationalSearchService.ConverseConversation method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ConverseConversationRequest {
        /**
         * Boost specification to boost certain documents in search results which may affect the converse response. For more information on boosting, see [Boosting](https://cloud.google.com/retail/docs/boosting#boost)
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpec;
        /**
         * The conversation to be used by auto session only. The name field will be ignored as we automatically assign new name for the conversation in auto session.
         */
        conversation?: Schema$GoogleCloudDiscoveryengineV1Conversation;
        /**
         * The filter syntax consists of an expression language for constructing a predicate from one or more fields of the documents being filtered. Filter expression is case-sensitive. This will be used to filter search results which may affect the summary response. If this field is unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI Search is done by mapping the LHS filter key to a key property defined in the Vertex AI Search backend -- this mapping is defined by the customer in their schema. For example a media customer might have a field 'name' in their schema. In this case the filter would look like this: filter --\> name:'ANY("king kong")' For more information about filtering including syntax and filter operators, see [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
        /**
         * Required. Current user input.
         */
        query?: Schema$GoogleCloudDiscoveryengineV1TextInput;
        /**
         * Whether to turn on safe search.
         */
        safeSearch?: boolean | null;
        /**
         * The resource name of the Serving Config to use. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/servingConfigs/{serving_config_id\}` If this is not set, the default serving config will be used.
         */
        servingConfig?: string | null;
        /**
         * A specification for configuring the summary returned in the response.
         */
        summarySpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec;
        /**
         * The user labels applied to a resource must meet the following requirements: * Each resource can have multiple labels, up to a maximum of 64. * Each label must be a key-value pair. * Keys have a minimum length of 1 character and a maximum length of 63 characters and cannot be empty. Values can be empty and have a maximum length of 63 characters. * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. All characters must use UTF-8 encoding, and international characters are allowed. * The key portion of a label must be unique. However, you can use the same key with multiple resources. * Keys must start with a lowercase letter or international character. See [Google Cloud Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements) for more details.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Response message for ConversationalSearchService.ConverseConversation method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ConverseConversationResponse {
        /**
         * Updated conversation including the answer.
         */
        conversation?: Schema$GoogleCloudDiscoveryengineV1Conversation;
        /**
         * Answer to the current query.
         */
        reply?: Schema$GoogleCloudDiscoveryengineV1Reply;
        /**
         * Search Results.
         */
        searchResults?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSearchResult[];
    }
    /**
     * Metadata related to the progress of the DataStoreService.CreateDataStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CreateDataStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the EngineService.CreateEngine operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CreateEngineMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for Create Schema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CreateSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.CreateSitemap operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CreateSitemapMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.CreateTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CreateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for SiteSearchEngineService.CreateTargetSite method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CreateTargetSiteRequest {
        /**
         * Required. Parent resource name of TargetSite, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/siteSearchEngine`.
         */
        parent?: string | null;
        /**
         * Required. The TargetSite to create.
         */
        targetSite?: Schema$GoogleCloudDiscoveryengineV1TargetSite;
    }
    /**
     * A custom attribute that is not explicitly modeled in a resource, e.g. UserEvent.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CustomAttribute {
        /**
         * The numerical values of this custom attribute. For example, `[2.3, 15.4]` when the key is "lengths_cm". Exactly one of CustomAttribute.text or CustomAttribute.numbers should be set. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        numbers?: number[] | null;
        /**
         * The textual values of this custom attribute. For example, `["yellow", "green"]` when the key is "color". Empty string is not allowed. Otherwise, an `INVALID_ARGUMENT` error is returned. Exactly one of CustomAttribute.text or CustomAttribute.numbers should be set. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        text?: string[] | null;
    }
    /**
     * Metadata that describes a custom tuned model.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1CustomTuningModel {
        /**
         * Deprecated: Timestamp the Model was created at.
         */
        createTime?: string | null;
        /**
         * The display name of the model.
         */
        displayName?: string | null;
        /**
         * Currently this is only populated if the model state is `INPUT_VALIDATION_FAILED`.
         */
        errorMessage?: string | null;
        /**
         * The metrics of the trained model.
         */
        metrics?: {
            [key: string]: number;
        } | null;
        /**
         * The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
         */
        modelState?: string | null;
        /**
         * The version of the model.
         */
        modelVersion?: string | null;
        /**
         * Required. The fully qualified resource name of the model. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/customTuningModels/{custom_tuning_model\}`. Model must be an alpha-numerical string with limit of 40 characters.
         */
        name?: string | null;
        /**
         * Timestamp the model training was initiated.
         */
        trainingStartTime?: string | null;
    }
    /**
     * DataStore captures global settings and configs at the DataStore level.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DataStore {
        /**
         * Immutable. Whether data in the DataStore has ACL information. If set to `true`, the source data must have ACL. ACL will be ingested when data is ingested by DocumentService.ImportDocuments methods. When ACL is enabled for the DataStore, Document can't be accessed by calling DocumentService.GetDocument or DocumentService.ListDocuments. Currently ACL is only supported in `GENERIC` industry vertical with non-`PUBLIC_WEBSITE` content config.
         */
        aclEnabled?: boolean | null;
        /**
         * Optional. Configuration for advanced site search.
         */
        advancedSiteSearchConfig?: Schema$GoogleCloudDiscoveryengineV1AdvancedSiteSearchConfig;
        /**
         * Output only. Data size estimation for billing.
         */
        billingEstimation?: Schema$GoogleCloudDiscoveryengineV1DataStoreBillingEstimation;
        /**
         * Output only. CMEK-related information for the DataStore.
         */
        cmekConfig?: Schema$GoogleCloudDiscoveryengineV1CmekConfig;
        /**
         * Immutable. The content config of the data store. If this field is unset, the server behavior defaults to ContentConfig.NO_CONTENT.
         */
        contentConfig?: string | null;
        /**
         * Output only. Timestamp the DataStore was created at.
         */
        createTime?: string | null;
        /**
         * Output only. The id of the default Schema associated to this data store.
         */
        defaultSchemaId?: string | null;
        /**
         * Required. The data store display name. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        displayName?: string | null;
        /**
         * Configuration for Document understanding and enrichment.
         */
        documentProcessingConfig?: Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfig;
        /**
         * Optional. Configuration for `HEALTHCARE_FHIR` vertical.
         */
        healthcareFhirConfig?: Schema$GoogleCloudDiscoveryengineV1HealthcareFhirConfig;
        /**
         * Immutable. The fully qualified resource name of the associated IdentityMappingStore. This field can only be set for acl_enabled DataStores with `THIRD_PARTY` or `GSUITE` IdP. Format: `projects/{project\}/locations/{location\}/identityMappingStores/{identity_mapping_store\}`.
         */
        identityMappingStore?: string | null;
        /**
         * Immutable. The industry vertical that the data store registers.
         */
        industryVertical?: string | null;
        /**
         * Optional. If set, this DataStore is an Infobot FAQ DataStore.
         */
        isInfobotFaqDataStore?: boolean | null;
        /**
         * Input only. The KMS key to be used to protect this DataStore at creation time. Must be set for requests that need to comply with CMEK Org Policy protections. If this field is set and processed successfully, the DataStore will be protected by the KMS key, as indicated in the cmek_config field.
         */
        kmsKeyName?: string | null;
        /**
         * Immutable. Identifier. The full resource name of the data store. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * Optional. Stores serving config at DataStore level.
         */
        servingConfigDataStore?: Schema$GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore;
        /**
         * The solutions that the data store enrolls. Available solutions for each industry_vertical: * `MEDIA`: `SOLUTION_TYPE_RECOMMENDATION` and `SOLUTION_TYPE_SEARCH`. * `SITE_SEARCH`: `SOLUTION_TYPE_SEARCH` is automatically enrolled. Other solutions cannot be enrolled.
         */
        solutionTypes?: string[] | null;
        /**
         * The start schema to use for this DataStore when provisioning it. If unset, a default vertical specialized schema will be used. This field is only used by CreateDataStore API, and will be ignored if used in other APIs. This field will be omitted from all API responses including CreateDataStore API. To retrieve a schema of a DataStore, use SchemaService.GetSchema API instead. The provided schema will be validated against certain rules on schema. Learn more from [this doc](https://cloud.google.com/generative-ai-app-builder/docs/provide-schema).
         */
        startingSchema?: Schema$GoogleCloudDiscoveryengineV1Schema;
        /**
         * Config to store data store type configuration for workspace data. This must be set when DataStore.content_config is set as DataStore.ContentConfig.GOOGLE_WORKSPACE.
         */
        workspaceConfig?: Schema$GoogleCloudDiscoveryengineV1WorkspaceConfig;
    }
    /**
     * Estimation of data size per data store.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DataStoreBillingEstimation {
        /**
         * Data size for structured data in terms of bytes.
         */
        structuredDataSize?: string | null;
        /**
         * Last updated timestamp for structured data.
         */
        structuredDataUpdateTime?: string | null;
        /**
         * Data size for unstructured data in terms of bytes.
         */
        unstructuredDataSize?: string | null;
        /**
         * Last updated timestamp for unstructured data.
         */
        unstructuredDataUpdateTime?: string | null;
        /**
         * Data size for websites in terms of bytes.
         */
        websiteDataSize?: string | null;
        /**
         * Last updated timestamp for websites.
         */
        websiteDataUpdateTime?: string | null;
    }
    /**
     * Stores information regarding the serving configurations at DataStore level.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DataStoreServingConfigDataStore {
        /**
         * Optional. If set true, the DataStore will not be available for serving search requests.
         */
        disabledForServing?: boolean | null;
    }
    /**
     * Metadata related to the progress of the CmekConfigService.DeleteCmekConfig operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DeleteCmekConfigMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the DataStoreService.DeleteDataStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DeleteDataStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the EngineService.DeleteEngine operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DeleteEngineMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the IdentityMappingStoreService.DeleteIdentityMappingStore operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DeleteIdentityMappingStoreMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for DeleteSchema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DeleteSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DeleteSitemap operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DeleteSitemapMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DeleteTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DeleteTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.DisableAdvancedSiteSearch operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchRequest {
    }
    /**
     * Response message for SiteSearchEngineService.DisableAdvancedSiteSearch method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DisableAdvancedSiteSearchResponse {
    }
    /**
     * Document captures all raw metadata information of items to be recommended or searched.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Document {
        /**
         * Access control information for the document.
         */
        aclInfo?: Schema$GoogleCloudDiscoveryengineV1DocumentAclInfo;
        /**
         * The unstructured data linked to this document. Content can only be set and must be set if this document is under a `CONTENT_REQUIRED` data store.
         */
        content?: Schema$GoogleCloudDiscoveryengineV1DocumentContent;
        /**
         * Output only. This field is OUTPUT_ONLY. It contains derived data that are not in the original input document.
         */
        derivedStructData?: {
            [key: string]: any;
        } | null;
        /**
         * Immutable. The identifier of the document. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 128 characters.
         */
        id?: string | null;
        /**
         * Output only. The index status of the document. * If document is indexed successfully, the index_time field is populated. * Otherwise, if document is not indexed due to errors, the error_samples field is populated. * Otherwise, if document's index is in progress, the pending_message field is populated.
         */
        indexStatus?: Schema$GoogleCloudDiscoveryengineV1DocumentIndexStatus;
        /**
         * Output only. The last time the document was indexed. If this field is set, the document could be returned in search results. This field is OUTPUT_ONLY. If this field is not populated, it means the document has never been indexed.
         */
        indexTime?: string | null;
        /**
         * The JSON string representation of the document. It should conform to the registered Schema or an `INVALID_ARGUMENT` error is thrown.
         */
        jsonData?: string | null;
        /**
         * Immutable. The full resource name of the document. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}/documents/{document_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * The identifier of the parent document. Currently supports at most two level document hierarchy. Id should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
         */
        parentDocumentId?: string | null;
        /**
         * The identifier of the schema located in the same data store.
         */
        schemaId?: string | null;
        /**
         * The structured JSON data for the document. It should conform to the registered Schema or an `INVALID_ARGUMENT` error is thrown.
         */
        structData?: {
            [key: string]: any;
        } | null;
    }
    /**
     * ACL Information of the Document.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentAclInfo {
        /**
         * Readers of the document.
         */
        readers?: Schema$GoogleCloudDiscoveryengineV1DocumentAclInfoAccessRestriction[];
    }
    /**
     * AclRestriction to model complex inheritance restrictions. Example: Modeling a "Both Permit" inheritance, where to access a child document, user needs to have access to parent document. Document Hierarchy - Space_S --\> Page_P. Readers: Space_S: group_1, user_1 Page_P: group_2, group_3, user_2 Space_S ACL Restriction - { "acl_info": { "readers": [ { "principals": [ { "group_id": "group_1" \}, { "user_id": "user_1" \} ] \} ] \} \} Page_P ACL Restriction. { "acl_info": { "readers": [ { "principals": [ { "group_id": "group_2" \}, { "group_id": "group_3" \}, { "user_id": "user_2" \} ], \}, { "principals": [ { "group_id": "group_1" \}, { "user_id": "user_1" \} ], \} ] \} \}
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentAclInfoAccessRestriction {
        /**
         * All users within the Identity Provider.
         */
        idpWide?: boolean | null;
        /**
         * List of principals.
         */
        principals?: Schema$GoogleCloudDiscoveryengineV1Principal[];
    }
    /**
     * Unstructured data linked to this document.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentContent {
        /**
         * The MIME type of the content. Supported types: * `application/pdf` (PDF, only native PDFs are supported for now) * `text/html` (HTML) * `text/plain` (TXT) * `application/xml` or `text/xml` (XML) * `application/json` (JSON) * `application/vnd.openxmlformats-officedocument.wordprocessingml.document` (DOCX) * `application/vnd.openxmlformats-officedocument.presentationml.presentation` (PPTX) * `application/vnd.openxmlformats-officedocument.spreadsheetml.sheet` (XLSX) * `application/vnd.ms-excel.sheet.macroenabled.12` (XLSM) The following types are supported only if layout parser is enabled in the data store: * `image/bmp` (BMP) * `image/gif` (GIF) * `image/jpeg` (JPEG) * `image/png` (PNG) * `image/tiff` (TIFF) See https://www.iana.org/assignments/media-types/media-types.xhtml.
         */
        mimeType?: string | null;
        /**
         * The content represented as a stream of bytes. The maximum length is 1,000,000 bytes (1 MB / ~0.95 MiB). Note: As with all `bytes` fields, this field is represented as pure binary in Protocol Buffers and base64-encoded string in JSON. For example, `abc123!?$*&()'-=@~` should be represented as `YWJjMTIzIT8kKiYoKSctPUB+` in JSON. See https://developers.google.com/protocol-buffers/docs/proto3#json.
         */
        rawBytes?: string | null;
        /**
         * The URI of the content. Only Cloud Storage URIs (e.g. `gs://bucket-name/path/to/file`) are supported. The maximum file size is 2.5 MB for text-based formats, 200 MB for other formats.
         */
        uri?: string | null;
    }
    /**
     * Index status of the document.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentIndexStatus {
        /**
         * A sample of errors encountered while indexing the document. If this field is populated, the document is not indexed due to errors.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * The time when the document was indexed. If this field is populated, it means the document has been indexed.
         */
        indexTime?: string | null;
        /**
         * Immutable. The message indicates the document index is in progress. If this field is populated, the document index is pending.
         */
        pendingMessage?: string | null;
    }
    /**
     * Detailed document information associated with a user event.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentInfo {
        /**
         * Optional. The conversion value associated with this Document. Must be set if UserEvent.event_type is "conversion". For example, a value of 1000 signifies that 1000 seconds were spent viewing a Document for the `watch` conversion type.
         */
        conversionValue?: number | null;
        /**
         * The Document resource ID.
         */
        id?: string | null;
        /**
         * Output only. Whether the referenced Document can be found in the data store.
         */
        joined?: boolean | null;
        /**
         * The Document resource full name, of the form: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}/branches/{branch_id\}/documents/{document_id\}`
         */
        name?: string | null;
        /**
         * The promotion IDs associated with this Document. Currently, this field is restricted to at most one ID.
         */
        promotionIds?: string[] | null;
        /**
         * Quantity of the Document associated with the user event. Defaults to 1. For example, this field is 2 if two quantities of the same Document are involved in a `add-to-cart` event. Required for events of the following event types: * `add-to-cart` * `purchase`
         */
        quantity?: number | null;
        /**
         * The Document URI - only allowed for website data stores.
         */
        uri?: string | null;
    }
    /**
     * A singleton resource of DataStore. If it's empty when DataStore is created and DataStore is set to DataStore.ContentConfig.CONTENT_REQUIRED, the default parser will default to digital parser.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfig {
        /**
         * Whether chunking mode is enabled.
         */
        chunkingConfig?: Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig;
        /**
         * Configurations for default Document parser. If not specified, we will configure it as default DigitalParsingConfig, and the default parsing config will be applied to all file types for Document parsing.
         */
        defaultParsingConfig?: Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig;
        /**
         * The full resource name of the Document Processing Config. Format: `projects/x/locations/x/collections/x/dataStores/x/documentProcessingConfig`.
         */
        name?: string | null;
        /**
         * Map from file type to override the default parsing configuration based on the file type. Supported keys: * `pdf`: Override parsing config for PDF files, either digital parsing, ocr parsing or layout parsing is supported. * `html`: Override parsing config for HTML files, only digital parsing and layout parsing are supported. * `docx`: Override parsing config for DOCX files, only digital parsing and layout parsing are supported. * `pptx`: Override parsing config for PPTX files, only digital parsing and layout parsing are supported. * `xlsm`: Override parsing config for XLSM files, only digital parsing and layout parsing are supported. * `xlsx`: Override parsing config for XLSX files, only digital parsing and layout parsing are supported.
         */
        parsingConfigOverrides?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig;
        } | null;
    }
    /**
     * Configuration for chunking config.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfig {
        /**
         * Configuration for the layout based chunking.
         */
        layoutBasedChunkingConfig?: Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig;
    }
    /**
     * Configuration for the layout based chunking.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigChunkingConfigLayoutBasedChunkingConfig {
        /**
         * The token size limit for each chunk. Supported values: 100-500 (inclusive). Default value: 500.
         */
        chunkSize?: number | null;
        /**
         * Whether to include appending different levels of headings to chunks from the middle of the document to prevent context loss. Default value: False.
         */
        includeAncestorHeadings?: boolean | null;
    }
    /**
     * Related configurations applied to a specific type of document parser.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfig {
        /**
         * Configurations applied to digital parser.
         */
        digitalParsingConfig?: Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsingConfig;
        /**
         * Configurations applied to layout parser.
         */
        layoutParsingConfig?: Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig;
        /**
         * Configurations applied to OCR parser. Currently it only applies to PDFs.
         */
        ocrParsingConfig?: Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig;
    }
    /**
     * The digital parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigDigitalParsingConfig {
    }
    /**
     * The layout parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigLayoutParsingConfig {
        /**
         * Optional. If true, the processed document will be made available for the GetProcessedDocument API.
         */
        enableGetProcessedDocument?: boolean | null;
        /**
         * Optional. If true, the LLM based annotation is added to the image during parsing.
         */
        enableImageAnnotation?: boolean | null;
        /**
         * Optional. If true, the LLM based annotation is added to the table during parsing.
         */
        enableTableAnnotation?: boolean | null;
        /**
         * Optional. List of HTML classes to exclude from the parsed content.
         */
        excludeHtmlClasses?: string[] | null;
        /**
         * Optional. List of HTML elements to exclude from the parsed content.
         */
        excludeHtmlElements?: string[] | null;
        /**
         * Optional. List of HTML ids to exclude from the parsed content.
         */
        excludeHtmlIds?: string[] | null;
        /**
         * Optional. Contains the required structure types to extract from the document. Supported values: * `shareholder-structure`
         */
        structuredContentTypes?: string[] | null;
    }
    /**
     * The OCR parsing configurations for documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DocumentProcessingConfigParsingConfigOcrParsingConfig {
        /**
         * [DEPRECATED] This field is deprecated. To use the additional enhanced document elements processing, please switch to `layout_parsing_config`.
         */
        enhancedDocumentElements?: string[] | null;
        /**
         * If true, will use native text instead of OCR text on pages containing native text.
         */
        useNativeText?: boolean | null;
    }
    /**
     * Double list.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1DoubleList {
        /**
         * Double values.
         */
        values?: number[] | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.EnableAdvancedSiteSearch operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchRequest {
    }
    /**
     * Response message for SiteSearchEngineService.EnableAdvancedSiteSearch method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EnableAdvancedSiteSearchResponse {
    }
    /**
     * Metadata that describes the training and serving parameters of an Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Engine {
        /**
         * Configurations for the Chat Engine. Only applicable if solution_type is SOLUTION_TYPE_CHAT.
         */
        chatEngineConfig?: Schema$GoogleCloudDiscoveryengineV1EngineChatEngineConfig;
        /**
         * Output only. Additional information of the Chat Engine. Only applicable if solution_type is SOLUTION_TYPE_CHAT.
         */
        chatEngineMetadata?: Schema$GoogleCloudDiscoveryengineV1EngineChatEngineMetadata;
        /**
         * Common config spec that specifies the metadata of the engine.
         */
        commonConfig?: Schema$GoogleCloudDiscoveryengineV1EngineCommonConfig;
        /**
         * Output only. Timestamp the Recommendation Engine was created at.
         */
        createTime?: string | null;
        /**
         * Optional. The data stores associated with this engine. For SOLUTION_TYPE_SEARCH and SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store. If solution_type is SOLUTION_TYPE_CHAT, multiple DataStores in the same Collection can be associated here. Note that when used in CreateEngineRequest, one DataStore id must be provided as the system will use it for necessary initializations.
         */
        dataStoreIds?: string[] | null;
        /**
         * Optional. Whether to disable analytics for searches performed on this engine.
         */
        disableAnalytics?: boolean | null;
        /**
         * Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
         */
        displayName?: string | null;
        /**
         * Optional. Feature config for the engine to opt in or opt out of features. Supported keys: * `*`: all features, if it's present, all other feature state settings are ignored. * `agent-gallery` * `no-code-agent-builder` * `prompt-gallery` * `model-selector` * `notebook-lm` * `people-search` * `people-search-org-chart` * `bi-directional-audio` * `feedback` * `session-sharing` * `personalization-memory` - Enables personalization based on user preferences.
         */
        features?: {
            [key: string]: string;
        } | null;
        /**
         * Optional. The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: Vertical on Engine has to match vertical of the DataStore linked to the engine.
         */
        industryVertical?: string | null;
        /**
         * Configurations for the Media Engine. Only applicable on the data stores with solution_type SOLUTION_TYPE_RECOMMENDATION and IndustryVertical.MEDIA vertical.
         */
        mediaRecommendationEngineConfig?: Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfig;
        /**
         * Immutable. Identifier. The fully qualified resource name of the engine. This field must be a UTF-8 encoded string with a length limit of 1024 characters. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}` engine should be 1-63 characters, and valid characters are /a-z0-9x/. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        name?: string | null;
        /**
         * Configurations for the Search Engine. Only applicable if solution_type is SOLUTION_TYPE_SEARCH.
         */
        searchEngineConfig?: Schema$GoogleCloudDiscoveryengineV1EngineSearchEngineConfig;
        /**
         * Required. The solutions of the engine.
         */
        solutionType?: string | null;
        /**
         * Output only. Timestamp the Recommendation Engine was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Configurations for a Chat Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineChatEngineConfig {
        /**
         * The configurationt generate the Dialogflow agent that is associated to this Engine. Note that these configurations are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
         */
        agentCreationConfig?: Schema$GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig;
        /**
         * Optional. If the flag set to true, we allow the agent and engine are in different locations, otherwise the agent and engine are required to be in the same location. The flag is set to false by default. Note that the `allow_cross_region` are one-time consumed by and passed to EngineService.CreateEngine. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
         */
        allowCrossRegion?: boolean | null;
        /**
         * The resource name of an exist Dialogflow agent to link to this Chat Engine. Customers can either provide `agent_creation_config` to create agent or provide an agent name that links the agent with the Chat engine. Format: `projects//locations//agents/`. Note that the `dialogflow_agent_to_link` are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation. Use ChatEngineMetadata.dialogflow_agent for actual agent association after Engine is created.
         */
        dialogflowAgentToLink?: string | null;
    }
    /**
     * Configurations for generating a Dialogflow agent. Note that these configurations are one-time consumed by and passed to Dialogflow service. It means they cannot be retrieved using EngineService.GetEngine or EngineService.ListEngines API after engine creation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineChatEngineConfigAgentCreationConfig {
        /**
         * Name of the company, organization or other entity that the agent represents. Used for knowledge connector LLM prompt and for knowledge search.
         */
        business?: string | null;
        /**
         * Required. The default language of the agent as a language tag. See [Language Support](https://cloud.google.com/dialogflow/docs/reference/language) for a list of the currently supported language codes.
         */
        defaultLanguageCode?: string | null;
        /**
         * Agent location for Agent creation, supported values: global/us/eu. If not provided, us Engine will create Agent using us-central-1 by default; eu Engine will create Agent using eu-west-1 by default.
         */
        location?: string | null;
        /**
         * Required. The time zone of the agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
         */
        timeZone?: string | null;
    }
    /**
     * Additional information of a Chat Engine. Fields in this message are output only.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineChatEngineMetadata {
        /**
         * The resource name of a Dialogflow agent, that this Chat Engine refers to. Format: `projects//locations//agents/`.
         */
        dialogflowAgent?: string | null;
    }
    /**
     * Common configurations for an Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineCommonConfig {
        /**
         * The name of the company, business or entity that is associated with the engine. Setting this may help improve LLM related features.
         */
        companyName?: string | null;
    }
    /**
     * Additional config specs for a Media Recommendation engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfig {
        /**
         * Optional. Additional engine features config.
         */
        engineFeaturesConfig?: Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigEngineFeaturesConfig;
        /**
         * The optimization objective. e.g., `cvr`. This field together with optimization_objective describe engine metadata to use to control engine training and serving. Currently supported values: `ctr`, `cvr`. If not specified, we choose default based on engine type. Default depends on type of recommendation: `recommended-for-you` =\> `ctr` `others-you-may-like` =\> `ctr`
         */
        optimizationObjective?: string | null;
        /**
         * Name and value of the custom threshold for cvr optimization_objective. For target_field `watch-time`, target_field_value must be an integer value indicating the media progress time in seconds between (0, 86400] (excludes 0, includes 86400) (e.g., 90). For target_field `watch-percentage`, the target_field_value must be a valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g., 0.5).
         */
        optimizationObjectiveConfig?: Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimizationObjectiveConfig;
        /**
         * The training state that the engine is in (e.g. `TRAINING` or `PAUSED`). Since part of the cost of running the service is frequency of training - this can be used to determine when to train engine in order to control cost. If not specified: the default value for `CreateEngine` method is `TRAINING`. The default value for `UpdateEngine` method is to keep the state the same as before.
         */
        trainingState?: string | null;
        /**
         * Required. The type of engine. e.g., `recommended-for-you`. This field together with optimization_objective describe engine metadata to use to control engine training and serving. Currently supported values: `recommended-for-you`, `others-you-may-like`, `more-like-this`, `most-popular-items`.
         */
        type?: string | null;
    }
    /**
     * More feature configs of the selected engine type.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigEngineFeaturesConfig {
        /**
         * Most popular engine feature config.
         */
        mostPopularConfig?: Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigMostPopularFeatureConfig;
        /**
         * Recommended for you engine feature config.
         */
        recommendedForYouConfig?: Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig;
    }
    /**
     * Feature configurations that are required for creating a Most Popular engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigMostPopularFeatureConfig {
        /**
         * The time window of which the engine is queried at training and prediction time. Positive integers only. The value translates to the last X days of events. Currently required for the `most-popular-items` engine.
         */
        timeWindowDays?: string | null;
    }
    /**
     * Custom threshold for `cvr` optimization_objective.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigOptimizationObjectiveConfig {
        /**
         * Required. The name of the field to target. Currently supported values: `watch-percentage`, `watch-time`.
         */
        targetField?: string | null;
        /**
         * Required. The threshold to be applied to the target (e.g., 0.5).
         */
        targetFieldValueFloat?: number | null;
    }
    /**
     * Additional feature configurations for creating a `recommended-for-you` engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineMediaRecommendationEngineConfigRecommendedForYouFeatureConfig {
        /**
         * The type of event with which the engine is queried at prediction time. If set to `generic`, only `view-item`, `media-play`,and `media-complete` will be used as `context-event` in engine training. If set to `view-home-page`, `view-home-page` will also be used as `context-events` in addition to `view-item`, `media-play`, and `media-complete`. Currently supported for the `recommended-for-you` engine. Currently supported values: `view-home-page`, `generic`.
         */
        contextEventType?: string | null;
    }
    /**
     * Configurations for a Search Engine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1EngineSearchEngineConfig {
        /**
         * The add-on that this search engine enables.
         */
        searchAddOns?: string[] | null;
        /**
         * The search feature tier of this engine. Different tiers might have different pricing. To learn more, check the pricing documentation. Defaults to SearchTier.SEARCH_TIER_STANDARD if not specified.
         */
        searchTier?: string | null;
    }
    /**
     * Fact Chunk.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1FactChunk {
        /**
         * Text content of the fact chunk. Can be at most 10K characters long.
         */
        chunkText?: string | null;
        /**
         * The domain of the source.
         */
        domain?: string | null;
        /**
         * The index of this chunk. Currently, only used for the streaming mode.
         */
        index?: number | null;
        /**
         * Source from which this fact chunk was retrieved. If it was retrieved from the GroundingFacts provided in the request then this field will contain the index of the specific fact from which this chunk was retrieved.
         */
        source?: string | null;
        /**
         * More fine-grained information for the source reference.
         */
        sourceMetadata?: {
            [key: string]: string;
        } | null;
        /**
         * The title of the source.
         */
        title?: string | null;
        /**
         * The URI of the source.
         */
        uri?: string | null;
    }
    /**
     * Response message for SiteSearchEngineService.FetchDomainVerificationStatus method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1FetchDomainVerificationStatusResponse {
        /**
         * A token that can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * List of TargetSites containing the site verification status.
         */
        targetSites?: Schema$GoogleCloudDiscoveryengineV1TargetSite[];
        /**
         * The total number of items matching the request. This will always be populated in the response.
         */
        totalSize?: number | null;
    }
    /**
     * Response message for SiteSearchEngineService.FetchSitemaps method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1FetchSitemapsResponse {
        /**
         * List of Sitemaps fetched.
         */
        sitemapsMetadata?: Schema$GoogleCloudDiscoveryengineV1FetchSitemapsResponseSitemapMetadata[];
    }
    /**
     * Contains a Sitemap and its metadata.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1FetchSitemapsResponseSitemapMetadata {
        /**
         * The Sitemap.
         */
        sitemap?: Schema$GoogleCloudDiscoveryengineV1Sitemap;
    }
    /**
     * Cloud FhirStore source import data from.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1FhirStoreSource {
        /**
         * Required. The full resource name of the FHIR store to import data from, in the format of `projects/{project\}/locations/{location\}/datasets/{dataset\}/fhirStores/{fhir_store\}`.
         */
        fhirStore?: string | null;
        /**
         * Intermediate Cloud Storage directory used for the import with a length limit of 2,000 characters. Can be specified if one wants to have the FhirStore export to a specific Cloud Storage directory.
         */
        gcsStagingDir?: string | null;
        /**
         * The FHIR resource types to import. The resource types should be a subset of all [supported FHIR resource types](https://cloud.google.com/generative-ai-app-builder/docs/fhir-schema-reference#resource-level-specification). Default to all supported FHIR resource types if empty.
         */
        resourceTypes?: string[] | null;
        /**
         * Optional. Whether to update the DataStore schema to the latest predefined schema. If true, the DataStore schema will be updated to include any FHIR fields or resource types that have been added since the last import and corresponding FHIR resources will be imported from the FHIR store. Note this field cannot be used in conjunction with `resource_types`. It should be used after initial import.
         */
        updateFromLatestPredefinedSchema?: boolean | null;
    }
    /**
     * Firestore source import data from.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1FirestoreSource {
        /**
         * Required. The Firestore collection (or entity) to copy the data from with a length limit of 1,500 characters.
         */
        collectionId?: string | null;
        /**
         * Required. The Firestore database to copy the data from with a length limit of 256 characters.
         */
        databaseId?: string | null;
        /**
         * Intermediate Cloud Storage directory used for the import with a length limit of 2,000 characters. Can be specified if one wants to have the Firestore export to a specific Cloud Storage directory. Ensure that the Firestore service account has the necessary Cloud Storage Admin permissions to access the specified Cloud Storage directory.
         */
        gcsStagingDir?: string | null;
        /**
         * The project ID that the Cloud SQL source is in with a length limit of 128 characters. If not specified, inherits the project ID from the parent request.
         */
        projectId?: string | null;
    }
    /**
     * Cloud Storage location for input content.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1GcsSource {
        /**
         * The schema to use when parsing the data from the source. Supported values for document imports: * `document` (default): One JSON Document per line. Each document must have a valid Document.id. * `content`: Unstructured data (e.g. PDF, HTML). Each file matched by `input_uris` becomes a document, with the ID set to the first 128 bits of SHA256(URI) encoded as a hex string. * `custom`: One custom data JSON per row in arbitrary format that conforms to the defined Schema of the data store. This can only be used by the GENERIC Data Store vertical. * `csv`: A CSV file with header conforming to the defined Schema of the data store. Each entry after the header is imported as a Document. This can only be used by the GENERIC Data Store vertical. Supported values for user event imports: * `user_event` (default): One JSON UserEvent per line.
         */
        dataSchema?: string | null;
        /**
         * Required. Cloud Storage URIs to input files. Each URI can be up to 2000 characters long. URIs can match the full object path (for example, `gs://bucket/directory/object.json`) or a pattern matching one or more files, such as `gs://bucket/directory/x.json`. A request can contain at most 100 files (or 100,000 files if `data_schema` is `content`). Each file can be up to 2 GB (or 100 MB if `data_schema` is `content`).
         */
        inputUris?: string[] | null;
    }
    /**
     * Grounding Fact.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1GroundingFact {
        /**
         * Attributes associated with the fact. Common attributes include `source` (indicating where the fact was sourced from), `author` (indicating the author of the fact), and so on.
         */
        attributes?: {
            [key: string]: string;
        } | null;
        /**
         * Text content of the fact. Can be at most 10K characters long.
         */
        factText?: string | null;
    }
    /**
     * Config to data store for `HEALTHCARE_FHIR` vertical.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1HealthcareFhirConfig {
        /**
         * Whether to enable configurable schema for `HEALTHCARE_FHIR` vertical. If set to `true`, the predefined healthcare fhir schema can be extended for more customized searching and filtering.
         */
        enableConfigurableSchema?: boolean | null;
        /**
         * Whether to enable static indexing for `HEALTHCARE_FHIR` batch ingestion. If set to `true`, the batch ingestion will be processed in a static indexing mode which is slower but more capable of handling larger volume.
         */
        enableStaticIndexingForBatchIngestion?: boolean | null;
    }
    /**
     * Identity Mapping Entry that maps an external identity to an internal identity.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1IdentityMappingEntry {
        /**
         * Required. Identity outside the customer identity provider. The length limit of external identity will be of 100 characters.
         */
        externalIdentity?: string | null;
        /**
         * Group identifier. For Google Workspace user account, group_id should be the google workspace group email. For non-google identity provider, group_id is the mapped group identifier configured during the workforcepool config.
         */
        groupId?: string | null;
        /**
         * User identifier. For Google Workspace user account, user_id should be the google workspace user email. For non-google identity provider, user_id is the mapped user identifier configured during the workforcepool config.
         */
        userId?: string | null;
    }
    /**
     * IdentityMappingEntry LongRunningOperation metadata for IdentityMappingStoreService.ImportIdentityMappings and IdentityMappingStoreService.PurgeIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1IdentityMappingEntryOperationMetadata {
        /**
         * The number of IdentityMappingEntries that failed to be processed.
         */
        failureCount?: string | null;
        /**
         * The number of IdentityMappingEntries that were successfully processed.
         */
        successCount?: string | null;
        /**
         * The total number of IdentityMappingEntries that were processed.
         */
        totalCount?: string | null;
    }
    /**
     * Identity Mapping Store which contains Identity Mapping Entries.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1IdentityMappingStore {
        /**
         * Output only. CMEK-related information for the Identity Mapping Store.
         */
        cmekConfig?: Schema$GoogleCloudDiscoveryengineV1CmekConfig;
        /**
         * Input only. The KMS key to be used to protect this Identity Mapping Store at creation time. Must be set for requests that need to comply with CMEK Org Policy protections. If this field is set and processed successfully, the Identity Mapping Store will be protected by the KMS key, as indicated in the cmek_config field.
         */
        kmsKeyName?: string | null;
        /**
         * Immutable. The full resource name of the identity mapping store. Format: `projects/{project\}/locations/{location\}/identityMappingStores/{identity_mapping_store\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
    }
    /**
     * Metadata related to the progress of the ImportCompletionSuggestions operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of CompletionSuggestions that failed to be imported.
         */
        failureCount?: string | null;
        /**
         * Count of CompletionSuggestions successfully imported.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for CompletionService.ImportCompletionSuggestions method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest {
        /**
         * BigQuery input source.
         */
        bigquerySource?: Schema$GoogleCloudDiscoveryengineV1BigQuerySource;
        /**
         * The desired location of errors incurred during the Import.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig;
        /**
         * Cloud Storage location for the input content.
         */
        gcsSource?: Schema$GoogleCloudDiscoveryengineV1GcsSource;
        /**
         * The Inline source for suggestion entries.
         */
        inlineSource?: Schema$GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource;
    }
    /**
     * The inline source for CompletionSuggestions.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequestInlineSource {
        /**
         * Required. A list of all denylist entries to import. Max of 1000 items.
         */
        suggestions?: Schema$GoogleCloudDiscoveryengineV1CompletionSuggestion[];
    }
    /**
     * Response of the CompletionService.ImportCompletionSuggestions method. If the long running operation is done, this message is returned by the google.longrunning.Operations.response field if the operation is successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsResponse {
        /**
         * The desired location of errors incurred during the Import.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Metadata related to the progress of the ImportDocuments operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportDocumentsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were processed successfully.
         */
        successCount?: string | null;
        /**
         * Total count of entries that were processed.
         */
        totalCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for Import methods.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportDocumentsRequest {
        /**
         * AlloyDB input source.
         */
        alloyDbSource?: Schema$GoogleCloudDiscoveryengineV1AlloyDbSource;
        /**
         * Whether to automatically generate IDs for the documents if absent. If set to `true`, Document.ids are automatically generated based on the hash of the payload, where IDs may not be consistent during multiple imports. In which case ReconciliationMode.FULL is highly recommended to avoid duplicate contents. If unset or set to `false`, Document.ids have to be specified using id_field, otherwise, documents without IDs fail to be imported. Supported data sources: * GcsSource. GcsSource.data_schema must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. * BigQuerySource. BigQuerySource.data_schema must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. * SpannerSource. * CloudSqlSource. * FirestoreSource. * BigtableSource.
         */
        autoGenerateIds?: boolean | null;
        /**
         * BigQuery input source.
         */
        bigquerySource?: Schema$GoogleCloudDiscoveryengineV1BigQuerySource;
        /**
         * Cloud Bigtable input source.
         */
        bigtableSource?: Schema$GoogleCloudDiscoveryengineV1BigtableSource;
        /**
         * Cloud SQL input source.
         */
        cloudSqlSource?: Schema$GoogleCloudDiscoveryengineV1CloudSqlSource;
        /**
         * The desired location of errors incurred during the Import.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig;
        /**
         * FhirStore input source.
         */
        fhirStoreSource?: Schema$GoogleCloudDiscoveryengineV1FhirStoreSource;
        /**
         * Firestore input source.
         */
        firestoreSource?: Schema$GoogleCloudDiscoveryengineV1FirestoreSource;
        /**
         * Optional. Whether to force refresh the unstructured content of the documents. If set to `true`, the content part of the documents will be refreshed regardless of the update status of the referencing content.
         */
        forceRefreshContent?: boolean | null;
        /**
         * Cloud Storage location for the input content.
         */
        gcsSource?: Schema$GoogleCloudDiscoveryengineV1GcsSource;
        /**
         * The field indicates the ID field or column to be used as unique IDs of the documents. For GcsSource it is the key of the JSON field. For instance, `my_id` for JSON `{"my_id": "some_uuid"\}`. For others, it may be the column name of the table where the unique ids are stored. The values of the JSON field or the table column are used as the Document.ids. The JSON field or the table column must be of string type, and the values must be set as valid strings conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) with 1-63 characters. Otherwise, documents without valid IDs fail to be imported. Only set this field when auto_generate_ids is unset or set as `false`. Otherwise, an INVALID_ARGUMENT error is thrown. If it is unset, a default value `_id` is used when importing from the allowed data sources. Supported data sources: * GcsSource. GcsSource.data_schema must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. * BigQuerySource. BigQuerySource.data_schema must be `custom` or `csv`. Otherwise, an INVALID_ARGUMENT error is thrown. * SpannerSource. * CloudSqlSource. * BigtableSource.
         */
        idField?: string | null;
        /**
         * The Inline source for the input content for documents.
         */
        inlineSource?: Schema$GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource;
        /**
         * The mode of reconciliation between existing documents and the documents to be imported. Defaults to ReconciliationMode.INCREMENTAL.
         */
        reconciliationMode?: string | null;
        /**
         * Spanner input source.
         */
        spannerSource?: Schema$GoogleCloudDiscoveryengineV1SpannerSource;
        /**
         * Indicates which fields in the provided imported documents to update. If not set, the default is to update all fields.
         */
        updateMask?: string | null;
    }
    /**
     * The inline source for the input config for ImportDocuments method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportDocumentsRequestInlineSource {
        /**
         * Required. A list of documents to update/create. Each document must have a valid Document.id. Recommended max of 100 items.
         */
        documents?: Schema$GoogleCloudDiscoveryengineV1Document[];
    }
    /**
     * Response of the ImportDocumentsRequest. If the long running operation is done, then this message is returned by the google.longrunning.Operations.response field if the operation was successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportDocumentsResponse {
        /**
         * Echoes the destination for the complete errors in the request if set.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Configuration of destination for Import related errors.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig {
        /**
         * Cloud Storage prefix for import errors. This must be an empty, existing Cloud Storage directory. Import errors are written to sharded files in this directory, one per line, as a JSON-encoded `google.rpc.Status` message.
         */
        gcsPrefix?: string | null;
    }
    /**
     * Request message for IdentityMappingStoreService.ImportIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequest {
        /**
         * The inline source to import identity mapping entries from.
         */
        inlineSource?: Schema$GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequestInlineSource;
    }
    /**
     * The inline source to import identity mapping entries from.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportIdentityMappingsRequestInlineSource {
        /**
         * A maximum of 10000 entries can be imported at one time
         */
        identityMappingEntries?: Schema$GoogleCloudDiscoveryengineV1IdentityMappingEntry[];
    }
    /**
     * Response message for IdentityMappingStoreService.ImportIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportIdentityMappingsResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
    }
    /**
     * Metadata related to the progress of the ImportSuggestionDenyListEntries operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for CompletionService.ImportSuggestionDenyListEntries method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequest {
        /**
         * Cloud Storage location for the input content. Only 1 file can be specified that contains all entries to import. Supported values `gcs_source.schema` for autocomplete suggestion deny list entry imports: * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry] per line.
         */
        gcsSource?: Schema$GoogleCloudDiscoveryengineV1GcsSource;
        /**
         * The Inline source for the input content for suggestion deny list entries.
         */
        inlineSource?: Schema$GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource;
    }
    /**
     * The inline source for SuggestionDenyListEntry.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesRequestInlineSource {
        /**
         * Required. A list of all denylist entries to import. Max of 1000 items.
         */
        entries?: Schema$GoogleCloudDiscoveryengineV1SuggestionDenyListEntry[];
    }
    /**
     * Response message for CompletionService.ImportSuggestionDenyListEntries method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportSuggestionDenyListEntriesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Count of deny list entries that failed to be imported.
         */
        failedEntriesCount?: string | null;
        /**
         * Count of deny list entries successfully imported.
         */
        importedEntriesCount?: string | null;
    }
    /**
     * Metadata related to the progress of the Import operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportUserEventsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were processed successfully.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for the ImportUserEvents request.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportUserEventsRequest {
        /**
         * BigQuery input source.
         */
        bigquerySource?: Schema$GoogleCloudDiscoveryengineV1BigQuerySource;
        /**
         * The desired location of errors incurred during the Import. Cannot be set for inline user event imports.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig;
        /**
         * Cloud Storage location for the input content.
         */
        gcsSource?: Schema$GoogleCloudDiscoveryengineV1GcsSource;
        /**
         * The Inline source for the input content for UserEvents.
         */
        inlineSource?: Schema$GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource;
    }
    /**
     * The inline source for the input config for ImportUserEvents method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportUserEventsRequestInlineSource {
        /**
         * Required. A list of user events to import. Recommended max of 10k items.
         */
        userEvents?: Schema$GoogleCloudDiscoveryengineV1UserEvent[];
    }
    /**
     * Response of the ImportUserEventsRequest. If the long running operation was successful, then this message is returned by the google.longrunning.Operations.response field if the operation was successful.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ImportUserEventsResponse {
        /**
         * Echoes the destination for the complete errors if this field was set in the request.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig;
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Count of user events imported with complete existing Documents.
         */
        joinedEventsCount?: string | null;
        /**
         * Count of user events imported, but with Document information not found in the existing Branch.
         */
        unjoinedEventsCount?: string | null;
    }
    /**
     * A floating point interval.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Interval {
        /**
         * Exclusive upper bound.
         */
        exclusiveMaximum?: number | null;
        /**
         * Exclusive lower bound.
         */
        exclusiveMinimum?: number | null;
        /**
         * Inclusive upper bound.
         */
        maximum?: number | null;
        /**
         * Inclusive lower bound.
         */
        minimum?: number | null;
    }
    /**
     * Response message for CmekConfigService.ListCmekConfigs method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListCmekConfigsResponse {
        /**
         * All the customer's CmekConfigs.
         */
        cmekConfigs?: Schema$GoogleCloudDiscoveryengineV1CmekConfig[];
    }
    /**
     * Response for ListControls method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListControlsResponse {
        /**
         * All the Controls for a given data store.
         */
        controls?: Schema$GoogleCloudDiscoveryengineV1Control[];
        /**
         * Pagination token, if not returned indicates the last page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response for ListConversations method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListConversationsResponse {
        /**
         * All the Conversations for a given data store.
         */
        conversations?: Schema$GoogleCloudDiscoveryengineV1Conversation[];
        /**
         * Pagination token, if not returned indicates the last page.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for SearchTuningService.ListCustomModels method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListCustomModelsResponse {
        /**
         * List of custom tuning models.
         */
        models?: Schema$GoogleCloudDiscoveryengineV1CustomTuningModel[];
    }
    /**
     * Response message for DataStoreService.ListDataStores method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListDataStoresResponse {
        /**
         * All the customer's DataStores.
         */
        dataStores?: Schema$GoogleCloudDiscoveryengineV1DataStore[];
        /**
         * A token that can be sent as ListDataStoresRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for DocumentService.ListDocuments method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListDocumentsResponse {
        /**
         * The Documents.
         */
        documents?: Schema$GoogleCloudDiscoveryengineV1Document[];
        /**
         * A token that can be sent as ListDocumentsRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for EngineService.ListEngines method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListEnginesResponse {
        /**
         * All the customer's Engines.
         */
        engines?: Schema$GoogleCloudDiscoveryengineV1Engine[];
        /**
         * Not supported.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for IdentityMappingStoreService.ListIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListIdentityMappingsResponse {
        /**
         * The Identity Mapping Entries.
         */
        identityMappingEntries?: Schema$GoogleCloudDiscoveryengineV1IdentityMappingEntry[];
        /**
         * A token that can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for IdentityMappingStoreService.ListIdentityMappingStores
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListIdentityMappingStoresResponse {
        /**
         * The Identity Mapping Stores.
         */
        identityMappingStores?: Schema$GoogleCloudDiscoveryengineV1IdentityMappingStore[];
        /**
         * A token that can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response message for SchemaService.ListSchemas method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListSchemasResponse {
        /**
         * A token that can be sent as ListSchemasRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The Schemas.
         */
        schemas?: Schema$GoogleCloudDiscoveryengineV1Schema[];
    }
    /**
     * Response for ListSessions method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListSessionsResponse {
        /**
         * Pagination token, if not returned indicates the last page.
         */
        nextPageToken?: string | null;
        /**
         * All the Sessions for a given data store.
         */
        sessions?: Schema$GoogleCloudDiscoveryengineV1Session[];
    }
    /**
     * Response message for SiteSearchEngineService.ListTargetSites method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListTargetSitesResponse {
        /**
         * A token that can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * List of TargetSites.
         */
        targetSites?: Schema$GoogleCloudDiscoveryengineV1TargetSite[];
        /**
         * The total number of items matching the request. This will always be populated in the response.
         */
        totalSize?: number | null;
    }
    /**
     * Response message for UserLicenseService.ListUserLicenses.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ListUserLicensesResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * All the customer's UserLicenses.
         */
        userLicenses?: Schema$GoogleCloudDiscoveryengineV1UserLicense[];
    }
    /**
     * Media-specific user event information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1MediaInfo {
        /**
         * The media progress time in seconds, if applicable. For example, if the end user has finished 90 seconds of a playback video, then MediaInfo.media_progress_duration.seconds should be set to 90.
         */
        mediaProgressDuration?: string | null;
        /**
         * Media progress should be computed using only the media_progress_duration relative to the media total length. This value must be between `[0, 1.0]` inclusive. If this is not a playback or the progress cannot be computed (e.g. ongoing livestream), this field should be unset.
         */
        mediaProgressPercentage?: number | null;
    }
    /**
     * Detailed page information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PageInfo {
        /**
         * The most specific category associated with a category page. To represent full path of category, use '\>' sign to separate different hierarchies. If '\>' is part of the category name, replace it with other character(s). Category pages include special pages such as sales or promotions. For instance, a special sale page may have the category hierarchy: `"pageCategory" : "Sales \> 2017 Black Friday Deals"`. Required for `view-category-page` events. Other event types should not set this field. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        pageCategory?: string | null;
        /**
         * A unique ID of a web page view. This should be kept the same for all user events triggered from the same pageview. For example, an item detail page view could trigger multiple events as the user is browsing the page. The `pageview_id` property should be kept the same for all these events so that they can be grouped together properly. When using the client side event reporting with JavaScript pixel and Google Tag Manager, this value is filled in automatically.
         */
        pageviewId?: string | null;
        /**
         * The referrer URL of the current page. When using the client side event reporting with JavaScript pixel and Google Tag Manager, this value is filled in automatically. However, some browser privacy restrictions may cause this field to be empty.
         */
        referrerUri?: string | null;
        /**
         * Complete URL (window.location.href) of the user's current page. When using the client side event reporting with JavaScript pixel and Google Tag Manager, this value is filled in automatically. Maximum length 5,000 characters.
         */
        uri?: string | null;
    }
    /**
     * Detailed panel information associated with a user event.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PanelInfo {
        /**
         * The display name of the panel.
         */
        displayName?: string | null;
        /**
         * Optional. The document IDs associated with this panel.
         */
        documents?: Schema$GoogleCloudDiscoveryengineV1DocumentInfo[];
        /**
         * Required. The panel ID.
         */
        panelId?: string | null;
        /**
         * The ordered position of the panel, if shown to the user with other panels. If set, then total_panels must also be set.
         */
        panelPosition?: number | null;
        /**
         * The total number of panels, including this one, shown to the user. Must be set if panel_position is set.
         */
        totalPanels?: number | null;
    }
    /**
     * Principal identifier of a user or a group.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Principal {
        /**
         * For 3P application identities which are not present in the customer identity provider.
         */
        externalEntityId?: string | null;
        /**
         * Group identifier. For Google Workspace user account, group_id should be the google workspace group email. For non-google identity provider user account, group_id is the mapped group identifier configured during the workforcepool config.
         */
        groupId?: string | null;
        /**
         * User identifier. For Google Workspace user account, user_id should be the google workspace user email. For non-google identity provider user account, user_id is the mapped user identifier configured during the workforcepool config.
         */
        userId?: string | null;
    }
    /**
     * Metadata and configurations for a Google Cloud project in the service.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Project {
        /**
         * Output only. The timestamp when this project is created.
         */
        createTime?: string | null;
        /**
         * Output only. Full resource name of the project, for example `projects/{project\}`. Note that when making requests, project number and project id are both acceptable, but the server will always respond in project number.
         */
        name?: string | null;
        /**
         * Output only. The timestamp when this project is successfully provisioned. Empty value means this project is still provisioning and is not ready for use.
         */
        provisionCompletionTime?: string | null;
        /**
         * Output only. A map of terms of services. The key is the `id` of ServiceTerms.
         */
        serviceTermsMap?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1ProjectServiceTerms;
        } | null;
    }
    /**
     * Metadata about the terms of service.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ProjectServiceTerms {
        /**
         * The last time when the project agreed to the terms of service.
         */
        acceptTime?: string | null;
        /**
         * The last time when the project declined or revoked the agreement to terms of service.
         */
        declineTime?: string | null;
        /**
         * The unique identifier of this terms of service. Available terms: * `GA_DATA_USE_TERMS`: [Terms for data use](https://cloud.google.com/retail/data-use-terms). When using this as `id`, the acceptable version to provide is `2022-11-23`.
         */
        id?: string | null;
        /**
         * Whether the project has accepted/rejected the service terms or it is still pending.
         */
        state?: string | null;
        /**
         * The version string of the terms of service. For acceptable values, see the comments for id above.
         */
        version?: string | null;
    }
    /**
     * Metadata associated with a project provision operation.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ProvisionProjectMetadata {
    }
    /**
     * Request for ProjectService.ProvisionProject method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ProvisionProjectRequest {
        /**
         * Required. Set to `true` to specify that caller has read and would like to give consent to the [Terms for data use](https://cloud.google.com/retail/data-use-terms).
         */
        acceptDataUseTerms?: boolean | null;
        /**
         * Required. The version of the [Terms for data use](https://cloud.google.com/retail/data-use-terms) that caller has read and would like to give consent to. Acceptable version is `2022-11-23`, and this may change over time.
         */
        dataUseTermsVersion?: string | null;
        /**
         * Optional. Parameters for Agentspace.
         */
        saasParams?: Schema$GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams;
    }
    /**
     * Parameters for Agentspace.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams {
        /**
         * Optional. Set to `true` to specify that caller has read and would like to give consent to the [Terms for Agent Space quality of service].
         */
        acceptBizQos?: boolean | null;
    }
    /**
     * Metadata related to the progress of the PurgeCompletionSuggestions operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for CompletionService.PurgeCompletionSuggestions method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsRequest {
    }
    /**
     * Response message for CompletionService.PurgeCompletionSuggestions method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Whether the completion suggestions were successfully purged.
         */
        purgeSucceeded?: boolean | null;
    }
    /**
     * Metadata related to the progress of the PurgeDocuments operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeDocumentsMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Count of entries that encountered errors while processing.
         */
        failureCount?: string | null;
        /**
         * Count of entries that were ignored as entries were not found.
         */
        ignoredCount?: string | null;
        /**
         * Count of entries that were deleted successfully.
         */
        successCount?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for DocumentService.PurgeDocuments method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeDocumentsRequest {
        /**
         * The desired location of errors incurred during the purge.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1PurgeErrorConfig;
        /**
         * Required. Filter matching documents to purge. Only currently supported value is `*` (all items).
         */
        filter?: string | null;
        /**
         * Actually performs the purge. If `force` is set to false, return the expected purge count without deleting any documents.
         */
        force?: boolean | null;
        /**
         * Cloud Storage location for the input content. Supported `data_schema`: * `document_id`: One valid Document.id per line.
         */
        gcsSource?: Schema$GoogleCloudDiscoveryengineV1GcsSource;
        /**
         * Inline source for the input content for purge.
         */
        inlineSource?: Schema$GoogleCloudDiscoveryengineV1PurgeDocumentsRequestInlineSource;
    }
    /**
     * The inline source for the input config for DocumentService.PurgeDocuments method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeDocumentsRequestInlineSource {
        /**
         * Required. A list of full resource name of documents to purge. In the format `projects/x/locations/x/collections/x/dataStores/x/branches/x/documents/x`. Recommended max of 100 items.
         */
        documents?: string[] | null;
    }
    /**
     * Response message for DocumentService.PurgeDocuments method. If the long running operation is successfully done, then this message is returned by the google.longrunning.Operations.response field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeDocumentsResponse {
        /**
         * The total count of documents purged as a result of the operation.
         */
        purgeCount?: string | null;
        /**
         * A sample of document names that will be deleted. Only populated if `force` is set to false. A max of 100 names will be returned and the names are chosen at random.
         */
        purgeSample?: string[] | null;
    }
    /**
     * Configuration of destination for Purge related errors.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeErrorConfig {
        /**
         * Cloud Storage prefix for purge errors. This must be an empty, existing Cloud Storage directory. Purge errors are written to sharded files in this directory, one per line, as a JSON-encoded `google.rpc.Status` message.
         */
        gcsPrefix?: string | null;
    }
    /**
     * Request message for IdentityMappingStoreService.PurgeIdentityMappings
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequest {
        /**
         * Filter matching identity mappings to purge. The eligible field for filtering is: * `update_time`: in ISO 8601 "zulu" format. * `external_id` Examples: * Deleting all identity mappings updated in a time range: `update_time \> "2012-04-23T18:25:43.511Z" AND update_time < "2012-04-23T18:30:43.511Z"` * Deleting all identity mappings for a given external_id: `external_id = "id1"` * Deleting all identity mappings inside an identity mapping store: `*` The filtering fields are assumed to have an implicit AND. Should not be used with source. An error will be thrown, if both are provided.
         */
        filter?: string | null;
        /**
         * Actually performs the purge. If `force` is set to false, return the expected purge count without deleting any identity mappings. This field is only supported for purge with filter. For input source this field is ignored and data will be purged regardless of the value of this field.
         */
        force?: boolean | null;
        /**
         * The inline source to purge identity mapping entries from.
         */
        inlineSource?: Schema$GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequestInlineSource;
    }
    /**
     * The inline source to purge identity mapping entries from.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeIdentityMappingsRequestInlineSource {
        /**
         * A maximum of 10000 entries can be purged at one time
         */
        identityMappingEntries?: Schema$GoogleCloudDiscoveryengineV1IdentityMappingEntry[];
    }
    /**
     * Metadata related to the progress of the PurgeSuggestionDenyListEntries operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for CompletionService.PurgeSuggestionDenyListEntries method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesRequest {
    }
    /**
     * Response message for CompletionService.PurgeSuggestionDenyListEntries method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeSuggestionDenyListEntriesResponse {
        /**
         * A sample of errors encountered while processing the request.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * Number of suggestion deny list entries purged.
         */
        purgeCount?: string | null;
    }
    /**
     * Request message for PurgeUserEvents method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1PurgeUserEventsRequest {
        /**
         * Required. The filter string to specify the events to be deleted with a length limit of 5,000 characters. The eligible fields for filtering are: * `eventType`: Double quoted UserEvent.event_type string. * `eventTime`: in ISO 8601 "zulu" format. * `userPseudoId`: Double quoted string. Specifying this will delete all events associated with a visitor. * `userId`: Double quoted string. Specifying this will delete all events associated with a user. Note: This API only supports purging a max range of 30 days. Examples: * Deleting all events in a time range: `eventTime \> "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z"` * Deleting specific eventType in a time range: `eventTime \> "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" eventType = "search"` * Deleting all events for a specific visitor in a time range: `eventTime \> "2012-04-23T18:25:43.511Z" eventTime < "2012-04-23T18:30:43.511Z" userPseudoId = "visitor1024"` * Deleting the past 30 days of events inside a DataStore: `*` The filtering fields are assumed to have an implicit AND.
         */
        filter?: string | null;
        /**
         * The `force` field is currently not supported. Purge user event requests will permanently delete all purgeable events. Once the development is complete: If `force` is set to false, the method will return the expected purge count without deleting any user events. This field will default to false if not included in the request.
         */
        force?: boolean | null;
    }
    /**
     * Defines a user inputed query.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Query {
        /**
         * Output only. Unique Id for the query.
         */
        queryId?: string | null;
        /**
         * Plain text.
         */
        text?: string | null;
    }
    /**
     * Record message for RankService.Rank method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1RankingRecord {
        /**
         * The content of the record. Empty by default. At least one of title or content should be set otherwise an INVALID_ARGUMENT error is thrown.
         */
        content?: string | null;
        /**
         * The unique ID to represent the record.
         */
        id?: string | null;
        /**
         * The score of this record based on the given query and selected model. The score will be rounded to 2 decimal places. If the score is close to 0, it will be rounded to 0.0001 to avoid returning unset.
         */
        score?: number | null;
        /**
         * The title of the record. Empty by default. At least one of title or content should be set otherwise an INVALID_ARGUMENT error is thrown.
         */
        title?: string | null;
    }
    /**
     * Request message for RankService.Rank method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1RankRequest {
        /**
         * If true, the response will contain only record ID and score. By default, it is false, the response will contain record details.
         */
        ignoreRecordDetailsInResponse?: boolean | null;
        /**
         * The identifier of the model to use. It is one of: * `semantic-ranker-512@latest`: Semantic ranking model with maximum input token size 512. It is set to `semantic-ranker-512@latest` by default if unspecified.
         */
        model?: string | null;
        /**
         * The query to use.
         */
        query?: string | null;
        /**
         * Required. A list of records to rank.
         */
        records?: Schema$GoogleCloudDiscoveryengineV1RankingRecord[];
        /**
         * The number of results to return. If this is unset or no bigger than zero, returns all results.
         */
        topN?: number | null;
        /**
         * The user labels applied to a resource must meet the following requirements: * Each resource can have multiple labels, up to a maximum of 64. * Each label must be a key-value pair. * Keys have a minimum length of 1 character and a maximum length of 63 characters and cannot be empty. Values can be empty and have a maximum length of 63 characters. * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. All characters must use UTF-8 encoding, and international characters are allowed. * The key portion of a label must be unique. However, you can use the same key with multiple resources. * Keys must start with a lowercase letter or international character. See [Google Cloud Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements) for more details.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Response message for RankService.Rank method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1RankResponse {
        /**
         * A list of records sorted by descending score.
         */
        records?: Schema$GoogleCloudDiscoveryengineV1RankingRecord[];
    }
    /**
     * Request message for Recommend method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1RecommendRequest {
        /**
         * Filter for restricting recommendation results with a length limit of 5,000 characters. Currently, only filter expressions on the `filter_tags` attribute is supported. Examples: * `(filter_tags: ANY("Red", "Blue") OR filter_tags: ANY("Hot", "Cold"))` * `(filter_tags: ANY("Red", "Blue")) AND NOT (filter_tags: ANY("Green"))` If `attributeFilteringSyntax` is set to true under the `params` field, then attribute-based expressions are expected instead of the above described tag-based syntax. Examples: * (language: ANY("en", "es")) AND NOT (categories: ANY("Movie")) * (available: true) AND (language: ANY("en", "es")) OR (categories: ANY("Movie")) If your filter blocks all results, the API returns generic (unfiltered) popular Documents. If you only want results strictly matching the filters, set `strictFiltering` to `true` in RecommendRequest.params to receive empty results instead. Note that the API never returns Documents with `storageStatus` as `EXPIRED` or `DELETED` regardless of filter choices.
         */
        filter?: string | null;
        /**
         * Maximum number of results to return. Set this property to the number of recommendation results needed. If zero, the service chooses a reasonable default. The maximum allowed value is 100. Values above 100 are set to 100.
         */
        pageSize?: number | null;
        /**
         * Additional domain specific parameters for the recommendations. Allowed values: * `returnDocument`: Boolean. If set to `true`, the associated Document object is returned in RecommendResponse.RecommendationResult.document. * `returnScore`: Boolean. If set to true, the recommendation score corresponding to each returned Document is set in RecommendResponse.RecommendationResult.metadata. The given score indicates the probability of a Document conversion given the user's context and history. * `strictFiltering`: Boolean. True by default. If set to `false`, the service returns generic (unfiltered) popular Documents instead of empty if your filter blocks all recommendation results. * `diversityLevel`: String. Default empty. If set to be non-empty, then it needs to be one of: * `no-diversity` * `low-diversity` * `medium-diversity` * `high-diversity` * `auto-diversity` This gives request-level control and adjusts recommendation results based on Document category. * `attributeFilteringSyntax`: Boolean. False by default. If set to true, the `filter` field is interpreted according to the new, attribute-based syntax.
         */
        params?: {
            [key: string]: any;
        } | null;
        /**
         * Required. Context about the user, what they are looking at and what action they took to trigger the Recommend request. Note that this user event detail won't be ingested to userEvent logs. Thus, a separate userEvent write request is required for event logging. Don't set UserEvent.user_pseudo_id or UserEvent.user_info.user_id to the same fixed ID for different users. If you are trying to receive non-personalized recommendations (not recommended; this can negatively impact model performance), instead set UserEvent.user_pseudo_id to a random unique ID and leave UserEvent.user_info.user_id unset.
         */
        userEvent?: Schema$GoogleCloudDiscoveryengineV1UserEvent;
        /**
         * The user labels applied to a resource must meet the following requirements: * Each resource can have multiple labels, up to a maximum of 64. * Each label must be a key-value pair. * Keys have a minimum length of 1 character and a maximum length of 63 characters and cannot be empty. Values can be empty and have a maximum length of 63 characters. * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. All characters must use UTF-8 encoding, and international characters are allowed. * The key portion of a label must be unique. However, you can use the same key with multiple resources. * Keys must start with a lowercase letter or international character. See [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements) for more details.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
        /**
         * Use validate only mode for this recommendation query. If set to `true`, a fake model is used that returns arbitrary Document IDs. Note that the validate only mode should only be used for testing the API, or if the model is not ready.
         */
        validateOnly?: boolean | null;
    }
    /**
     * Response message for Recommend method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1RecommendResponse {
        /**
         * A unique attribution token. This should be included in the UserEvent logs resulting from this recommendation, which enables accurate attribution of recommendation model performance.
         */
        attributionToken?: string | null;
        /**
         * IDs of documents in the request that were missing from the default Branch associated with the requested ServingConfig.
         */
        missingIds?: string[] | null;
        /**
         * A list of recommended Documents. The order represents the ranking (from the most relevant Document to the least).
         */
        results?: Schema$GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult[];
        /**
         * True if RecommendRequest.validate_only was set.
         */
        validateOnly?: boolean | null;
    }
    /**
     * RecommendationResult represents a generic recommendation result with associated metadata.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1RecommendResponseRecommendationResult {
        /**
         * Set if `returnDocument` is set to true in RecommendRequest.params.
         */
        document?: Schema$GoogleCloudDiscoveryengineV1Document;
        /**
         * Resource ID of the recommended Document.
         */
        id?: string | null;
        /**
         * Additional Document metadata or annotations. Possible values: * `score`: Recommendation score in double value. Is set if `returnScore` is set to true in RecommendRequest.params.
         */
        metadata?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Request message for SiteSearchEngineService.RecrawlUris method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1RecrawlUrisRequest {
        /**
         * Optional. Credential id to use for crawling.
         */
        siteCredential?: string | null;
        /**
         * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise an INVALID_ARGUMENT error is thrown. Each URI should match at least one TargetSite in `site_search_engine`.
         */
        uris?: string[] | null;
    }
    /**
     * Defines a reply message to user.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Reply {
        /**
         * Summary based on search results.
         */
        summary?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummary;
    }
    /**
     * Safety rating corresponding to the generated content.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SafetyRating {
        /**
         * Output only. Indicates whether the content was filtered out because of this rating.
         */
        blocked?: boolean | null;
        /**
         * Output only. Harm category.
         */
        category?: string | null;
        /**
         * Output only. Harm probability levels in the content.
         */
        probability?: string | null;
        /**
         * Output only. Harm probability score.
         */
        probabilityScore?: number | null;
        /**
         * Output only. Harm severity levels in the content.
         */
        severity?: string | null;
        /**
         * Output only. Harm severity score.
         */
        severityScore?: number | null;
    }
    /**
     * Defines the structure and layout of a type of document data.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Schema {
        /**
         * The JSON representation of the schema.
         */
        jsonSchema?: string | null;
        /**
         * Immutable. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string | null;
        /**
         * The structured representation of the schema.
         */
        structSchema?: {
            [key: string]: any;
        } | null;
    }
    /**
     * Detailed search information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchInfo {
        /**
         * An integer that specifies the current offset for pagination (the 0-indexed starting location, amongst the products deemed by the API as relevant). See SearchRequest.offset for definition. If this field is negative, an `INVALID_ARGUMENT` is returned. This can only be set for `search` events. Other event types should not set this field. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        offset?: number | null;
        /**
         * The order in which products are returned, if applicable. See SearchRequest.order_by for definition and syntax. The value must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. This can only be set for `search` events. Other event types should not set this field. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        orderBy?: string | null;
        /**
         * The user's search query. See SearchRequest.query for definition. The value must be a UTF-8 encoded string with a length limit of 5,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. At least one of search_query or PageInfo.page_category is required for `search` events. Other event types should not set this field. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        searchQuery?: string | null;
    }
    /**
     * Promotion proto includes uri and other helping information to display the promotion.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchLinkPromotion {
        /**
         * Optional. The Promotion description. Maximum length: 200 characters.
         */
        description?: string | null;
        /**
         * Optional. The Document the user wants to promote. For site search, leave unset and only populate uri. Can be set along with uri.
         */
        document?: string | null;
        /**
         * Optional. The enabled promotion will be returned for any serving configs associated with the parent of the control this promotion is attached to. This flag is used for basic site search only.
         */
        enabled?: boolean | null;
        /**
         * Optional. The promotion thumbnail image url.
         */
        imageUri?: string | null;
        /**
         * Required. The title of the promotion. Maximum length: 160 characters.
         */
        title?: string | null;
        /**
         * Optional. The URL for the page the user wants to promote. Must be set for site search. For other verticals, this is optional.
         */
        uri?: string | null;
    }
    /**
     * Request message for SearchService.Search method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequest {
        /**
         * Boost specification to boost certain documents. For more information on boosting, see [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpec;
        /**
         * The branch resource name, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store/branches/0`. Use `default_branch` as the branch ID or leave this field empty, to search documents under the default branch.
         */
        branch?: string | null;
        /**
         * The default filter that is applied when a user performs a search without checking any filters on the search page. The filter applied to every search request when quality improvement such as query expansion is needed. In the case a query does not have a sufficient amount of results this filter will be used to determine whether or not to enable the query expansion flow. The original filter will still be used for the query expanded search. This field is strongly recommended to achieve high search quality. For more information about filter syntax, see SearchRequest.filter.
         */
        canonicalFilter?: string | null;
        /**
         * A specification for configuring the behavior of content search.
         */
        contentSearchSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec;
        /**
         * Specifications that define the specific DataStores to be searched, along with configurations for those data stores. This is only considered for Engines with multiple data stores. For engines with a single data store, the specs directly under SearchRequest should be used.
         */
        dataStoreSpecs?: Schema$GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec[];
        /**
         * Optional. Config for display feature, like match highlighting on search results.
         */
        displaySpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestDisplaySpec;
        /**
         * Facet specifications for faceted search. If empty, no facets are returned. A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        facetSpecs?: Schema$GoogleCloudDiscoveryengineV1SearchRequestFacetSpec[];
        /**
         * The filter syntax consists of an expression language for constructing a predicate from one or more fields of the documents being filtered. Filter expression is case-sensitive. If this field is unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI Search is done by mapping the LHS filter key to a key property defined in the Vertex AI Search backend -- this mapping is defined by the customer in their schema. For example a media customer might have a field 'name' in their schema. In this case the filter would look like this: filter --\> name:'ANY("king kong")' For more information about filtering including syntax and filter operators, see [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
        /**
         * Raw image query.
         */
        imageQuery?: Schema$GoogleCloudDiscoveryengineV1SearchRequestImageQuery;
        /**
         * The BCP-47 language code, such as "en-US" or "sr-Latn". For more information, see [Standard fields](https://cloud.google.com/apis/design/standard_fields). This field helps to better interpret the query. If a value isn't specified, the query language code is automatically detected, which may not be accurate.
         */
        languageCode?: string | null;
        /**
         * A 0-indexed integer that specifies the current offset (that is, starting result location, amongst the Documents deemed by the API as relevant) in search results. This field is only considered if page_token is unset. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        offset?: number | null;
        /**
         * The maximum number of results to return for OneBox. This applies to each OneBox type individually. Default number is 10.
         */
        oneBoxPageSize?: number | null;
        /**
         * The order in which documents are returned. Documents can be ordered by a field in an Document object. Leave it unset if ordered by relevance. `order_by` expression is case-sensitive. For more information on ordering the website search results, see [Order web search results](https://cloud.google.com/generative-ai-app-builder/docs/order-web-search-results). For more information on ordering the healthcare search results, see [Order healthcare search results](https://cloud.google.com/generative-ai-app-builder/docs/order-hc-results). If this field is unrecognizable, an `INVALID_ARGUMENT` is returned.
         */
        orderBy?: string | null;
        /**
         * Maximum number of Documents to return. The maximum allowed value depends on the data type. Values above the maximum value are coerced to the maximum value. * Websites with basic indexing: Default `10`, Maximum `25`. * Websites with advanced indexing: Default `25`, Maximum `50`. * Other: Default `50`, Maximum `100`. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        pageSize?: number | null;
        /**
         * A page token received from a previous SearchService.Search call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to SearchService.Search must match the call that provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        pageToken?: string | null;
        /**
         * Additional search parameters. For public website search only, supported values are: * `user_country_code`: string. Default empty. If set to non-empty, results are restricted or boosted based on the location provided. For example, `user_country_code: "au"` For available codes see [Country Codes](https://developers.google.com/custom-search/docs/json_api_reference#countryCodes) * `search_type`: double. Default empty. Enables non-webpage searching depending on the value. The only valid non-default value is 1, which enables image searching. For example, `search_type: 1`
         */
        params?: {
            [key: string]: any;
        } | null;
        /**
         * Raw search query.
         */
        query?: string | null;
        /**
         * The query expansion specification that specifies the conditions under which query expansion occurs.
         */
        queryExpansionSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec;
        /**
         * Optional. The ranking expression controls the customized ranking on retrieval documents. This overrides ServingConfig.ranking_expression. The syntax and supported features depend on the `ranking_expression_backend` value. If `ranking_expression_backend` is not provided, it defaults to `RANK_BY_EMBEDDING`. If ranking_expression_backend is not provided or set to `RANK_BY_EMBEDDING`, it should be a single function or multiple functions that are joined by "+". * ranking_expression = function, { " + ", function \}; Supported functions: * double * relevance_score * double * dotProduct(embedding_field_path) Function variables: * `relevance_score`: pre-defined keywords, used for measure relevance between query and document. * `embedding_field_path`: the document embedding field used with query embedding vector. * `dotProduct`: embedding function between `embedding_field_path` and query embedding vector. Example ranking expression: If document has an embedding field doc_embedding, the ranking expression could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`. If ranking_expression_backend is set to `RANK_BY_FORMULA`, the following expression types (and combinations of those chained using + or * operators) are supported: * `double` * `signal` * `log(signal)` * `exp(signal)` * `rr(signal, double \> 0)` -- reciprocal rank transformation with second argument being a denominator constant. * `is_nan(signal)` -- returns 0 if signal is NaN, 1 otherwise. * `fill_nan(signal1, signal2 | double)` -- if signal1 is NaN, returns signal2 | double, else returns signal1. Here are a few examples of ranking formulas that use the supported ranking expression types: - `0.2 * semantic_similarity_score + 0.8 * log(keyword_similarity_score)` -- mostly rank by the logarithm of `keyword_similarity_score` with slight `semantic_smilarity_score` adjustment. - `0.2 * exp(fill_nan(semantic_similarity_score, 0)) + 0.3 * is_nan(keyword_similarity_score)` -- rank by the exponent of `semantic_similarity_score` filling the value with 0 if it's NaN, also add constant 0.3 adjustment to the final score if `semantic_similarity_score` is NaN. - `0.2 * rr(semantic_similarity_score, 16) + 0.8 * rr(keyword_similarity_score, 16)` -- mostly rank by the reciprocal rank of `keyword_similarity_score` with slight adjustment of reciprocal rank of `semantic_smilarity_score`. The following signals are supported: * `semantic_similarity_score`: semantic similarity adjustment that is calculated using the embeddings generated by a proprietary Google model. This score determines how semantically similar a search query is to a document. * `keyword_similarity_score`: keyword match adjustment uses the Best Match 25 (BM25) ranking function. This score is calculated using a probabilistic model to estimate the probability that a document is relevant to a given query. * `relevance_score`: semantic relevance adjustment that uses a proprietary Google model to determine the meaning and intent behind a user's query in context with the content in the documents. * `pctr_rank`: predicted conversion rate adjustment as a rank use predicted Click-through rate (pCTR) to gauge the relevance and attractiveness of a search result from a user's perspective. A higher pCTR suggests that the result is more likely to satisfy the user's query and intent, making it a valuable signal for ranking. * `freshness_rank`: freshness adjustment as a rank * `document_age`: The time in hours elapsed since the document was last updated, a floating-point number (e.g., 0.25 means 15 minutes). * `topicality_rank`: topicality adjustment as a rank. Uses proprietary Google model to determine the keyword-based overlap between the query and the document. * `base_rank`: the default rank of the result
         */
        rankingExpression?: string | null;
        /**
         * Optional. The backend to use for the ranking expression evaluation.
         */
        rankingExpressionBackend?: string | null;
        /**
         * Optional. The specification for returning the relevance score.
         */
        relevanceScoreSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestRelevanceScoreSpec;
        /**
         * The relevance threshold of the search results. Default to Google defined threshold, leveraging a balance of precision and recall to deliver both highly accurate results and comprehensive coverage of relevant information. This feature is not supported for healthcare search.
         */
        relevanceThreshold?: string | null;
        /**
         * Whether to turn on safe search. This is only supported for website search.
         */
        safeSearch?: boolean | null;
        /**
         * Search as you type configuration. Only supported for the IndustryVertical.MEDIA vertical.
         */
        searchAsYouTypeSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec;
        /**
         * The session resource name. Optional. Session allows users to do multi-turn /search API calls or coordination between /search API calls and /answer API calls. Example #1 (multi-turn /search API calls): Call /search API with the session ID generated in the first call. Here, the previous search query gets considered in query standing. I.e., if the first query is "How did Alphabet do in 2022?" and the current query is "How about 2023?", the current query will be interpreted as "How did Alphabet do in 2023?". Example #2 (coordination between /search API calls and /answer API calls): Call /answer API with the session ID generated in the first call. Here, the answer generation happens in the context of the search results from the first search call. Multi-turn Search feature is currently at private GA stage. Please use v1alpha or v1beta version instead before we launch this feature to public GA. Or ask for allowlisting through Google Support team.
         */
        session?: string | null;
        /**
         * Session specification. Can be used only when `session` is set.
         */
        sessionSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestSessionSpec;
        /**
         * The spell correction specification that specifies the mode under which spell correction takes effect.
         */
        spellCorrectionSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec;
        /**
         * Information about the end user. Highly recommended for analytics and personalization. UserInfo.user_agent is used to deduce `device_type` for analytics.
         */
        userInfo?: Schema$GoogleCloudDiscoveryengineV1UserInfo;
        /**
         * The user labels applied to a resource must meet the following requirements: * Each resource can have multiple labels, up to a maximum of 64. * Each label must be a key-value pair. * Keys have a minimum length of 1 character and a maximum length of 63 characters and cannot be empty. Values can be empty and have a maximum length of 63 characters. * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. All characters must use UTF-8 encoding, and international characters are allowed. * The key portion of a label must be unique. However, you can use the same key with multiple resources. * Keys must start with a lowercase letter or international character. See [Google Cloud Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements) for more details.
         */
        userLabels?: {
            [key: string]: string;
        } | null;
        /**
         * A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. This field should NOT have a fixed value such as `unknown_visitor`. This should be the same identifier as UserEvent.user_pseudo_id and CompleteQueryRequest.user_pseudo_id The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        userPseudoId?: string | null;
    }
    /**
     * Boost specification to boost certain documents.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpec {
        /**
         * Condition boost specifications. If a document matches multiple conditions in the specifications, boost scores from these specifications are all applied and combined in a non-linear way. Maximum number of specifications is 20.
         */
        conditionBoostSpecs?: Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec[];
    }
    /**
     * Boost applies to documents which match a condition.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpec {
        /**
         * Strength of the condition boost, which should be in [-1, 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the document a big promotion. However, it does not necessarily mean that the boosted document will be the top result at all times, nor that other documents will be excluded. Results could still be shown even when none of them matches the condition. And results that are significantly more relevant to the search query can still trump your heavily favored but irrelevant documents. Setting to -1.0 gives the document a big demotion. However, results that are deeply relevant might still be shown. The document will have an upstream battle to get a fairly high ranking, but it is not blocked out completely. Setting to 0.0 means no boost applied. The boosting condition is ignored. Only one of the (condition, boost) combination or the boost_control_spec below are set. If both are set then the global boost is ignored and the more fine-grained boost_control_spec is applied.
         */
        boost?: number | null;
        /**
         * Complex specification for custom ranking based on customer defined attribute value.
         */
        boostControlSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpec;
        /**
         * An expression which specifies a boost condition. The syntax and supported fields are the same as a filter expression. See SearchRequest.filter for detail syntax and limitations. Examples: * To boost documents with document ID "doc_1" or "doc_2", and color "Red" or "Blue": `(document_id: ANY("doc_1", "doc_2")) AND (color: ANY("Red", "Blue"))`
         */
        condition?: string | null;
    }
    /**
     * Specification for custom ranking based on customer specified attribute value. It provides more controls for customized ranking than the simple (condition, boost) combination above.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpec {
        /**
         * The attribute type to be used to determine the boost amount. The attribute value can be derived from the field value of the specified field_name. In the case of numerical it is straightforward i.e. attribute_value = numerical_field_value. In the case of freshness however, attribute_value = (time.now() - datetime_field_value).
         */
        attributeType?: string | null;
        /**
         * The control points used to define the curve. The monotonic function (defined through the interpolation_type above) passes through the control points listed here.
         */
        controlPoints?: Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint[];
        /**
         * The name of the field whose value will be used to determine the boost amount.
         */
        fieldName?: string | null;
        /**
         * The interpolation type to be applied to connect the control points listed below.
         */
        interpolationType?: string | null;
    }
    /**
     * The control points used to define the curve. The curve defined through these control points can only be monotonically increasing or decreasing(constant values are acceptable).
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpecConditionBoostSpecBoostControlSpecControlPoint {
        /**
         * Can be one of: 1. The numerical field value. 2. The duration spec for freshness: The value must be formatted as an XSD `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value). The pattern for this is: `nDnM]`.
         */
        attributeValue?: string | null;
        /**
         * The value between -1 to 1 by which to boost the score if the attribute_value evaluates to the value specified above.
         */
        boostAmount?: number | null;
    }
    /**
     * A specification for configuring the behavior of content search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec {
        /**
         * Specifies the chunk spec to be returned from the search response. Only available if the SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS
         */
        chunkSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec;
        /**
         * If there is no extractive_content_spec provided, there will be no extractive answer in the search response.
         */
        extractiveContentSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec;
        /**
         * Specifies the search result mode. If unspecified, the search result mode defaults to `DOCUMENTS`.
         */
        searchResultMode?: string | null;
        /**
         * If `snippetSpec` is not specified, snippets are not included in the search response.
         */
        snippetSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec;
        /**
         * If `summarySpec` is not specified, summaries are not included in the search response.
         */
        summarySpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec;
    }
    /**
     * Specifies the chunk spec to be returned from the search response. Only available if the SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecChunkSpec {
        /**
         * The number of next chunks to be returned of the current chunk. The maximum allowed value is 3. If not specified, no next chunks will be returned.
         */
        numNextChunks?: number | null;
        /**
         * The number of previous chunks to be returned of the current chunk. The maximum allowed value is 3. If not specified, no previous chunks will be returned.
         */
        numPreviousChunks?: number | null;
    }
    /**
     * A specification for configuring the extractive content in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecExtractiveContentSpec {
        /**
         * The maximum number of extractive answers returned in each search result. An extractive answer is a verbatim answer extracted from the original document, which provides a precise and contextually relevant answer to the search query. If the number of matching answers is less than the `max_extractive_answer_count`, return all of the answers. Otherwise, return the `max_extractive_answer_count`. At most five answers are returned for each SearchResult.
         */
        maxExtractiveAnswerCount?: number | null;
        /**
         * The max number of extractive segments returned in each search result. Only applied if the DataStore is set to DataStore.ContentConfig.CONTENT_REQUIRED or DataStore.solution_types is SOLUTION_TYPE_CHAT. An extractive segment is a text segment extracted from the original document that is relevant to the search query, and, in general, more verbose than an extractive answer. The segment could then be used as input for LLMs to generate summaries and answers. If the number of matching segments is less than `max_extractive_segment_count`, return all of the segments. Otherwise, return the `max_extractive_segment_count`.
         */
        maxExtractiveSegmentCount?: number | null;
        /**
         * Return at most `num_next_segments` segments after each selected segments.
         */
        numNextSegments?: number | null;
        /**
         * Specifies whether to also include the adjacent from each selected segments. Return at most `num_previous_segments` segments before each selected segments.
         */
        numPreviousSegments?: number | null;
        /**
         * Specifies whether to return the confidence score from the extractive segments in each search result. This feature is available only for new or allowlisted data stores. To allowlist your data store, contact your Customer Engineer. The default value is `false`.
         */
        returnExtractiveSegmentScore?: boolean | null;
    }
    /**
     * A specification for configuring snippets in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSnippetSpec {
        /**
         * [DEPRECATED] This field is deprecated. To control snippet return, use `return_snippet` field. For backwards compatibility, we will return snippet if max_snippet_count \> 0.
         */
        maxSnippetCount?: number | null;
        /**
         * [DEPRECATED] This field is deprecated and will have no affect on the snippet.
         */
        referenceOnly?: boolean | null;
        /**
         * If `true`, then return snippet. If no snippet can be generated, we return "No snippet is available for this page." A `snippet_status` with `SUCCESS` or `NO_SNIPPET_AVAILABLE` will also be returned.
         */
        returnSnippet?: boolean | null;
    }
    /**
     * A specification for configuring a summary returned in a search response.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpec {
        /**
         * Specifies whether to filter out adversarial queries. The default value is `false`. Google employs search-query classification to detect adversarial queries. No summary is returned if the search query is classified as an adversarial query. For example, a user might ask a question regarding negative comments about the company or submit a query designed to generate unsafe, policy-violating output. If this field is set to `true`, we skip generating summaries for adversarial queries and return fallback messages instead.
         */
        ignoreAdversarialQuery?: boolean | null;
        /**
         * Optional. Specifies whether to filter out jail-breaking queries. The default value is `false`. Google employs search-query classification to detect jail-breaking queries. No summary is returned if the search query is classified as a jail-breaking query. A user might add instructions to the query to change the tone, style, language, content of the answer, or ask the model to act as a different entity, e.g. "Reply in the tone of a competing company's CEO". If this field is set to `true`, we skip generating summaries for jail-breaking queries and return fallback messages instead.
         */
        ignoreJailBreakingQuery?: boolean | null;
        /**
         * Specifies whether to filter out queries that have low relevance. The default value is `false`. If this field is set to `false`, all search results are used regardless of relevance to generate answers. If set to `true`, only queries with high relevance search results will generate answers.
         */
        ignoreLowRelevantContent?: boolean | null;
        /**
         * Specifies whether to filter out queries that are not summary-seeking. The default value is `false`. Google employs search-query classification to detect summary-seeking queries. No summary is returned if the search query is classified as a non-summary seeking query. For example, `why is the sky blue` and `Who is the best soccer player in the world?` are summary-seeking queries, but `SFO airport` and `world cup 2026` are not. They are most likely navigational queries. If this field is set to `true`, we skip generating summaries for non-summary seeking queries and return fallback messages instead.
         */
        ignoreNonSummarySeekingQuery?: boolean | null;
        /**
         * Specifies whether to include citations in the summary. The default value is `false`. When this field is set to `true`, summaries include in-line citation numbers. Example summary including citations: BigQuery is Google Cloud's fully managed and completely serverless enterprise data warehouse [1]. BigQuery supports all data types, works across clouds, and has built-in machine learning and business intelligence, all within a unified platform [2, 3]. The citation numbers refer to the returned search results and are 1-indexed. For example, [1] means that the sentence is attributed to the first search result. [2, 3] means that the sentence is attributed to both the second and third search results.
         */
        includeCitations?: boolean | null;
        /**
         * Language code for Summary. Use language tags defined by [BCP47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Note: This is an experimental feature.
         */
        languageCode?: string | null;
        /**
         * If specified, the spec will be used to modify the prompt provided to the LLM.
         */
        modelPromptSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec;
        /**
         * If specified, the spec will be used to modify the model specification provided to the LLM.
         */
        modelSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec;
        /**
         * The number of top results to generate the summary from. If the number of results returned is less than `summaryResultCount`, the summary is generated from all of the results. At most 10 results for documents mode, or 50 for chunks mode, can be used to generate a summary. The chunks mode is used when SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
         */
        summaryResultCount?: number | null;
        /**
         * If true, answer will be generated from most relevant chunks from top search results. This feature will improve summary quality. Note that with this feature enabled, not all top search results will be referenced and included in the reference list, so the citation source index only points to the search results listed in the reference list.
         */
        useSemanticChunks?: boolean | null;
    }
    /**
     * Specification of the prompt to use with the model.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelPromptSpec {
        /**
         * Text at the beginning of the prompt that instructs the assistant. Examples are available in the user guide.
         */
        preamble?: string | null;
    }
    /**
     * Specification of the model.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpecSummarySpecModelSpec {
        /**
         * The model version used to generate the summary. Supported values are: * `stable`: string. Default value when no value is specified. Uses a generally available, fine-tuned model. For more information, see [Answer generation model versions and lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models). * `preview`: string. (Public preview) Uses a preview model. For more information, see [Answer generation model versions and lifecycle](https://cloud.google.com/generative-ai-app-builder/docs/answer-generation-models).
         */
        version?: string | null;
    }
    /**
     * A struct to define data stores to filter on in a search call and configurations for those data stores. Otherwise, an `INVALID_ARGUMENT` error is returned.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec {
        /**
         * Optional. Boost specification to boost certain documents. For more information on boosting, see [Boosting](https://cloud.google.com/generative-ai-app-builder/docs/boost-search-results)
         */
        boostSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestBoostSpec;
        /**
         * Optional. Custom search operators which if specified will be used to filter results from workspace data stores. For more information on custom search operators, see [SearchOperators](https://support.google.com/cloudsearch/answer/6172299).
         */
        customSearchOperators?: string | null;
        /**
         * Required. Full resource name of DataStore, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. The path must include the project number, project id is not supported for this field.
         */
        dataStore?: string | null;
        /**
         * Optional. Filter specification to filter documents in the data store specified by data_store field. For more information on filtering, see [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
    }
    /**
     * Specifies features for display, like match highlighting.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestDisplaySpec {
        /**
         * The condition under which match highlighting should occur.
         */
        matchHighlightingCondition?: string | null;
    }
    /**
     * A facet specification to perform faceted search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestFacetSpec {
        /**
         * Enables dynamic position for this facet. If set to true, the position of this facet among all facets in the response is determined automatically. If dynamic facets are enabled, it is ordered together. If set to false, the position of this facet in the response is the same as in the request, and it is ranked before the facets with dynamic position enable and all dynamic facets. For example, you may always want to have rating facet returned in the response, but it's not necessarily to always display the rating facet at the top. In that case, you can set enable_dynamic_position to true so that the position of rating facet in response is determined automatically. Another example, assuming you have the following facets in the request: * "rating", enable_dynamic_position = true * "price", enable_dynamic_position = false * "brands", enable_dynamic_position = false And also you have a dynamic facets enabled, which generates a facet `gender`. Then the final order of the facets in the response can be ("price", "brands", "rating", "gender") or ("price", "brands", "gender", "rating") depends on how API orders "gender" and "rating" facets. However, notice that "price" and "brands" are always ranked at first and second position because their enable_dynamic_position is false.
         */
        enableDynamicPosition?: boolean | null;
        /**
         * List of keys to exclude when faceting. By default, FacetKey.key is not excluded from the filter unless it is listed in this field. Listing a facet key in this field allows its values to appear as facet results, even when they are filtered out of search results. Using this field does not affect what search results are returned. For example, suppose there are 100 documents with the color facet "Red" and 200 documents with the color facet "Blue". A query containing the filter "color:ANY("Red")" and having "color" as FacetKey.key would by default return only "Red" documents in the search results, and also return "Red" with count 100 as the only color facet. Although there are also blue documents available, "Blue" would not be shown as an available facet value. If "color" is listed in "excludedFilterKeys", then the query returns the facet values "Red" with count 100 and "Blue" with count 200, because the "color" key is now excluded from the filter. Because this field doesn't affect search results, the search results are still correctly filtered to return only "Red" documents. A maximum of 100 values are allowed. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        excludedFilterKeys?: string[] | null;
        /**
         * Required. The facet key specification.
         */
        facetKey?: Schema$GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey;
        /**
         * Maximum facet values that are returned for this facet. If unspecified, defaults to 20. The maximum allowed value is 300. Values above 300 are coerced to 300. For aggregation in healthcare search, when the [FacetKey.key] is "healthcare_aggregation_key", the limit will be overridden to 10,000 internally, regardless of the value set here. If this field is negative, an `INVALID_ARGUMENT` is returned.
         */
        limit?: number | null;
    }
    /**
     * Specifies how a facet is computed.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestFacetSpecFacetKey {
        /**
         * True to make facet keys case insensitive when getting faceting values with prefixes or contains; false otherwise.
         */
        caseInsensitive?: boolean | null;
        /**
         * Only get facet values that contain the given strings. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "contains" to "2022", the "category" facet only contains "Action \> 2022" and "Sci-Fi \> 2022". Only supported on textual fields. Maximum is 10.
         */
        contains?: string[] | null;
        /**
         * Set only if values should be bucketed into intervals. Must be set for facets with numerical values. Must not be set for facet with text values. Maximum number of intervals is 30.
         */
        intervals?: Schema$GoogleCloudDiscoveryengineV1Interval[];
        /**
         * Required. Supported textual and numerical facet keys in Document object, over which the facet values are computed. Facet key is case-sensitive.
         */
        key?: string | null;
        /**
         * The order in which documents are returned. Allowed values are: * "count desc", which means order by SearchResponse.Facet.values.count descending. * "value desc", which means order by SearchResponse.Facet.values.value descending. Only applies to textual facets. If not set, textual values are sorted in [natural order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical intervals are sorted in the order given by FacetSpec.FacetKey.intervals.
         */
        orderBy?: string | null;
        /**
         * Only get facet values that start with the given string prefix. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "prefixes" to "Action", the "category" facet only contains "Action \> 2022" and "Action \> 2021". Only supported on textual fields. Maximum is 10.
         */
        prefixes?: string[] | null;
        /**
         * Only get facet for the given restricted values. Only supported on textual fields. For example, suppose "category" has three values "Action \> 2022", "Action \> 2021" and "Sci-Fi \> 2022". If set "restricted_values" to "Action \> 2022", the "category" facet only contains "Action \> 2022". Only supported on textual fields. Maximum is 10.
         */
        restrictedValues?: string[] | null;
    }
    /**
     * Specifies the image query input.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestImageQuery {
        /**
         * Base64 encoded image bytes. Supported image formats: JPEG, PNG, and BMP.
         */
        imageBytes?: string | null;
    }
    /**
     * Specification to determine under which conditions query expansion should occur.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestQueryExpansionSpec {
        /**
         * The condition under which query expansion should occur. Default to Condition.DISABLED.
         */
        condition?: string | null;
        /**
         * Whether to pin unexpanded results. If this field is set to true, unexpanded products are always at the top of the search results, followed by the expanded results.
         */
        pinUnexpandedResults?: boolean | null;
    }
    /**
     * The specification for returning the document relevance score.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestRelevanceScoreSpec {
        /**
         * Optional. Whether to return the relevance score for search results. The higher the score, the more relevant the document is to the query.
         */
        returnRelevanceScore?: boolean | null;
    }
    /**
     * Specification for search as you type in search requests.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestSearchAsYouTypeSpec {
        /**
         * The condition under which search as you type should occur. Default to Condition.DISABLED.
         */
        condition?: string | null;
    }
    /**
     * Session specification. Multi-turn Search feature is currently at private GA stage. Please use v1alpha or v1beta version instead before we launch this feature to public GA. Or ask for allowlisting through Google Support team.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestSessionSpec {
        /**
         * If set, the search result gets stored to the "turn" specified by this query ID. Example: Let's say the session looks like this: session { name: ".../sessions/xxx" turns { query { text: "What is foo?" query_id: ".../questions/yyy" \} answer: "Foo is ..." \} turns { query { text: "How about bar then?" query_id: ".../questions/zzz" \} \} \} The user can call /search API with a request like this: session: ".../sessions/xxx" session_spec { query_id: ".../questions/zzz" \} Then, the API stores the search result, associated with the last turn. The stored search result can be used by a subsequent /answer API call (with the session ID and the query ID specified). Also, it is possible to call /search and /answer in parallel with the same session ID & query ID.
         */
        queryId?: string | null;
        /**
         * The number of top search results to persist. The persisted search results can be used for the subsequent /answer api call. This field is similar to the `summary_result_count` field in SearchRequest.ContentSearchSpec.SummarySpec.summary_result_count. At most 10 results for documents mode, or 50 for chunks mode.
         */
        searchResultPersistenceCount?: number | null;
    }
    /**
     * The specification for query spell correction.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchRequestSpellCorrectionSpec {
        /**
         * The mode under which spell correction replaces the original search query. Defaults to Mode.AUTO.
         */
        mode?: string | null;
    }
    /**
     * Response message for SearchService.Search method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponse {
        /**
         * A unique search token. This should be included in the UserEvent logs resulting from this search, which enables accurate attribution of search model performance. This also helps to identify a request during the customer support scenarios.
         */
        attributionToken?: string | null;
        /**
         * Contains the spell corrected query, if found. If the spell correction type is AUTOMATIC, then the search results are based on corrected_query. Otherwise the original query is used for search.
         */
        correctedQuery?: string | null;
        /**
         * Results of facets requested by user.
         */
        facets?: Schema$GoogleCloudDiscoveryengineV1SearchResponseFacet[];
        /**
         * A token that can be sent as SearchRequest.page_token to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * Query expansion information for the returned results.
         */
        queryExpansionInfo?: Schema$GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo;
        /**
         * The URI of a customer-defined redirect page. If redirect action is triggered, no search is performed, and only redirect_uri and attribution_token are set in the response.
         */
        redirectUri?: string | null;
        /**
         * A list of matched documents. The order represents the ranking.
         */
        results?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSearchResult[];
        /**
         * Promotions for site search.
         */
        searchLinkPromotions?: Schema$GoogleCloudDiscoveryengineV1SearchLinkPromotion[];
        /**
         * Session information. Only set if SearchRequest.session is provided. See its description for more details.
         */
        sessionInfo?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSessionInfo;
        /**
         * A summary as part of the search results. This field is only returned if SearchRequest.ContentSearchSpec.summary_spec is set.
         */
        summary?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummary;
        /**
         * The estimated total count of matched items irrespective of pagination. The count of results returned by pagination may be less than the total_size that matches.
         */
        totalSize?: number | null;
    }
    /**
     * A facet result.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseFacet {
        /**
         * Whether the facet is dynamically generated.
         */
        dynamicFacet?: boolean | null;
        /**
         * The key for this facet. For example, `"colors"` or `"price"`. It matches SearchRequest.FacetSpec.FacetKey.key.
         */
        key?: string | null;
        /**
         * The facet values for this field.
         */
        values?: Schema$GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue[];
    }
    /**
     * A facet value which contains value names and their count.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseFacetFacetValue {
        /**
         * Number of items that have this facet value.
         */
        count?: string | null;
        /**
         * Interval value for a facet, such as 10, 20) for facet "price". It matches [SearchRequest.FacetSpec.FacetKey.intervals.
         */
        interval?: Schema$GoogleCloudDiscoveryengineV1Interval;
        /**
         * Text value of a facet, such as "Black" for facet "colors".
         */
        value?: string | null;
    }
    /**
     * Information describing query expansion including whether expansion has occurred.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseQueryExpansionInfo {
        /**
         * Bool describing whether query expansion has occurred.
         */
        expandedQuery?: boolean | null;
        /**
         * Number of pinned results. This field will only be set when expansion happens and SearchRequest.QueryExpansionSpec.pin_unexpanded_results is set to true.
         */
        pinnedResultCount?: string | null;
    }
    /**
     * Represents the search results.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSearchResult {
        /**
         * The chunk data in the search response if the SearchRequest.ContentSearchSpec.search_result_mode is set to CHUNKS.
         */
        chunk?: Schema$GoogleCloudDiscoveryengineV1Chunk;
        /**
         * The document data snippet in the search response. Only fields that are marked as `retrievable` are populated.
         */
        document?: Schema$GoogleCloudDiscoveryengineV1Document;
        /**
         * Document.id of the searched Document.
         */
        id?: string | null;
        /**
         * Output only. Google provided available scores.
         */
        modelScores?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1DoubleList;
        } | null;
        /**
         * Optional. A set of ranking signals associated with the result.
         */
        rankSignals?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals;
    }
    /**
     * A set of ranking signals.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignals {
        /**
         * Optional. Combined custom boosts for a doc.
         */
        boostingFactor?: number | null;
        /**
         * Optional. A list of custom clearbox signals.
         */
        customSignals?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal[];
        /**
         * Optional. The default rank of the result.
         */
        defaultRank?: number | null;
        /**
         * Optional. Age of the document in hours.
         */
        documentAge?: number | null;
        /**
         * Optional. Keyword matching adjustment.
         */
        keywordSimilarityScore?: number | null;
        /**
         * Optional. Predicted conversion rate adjustment as a rank.
         */
        pctrRank?: number | null;
        /**
         * Optional. Semantic relevance adjustment.
         */
        relevanceScore?: number | null;
        /**
         * Optional. Semantic similarity adjustment.
         */
        semanticSimilarityScore?: number | null;
        /**
         * Optional. Topicality adjustment as a rank.
         */
        topicalityRank?: number | null;
    }
    /**
     * Custom clearbox signal represented by name and value pair.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSearchResultRankSignalsCustomSignal {
        /**
         * Optional. Name of the signal.
         */
        name?: string | null;
        /**
         * Optional. Float value representing the ranking signal (e.g. 1.25 for BM25).
         */
        value?: number | null;
    }
    /**
     * Information about the session.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSessionInfo {
        /**
         * Name of the session. If the auto-session mode is used (when SearchRequest.session ends with "-"), this field holds the newly generated session name.
         */
        name?: string | null;
        /**
         * Query ID that corresponds to this search API call. One session can have multiple turns, each with a unique query ID. By specifying the session name and this query ID in the Answer API call, the answer generation happens in the context of the search results from this search call.
         */
        queryId?: string | null;
    }
    /**
     * Summary of the top N search results specified by the summary spec.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSummary {
        /**
         * A collection of Safety Attribute categories and their associated confidence scores.
         */
        safetyAttributes?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes;
        /**
         * Additional summary-skipped reasons. This provides the reason for ignored cases. If nothing is skipped, this field is not set.
         */
        summarySkippedReasons?: string[] | null;
        /**
         * The summary content.
         */
        summaryText?: string | null;
        /**
         * Summary with metadata information.
         */
        summaryWithMetadata?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata;
    }
    /**
     * Citation info for a segment.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation {
        /**
         * End of the attributed segment, exclusive.
         */
        endIndex?: string | null;
        /**
         * Citation sources for the attributed segment.
         */
        sources?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource[];
        /**
         * Index indicates the start of the segment, measured in bytes/unicode.
         */
        startIndex?: string | null;
    }
    /**
     * Citation metadata.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata {
        /**
         * Citations for segments.
         */
        citations?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryCitation[];
    }
    /**
     * Citation source.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationSource {
        /**
         * Document reference index from SummaryWithMetadata.references. It is 0-indexed and the value will be zero if the reference_index is not set explicitly.
         */
        referenceIndex?: string | null;
    }
    /**
     * Document reference.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryReference {
        /**
         * List of cited chunk contents derived from document content.
         */
        chunkContents?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent[];
        /**
         * Required. Document.name of the document. Full resource name of the referenced document, in the format `projects/x/locations/x/collections/x/dataStores/x/branches/x/documents/x`.
         */
        document?: string | null;
        /**
         * Title of the document.
         */
        title?: string | null;
        /**
         * Cloud Storage or HTTP uri for the document.
         */
        uri?: string | null;
    }
    /**
     * Chunk content.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryReferenceChunkContent {
        /**
         * Chunk textual content.
         */
        content?: string | null;
        /**
         * Page identifier.
         */
        pageIdentifier?: string | null;
    }
    /**
     * Safety Attribute categories and their associated confidence scores.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSummarySafetyAttributes {
        /**
         * The display names of Safety Attribute categories associated with the generated content. Order matches the Scores.
         */
        categories?: string[] | null;
        /**
         * The confidence scores of the each category, higher value means higher confidence. Order matches the Categories.
         */
        scores?: number[] | null;
    }
    /**
     * Summary with metadata information.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SearchResponseSummarySummaryWithMetadata {
        /**
         * Citation metadata for given summary.
         */
        citationMetadata?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryCitationMetadata;
        /**
         * Document References.
         */
        references?: Schema$GoogleCloudDiscoveryengineV1SearchResponseSummaryReference[];
        /**
         * Summary text with no citation information.
         */
        summary?: string | null;
    }
    /**
     * Configures metadata that is used to generate serving time results (e.g. search results or recommendation predictions). The ServingConfig is passed in the search and predict request and generates results.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ServingConfig {
        /**
         * Optional. The specification for answer generation.
         */
        answerGenerationSpec?: Schema$GoogleCloudDiscoveryengineV1AnswerGenerationSpec;
        /**
         * Boost controls to use in serving path. All triggered boost controls will be applied. Boost controls must be in the same data store as the serving config. Maximum of 20 boost controls.
         */
        boostControlIds?: string[] | null;
        /**
         * Output only. ServingConfig created timestamp.
         */
        createTime?: string | null;
        /**
         * Required. The human readable serving config display name. Used in Discovery UI. This field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        displayName?: string | null;
        /**
         * Condition do not associate specifications. If multiple do not associate conditions match, all matching do not associate controls in the list will execute. Order does not matter. Maximum number of specifications is 100. Can only be set if SolutionType is SOLUTION_TYPE_SEARCH.
         */
        dissociateControlIds?: string[] | null;
        /**
         * How much diversity to use in recommendation model results e.g. `medium-diversity` or `high-diversity`. Currently supported values: * `no-diversity` * `low-diversity` * `medium-diversity` * `high-diversity` * `auto-diversity` If not specified, we choose default based on recommendation model type. Default value: `no-diversity`. Can only be set if SolutionType is SOLUTION_TYPE_RECOMMENDATION.
         */
        diversityLevel?: string | null;
        /**
         * Filter controls to use in serving path. All triggered filter controls will be applied. Filter controls must be in the same data store as the serving config. Maximum of 20 filter controls.
         */
        filterControlIds?: string[] | null;
        /**
         * The GenericConfig of the serving configuration.
         */
        genericConfig?: Schema$GoogleCloudDiscoveryengineV1ServingConfigGenericConfig;
        /**
         * Condition ignore specifications. If multiple ignore conditions match, all matching ignore controls in the list will execute. Order does not matter. Maximum number of specifications is 100.
         */
        ignoreControlIds?: string[] | null;
        /**
         * The MediaConfig of the serving configuration.
         */
        mediaConfig?: Schema$GoogleCloudDiscoveryengineV1ServingConfigMediaConfig;
        /**
         * The id of the model to use at serving time. Currently only RecommendationModels are supported. Can be changed but only to a compatible model (e.g. others-you-may-like CTR to others-you-may-like CVR). Required when SolutionType is SOLUTION_TYPE_RECOMMENDATION.
         */
        modelId?: string | null;
        /**
         * Immutable. Fully qualified name `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}/servingConfigs/{serving_config_id\}`
         */
        name?: string | null;
        /**
         * Condition oneway synonyms specifications. If multiple oneway synonyms conditions match, all matching oneway synonyms controls in the list will execute. Maximum number of specifications is 100. Can only be set if SolutionType is SOLUTION_TYPE_SEARCH.
         */
        onewaySynonymsControlIds?: string[] | null;
        /**
         * Condition promote specifications. Maximum number of specifications is 100.
         */
        promoteControlIds?: string[] | null;
        /**
         * The ranking expression controls the customized ranking on retrieval documents. To leverage this, document embedding is required. The ranking expression setting in ServingConfig applies to all search requests served by the serving config. However, if `SearchRequest.ranking_expression` is specified, it overrides the ServingConfig ranking expression. The ranking expression is a single function or multiple functions that are joined by "+". * ranking_expression = function, { " + ", function \}; Supported functions: * double * relevance_score * double * dotProduct(embedding_field_path) Function variables: * `relevance_score`: pre-defined keywords, used for measure relevance between query and document. * `embedding_field_path`: the document embedding field used with query embedding vector. * `dotProduct`: embedding function between embedding_field_path and query embedding vector. Example ranking expression: If document has an embedding field doc_embedding, the ranking expression could be `0.5 * relevance_score + 0.3 * dotProduct(doc_embedding)`.
         */
        rankingExpression?: string | null;
        /**
         * IDs of the redirect controls. Only the first triggered redirect action is applied, even if multiple apply. Maximum number of specifications is 100. Can only be set if SolutionType is SOLUTION_TYPE_SEARCH.
         */
        redirectControlIds?: string[] | null;
        /**
         * Condition replacement specifications. Applied according to the order in the list. A previously replaced term can not be re-replaced. Maximum number of specifications is 100. Can only be set if SolutionType is SOLUTION_TYPE_SEARCH.
         */
        replacementControlIds?: string[] | null;
        /**
         * Required. Immutable. Specifies the solution type that a serving config can be associated with.
         */
        solutionType?: string | null;
        /**
         * Condition synonyms specifications. If multiple synonyms conditions match, all matching synonyms controls in the list will execute. Maximum number of specifications is 100. Can only be set if SolutionType is SOLUTION_TYPE_SEARCH.
         */
        synonymsControlIds?: string[] | null;
        /**
         * Output only. ServingConfig updated timestamp.
         */
        updateTime?: string | null;
    }
    /**
     * Specifies the configurations needed for Generic Discovery.Currently we support: * `content_search_spec`: configuration for generic content search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ServingConfigGenericConfig {
        /**
         * Specifies the expected behavior of content search. Only valid for content-search enabled data store.
         */
        contentSearchSpec?: Schema$GoogleCloudDiscoveryengineV1SearchRequestContentSearchSpec;
    }
    /**
     * Specifies the configurations needed for Media Discovery. Currently we support: * `demote_content_watched`: Threshold for watched content demotion. Customers can specify if using watched content demotion or use viewed detail page. Using the content watched demotion, customers need to specify the watched minutes or percentage exceeds the threshold, the content will be demoted in the recommendation result. * `promote_fresh_content`: cutoff days for fresh content promotion. Customers can specify if using content freshness promotion. If the content was published within the cutoff days, the content will be promoted in the recommendation result. Can only be set if SolutionType is SOLUTION_TYPE_RECOMMENDATION.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1ServingConfigMediaConfig {
        /**
         * Specifies the content freshness used for recommendation result. Contents will be demoted if contents were published for more than content freshness cutoff days.
         */
        contentFreshnessCutoffDays?: number | null;
        /**
         * Specifies the content watched percentage threshold for demotion. Threshold value must be between [0, 1.0] inclusive.
         */
        contentWatchedPercentageThreshold?: number | null;
        /**
         * Specifies the content watched minutes threshold for demotion.
         */
        contentWatchedSecondsThreshold?: number | null;
        /**
         * Optional. Specifies the number of days to look back for demoting watched content. If set to zero or unset, defaults to the maximum of 365 days.
         */
        demoteContentWatchedPastDays?: number | null;
        /**
         * Specifies the event type used for demoting recommendation result. Currently supported values: * `view-item`: Item viewed. * `media-play`: Start/resume watching a video, playing a song, etc. * `media-complete`: Finished or stopped midway through a video, song, etc. If unset, watch history demotion will not be applied. Content freshness demotion will still be applied.
         */
        demotionEventType?: string | null;
    }
    /**
     * External session proto definition.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Session {
        /**
         * Optional. The display name of the session. This field is used to identify the session in the UI. By default, the display name is the first turn query text in the session.
         */
        displayName?: string | null;
        /**
         * Output only. The time the session finished.
         */
        endTime?: string | null;
        /**
         * Optional. Whether the session is pinned, pinned session will be displayed on the top of the session list.
         */
        isPinned?: boolean | null;
        /**
         * Immutable. Fully qualified name `projects/{project\}/locations/global/collections/{collection\}/engines/{engine\}/sessions/x`
         */
        name?: string | null;
        /**
         * Output only. The time the session started.
         */
        startTime?: string | null;
        /**
         * The state of the session.
         */
        state?: string | null;
        /**
         * Turns.
         */
        turns?: Schema$GoogleCloudDiscoveryengineV1SessionTurn[];
        /**
         * A unique identifier for tracking users.
         */
        userPseudoId?: string | null;
    }
    /**
     * Represents a turn, including a query from the user and a answer from service.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SessionTurn {
        /**
         * Optional. The resource name of the answer to the user query. Only set if the answer generation (/answer API call) happened in this turn.
         */
        answer?: string | null;
        /**
         * Output only. In ConversationalSearchService.GetSession API, if GetSessionRequest.include_answer_details is set to true, this field will be populated when getting answer query session.
         */
        detailedAnswer?: Schema$GoogleCloudDiscoveryengineV1Answer;
        /**
         * Optional. The user query. May not be set if this turn is merely regenerating an answer to a different turn
         */
        query?: Schema$GoogleCloudDiscoveryengineV1Query;
        /**
         * Optional. Represents metadata related to the query config, for example LLM model and version used, model parameters (temperature, grounding parameters, etc.). The prefix "google." is reserved for Google-developed functionality.
         */
        queryConfig?: {
            [key: string]: string;
        } | null;
    }
    /**
     * Metadata for single-regional CMEKs.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SingleRegionKey {
        /**
         * Required. Single-regional kms key resource name which will be used to encrypt resources `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{keyId\}`.
         */
        kmsKey?: string | null;
    }
    /**
     * A sitemap for the SiteSearchEngine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1Sitemap {
        /**
         * Output only. The sitemap's creation time.
         */
        createTime?: string | null;
        /**
         * Output only. The fully qualified resource name of the sitemap. `projects/x/locations/x/collections/x/dataStores/x/siteSearchEngine/sitemaps/x` The `sitemap_id` suffix is system-generated.
         */
        name?: string | null;
        /**
         * Public URI for the sitemap, e.g. `www.example.com/sitemap.xml`.
         */
        uri?: string | null;
    }
    /**
     * SiteSearchEngine captures DataStore level site search persisting configurations. It is a singleton value per data store.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SiteSearchEngine {
        /**
         * The fully qualified resource name of the site search engine. Format: `projects/x/locations/x/dataStores/x/siteSearchEngine`
         */
        name?: string | null;
    }
    /**
     * Verification information for target sites in advanced site search.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SiteVerificationInfo {
        /**
         * Site verification state indicating the ownership and validity.
         */
        siteVerificationState?: string | null;
        /**
         * Latest site verification time.
         */
        verifyTime?: string | null;
    }
    /**
     * The Spanner source for importing data
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SpannerSource {
        /**
         * Required. The database ID of the source Spanner table.
         */
        databaseId?: string | null;
        /**
         * Whether to apply data boost on Spanner export. Enabling this option will incur additional cost. More info can be found [here](https://cloud.google.com/spanner/docs/databoost/databoost-overview#billing_and_quotas).
         */
        enableDataBoost?: boolean | null;
        /**
         * Required. The instance ID of the source Spanner table.
         */
        instanceId?: string | null;
        /**
         * The project ID that contains the Spanner source. Has a length limit of 128 characters. If not specified, inherits the project ID from the parent request.
         */
        projectId?: string | null;
        /**
         * Required. The table name of the Spanner database that needs to be imported.
         */
        tableId?: string | null;
    }
    /**
     * Request for the AssistantService.StreamAssist method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistRequest {
        /**
         * Optional. Specification of the generation configuration for the request.
         */
        generationSpec?: Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestGenerationSpec;
        /**
         * Optional. Current user query. Empty query is only supported if `file_ids` are provided. In this case, the answer will be generated based on those context files.
         */
        query?: Schema$GoogleCloudDiscoveryengineV1Query;
        /**
         * Optional. The session to use for the request. If specified, the assistant has access to the session history, and the query and the answer are stored there. If `-` is specified as the session ID, or it is left empty, then a new session is created with an automatically generated ID. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}/sessions/{session\}`
         */
        session?: string | null;
        /**
         * Optional. Specification of tools that are used to serve the request.
         */
        toolsSpec?: Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpec;
        /**
         * Optional. Information about the user initiating the query.
         */
        userMetadata?: Schema$GoogleCloudDiscoveryengineV1AssistUserMetadata;
    }
    /**
     * Assistant generation specification for the request. This allows to override the default generation configuration at the engine level.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestGenerationSpec {
        /**
         * Optional. The Vertex AI model_id used for the generative model. If not set, the default Assistant model will be used.
         */
        modelId?: string | null;
    }
    /**
     * Specification of tools that are used to serve the request.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpec {
        /**
         * Optional. Specification of the image generation tool.
         */
        imageGenerationSpec?: Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecImageGenerationSpec;
        /**
         * Optional. Specification of the Vertex AI Search tool.
         */
        vertexAiSearchSpec?: Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVertexAiSearchSpec;
        /**
         * Optional. Specification of the video generation tool.
         */
        videoGenerationSpec?: Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVideoGenerationSpec;
        /**
         * Optional. Specification of the web grounding tool. If field is present, enables grounding with web search. Works only if Assistant.web_grounding_type is WEB_GROUNDING_TYPE_GOOGLE_SEARCH or WEB_GROUNDING_TYPE_ENTERPRISE_WEB_SEARCH.
         */
        webGroundingSpec?: Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecWebGroundingSpec;
    }
    /**
     * Specification of the image generation tool.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecImageGenerationSpec {
    }
    /**
     * Specification of the Vertex AI Search tool.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVertexAiSearchSpec {
        /**
         * Optional. Specs defining DataStores to filter on in a search call and configurations for those data stores. This is only considered for Engines with multiple data stores.
         */
        dataStoreSpecs?: Schema$GoogleCloudDiscoveryengineV1SearchRequestDataStoreSpec[];
        /**
         * Optional. The filter syntax consists of an expression language for constructing a predicate from one or more fields of the documents being filtered. Filter expression is case-sensitive. If this field is unrecognizable, an `INVALID_ARGUMENT` is returned. Filtering in Vertex AI Search is done by mapping the LHS filter key to a key property defined in the Vertex AI Search backend -- this mapping is defined by the customer in their schema. For example a media customer might have a field 'name' in their schema. In this case the filter would look like this: filter --\> name:'ANY("king kong")' For more information about filtering including syntax and filter operators, see [Filter](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
         */
        filter?: string | null;
    }
    /**
     * Specification of the video generation tool.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecVideoGenerationSpec {
    }
    /**
     * Specification of the web grounding tool.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistRequestToolsSpecWebGroundingSpec {
    }
    /**
     * Response for the AssistantService.StreamAssist method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistResponse {
        /**
         * Assist answer resource object containing parts of the assistant's final answer for the user's query. Not present if the current response doesn't add anything to previously sent AssistAnswer.replies. Observe AssistAnswer.state to see if more parts are to be expected. While the state is `IN_PROGRESS`, the AssistAnswer.replies field in each response will contain replies (reply fragments) to be appended to the ones received in previous responses. AssistAnswer.name won't be filled. If the state is `SUCCEEDED`, `FAILED` or `SKIPPED`, the response is the last response and AssistAnswer.name will have a value.
         */
        answer?: Schema$GoogleCloudDiscoveryengineV1AssistAnswer;
        /**
         * A global unique ID that identifies the current pair of request and stream of responses. Used for feedback and support.
         */
        assistToken?: string | null;
        /**
         * Session information.
         */
        sessionInfo?: Schema$GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo;
    }
    /**
     * Information about the session.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo {
        /**
         * Name of the newly generated or continued session. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}/sessions/{session\}`.
         */
        session?: string | null;
    }
    /**
     * Suggestion deny list entry identifying the phrase to block from suggestions and the applied operation for the phrase.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1SuggestionDenyListEntry {
        /**
         * Required. Phrase to block from suggestions served. Can be maximum 125 characters.
         */
        blockPhrase?: string | null;
        /**
         * Required. The match operator to apply for this phrase. Whether to block the exact phrase, or block any suggestions containing this phrase.
         */
        matchOperator?: string | null;
    }
    /**
     * A target site for the SiteSearchEngine.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TargetSite {
        /**
         * Immutable. If set to false, a uri_pattern is generated to include all pages whose address contains the provided_uri_pattern. If set to true, an uri_pattern is generated to try to be an exact match of the provided_uri_pattern or just the specific page if the provided_uri_pattern is a specific one. provided_uri_pattern is always normalized to generate the URI pattern to be used by the search engine.
         */
        exactMatch?: boolean | null;
        /**
         * Output only. Failure reason.
         */
        failureReason?: Schema$GoogleCloudDiscoveryengineV1TargetSiteFailureReason;
        /**
         * Output only. This is system-generated based on the provided_uri_pattern.
         */
        generatedUriPattern?: string | null;
        /**
         * Output only. Indexing status.
         */
        indexingStatus?: string | null;
        /**
         * Output only. The fully qualified resource name of the target site. `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/siteSearchEngine/targetSites/{target_site\}` The `target_site_id` is system-generated.
         */
        name?: string | null;
        /**
         * Required. Input only. The user provided URI pattern from which the `generated_uri_pattern` is generated.
         */
        providedUriPattern?: string | null;
        /**
         * Output only. Root domain of the provided_uri_pattern.
         */
        rootDomainUri?: string | null;
        /**
         * Output only. Site ownership and validity verification status.
         */
        siteVerificationInfo?: Schema$GoogleCloudDiscoveryengineV1SiteVerificationInfo;
        /**
         * The type of the target site, e.g., whether the site is to be included or excluded.
         */
        type?: string | null;
        /**
         * Output only. The target site's last updated time.
         */
        updateTime?: string | null;
    }
    /**
     * Site search indexing failure reasons.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TargetSiteFailureReason {
        /**
         * Failed due to insufficient quota.
         */
        quotaFailure?: Schema$GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure;
    }
    /**
     * Failed due to insufficient quota.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TargetSiteFailureReasonQuotaFailure {
        /**
         * This number is an estimation on how much total quota this project needs to successfully complete indexing.
         */
        totalRequiredQuota?: string | null;
    }
    /**
     * Defines text input.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TextInput {
        /**
         * Conversation context of the input.
         */
        context?: Schema$GoogleCloudDiscoveryengineV1ConversationContext;
        /**
         * Text input.
         */
        input?: string | null;
    }
    /**
     * Metadata related to the progress of the TrainCustomModel operation. This is returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TrainCustomModelMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Request message for SearchTuningService.TrainCustomModel method.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TrainCustomModelRequest {
        /**
         * The desired location of errors incurred during the data ingestion and training.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig;
        /**
         * Cloud Storage training input.
         */
        gcsTrainingInput?: Schema$GoogleCloudDiscoveryengineV1TrainCustomModelRequestGcsTrainingInput;
        /**
         * If not provided, a UUID will be generated.
         */
        modelId?: string | null;
        /**
         * Model to be trained. Supported values are: * **search-tuning**: Fine tuning the search system based on data provided.
         */
        modelType?: string | null;
    }
    /**
     * Cloud Storage training data input.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TrainCustomModelRequestGcsTrainingInput {
        /**
         * The Cloud Storage corpus data which could be associated in train data. The data path format is `gs:///`. A newline delimited jsonl/ndjson file. For search-tuning model, each line should have the _id, title and text. Example: `{"_id": "doc1", title: "relevant doc", "text": "relevant text"\}`
         */
        corpusDataPath?: string | null;
        /**
         * The gcs query data which could be associated in train data. The data path format is `gs:///`. A newline delimited jsonl/ndjson file. For search-tuning model, each line should have the _id and text. Example: {"_id": "query1", "text": "example query"\}
         */
        queryDataPath?: string | null;
        /**
         * Cloud Storage test data. Same format as train_data_path. If not provided, a random 80/20 train/test split will be performed on train_data_path.
         */
        testDataPath?: string | null;
        /**
         * Cloud Storage training data path whose format should be `gs:///`. The file should be in tsv format. Each line should have the doc_id and query_id and score (number). For search-tuning model, it should have the query-id corpus-id score as tsv file header. The score should be a number in `[0, inf+)`. The larger the number is, the more relevant the pair is. Example: * `query-id\tcorpus-id\tscore` * `query1\tdoc1\t1`
         */
        trainDataPath?: string | null;
    }
    /**
     * Response of the TrainCustomModelRequest. This message is returned by the google.longrunning.Operations.response field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TrainCustomModelResponse {
        /**
         * Echoes the destination for the complete errors in the request if set.
         */
        errorConfig?: Schema$GoogleCloudDiscoveryengineV1ImportErrorConfig;
        /**
         * A sample of errors encountered while processing the data.
         */
        errorSamples?: Schema$GoogleRpcStatus[];
        /**
         * The metrics of the trained model.
         */
        metrics?: {
            [key: string]: number;
        } | null;
        /**
         * Fully qualified name of the CustomTuningModel.
         */
        modelName?: string | null;
        /**
         * The trained model status. Possible values are: * **bad-data**: The training data quality is bad. * **no-improvement**: Tuning didn't improve performance. Won't deploy. * **in-progress**: Model training job creation is in progress. * **training**: Model is actively training. * **evaluating**: The model is evaluating trained metrics. * **indexing**: The model trained metrics are indexing. * **ready**: The model is ready for serving.
         */
        modelStatus?: string | null;
    }
    /**
     * A transaction represents the entire purchase transaction.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1TransactionInfo {
        /**
         * All the costs associated with the products. These can be manufacturing costs, shipping expenses not borne by the end user, or any other costs, such that: * Profit = value - tax - cost
         */
        cost?: number | null;
        /**
         * Required. Currency code. Use three-character ISO-4217 code.
         */
        currency?: string | null;
        /**
         * The total discount(s) value applied to this transaction. This figure should be excluded from TransactionInfo.value For example, if a user paid TransactionInfo.value amount, then nominal (pre-discount) value of the transaction is the sum of TransactionInfo.value and TransactionInfo.discount_value This means that profit is calculated the same way, regardless of the discount value, and that TransactionInfo.discount_value can be larger than TransactionInfo.value: * Profit = value - tax - cost
         */
        discountValue?: number | null;
        /**
         * All the taxes associated with the transaction.
         */
        tax?: number | null;
        /**
         * The transaction ID with a length limit of 128 characters.
         */
        transactionId?: string | null;
        /**
         * Required. Total non-zero value associated with the transaction. This value may include shipping, tax, or other adjustments to the total value that you want to include.
         */
        value?: number | null;
    }
    /**
     * Metadata related to the progress of the CmekConfigService.UpdateCmekConfig operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1UpdateCmekConfigMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for UpdateSchema LRO.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1UpdateSchemaMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata related to the progress of the SiteSearchEngineService.UpdateTargetSite operation. This will be returned by the google.longrunning.Operation.metadata field.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1UpdateTargetSiteMetadata {
        /**
         * Operation create time.
         */
        createTime?: string | null;
        /**
         * Operation last update time. If the operation is done, this is also the finish time.
         */
        updateTime?: string | null;
    }
    /**
     * UserEvent captures all metadata information Discovery Engine API needs to know about how end users interact with your website.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1UserEvent {
        /**
         * Extra user event features to include in the recommendation model. These attributes must NOT contain data that needs to be parsed or processed further, e.g. JSON or other encodings. If you provide custom attributes for ingested user events, also include them in the user events that you associate with prediction requests. Custom attribute formatting must be consistent between imported events and events provided with prediction requests. This lets the Discovery Engine API use those custom attributes when training models and serving predictions, which helps improve recommendation quality. This field needs to pass all below criteria, otherwise an `INVALID_ARGUMENT` error is returned: * The key must be a UTF-8 encoded string with a length limit of 5,000 characters. * For text attributes, at most 400 values are allowed. Empty values are not allowed. Each value must be a UTF-8 encoded string with a length limit of 256 characters. * For number attributes, at most 400 values are allowed. For product recommendations, an example of extra user information is `traffic_channel`, which is how a user arrives at the site. Users can arrive at the site by coming to the site directly, coming through Google search, or in other ways.
         */
        attributes?: {
            [key: string]: Schema$GoogleCloudDiscoveryengineV1CustomAttribute;
        } | null;
        /**
         * Token to attribute an API response to user action(s) to trigger the event. Highly recommended for user events that are the result of RecommendationService.Recommend. This field enables accurate attribution of recommendation model performance. The value must be one of: * RecommendResponse.attribution_token for events that are the result of RecommendationService.Recommend. * SearchResponse.attribution_token for events that are the result of SearchService.Search. This token enables us to accurately attribute page view or conversion completion back to the event and the particular predict response containing this clicked/purchased product. If user clicks on product K in the recommendation results, pass RecommendResponse.attribution_token as a URL parameter to product K's page. When recording events on product K's page, log the RecommendResponse.attribution_token to this field.
         */
        attributionToken?: string | null;
        /**
         * CompletionService.CompleteQuery details related to the event. This field should be set for `search` event when autocomplete function is enabled and the user clicks a suggestion for search.
         */
        completionInfo?: Schema$GoogleCloudDiscoveryengineV1CompletionInfo;
        /**
         * Optional. Conversion type. Required if UserEvent.event_type is `conversion`. This is a customer-defined conversion name in lowercase letters or numbers separated by "-", such as "watch", "good-visit" etc. Do not set the field if UserEvent.event_type is not `conversion`. This mixes the custom conversion event with predefined events like `search`, `view-item` etc.
         */
        conversionType?: string | null;
        /**
         * The DataStore resource full name, of the form `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. Optional. Only required for user events whose data store can't by determined by UserEvent.engine or UserEvent.documents. If data store is set in the parent of write/import/collect user event requests, this field can be omitted.
         */
        dataStore?: string | null;
        /**
         * Should set to true if the request is made directly from the end user, in which case the UserEvent.user_info.user_agent can be populated from the HTTP request. This flag should be set only if the API request is made directly from the end user such as a mobile app (and not if a gateway or a server is processing and pushing the user events). This should not be set when using the JavaScript tag in UserEventService.CollectUserEvent.
         */
        directUserRequest?: boolean | null;
        /**
         * List of Documents associated with this user event. This field is optional except for the following event types: * `view-item` * `add-to-cart` * `purchase` * `media-play` * `media-complete` In a `search` event, this field represents the documents returned to the end user on the current page (the end user may have not finished browsing the whole page yet). When a new page is returned to the end user, after pagination/filtering/ordering even for the same query, a new `search` event with different UserEvent.documents is desired.
         */
        documents?: Schema$GoogleCloudDiscoveryengineV1DocumentInfo[];
        /**
         * The Engine resource name, in the form of `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}`. Optional. Only required for Engine produced user events. For example, user events from blended search.
         */
        engine?: string | null;
        /**
         * Only required for UserEventService.ImportUserEvents method. Timestamp of when the user event happened.
         */
        eventTime?: string | null;
        /**
         * Required. User event type. Allowed values are: Generic values: * `search`: Search for Documents. * `view-item`: Detailed page view of a Document. * `view-item-list`: View of a panel or ordered list of Documents. * `view-home-page`: View of the home page. * `view-category-page`: View of a category page, e.g. Home \> Men \> Jeans * `add-feedback`: Add a user feedback. Retail-related values: * `add-to-cart`: Add an item(s) to cart, e.g. in Retail online shopping * `purchase`: Purchase an item(s) Media-related values: * `media-play`: Start/resume watching a video, playing a song, etc. * `media-complete`: Finished or stopped midway through a video, song, etc. Custom conversion value: * `conversion`: Customer defined conversion event.
         */
        eventType?: string | null;
        /**
         * The filter syntax consists of an expression language for constructing a predicate from one or more fields of the documents being filtered. One example is for `search` events, the associated SearchRequest may contain a filter expression in SearchRequest.filter conforming to https://google.aip.dev/160#filtering. Similarly, for `view-item-list` events that are generated from a RecommendRequest, this field may be populated directly from RecommendRequest.filter conforming to https://google.aip.dev/160#filtering. The value must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        filter?: string | null;
        /**
         * Media-specific info.
         */
        mediaInfo?: Schema$GoogleCloudDiscoveryengineV1MediaInfo;
        /**
         * Page metadata such as categories and other critical information for certain event types such as `view-category-page`.
         */
        pageInfo?: Schema$GoogleCloudDiscoveryengineV1PageInfo;
        /**
         * Panel metadata associated with this user event.
         */
        panel?: Schema$GoogleCloudDiscoveryengineV1PanelInfo;
        /**
         * Optional. List of panels associated with this event. Used for page-level impression data.
         */
        panels?: Schema$GoogleCloudDiscoveryengineV1PanelInfo[];
        /**
         * The promotion IDs if this is an event associated with promotions. Currently, this field is restricted to at most one ID.
         */
        promotionIds?: string[] | null;
        /**
         * SearchService.Search details related to the event. This field should be set for `search` event.
         */
        searchInfo?: Schema$GoogleCloudDiscoveryengineV1SearchInfo;
        /**
         * A unique identifier for tracking a visitor session with a length limit of 128 bytes. A session is an aggregation of an end user behavior in a time span. A general guideline to populate the session_id: 1. If user has no activity for 30 min, a new session_id should be assigned. 2. The session_id should be unique across users, suggest use uuid or add UserEvent.user_pseudo_id as prefix.
         */
        sessionId?: string | null;
        /**
         * A list of identifiers for the independent experiment groups this user event belongs to. This is used to distinguish between user events associated with different experiment setups.
         */
        tagIds?: string[] | null;
        /**
         * The transaction metadata (if any) associated with this user event.
         */
        transactionInfo?: Schema$GoogleCloudDiscoveryengineV1TransactionInfo;
        /**
         * Information about the end user.
         */
        userInfo?: Schema$GoogleCloudDiscoveryengineV1UserInfo;
        /**
         * Required. A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor log in/out of the website. Do not set the field to the same fixed ID for different users. This mixes the event history of those users together, which results in degraded model quality. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. The field should not contain PII or user-data. We recommend to use Google Analytics [Client ID](https://developers.google.com/analytics/devguides/collection/analyticsjs/field-reference#clientId) for this field.
         */
        userPseudoId?: string | null;
    }
    /**
     * Information of an end user.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1UserInfo {
        /**
         * Optional. IANA time zone, e.g. Europe/Budapest.
         */
        timeZone?: string | null;
        /**
         * User agent as included in the HTTP header. The field must be a UTF-8 encoded string with a length limit of 1,000 characters. Otherwise, an `INVALID_ARGUMENT` error is returned. This should not be set when using the client side event reporting with GTM or JavaScript tag in UserEventService.CollectUserEvent or if UserEvent.direct_user_request is set.
         */
        userAgent?: string | null;
        /**
         * Highly recommended for logged-in users. Unique identifier for logged-in user, such as a user name. Don't set for anonymous users. Always use a hashed value for this ID. Don't set the field to the same fixed ID for different users. This mixes the event history of those users together, which results in degraded model quality. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        userId?: string | null;
    }
    /**
     * User License information assigned by the admin.
     */
    export interface Schema$GoogleCloudDiscoveryengineV1UserLicense {
        /**
         * Output only. User created timestamp.
         */
        createTime?: string | null;
        /**
         * Output only. User last logged in time. If the user has not logged in yet, this field will be empty.
         */
        lastLoginTime?: string | null;
        /**
         * Output only. License assignment state of the user. If the user is assigned with a license config, the user login will be assigned with the license; If the user's license assignment state is unassigned or unspecified, no license config will be associated to the user;
         */
        licenseAssignmentState?: string | null;
        /**
         * Optional. The full resource name of the Subscription(LicenseConfig) assigned to the user.
         */
        licenseConfig?: string | null;
        /**
         * Output only. User update timestamp.
         */
        updateTime?: string | null;
        /**
         * Required. Immutable. The user principal of the User, could be email address or other prinical identifier. This field is immutable. Admin assign licenses based on the user principal.
         */
        userPrincipal?: string | null;
        /**
         * Optional. The user profile. We user user full name(First name + Last name) as user profile.
         */
        userProfile?: string | null;
    }
    /**
     * Config to store data store type configuration for workspace data
     */
    export interface Schema$GoogleCloudDiscoveryengineV1WorkspaceConfig {
        /**
         * Obfuscated Dasher customer ID.
         */
        dasherCustomerId?: string | null;
        /**
         * Optional. The super admin email address for the workspace that will be used for access token generation. For now we only use it for Native Google Drive connector data ingestion.
         */
        superAdminEmailAddress?: string | null;
        /**
         * Optional. The super admin service account for the workspace that will be used for access token generation. For now we only use it for Native Google Drive connector data ingestion.
         */
        superAdminServiceAccount?: string | null;
        /**
         * The Google Workspace data source.
         */
        type?: string | null;
    }
    /**
     * The request message for Operations.CancelOperation.
     */
    export interface Schema$GoogleLongrunningCancelOperationRequest {
    }
    /**
     * The response message for Operations.ListOperations.
     */
    export interface Schema$GoogleLongrunningListOperationsResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
        /**
         * A list of operations that matches the specified filter in the request.
         */
        operations?: Schema$GoogleLongrunningOperation[];
    }
    /**
     * This resource represents a long-running operation that is the result of a network API call.
     */
    export interface Schema$GoogleLongrunningOperation {
        /**
         * If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
         */
        done?: boolean | null;
        /**
         * The error result of the operation in case of failure or cancellation.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id\}`.
         */
        name?: string | null;
        /**
         * The normal, successful response of the operation. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
         */
        response?: {
            [key: string]: any;
        } | null;
    }
    /**
     * A single data point in a time series.
     */
    export interface Schema$GoogleMonitoringV3Point {
        /**
         * The time interval to which the data point applies. For `GAUGE` metrics, the start time is optional, but if it is supplied, it must equal the end time. For `DELTA` metrics, the start and end time should specify a non-zero interval, with subsequent points specifying contiguous and non-overlapping intervals. For `CUMULATIVE` metrics, the start and end time should specify a non-zero interval, with subsequent points specifying the same start time and increasing end times, until an event resets the cumulative value to zero and sets a new start time for the following points.
         */
        interval?: Schema$GoogleMonitoringV3TimeInterval;
        /**
         * The value of the data point.
         */
        value?: Schema$GoogleMonitoringV3TypedValue;
    }
    /**
     * A time interval extending just after a start time through an end time. If the start time is the same as the end time, then the interval represents a single point in time.
     */
    export interface Schema$GoogleMonitoringV3TimeInterval {
        /**
         * Required. The end of the time interval.
         */
        endTime?: string | null;
        /**
         * Optional. The beginning of the time interval. The default value for the start time is the end time. The start time must not be later than the end time.
         */
        startTime?: string | null;
    }
    /**
     * A collection of data points that describes the time-varying values of a metric. A time series is identified by a combination of a fully-specified monitored resource and a fully-specified metric. This type is used for both listing and creating time series.
     */
    export interface Schema$GoogleMonitoringV3TimeSeries {
        /**
         * Input only. A detailed description of the time series that will be associated with the google.api.MetricDescriptor for the metric. Once set, this field cannot be changed through CreateTimeSeries.
         */
        description?: string | null;
        /**
         * Output only. The associated monitored resource metadata. When reading a time series, this field will include metadata labels that are explicitly named in the reduction. When creating a time series, this field is ignored.
         */
        metadata?: Schema$GoogleApiMonitoredResourceMetadata;
        /**
         * The associated metric. A fully-specified metric used to identify the time series.
         */
        metric?: Schema$GoogleApiMetric;
        /**
         * The metric kind of the time series. When listing time series, this metric kind might be different from the metric kind of the associated metric if this time series is an alignment or reduction of other time series. When creating a time series, this field is optional. If present, it must be the same as the metric kind of the associated metric. If the associated metric's descriptor must be auto-created, then this field specifies the metric kind of the new descriptor and must be either `GAUGE` (the default) or `CUMULATIVE`.
         */
        metricKind?: string | null;
        /**
         * The data points of this time series. When listing time series, points are returned in reverse time order. When creating a time series, this field must contain exactly one point and the point's type must be the same as the value type of the associated metric. If the associated metric's descriptor must be auto-created, then the value type of the descriptor is determined by the point's type, which must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
         */
        points?: Schema$GoogleMonitoringV3Point[];
        /**
         * The associated monitored resource. Custom metrics can use only certain monitored resource types in their time series data. For more information, see [Monitored resources for custom metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
         */
        resource?: Schema$GoogleApiMonitoredResource;
        /**
         * The units in which the metric value is reported. It is only applicable if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit` defines the representation of the stored metric values. This field can only be changed through CreateTimeSeries when it is empty.
         */
        unit?: string | null;
        /**
         * The value type of the time series. When listing time series, this value type might be different from the value type of the associated metric if this time series is an alignment or reduction of other time series. When creating a time series, this field is optional. If present, it must be the same as the type of the data in the `points` field.
         */
        valueType?: string | null;
    }
    /**
     * A single strongly-typed value.
     */
    export interface Schema$GoogleMonitoringV3TypedValue {
        /**
         * A Boolean value: `true` or `false`.
         */
        boolValue?: boolean | null;
        /**
         * A distribution value.
         */
        distributionValue?: Schema$GoogleApiDistribution;
        /**
         * A 64-bit double-precision floating-point number. Its magnitude is approximately ±10±300 and it has 16 significant digits of precision.
         */
        doubleValue?: number | null;
        /**
         * A 64-bit integer. Its range is approximately ±9.2x1018.
         */
        int64Value?: string | null;
        /**
         * A variable-length string value.
         */
        stringValue?: string | null;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); \}
     */
    export interface Schema$GoogleProtobufEmpty {
    }
    /**
     * The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
     */
    export interface Schema$GoogleRpcStatus {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number | null;
        /**
         * A list of messages that carry the error details. There is a common set of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }> | null;
        /**
         * A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
         */
        message?: string | null;
    }
    /**
     * Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
     */
    export interface Schema$GoogleTypeDate {
        /**
         * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
         */
        day?: number | null;
        /**
         * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
         */
        month?: number | null;
        /**
         * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
         */
        year?: number | null;
    }
    /**
     * Represents civil time (or occasionally physical time). This type can represent a civil time in one of a few possible ways: * When utc_offset is set and time_zone is unset: a civil time on a calendar day with a particular offset from UTC. * When time_zone is set and utc_offset is unset: a civil time on a calendar day in a particular time zone. * When neither time_zone nor utc_offset is set: a civil time on a calendar day in local time. The date is relative to the Proleptic Gregorian Calendar. If year, month, or day are 0, the DateTime is considered not to have a specific year, month, or day respectively. This type may also be used to represent a physical time if all the date and time fields are set and either case of the `time_offset` oneof is set. Consider using `Timestamp` message for physical time instead. If your use case also would like to store the user's timezone, that can be done in another field. This type is more flexible than some applications may want. Make sure to document and validate your application's limitations.
     */
    export interface Schema$GoogleTypeDateTime {
        /**
         * Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a datetime without a day.
         */
        day?: number | null;
        /**
         * Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API may choose to allow the value "24:00:00" for scenarios like business closing time.
         */
        hours?: number | null;
        /**
         * Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
         */
        minutes?: number | null;
        /**
         * Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
         */
        month?: number | null;
        /**
         * Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
         */
        nanos?: number | null;
        /**
         * Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may allow the value 60 if it allows leap-seconds.
         */
        seconds?: number | null;
        /**
         * Time zone.
         */
        timeZone?: Schema$GoogleTypeTimeZone;
        /**
         * UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of -4:00 would be represented as { seconds: -14400 \}.
         */
        utcOffset?: string | null;
        /**
         * Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
         */
        year?: number | null;
    }
    /**
     * Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
     */
    export interface Schema$GoogleTypeTimeZone {
        /**
         * IANA Time Zone Database time zone. For example "America/New_York".
         */
        id?: string | null;
        /**
         * Optional. IANA Time Zone Database version number. For example "2019a".
         */
        version?: string | null;
    }
    export class Resource$Media {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Downloads a file from the session.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await discoveryengine.media.download({
         *     // Required. The ID of the file to be downloaded.
         *     fileId: 'placeholder-value',
         *     // Required. The resource name of the Session. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}/sessions/{session\}`
         *     name: 'projects/my-project/locations/my-location/collections/my-collection/engines/my-engine/sessions/my-session',
         *     // Optional. The ID of the view to be downloaded.
         *     viewId: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "algorithm": "my_algorithm",
         *   //   "bigstoreObjectRef": "my_bigstoreObjectRef",
         *   //   "blobRef": "my_blobRef",
         *   //   "blobstore2Info": {},
         *   //   "compositeMedia": [],
         *   //   "contentType": "my_contentType",
         *   //   "contentTypeInfo": {},
         *   //   "cosmoBinaryReference": "my_cosmoBinaryReference",
         *   //   "crc32cHash": 0,
         *   //   "diffChecksumsResponse": {},
         *   //   "diffDownloadResponse": {},
         *   //   "diffUploadRequest": {},
         *   //   "diffUploadResponse": {},
         *   //   "diffVersionResponse": {},
         *   //   "downloadParameters": {},
         *   //   "filename": "my_filename",
         *   //   "hash": "my_hash",
         *   //   "hashVerified": false,
         *   //   "inline": "my_inline",
         *   //   "isPotentialRetry": false,
         *   //   "length": "my_length",
         *   //   "md5Hash": "my_md5Hash",
         *   //   "mediaId": "my_mediaId",
         *   //   "objectId": {},
         *   //   "path": "my_path",
         *   //   "referenceType": "my_referenceType",
         *   //   "sha1Hash": "my_sha1Hash",
         *   //   "sha256Hash": "my_sha256Hash",
         *   //   "timestamp": "my_timestamp",
         *   //   "token": "my_token"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        download(params: Params$Resource$Media$Download, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        download(params?: Params$Resource$Media$Download, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GdataMedia>>;
        download(params: Params$Resource$Media$Download, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        download(params: Params$Resource$Media$Download, options: MethodOptions | BodyResponseCallback<Schema$GdataMedia>, callback: BodyResponseCallback<Schema$GdataMedia>): void;
        download(params: Params$Resource$Media$Download, callback: BodyResponseCallback<Schema$GdataMedia>): void;
        download(callback: BodyResponseCallback<Schema$GdataMedia>): void;
    }
    export interface Params$Resource$Media$Download extends StandardParameters {
        /**
         * Required. The ID of the file to be downloaded.
         */
        fileId?: string;
        /**
         * Required. The resource name of the Session. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/engines/{engine\}/sessions/{session\}`
         */
        name?: string;
        /**
         * Optional. The ID of the view to be downloaded.
         */
        viewId?: string;
    }
    export class Resource$Projects {
        context: APIRequestContext;
        locations: Resource$Projects$Locations;
        operations: Resource$Projects$Operations;
        constructor(context: APIRequestContext);
        /**
         * Provisions the project resource. During the process, related systems will get prepared and initialized. Caller must read the [Terms for data use](https://cloud.google.com/retail/data-use-terms), and optionally specify in request to provide consent to that service terms.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await discoveryengine.projects.provision({
         *     // Required. Full resource name of a Project, such as `projects/{project_id_or_number\}`.
         *     name: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "acceptDataUseTerms": false,
         *       //   "dataUseTermsVersion": "my_dataUseTermsVersion",
         *       //   "saasParams": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        provision(params: Params$Resource$Projects$Provision, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        provision(params?: Params$Resource$Projects$Provision, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        provision(params: Params$Resource$Projects$Provision, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        provision(params: Params$Resource$Projects$Provision, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        provision(params: Params$Resource$Projects$Provision, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        provision(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Provision extends StandardParameters {
        /**
         * Required. Full resource name of a Project, such as `projects/{project_id_or_number\}`.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1ProvisionProjectRequest;
    }
    export class Resource$Projects$Locations {
        context: APIRequestContext;
        cmekConfigs: Resource$Projects$Locations$Cmekconfigs;
        collections: Resource$Projects$Locations$Collections;
        dataStores: Resource$Projects$Locations$Datastores;
        groundingConfigs: Resource$Projects$Locations$Groundingconfigs;
        identityMappingStores: Resource$Projects$Locations$Identitymappingstores;
        operations: Resource$Projects$Locations$Operations;
        podcasts: Resource$Projects$Locations$Podcasts;
        rankingConfigs: Resource$Projects$Locations$Rankingconfigs;
        userEvents: Resource$Projects$Locations$Userevents;
        userStores: Resource$Projects$Locations$Userstores;
        constructor(context: APIRequestContext);
        /**
         * Gets the CmekConfig.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await discoveryengine.projects.locations.getCmekConfig({
         *     // Required. Resource name of CmekConfig, such as `projects/x/locations/x/cmekConfig` or `projects/x/locations/x/cmekConfigs/x`. If the caller does not have permission to access the CmekConfig, regardless of whether or not it exists, a PERMISSION_DENIED error is returned.
         *     name: 'projects/my-project/locations/my-location/cmekConfig',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "isDefault": false,
         *   //   "kmsKey": "my_kmsKey",
         *   //   "kmsKeyVersion": "my_kmsKeyVersion",
         *   //   "lastRotationTimestampMicros": "my_lastRotationTimestampMicros",
         *   //   "name": "my_name",
         *   //   "notebooklmState": "my_notebooklmState",
         *   //   "singleRegionKeys": [],
         *   //   "state": "my_state"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getCmekConfig(params: Params$Resource$Projects$Locations$Getcmekconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getCmekConfig(params?: Params$Resource$Projects$Locations$Getcmekconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1CmekConfig>>;
        getCmekConfig(params: Params$Resource$Projects$Locations$Getcmekconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getCmekConfig(params: Params$Resource$Projects$Locations$Getcmekconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CmekConfig>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CmekConfig>): void;
        getCmekConfig(params: Params$Resource$Projects$Locations$Getcmekconfig, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CmekConfig>): void;
        getCmekConfig(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CmekConfig>): void;
        /**
         * Provisions a CMEK key for use in a location of a customer's project. This method will also conduct location validation on the provided cmekConfig to make sure the key is valid and can be used in the selected location.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await discoveryengine.projects.locations.updateCmekConfig({
         *     // Required. The name of the CmekConfig of the form `projects/{project\}/locations/{location\}/cmekConfig` or `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         *     name: 'projects/my-project/locations/my-location/cmekConfig',
         *     // Set the following CmekConfig as the default to be used for child resources if one is not specified.
         *     setDefault: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "isDefault": false,
         *       //   "kmsKey": "my_kmsKey",
         *       //   "kmsKeyVersion": "my_kmsKeyVersion",
         *       //   "lastRotationTimestampMicros": "my_lastRotationTimestampMicros",
         *       //   "name": "my_name",
         *       //   "notebooklmState": "my_notebooklmState",
         *       //   "singleRegionKeys": [],
         *       //   "state": "my_state"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        updateCmekConfig(params: Params$Resource$Projects$Locations$Updatecmekconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        updateCmekConfig(params?: Params$Resource$Projects$Locations$Updatecmekconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        updateCmekConfig(params: Params$Resource$Projects$Locations$Updatecmekconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        updateCmekConfig(params: Params$Resource$Projects$Locations$Updatecmekconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        updateCmekConfig(params: Params$Resource$Projects$Locations$Updatecmekconfig, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        updateCmekConfig(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Getcmekconfig extends StandardParameters {
        /**
         * Required. Resource name of CmekConfig, such as `projects/x/locations/x/cmekConfig` or `projects/x/locations/x/cmekConfigs/x`. If the caller does not have permission to access the CmekConfig, regardless of whether or not it exists, a PERMISSION_DENIED error is returned.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Updatecmekconfig extends StandardParameters {
        /**
         * Required. The name of the CmekConfig of the form `projects/{project\}/locations/{location\}/cmekConfig` or `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         */
        name?: string;
        /**
         * Set the following CmekConfig as the default to be used for child resources if one is not specified.
         */
        setDefault?: boolean;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1CmekConfig;
    }
    export class Resource$Projects$Locations$Cmekconfigs {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * De-provisions a CmekConfig.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await discoveryengine.projects.locations.cmekConfigs.delete({
         *     // Required. The resource name of the CmekConfig to delete, such as `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         *     name: 'projects/my-project/locations/my-location/cmekConfigs/my-cmekConfig',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Cmekconfigs$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Cmekconfigs$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Locations$Cmekconfigs$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Cmekconfigs$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Locations$Cmekconfigs$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets the CmekConfig.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await discoveryengine.projects.locations.cmekConfigs.get({
         *     // Required. Resource name of CmekConfig, such as `projects/x/locations/x/cmekConfig` or `projects/x/locations/x/cmekConfigs/x`. If the caller does not have permission to access the CmekConfig, regardless of whether or not it exists, a PERMISSION_DENIED error is returned.
         *     name: 'projects/my-project/locations/my-location/cmekConfigs/my-cmekConfig',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "isDefault": false,
         *   //   "kmsKey": "my_kmsKey",
         *   //   "kmsKeyVersion": "my_kmsKeyVersion",
         *   //   "lastRotationTimestampMicros": "my_lastRotationTimestampMicros",
         *   //   "name": "my_name",
         *   //   "notebooklmState": "my_notebooklmState",
         *   //   "singleRegionKeys": [],
         *   //   "state": "my_state"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Cmekconfigs$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Cmekconfigs$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1CmekConfig>>;
        get(params: Params$Resource$Projects$Locations$Cmekconfigs$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Cmekconfigs$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CmekConfig>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CmekConfig>): void;
        get(params: Params$Resource$Projects$Locations$Cmekconfigs$Get, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CmekConfig>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CmekConfig>): void;
        /**
         * Lists all the CmekConfigs with the project.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await discoveryengine.projects.locations.cmekConfigs.list({
         *     // Required. The parent location resource name, such as `projects/{project\}/locations/{location\}`. If the caller does not have permission to list CmekConfigs under this location, regardless of whether or not a CmekConfig exists, a PERMISSION_DENIED error is returned.
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "cmekConfigs": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Cmekconfigs$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Cmekconfigs$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ListCmekConfigsResponse>>;
        list(params: Params$Resource$Projects$Locations$Cmekconfigs$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Cmekconfigs$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListCmekConfigsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListCmekConfigsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Cmekconfigs$List, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListCmekConfigsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListCmekConfigsResponse>): void;
        /**
         * Provisions a CMEK key for use in a location of a customer's project. This method will also conduct location validation on the provided cmekConfig to make sure the key is valid and can be used in the selected location.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await discoveryengine.projects.locations.cmekConfigs.patch({
         *     // Required. The name of the CmekConfig of the form `projects/{project\}/locations/{location\}/cmekConfig` or `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         *     name: 'projects/my-project/locations/my-location/cmekConfigs/my-cmekConfig',
         *     // Set the following CmekConfig as the default to be used for child resources if one is not specified.
         *     setDefault: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "isDefault": false,
         *       //   "kmsKey": "my_kmsKey",
         *       //   "kmsKeyVersion": "my_kmsKeyVersion",
         *       //   "lastRotationTimestampMicros": "my_lastRotationTimestampMicros",
         *       //   "name": "my_name",
         *       //   "notebooklmState": "my_notebooklmState",
         *       //   "singleRegionKeys": [],
         *       //   "state": "my_state"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Cmekconfigs$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Cmekconfigs$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        patch(params: Params$Resource$Projects$Locations$Cmekconfigs$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Cmekconfigs$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        patch(params: Params$Resource$Projects$Locations$Cmekconfigs$Patch, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Cmekconfigs$Delete extends StandardParameters {
        /**
         * Required. The resource name of the CmekConfig to delete, such as `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Cmekconfigs$Get extends StandardParameters {
        /**
         * Required. Resource name of CmekConfig, such as `projects/x/locations/x/cmekConfig` or `projects/x/locations/x/cmekConfigs/x`. If the caller does not have permission to access the CmekConfig, regardless of whether or not it exists, a PERMISSION_DENIED error is returned.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Cmekconfigs$List extends StandardParameters {
        /**
         * Required. The parent location resource name, such as `projects/{project\}/locations/{location\}`. If the caller does not have permission to list CmekConfigs under this location, regardless of whether or not a CmekConfig exists, a PERMISSION_DENIED error is returned.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Cmekconfigs$Patch extends StandardParameters {
        /**
         * Required. The name of the CmekConfig of the form `projects/{project\}/locations/{location\}/cmekConfig` or `projects/{project\}/locations/{location\}/cmekConfigs/{cmek_config\}`.
         */
        name?: string;
        /**
         * Set the following CmekConfig as the default to be used for child resources if one is not specified.
         */
        setDefault?: boolean;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1CmekConfig;
    }
    export class Resource$Projects$Locations$Collections {
        context: APIRequestContext;
        dataConnector: Resource$Projects$Locations$Collections$Dataconnector;
        dataStores: Resource$Projects$Locations$Collections$Datastores;
        engines: Resource$Projects$Locations$Collections$Engines;
        operations: Resource$Projects$Locations$Collections$Operations;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Locations$Collections$Dataconnector {
        context: APIRequestContext;
        operations: Resource$Projects$Locations$Collections$Dataconnector$Operations;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Locations$Collections$Dataconnector$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataConnector.operations.get(
         *       {
         *         // The name of the operation resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataConnector/operations/my-operation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        get(params: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$Get, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataConnector.operations.list(
         *       {
         *         // The standard list filter.
         *         filter: 'placeholder-value',
         *         // The name of the operation's parent resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataConnector',
         *         // The standard list page size.
         *         pageSize: 'placeholder-value',
         *         // The standard list page token.
         *         pageToken: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "operations": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningListOperationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$List, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$Get extends StandardParameters {
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Dataconnector$Operations$List extends StandardParameters {
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    export class Resource$Projects$Locations$Collections$Datastores {
        context: APIRequestContext;
        branches: Resource$Projects$Locations$Collections$Datastores$Branches;
        completionConfig: Resource$Projects$Locations$Collections$Datastores$Completionconfig;
        completionSuggestions: Resource$Projects$Locations$Collections$Datastores$Completionsuggestions;
        controls: Resource$Projects$Locations$Collections$Datastores$Controls;
        conversations: Resource$Projects$Locations$Collections$Datastores$Conversations;
        customModels: Resource$Projects$Locations$Collections$Datastores$Custommodels;
        models: Resource$Projects$Locations$Collections$Datastores$Models;
        operations: Resource$Projects$Locations$Collections$Datastores$Operations;
        schemas: Resource$Projects$Locations$Collections$Datastores$Schemas;
        servingConfigs: Resource$Projects$Locations$Collections$Datastores$Servingconfigs;
        sessions: Resource$Projects$Locations$Collections$Datastores$Sessions;
        siteSearchEngine: Resource$Projects$Locations$Collections$Datastores$Sitesearchengine;
        suggestionDenyListEntries: Resource$Projects$Locations$Collections$Datastores$Suggestiondenylistentries;
        userEvents: Resource$Projects$Locations$Collections$Datastores$Userevents;
        constructor(context: APIRequestContext);
        /**
         * Completes the specified user input with keyword suggestions.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.completeQuery(
         *       {
         *         // Required. The parent data store resource name for which the completion is performed, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store`.
         *         dataStore:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *         // Indicates if tail suggestions should be returned if there are no suggestions that match the full query. Even if set to true, if there are suggestions that match the full query, those are returned and no tail suggestions are returned.
         *         includeTailSuggestions: 'placeholder-value',
         *         // Required. The typeahead input used to fetch suggestions. Maximum length is 128 characters.
         *         query: 'placeholder-value',
         *         // Specifies the autocomplete data model. This overrides any model specified in the Configuration \> Autocomplete section of the Cloud console. Currently supported values: * `document` - Using suggestions generated from user-imported documents. * `search-history` - Using suggestions generated from the past history of SearchService.Search API calls. Do not use it when there is no traffic for Search API. * `user-event` - Using suggestions generated from user-imported search events. * `document-completable` - Using suggestions taken directly from user-imported document fields marked as completable. Default values: * `document` is the default model for regular dataStores. * `search-history` is the default model for site search dataStores.
         *         queryModel: 'placeholder-value',
         *         // A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. This field should NOT have a fixed value such as `unknown_visitor`. This should be the same identifier as UserEvent.user_pseudo_id and SearchRequest.user_pseudo_id. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         *         userPseudoId: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "querySuggestions": [],
         *   //   "tailMatchTriggered": false
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        completeQuery(params: Params$Resource$Projects$Locations$Collections$Datastores$Completequery, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        completeQuery(params?: Params$Resource$Projects$Locations$Collections$Datastores$Completequery, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1CompleteQueryResponse>>;
        completeQuery(params: Params$Resource$Projects$Locations$Collections$Datastores$Completequery, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        completeQuery(params: Params$Resource$Projects$Locations$Collections$Datastores$Completequery, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CompleteQueryResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CompleteQueryResponse>): void;
        completeQuery(params: Params$Resource$Projects$Locations$Collections$Datastores$Completequery, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CompleteQueryResponse>): void;
        completeQuery(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1CompleteQueryResponse>): void;
        /**
         * Creates a DataStore. DataStore is for storing Documents. To serve these documents for Search, or Recommendation use case, an Engine needs to be created separately.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.create({
         *       // Resource name of the CmekConfig to use for protecting this DataStore.
         *       cmekConfigName: 'placeholder-value',
         *       // A boolean flag indicating whether user want to directly create an advanced data store for site search. If the data store is not configured as site search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will be ignored.
         *       createAdvancedSiteSearch: 'placeholder-value',
         *       // Required. The ID to use for the DataStore, which will become the final component of the DataStore's resource name. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
         *       dataStoreId: 'placeholder-value',
         *       // DataStore without CMEK protections. If a default CmekConfig is set for the project, setting this field will override the default CmekConfig as well.
         *       disableCmek: 'placeholder-value',
         *       // Required. The parent resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}`.
         *       parent:
         *         'projects/my-project/locations/my-location/collections/my-collection',
         *       // A boolean flag indicating whether to skip the default schema creation for the data store. Only enable this flag if you are certain that the default schema is incompatible with your use case. If set to true, you must manually create a schema for the data store before any documents can be ingested. This flag cannot be specified if `data_store.starting_schema` is specified.
         *       skipDefaultSchemaCreation: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "aclEnabled": false,
         *         //   "advancedSiteSearchConfig": {},
         *         //   "billingEstimation": {},
         *         //   "cmekConfig": {},
         *         //   "contentConfig": "my_contentConfig",
         *         //   "createTime": "my_createTime",
         *         //   "defaultSchemaId": "my_defaultSchemaId",
         *         //   "displayName": "my_displayName",
         *         //   "documentProcessingConfig": {},
         *         //   "healthcareFhirConfig": {},
         *         //   "identityMappingStore": "my_identityMappingStore",
         *         //   "industryVertical": "my_industryVertical",
         *         //   "isInfobotFaqDataStore": false,
         *         //   "kmsKeyName": "my_kmsKeyName",
         *         //   "name": "my_name",
         *         //   "servingConfigDataStore": {},
         *         //   "solutionTypes": [],
         *         //   "startingSchema": {},
         *         //   "workspaceConfig": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Collections$Datastores$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Deletes a DataStore.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.delete({
         *       // Required. Full resource name of DataStore, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. If the caller does not have permission to delete the DataStore, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the DataStore to delete does not exist, a NOT_FOUND error is returned.
         *       name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Collections$Datastores$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a DataStore.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.get({
         *       // Required. Full resource name of DataStore, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. If the caller does not have permission to access the DataStore, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the requested DataStore does not exist, a NOT_FOUND error is returned.
         *       name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "aclEnabled": false,
         *   //   "advancedSiteSearchConfig": {},
         *   //   "billingEstimation": {},
         *   //   "cmekConfig": {},
         *   //   "contentConfig": "my_contentConfig",
         *   //   "createTime": "my_createTime",
         *   //   "defaultSchemaId": "my_defaultSchemaId",
         *   //   "displayName": "my_displayName",
         *   //   "documentProcessingConfig": {},
         *   //   "healthcareFhirConfig": {},
         *   //   "identityMappingStore": "my_identityMappingStore",
         *   //   "industryVertical": "my_industryVertical",
         *   //   "isInfobotFaqDataStore": false,
         *   //   "kmsKeyName": "my_kmsKeyName",
         *   //   "name": "my_name",
         *   //   "servingConfigDataStore": {},
         *   //   "solutionTypes": [],
         *   //   "startingSchema": {},
         *   //   "workspaceConfig": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1DataStore>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1DataStore>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1DataStore>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Get, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1DataStore>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1DataStore>): void;
        /**
         * Gets the SiteSearchEngine.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.getSiteSearchEngine(
         *       {
         *         // Required. Resource name of SiteSearchEngine, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/siteSearchEngine`. If the caller does not have permission to access the [SiteSearchEngine], regardless of whether or not it exists, a PERMISSION_DENIED error is returned.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/siteSearchEngine',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getSiteSearchEngine(params: Params$Resource$Projects$Locations$Collections$Datastores$Getsitesearchengine, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getSiteSearchEngine(params?: Params$Resource$Projects$Locations$Collections$Datastores$Getsitesearchengine, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1SiteSearchEngine>>;
        getSiteSearchEngine(params: Params$Resource$Projects$Locations$Collections$Datastores$Getsitesearchengine, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getSiteSearchEngine(params: Params$Resource$Projects$Locations$Collections$Datastores$Getsitesearchengine, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1SiteSearchEngine>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1SiteSearchEngine>): void;
        getSiteSearchEngine(params: Params$Resource$Projects$Locations$Collections$Datastores$Getsitesearchengine, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1SiteSearchEngine>): void;
        getSiteSearchEngine(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1SiteSearchEngine>): void;
        /**
         * Lists all the DataStores associated with the project.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.list({
         *       // Filter by solution type . For example: `filter = 'solution_type:SOLUTION_TYPE_SEARCH'`
         *       filter: 'placeholder-value',
         *       // Maximum number of DataStores to return. If unspecified, defaults to 10. The maximum allowed value is 50. Values above 50 will be coerced to 50. If this field is negative, an INVALID_ARGUMENT is returned.
         *       pageSize: 'placeholder-value',
         *       // A page token ListDataStoresResponse.next_page_token, received from a previous DataStoreService.ListDataStores call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to DataStoreService.ListDataStores must match the call that provided the page token. Otherwise, an INVALID_ARGUMENT error is returned.
         *       pageToken: 'placeholder-value',
         *       // Required. The parent branch resource name, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}`. If the caller does not have permission to list DataStores under this location, regardless of whether or not this data store exists, a PERMISSION_DENIED error is returned.
         *       parent:
         *         'projects/my-project/locations/my-location/collections/my-collection',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "dataStores": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ListDataStoresResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListDataStoresResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListDataStoresResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$List, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListDataStoresResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListDataStoresResponse>): void;
        /**
         * Updates a DataStore
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.patch({
         *       // Immutable. Identifier. The full resource name of the data store. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         *       name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *       // Indicates which fields in the provided DataStore to update. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "aclEnabled": false,
         *         //   "advancedSiteSearchConfig": {},
         *         //   "billingEstimation": {},
         *         //   "cmekConfig": {},
         *         //   "contentConfig": "my_contentConfig",
         *         //   "createTime": "my_createTime",
         *         //   "defaultSchemaId": "my_defaultSchemaId",
         *         //   "displayName": "my_displayName",
         *         //   "documentProcessingConfig": {},
         *         //   "healthcareFhirConfig": {},
         *         //   "identityMappingStore": "my_identityMappingStore",
         *         //   "industryVertical": "my_industryVertical",
         *         //   "isInfobotFaqDataStore": false,
         *         //   "kmsKeyName": "my_kmsKeyName",
         *         //   "name": "my_name",
         *         //   "servingConfigDataStore": {},
         *         //   "solutionTypes": [],
         *         //   "startingSchema": {},
         *         //   "workspaceConfig": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "aclEnabled": false,
         *   //   "advancedSiteSearchConfig": {},
         *   //   "billingEstimation": {},
         *   //   "cmekConfig": {},
         *   //   "contentConfig": "my_contentConfig",
         *   //   "createTime": "my_createTime",
         *   //   "defaultSchemaId": "my_defaultSchemaId",
         *   //   "displayName": "my_displayName",
         *   //   "documentProcessingConfig": {},
         *   //   "healthcareFhirConfig": {},
         *   //   "identityMappingStore": "my_identityMappingStore",
         *   //   "industryVertical": "my_industryVertical",
         *   //   "isInfobotFaqDataStore": false,
         *   //   "kmsKeyName": "my_kmsKeyName",
         *   //   "name": "my_name",
         *   //   "servingConfigDataStore": {},
         *   //   "solutionTypes": [],
         *   //   "startingSchema": {},
         *   //   "workspaceConfig": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Collections$Datastores$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1DataStore>>;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1DataStore>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1DataStore>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1DataStore>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1DataStore>): void;
        /**
         * Trains a custom model.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.trainCustomModel(
         *       {
         *         // Required. The resource name of the Data Store, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store`. This field is used to identify the data store where to train the models.
         *         dataStore:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "errorConfig": {},
         *           //   "gcsTrainingInput": {},
         *           //   "modelId": "my_modelId",
         *           //   "modelType": "my_modelType"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        trainCustomModel(params: Params$Resource$Projects$Locations$Collections$Datastores$Traincustommodel, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        trainCustomModel(params?: Params$Resource$Projects$Locations$Collections$Datastores$Traincustommodel, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        trainCustomModel(params: Params$Resource$Projects$Locations$Collections$Datastores$Traincustommodel, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        trainCustomModel(params: Params$Resource$Projects$Locations$Collections$Datastores$Traincustommodel, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        trainCustomModel(params: Params$Resource$Projects$Locations$Collections$Datastores$Traincustommodel, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        trainCustomModel(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Completequery extends StandardParameters {
        /**
         * Required. The parent data store resource name for which the completion is performed, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store`.
         */
        dataStore?: string;
        /**
         * Indicates if tail suggestions should be returned if there are no suggestions that match the full query. Even if set to true, if there are suggestions that match the full query, those are returned and no tail suggestions are returned.
         */
        includeTailSuggestions?: boolean;
        /**
         * Required. The typeahead input used to fetch suggestions. Maximum length is 128 characters.
         */
        query?: string;
        /**
         * Specifies the autocomplete data model. This overrides any model specified in the Configuration \> Autocomplete section of the Cloud console. Currently supported values: * `document` - Using suggestions generated from user-imported documents. * `search-history` - Using suggestions generated from the past history of SearchService.Search API calls. Do not use it when there is no traffic for Search API. * `user-event` - Using suggestions generated from user-imported search events. * `document-completable` - Using suggestions taken directly from user-imported document fields marked as completable. Default values: * `document` is the default model for regular dataStores. * `search-history` is the default model for site search dataStores.
         */
        queryModel?: string;
        /**
         * A unique identifier for tracking visitors. For example, this could be implemented with an HTTP cookie, which should be able to uniquely identify a visitor on a single device. This unique identifier should not change if the visitor logs in or out of the website. This field should NOT have a fixed value such as `unknown_visitor`. This should be the same identifier as UserEvent.user_pseudo_id and SearchRequest.user_pseudo_id. The field must be a UTF-8 encoded string with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        userPseudoId?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Create extends StandardParameters {
        /**
         * Resource name of the CmekConfig to use for protecting this DataStore.
         */
        cmekConfigName?: string;
        /**
         * A boolean flag indicating whether user want to directly create an advanced data store for site search. If the data store is not configured as site search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will be ignored.
         */
        createAdvancedSiteSearch?: boolean;
        /**
         * Required. The ID to use for the DataStore, which will become the final component of the DataStore's resource name. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        dataStoreId?: string;
        /**
         * DataStore without CMEK protections. If a default CmekConfig is set for the project, setting this field will override the default CmekConfig as well.
         */
        disableCmek?: boolean;
        /**
         * Required. The parent resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}`.
         */
        parent?: string;
        /**
         * A boolean flag indicating whether to skip the default schema creation for the data store. Only enable this flag if you are certain that the default schema is incompatible with your use case. If set to true, you must manually create a schema for the data store before any documents can be ingested. This flag cannot be specified if `data_store.starting_schema` is specified.
         */
        skipDefaultSchemaCreation?: boolean;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1DataStore;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Delete extends StandardParameters {
        /**
         * Required. Full resource name of DataStore, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. If the caller does not have permission to delete the DataStore, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the DataStore to delete does not exist, a NOT_FOUND error is returned.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Get extends StandardParameters {
        /**
         * Required. Full resource name of DataStore, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. If the caller does not have permission to access the DataStore, regardless of whether or not it exists, a PERMISSION_DENIED error is returned. If the requested DataStore does not exist, a NOT_FOUND error is returned.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Getsitesearchengine extends StandardParameters {
        /**
         * Required. Resource name of SiteSearchEngine, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/siteSearchEngine`. If the caller does not have permission to access the [SiteSearchEngine], regardless of whether or not it exists, a PERMISSION_DENIED error is returned.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$List extends StandardParameters {
        /**
         * Filter by solution type . For example: `filter = 'solution_type:SOLUTION_TYPE_SEARCH'`
         */
        filter?: string;
        /**
         * Maximum number of DataStores to return. If unspecified, defaults to 10. The maximum allowed value is 50. Values above 50 will be coerced to 50. If this field is negative, an INVALID_ARGUMENT is returned.
         */
        pageSize?: number;
        /**
         * A page token ListDataStoresResponse.next_page_token, received from a previous DataStoreService.ListDataStores call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to DataStoreService.ListDataStores must match the call that provided the page token. Otherwise, an INVALID_ARGUMENT error is returned.
         */
        pageToken?: string;
        /**
         * Required. The parent branch resource name, such as `projects/{project\}/locations/{location\}/collections/{collection_id\}`. If the caller does not have permission to list DataStores under this location, regardless of whether or not this data store exists, a PERMISSION_DENIED error is returned.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Patch extends StandardParameters {
        /**
         * Immutable. Identifier. The full resource name of the data store. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string;
        /**
         * Indicates which fields in the provided DataStore to update. If an unsupported or unknown field is provided, an INVALID_ARGUMENT error is returned.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1DataStore;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Traincustommodel extends StandardParameters {
        /**
         * Required. The resource name of the Data Store, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store`. This field is used to identify the data store where to train the models.
         */
        dataStore?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1TrainCustomModelRequest;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Branches {
        context: APIRequestContext;
        documents: Resource$Projects$Locations$Collections$Datastores$Branches$Documents;
        operations: Resource$Projects$Locations$Collections$Datastores$Branches$Operations;
        constructor(context: APIRequestContext);
        /**
         * Gets index freshness metadata for Documents. Supported for website search only.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.batchGetDocumentsMetadata(
         *       {
         *         // Required. The FHIR resources to match by. Format: projects/{project\}/locations/{location\}/datasets/{dataset\}/fhirStores/{fhir_store\}/fhir/{resource_type\}/{fhir_resource_id\}
         *         'matcher.fhirMatcher.fhirResources': 'placeholder-value',
         *         // The exact URIs to match by.
         *         'matcher.urisMatcher.uris': 'placeholder-value',
         *         // Required. The parent branch resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "documentsMetadata": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchGetDocumentsMetadata(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Batchgetdocumentsmetadata, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchGetDocumentsMetadata(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Batchgetdocumentsmetadata, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse>>;
        batchGetDocumentsMetadata(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Batchgetdocumentsmetadata, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchGetDocumentsMetadata(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Batchgetdocumentsmetadata, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse>): void;
        batchGetDocumentsMetadata(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Batchgetdocumentsmetadata, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse>): void;
        batchGetDocumentsMetadata(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1BatchGetDocumentsMetadataResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Batchgetdocumentsmetadata extends StandardParameters {
        /**
         * Required. The FHIR resources to match by. Format: projects/{project\}/locations/{location\}/datasets/{dataset\}/fhirStores/{fhir_store\}/fhir/{resource_type\}/{fhir_resource_id\}
         */
        'matcher.fhirMatcher.fhirResources'?: string[];
        /**
         * The exact URIs to match by.
         */
        'matcher.urisMatcher.uris'?: string[];
        /**
         * Required. The parent branch resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`.
         */
        parent?: string;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Branches$Documents {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a Document.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.documents.create(
         *       {
         *         // Required. The ID to use for the Document, which becomes the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. This field must be unique among all Documents with the same parent. Otherwise, an `ALREADY_EXISTS` error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         *         documentId: 'placeholder-value',
         *         // Required. The parent resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "aclInfo": {},
         *           //   "content": {},
         *           //   "derivedStructData": {},
         *           //   "id": "my_id",
         *           //   "indexStatus": {},
         *           //   "indexTime": "my_indexTime",
         *           //   "jsonData": "my_jsonData",
         *           //   "name": "my_name",
         *           //   "parentDocumentId": "my_parentDocumentId",
         *           //   "schemaId": "my_schemaId",
         *           //   "structData": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "aclInfo": {},
         *   //   "content": {},
         *   //   "derivedStructData": {},
         *   //   "id": "my_id",
         *   //   "indexStatus": {},
         *   //   "indexTime": "my_indexTime",
         *   //   "jsonData": "my_jsonData",
         *   //   "name": "my_name",
         *   //   "parentDocumentId": "my_parentDocumentId",
         *   //   "schemaId": "my_schemaId",
         *   //   "structData": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Document>>;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Create, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        /**
         * Deletes a Document.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.documents.delete(
         *       {
         *         // Required. Full resource name of Document, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}/documents/{document\}`. If the caller does not have permission to delete the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the Document to delete does not exist, a `NOT_FOUND` error is returned.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche/documents/my-document',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets a Document.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.documents.get(
         *       {
         *         // Required. Full resource name of Document, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}/documents/{document\}`. If the caller does not have permission to access the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the requested Document does not exist, a `NOT_FOUND` error is returned.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche/documents/my-document',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "aclInfo": {},
         *   //   "content": {},
         *   //   "derivedStructData": {},
         *   //   "id": "my_id",
         *   //   "indexStatus": {},
         *   //   "indexTime": "my_indexTime",
         *   //   "jsonData": "my_jsonData",
         *   //   "name": "my_name",
         *   //   "parentDocumentId": "my_parentDocumentId",
         *   //   "schemaId": "my_schemaId",
         *   //   "structData": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Document>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Get, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        /**
         * Bulk import of multiple Documents. Request processing may be synchronous. Non-existing items are created. Note: It is possible for a subset of the Documents to be successfully updated.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.documents.import(
         *       {
         *         // Required. The parent branch resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`. Requires create/update permission.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "alloyDbSource": {},
         *           //   "autoGenerateIds": false,
         *           //   "bigquerySource": {},
         *           //   "bigtableSource": {},
         *           //   "cloudSqlSource": {},
         *           //   "errorConfig": {},
         *           //   "fhirStoreSource": {},
         *           //   "firestoreSource": {},
         *           //   "forceRefreshContent": false,
         *           //   "gcsSource": {},
         *           //   "idField": "my_idField",
         *           //   "inlineSource": {},
         *           //   "reconciliationMode": "my_reconciliationMode",
         *           //   "spannerSource": {},
         *           //   "updateMask": "my_updateMask"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        import(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Import, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        import(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Import, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        import(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Import, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        import(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Import, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Import, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a list of Documents.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.documents.list(
         *       {
         *         // Maximum number of Documents to return. If unspecified, defaults to 100. The maximum allowed value is 1000. Values above 1000 are set to 1000. If this field is negative, an `INVALID_ARGUMENT` error is returned.
         *         pageSize: 'placeholder-value',
         *         // A page token ListDocumentsResponse.next_page_token, received from a previous DocumentService.ListDocuments call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to DocumentService.ListDocuments must match the call that provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent branch resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`. Use `default_branch` as the branch ID, to list documents under the default branch. If the caller does not have permission to list Documents under this branch, regardless of whether or not this branch exists, a `PERMISSION_DENIED` error is returned.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "documents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ListDocumentsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListDocumentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListDocumentsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$List, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListDocumentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListDocumentsResponse>): void;
        /**
         * Updates a Document.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.documents.patch(
         *       {
         *         // If set to `true` and the Document is not found, a new Document is be created.
         *         allowMissing: 'placeholder-value',
         *         // Immutable. The full resource name of the document. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}/documents/{document_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche/documents/my-document',
         *         // Indicates which fields in the provided imported 'document' to update. If not set, by default updates all fields.
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "aclInfo": {},
         *           //   "content": {},
         *           //   "derivedStructData": {},
         *           //   "id": "my_id",
         *           //   "indexStatus": {},
         *           //   "indexTime": "my_indexTime",
         *           //   "jsonData": "my_jsonData",
         *           //   "name": "my_name",
         *           //   "parentDocumentId": "my_parentDocumentId",
         *           //   "schemaId": "my_schemaId",
         *           //   "structData": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "aclInfo": {},
         *   //   "content": {},
         *   //   "derivedStructData": {},
         *   //   "id": "my_id",
         *   //   "indexStatus": {},
         *   //   "indexTime": "my_indexTime",
         *   //   "jsonData": "my_jsonData",
         *   //   "name": "my_name",
         *   //   "parentDocumentId": "my_parentDocumentId",
         *   //   "schemaId": "my_schemaId",
         *   //   "structData": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Document>>;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Document>): void;
        /**
         * Permanently deletes all selected Documents in a branch. This process is asynchronous. Depending on the number of Documents to be deleted, this operation can take hours to complete. Before the delete operation completes, some Documents might still be returned by DocumentService.GetDocument or DocumentService.ListDocuments. To get a list of the Documents to be deleted, set PurgeDocumentsRequest.force to false.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.documents.purge(
         *       {
         *         // Required. The parent resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "errorConfig": {},
         *           //   "filter": "my_filter",
         *           //   "force": false,
         *           //   "gcsSource": {},
         *           //   "inlineSource": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        purge(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Purge, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        purge(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Purge, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        purge(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Purge, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        purge(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Purge, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        purge(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Purge, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        purge(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Create extends StandardParameters {
        /**
         * Required. The ID to use for the Document, which becomes the final component of the Document.name. If the caller does not have permission to create the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. This field must be unique among all Documents with the same parent. Otherwise, an `ALREADY_EXISTS` error is returned. This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 128 characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        documentId?: string;
        /**
         * Required. The parent resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1Document;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Delete extends StandardParameters {
        /**
         * Required. Full resource name of Document, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}/documents/{document\}`. If the caller does not have permission to delete the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the Document to delete does not exist, a `NOT_FOUND` error is returned.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Get extends StandardParameters {
        /**
         * Required. Full resource name of Document, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}/documents/{document\}`. If the caller does not have permission to access the Document, regardless of whether or not it exists, a `PERMISSION_DENIED` error is returned. If the requested Document does not exist, a `NOT_FOUND` error is returned.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Import extends StandardParameters {
        /**
         * Required. The parent branch resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`. Requires create/update permission.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1ImportDocumentsRequest;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$List extends StandardParameters {
        /**
         * Maximum number of Documents to return. If unspecified, defaults to 100. The maximum allowed value is 1000. Values above 1000 are set to 1000. If this field is negative, an `INVALID_ARGUMENT` error is returned.
         */
        pageSize?: number;
        /**
         * A page token ListDocumentsResponse.next_page_token, received from a previous DocumentService.ListDocuments call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to DocumentService.ListDocuments must match the call that provided the page token. Otherwise, an `INVALID_ARGUMENT` error is returned.
         */
        pageToken?: string;
        /**
         * Required. The parent branch resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`. Use `default_branch` as the branch ID, to list documents under the default branch. If the caller does not have permission to list Documents under this branch, regardless of whether or not this branch exists, a `PERMISSION_DENIED` error is returned.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Patch extends StandardParameters {
        /**
         * If set to `true` and the Document is not found, a new Document is be created.
         */
        allowMissing?: boolean;
        /**
         * Immutable. The full resource name of the document. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}/documents/{document_id\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string;
        /**
         * Indicates which fields in the provided imported 'document' to update. If not set, by default updates all fields.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1Document;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Documents$Purge extends StandardParameters {
        /**
         * Required. The parent resource name, such as `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/branches/{branch\}`.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1PurgeDocumentsRequest;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Branches$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.operations.cancel(
         *       {
         *         // The name of the operation resource to be cancelled.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche/operations/my-operation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {}
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        cancel(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Cancel, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        cancel(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Cancel, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        cancel(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Cancel, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        cancel(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Cancel, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        cancel(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Cancel, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        cancel(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.operations.get(
         *       {
         *         // The name of the operation resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche/operations/my-operation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Get, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.branches.operations.list(
         *       {
         *         // The standard list filter.
         *         filter: 'placeholder-value',
         *         // The name of the operation's parent resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/branches/my-branche',
         *         // The standard list page size.
         *         pageSize: 'placeholder-value',
         *         // The standard list page token.
         *         pageToken: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "operations": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningListOperationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$List, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Cancel extends StandardParameters {
        /**
         * The name of the operation resource to be cancelled.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleLongrunningCancelOperationRequest;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$Get extends StandardParameters {
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Branches$Operations$List extends StandardParameters {
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Completionconfig {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Completes the user input with advanced keyword suggestions.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/cloud_search.query',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.completionConfig.completeQuery(
         *       {
         *         // Required. The completion_config of the parent dataStore or engine resource name for which the completion is performed, such as `projects/x/locations/global/collections/default_collection/dataStores/x/completionConfig` `projects/x/locations/global/collections/default_collection/engines/x/completionConfig`.
         *         completionConfig:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/completionConfig',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "boostSpec": {},
         *           //   "experimentIds": [],
         *           //   "includeTailSuggestions": false,
         *           //   "query": "my_query",
         *           //   "queryModel": "my_queryModel",
         *           //   "suggestionTypeSpecs": [],
         *           //   "suggestionTypes": [],
         *           //   "userInfo": {},
         *           //   "userPseudoId": "my_userPseudoId"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contentSuggestions": [],
         *   //   "peopleSuggestions": [],
         *   //   "querySuggestions": [],
         *   //   "recentSearchSuggestions": [],
         *   //   "tailMatchTriggered": false
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        completeQuery(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionconfig$Completequery, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        completeQuery(params?: Params$Resource$Projects$Locations$Collections$Datastores$Completionconfig$Completequery, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse>>;
        completeQuery(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionconfig$Completequery, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        completeQuery(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionconfig$Completequery, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse>): void;
        completeQuery(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionconfig$Completequery, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse>): void;
        completeQuery(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Completionconfig$Completequery extends StandardParameters {
        /**
         * Required. The completion_config of the parent dataStore or engine resource name for which the completion is performed, such as `projects/x/locations/global/collections/default_collection/dataStores/x/completionConfig` `projects/x/locations/global/collections/default_collection/engines/x/completionConfig`.
         */
        completionConfig?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1AdvancedCompleteQueryRequest;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Completionsuggestions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Imports CompletionSuggestions for a DataStore.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.completionSuggestions.import(
         *       {
         *         // Required. The parent data store resource name for which to import customer autocomplete suggestions. Follows pattern `projects/x/locations/x/collections/x/dataStores/x`
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "bigquerySource": {},
         *           //   "errorConfig": {},
         *           //   "gcsSource": {},
         *           //   "inlineSource": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        import(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Import, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        import(params?: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Import, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        import(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Import, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        import(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Import, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Import, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Permanently deletes all CompletionSuggestions for a DataStore.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.completionSuggestions.purge(
         *       {
         *         // Required. The parent data store resource name for which to purge completion suggestions. Follows pattern projects/x/locations/x/collections/x/dataStores/x.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {}
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        purge(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Purge, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        purge(params?: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Purge, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        purge(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Purge, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        purge(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Purge, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        purge(params: Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Purge, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        purge(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Import extends StandardParameters {
        /**
         * Required. The parent data store resource name for which to import customer autocomplete suggestions. Follows pattern `projects/x/locations/x/collections/x/dataStores/x`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1ImportCompletionSuggestionsRequest;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Completionsuggestions$Purge extends StandardParameters {
        /**
         * Required. The parent data store resource name for which to purge completion suggestions. Follows pattern projects/x/locations/x/collections/x/dataStores/x.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1PurgeCompletionSuggestionsRequest;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Controls {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a Control. By default 1000 controls are allowed for a data store. A request can be submitted to adjust this limit. If the Control to create already exists, an ALREADY_EXISTS error is returned.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.controls.create(
         *       {
         *         // Required. The ID to use for the Control, which will become the final component of the Control's resource name. This value must be within 1-63 characters. Valid characters are /a-z-_/.
         *         controlId: 'placeholder-value',
         *         // Required. Full resource name of parent data store. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}` or `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}`.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "associatedServingConfigIds": [],
         *           //   "boostAction": {},
         *           //   "conditions": [],
         *           //   "displayName": "my_displayName",
         *           //   "filterAction": {},
         *           //   "name": "my_name",
         *           //   "promoteAction": {},
         *           //   "redirectAction": {},
         *           //   "solutionType": "my_solutionType",
         *           //   "synonymsAction": {},
         *           //   "useCases": []
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "associatedServingConfigIds": [],
         *   //   "boostAction": {},
         *   //   "conditions": [],
         *   //   "displayName": "my_displayName",
         *   //   "filterAction": {},
         *   //   "name": "my_name",
         *   //   "promoteAction": {},
         *   //   "redirectAction": {},
         *   //   "solutionType": "my_solutionType",
         *   //   "synonymsAction": {},
         *   //   "useCases": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Control>>;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Create, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
        /**
         * Deletes a Control. If the Control to delete does not exist, a NOT_FOUND error is returned.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.controls.delete(
         *       {
         *         // Required. The resource name of the Control to delete. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}/controls/{control_id\}`
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/controls/my-control',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets a Control.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.controls.get(
         *       {
         *         // Required. The resource name of the Control to get. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}/controls/{control_id\}`
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/controls/my-control',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "associatedServingConfigIds": [],
         *   //   "boostAction": {},
         *   //   "conditions": [],
         *   //   "displayName": "my_displayName",
         *   //   "filterAction": {},
         *   //   "name": "my_name",
         *   //   "promoteAction": {},
         *   //   "redirectAction": {},
         *   //   "solutionType": "my_solutionType",
         *   //   "synonymsAction": {},
         *   //   "useCases": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Control>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Get, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
        /**
         * Lists all Controls by their parent DataStore.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.controls.list(
         *       {
         *         // Optional. A filter to apply on the list results. Supported features: * List all the products under the parent branch if filter is unset. Currently this field is unsupported.
         *         filter: 'placeholder-value',
         *         // Optional. Maximum number of results to return. If unspecified, defaults to 50. Max allowed value is 1000.
         *         pageSize: 'placeholder-value',
         *         // Optional. A page token, received from a previous `ListControls` call. Provide this to retrieve the subsequent page.
         *         pageToken: 'placeholder-value',
         *         // Required. The data store resource name. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}` or `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}`.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "controls": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Controls$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ListControlsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListControlsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListControlsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$List, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListControlsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListControlsResponse>): void;
        /**
         * Updates a Control. Control action type cannot be changed. If the Control to update does not exist, a NOT_FOUND error is returned.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.controls.patch(
         *       {
         *         // Immutable. Fully qualified name `projects/x/locations/global/dataStore/x/controls/x`
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/controls/my-control',
         *         // Optional. Indicates which fields in the provided Control to update. The following are NOT supported: * Control.name * Control.solution_type If not set or empty, all supported fields are updated.
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "associatedServingConfigIds": [],
         *           //   "boostAction": {},
         *           //   "conditions": [],
         *           //   "displayName": "my_displayName",
         *           //   "filterAction": {},
         *           //   "name": "my_name",
         *           //   "promoteAction": {},
         *           //   "redirectAction": {},
         *           //   "solutionType": "my_solutionType",
         *           //   "synonymsAction": {},
         *           //   "useCases": []
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "associatedServingConfigIds": [],
         *   //   "boostAction": {},
         *   //   "conditions": [],
         *   //   "displayName": "my_displayName",
         *   //   "filterAction": {},
         *   //   "name": "my_name",
         *   //   "promoteAction": {},
         *   //   "redirectAction": {},
         *   //   "solutionType": "my_solutionType",
         *   //   "synonymsAction": {},
         *   //   "useCases": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Control>>;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Controls$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Control>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Controls$Create extends StandardParameters {
        /**
         * Required. The ID to use for the Control, which will become the final component of the Control's resource name. This value must be within 1-63 characters. Valid characters are /a-z-_/.
         */
        controlId?: string;
        /**
         * Required. Full resource name of parent data store. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}` or `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}`.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1Control;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Controls$Delete extends StandardParameters {
        /**
         * Required. The resource name of the Control to delete. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}/controls/{control_id\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Controls$Get extends StandardParameters {
        /**
         * Required. The resource name of the Control to get. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}/controls/{control_id\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Controls$List extends StandardParameters {
        /**
         * Optional. A filter to apply on the list results. Supported features: * List all the products under the parent branch if filter is unset. Currently this field is unsupported.
         */
        filter?: string;
        /**
         * Optional. Maximum number of results to return. If unspecified, defaults to 50. Max allowed value is 1000.
         */
        pageSize?: number;
        /**
         * Optional. A page token, received from a previous `ListControls` call. Provide this to retrieve the subsequent page.
         */
        pageToken?: string;
        /**
         * Required. The data store resource name. Format: `projects/{project\}/locations/{location\}/collections/{collection_id\}/dataStores/{data_store_id\}` or `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}`.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Controls$Patch extends StandardParameters {
        /**
         * Immutable. Fully qualified name `projects/x/locations/global/dataStore/x/controls/x`
         */
        name?: string;
        /**
         * Optional. Indicates which fields in the provided Control to update. The following are NOT supported: * Control.name * Control.solution_type If not set or empty, all supported fields are updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1Control;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Conversations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Converses a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.conversations.converse(
         *       {
         *         // Required. The resource name of the Conversation to get. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/conversations/{conversation_id\}`. Use `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/conversations/-` to activate auto session mode, which automatically creates a new conversation inside a ConverseConversation session.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/conversations/my-conversation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "boostSpec": {},
         *           //   "conversation": {},
         *           //   "filter": "my_filter",
         *           //   "query": {},
         *           //   "safeSearch": false,
         *           //   "servingConfig": "my_servingConfig",
         *           //   "summarySpec": {},
         *           //   "userLabels": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversation": {},
         *   //   "reply": {},
         *   //   "searchResults": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        converse(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Converse, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        converse(params?: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Converse, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ConverseConversationResponse>>;
        converse(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Converse, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        converse(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Converse, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ConverseConversationResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ConverseConversationResponse>): void;
        converse(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Converse, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ConverseConversationResponse>): void;
        converse(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ConverseConversationResponse>): void;
        /**
         * Creates a Conversation. If the Conversation to create already exists, an ALREADY_EXISTS error is returned.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.conversations.create(
         *       {
         *         // Required. Full resource name of parent data store. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}`
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "endTime": "my_endTime",
         *           //   "messages": [],
         *           //   "name": "my_name",
         *           //   "startTime": "my_startTime",
         *           //   "state": "my_state",
         *           //   "userPseudoId": "my_userPseudoId"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "endTime": "my_endTime",
         *   //   "messages": [],
         *   //   "name": "my_name",
         *   //   "startTime": "my_startTime",
         *   //   "state": "my_state",
         *   //   "userPseudoId": "my_userPseudoId"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Conversation>>;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Create, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
        /**
         * Deletes a Conversation. If the Conversation to delete does not exist, a NOT_FOUND error is returned.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.conversations.delete(
         *       {
         *         // Required. The resource name of the Conversation to delete. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/conversations/{conversation_id\}`
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets a Conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.conversations.get(
         *       {
         *         // Required. The resource name of the Conversation to get. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/conversations/{conversation_id\}`
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "endTime": "my_endTime",
         *   //   "messages": [],
         *   //   "name": "my_name",
         *   //   "startTime": "my_startTime",
         *   //   "state": "my_state",
         *   //   "userPseudoId": "my_userPseudoId"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Conversation>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Get, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
        /**
         * Lists all Conversations by their parent DataStore.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.conversations.list(
         *       {
         *         // A filter to apply on the list results. The supported features are: user_pseudo_id, state. Example: "user_pseudo_id = some_id"
         *         filter: 'placeholder-value',
         *         // A comma-separated list of fields to order by, sorted in ascending order. Use "desc" after a field name for descending. Supported fields: * `update_time` * `create_time` * `conversation_name` Example: "update_time desc" "create_time"
         *         orderBy: 'placeholder-value',
         *         // Maximum number of results to return. If unspecified, defaults to 50. Max allowed value is 1000.
         *         pageSize: 'placeholder-value',
         *         // A page token, received from a previous `ListConversations` call. Provide this to retrieve the subsequent page.
         *         pageToken: 'placeholder-value',
         *         // Required. The data store resource name. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}`
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversations": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ListConversationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListConversationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListConversationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$List, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListConversationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListConversationsResponse>): void;
        /**
         * Updates a Conversation. Conversation action type cannot be changed. If the Conversation to update does not exist, a NOT_FOUND error is returned.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.conversations.patch(
         *       {
         *         // Immutable. Fully qualified name `projects/{project\}/locations/global/collections/{collection\}/dataStore/x/conversations/x` or `projects/{project\}/locations/global/collections/{collection\}/engines/x/conversations/x`.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/conversations/my-conversation',
         *         // Indicates which fields in the provided Conversation to update. The following are NOT supported: * Conversation.name If not set or empty, all supported fields are updated.
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "endTime": "my_endTime",
         *           //   "messages": [],
         *           //   "name": "my_name",
         *           //   "startTime": "my_startTime",
         *           //   "state": "my_state",
         *           //   "userPseudoId": "my_userPseudoId"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "endTime": "my_endTime",
         *   //   "messages": [],
         *   //   "name": "my_name",
         *   //   "startTime": "my_startTime",
         *   //   "state": "my_state",
         *   //   "userPseudoId": "my_userPseudoId"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Conversation>>;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Conversation>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Converse extends StandardParameters {
        /**
         * Required. The resource name of the Conversation to get. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/conversations/{conversation_id\}`. Use `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/conversations/-` to activate auto session mode, which automatically creates a new conversation inside a ConverseConversation session.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1ConverseConversationRequest;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Create extends StandardParameters {
        /**
         * Required. Full resource name of parent data store. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1Conversation;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Delete extends StandardParameters {
        /**
         * Required. The resource name of the Conversation to delete. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/conversations/{conversation_id\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Get extends StandardParameters {
        /**
         * Required. The resource name of the Conversation to get. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}/conversations/{conversation_id\}`
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Conversations$List extends StandardParameters {
        /**
         * A filter to apply on the list results. The supported features are: user_pseudo_id, state. Example: "user_pseudo_id = some_id"
         */
        filter?: string;
        /**
         * A comma-separated list of fields to order by, sorted in ascending order. Use "desc" after a field name for descending. Supported fields: * `update_time` * `create_time` * `conversation_name` Example: "update_time desc" "create_time"
         */
        orderBy?: string;
        /**
         * Maximum number of results to return. If unspecified, defaults to 50. Max allowed value is 1000.
         */
        pageSize?: number;
        /**
         * A page token, received from a previous `ListConversations` call. Provide this to retrieve the subsequent page.
         */
        pageToken?: string;
        /**
         * Required. The data store resource name. Format: `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store_id\}`
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Conversations$Patch extends StandardParameters {
        /**
         * Immutable. Fully qualified name `projects/{project\}/locations/global/collections/{collection\}/dataStore/x/conversations/x` or `projects/{project\}/locations/global/collections/{collection\}/engines/x/conversations/x`.
         */
        name?: string;
        /**
         * Indicates which fields in the provided Conversation to update. The following are NOT supported: * Conversation.name If not set or empty, all supported fields are updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1Conversation;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Custommodels {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Gets a list of all the custom models.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.customModels.list(
         *       {
         *         // Required. The resource name of the parent Data Store, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store`. This field is used to identify the data store where to fetch the models from.
         *         dataStore:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "models": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Custommodels$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Custommodels$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ListCustomModelsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Custommodels$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Custommodels$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListCustomModelsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListCustomModelsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Custommodels$List, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListCustomModelsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListCustomModelsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Custommodels$List extends StandardParameters {
        /**
         * Required. The resource name of the parent Data Store, such as `projects/x/locations/global/collections/default_collection/dataStores/default_data_store`. This field is used to identify the data store where to fetch the models from.
         */
        dataStore?: string;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Models {
        context: APIRequestContext;
        operations: Resource$Projects$Locations$Collections$Datastores$Models$Operations;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Locations$Collections$Datastores$Models$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.models.operations.get(
         *       {
         *         // The name of the operation resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/models/my-model/operations/my-operation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$Get, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.models.operations.list(
         *       {
         *         // The standard list filter.
         *         filter: 'placeholder-value',
         *         // The name of the operation's parent resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/models/my-model',
         *         // The standard list page size.
         *         pageSize: 'placeholder-value',
         *         // The standard list page token.
         *         pageToken: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "operations": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningListOperationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$List, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$Get extends StandardParameters {
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Models$Operations$List extends StandardParameters {
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.operations.get(
         *       {
         *         // The name of the operation resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/operations/my-operation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Operations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Operations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Operations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Operations$Get, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.operations.list(
         *       {
         *         // The standard list filter.
         *         filter: 'placeholder-value',
         *         // The name of the operation's parent resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *         // The standard list page size.
         *         pageSize: 'placeholder-value',
         *         // The standard list page token.
         *         pageToken: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "operations": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Operations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Operations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningListOperationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Operations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Operations$List, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Operations$Get extends StandardParameters {
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Operations$List extends StandardParameters {
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Schemas {
        context: APIRequestContext;
        operations: Resource$Projects$Locations$Collections$Datastores$Schemas$Operations;
        constructor(context: APIRequestContext);
        /**
         * Creates a Schema.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.schemas.create(
         *       {
         *         // Required. The parent data store resource name, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}`.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *         // Required. The ID to use for the Schema, which becomes the final component of the Schema.name. This field should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
         *         schemaId: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "jsonSchema": "my_jsonSchema",
         *           //   "name": "my_name",
         *           //   "structSchema": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Deletes a Schema.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.schemas.delete(
         *       {
         *         // Required. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/schemas/my-schema',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a Schema.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.schemas.get(
         *       {
         *         // Required. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/schemas/my-schema',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "jsonSchema": "my_jsonSchema",
         *   //   "name": "my_name",
         *   //   "structSchema": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1Schema>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Schema>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Schema>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Get, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Schema>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1Schema>): void;
        /**
         * Gets a list of Schemas.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.schemas.list(
         *       {
         *         // The maximum number of Schemas to return. The service may return fewer than this value. If unspecified, at most 100 Schemas are returned. The maximum value is 1000; values above 1000 are set to 1000.
         *         pageSize: 'placeholder-value',
         *         // A page token, received from a previous SchemaService.ListSchemas call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to SchemaService.ListSchemas must match the call that provided the page token.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent data store resource name, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}`.
         *         parent:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "schemas": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ListSchemasResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListSchemasResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListSchemasResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$List, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListSchemasResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ListSchemasResponse>): void;
        /**
         * Updates a Schema.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.schemas.patch(
         *       {
         *         // If set to true, and the Schema is not found, a new Schema is created. In this situation, `update_mask` is ignored.
         *         allowMissing: 'placeholder-value',
         *         // Immutable. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/schemas/my-schema',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "jsonSchema": "my_jsonSchema",
         *           //   "name": "my_name",
         *           //   "structSchema": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Patch, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Create extends StandardParameters {
        /**
         * Required. The parent data store resource name, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}`.
         */
        parent?: string;
        /**
         * Required. The ID to use for the Schema, which becomes the final component of the Schema.name. This field should conform to [RFC-1034](https://tools.ietf.org/html/rfc1034) standard with a length limit of 63 characters.
         */
        schemaId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1Schema;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Delete extends StandardParameters {
        /**
         * Required. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Get extends StandardParameters {
        /**
         * Required. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Schemas$List extends StandardParameters {
        /**
         * The maximum number of Schemas to return. The service may return fewer than this value. If unspecified, at most 100 Schemas are returned. The maximum value is 1000; values above 1000 are set to 1000.
         */
        pageSize?: number;
        /**
         * A page token, received from a previous SchemaService.ListSchemas call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to SchemaService.ListSchemas must match the call that provided the page token.
         */
        pageToken?: string;
        /**
         * Required. The parent data store resource name, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}`.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Patch extends StandardParameters {
        /**
         * If set to true, and the Schema is not found, a new Schema is created. In this situation, `update_mask` is ignored.
         */
        allowMissing?: boolean;
        /**
         * Immutable. The full resource name of the schema, in the format of `projects/{project\}/locations/{location\}/collections/{collection\}/dataStores/{data_store\}/schemas/{schema\}`. This field must be a UTF-8 encoded string with a length limit of 1024 characters.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDiscoveryengineV1Schema;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Schemas$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.schemas.operations.get(
         *       {
         *         // The name of the operation resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/schemas/my-schema/operations/my-operation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$Get, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.schemas.operations.list(
         *       {
         *         // The standard list filter.
         *         filter: 'placeholder-value',
         *         // The name of the operation's parent resource.
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/schemas/my-schema',
         *         // The standard list page size.
         *         pageSize: 'placeholder-value',
         *         // The standard list page token.
         *         pageToken: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "operations": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningListOperationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$List, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$Get extends StandardParameters {
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Collections$Datastores$Schemas$Operations$List extends StandardParameters {
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
    }
    export class Resource$Projects$Locations$Collections$Datastores$Servingconfigs {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Answer query method.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.servingConfigs.answer(
         *       {
         *         // Required. The resource name of the Search serving config, such as `projects/x/locations/global/collections/default_collection/engines/x/servingConfigs/default_serving_config`, or `projects/x/locations/global/collections/default_collection/dataStores/x/servingConfigs/default_serving_config`. This field is used to identify the serving configuration name, set of models used to make the search.
         *         servingConfig:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/servingConfigs/my-servingConfig',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "answerGenerationSpec": {},
         *           //   "asynchronousMode": false,
         *           //   "endUserSpec": {},
         *           //   "groundingSpec": {},
         *           //   "query": {},
         *           //   "queryUnderstandingSpec": {},
         *           //   "relatedQuestionsSpec": {},
         *           //   "safetySpec": {},
         *           //   "searchSpec": {},
         *           //   "session": "my_session",
         *           //   "userLabels": {},
         *           //   "userPseudoId": "my_userPseudoId"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "answer": {},
         *   //   "answerQueryToken": "my_answerQueryToken",
         *   //   "session": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        answer(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Answer, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        answer(params?: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Answer, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1AnswerQueryResponse>>;
        answer(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Answer, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        answer(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Answer, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1AnswerQueryResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1AnswerQueryResponse>): void;
        answer(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Answer, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1AnswerQueryResponse>): void;
        answer(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1AnswerQueryResponse>): void;
        /**
         * Updates a ServingConfig. Returns a NOT_FOUND error if the ServingConfig does not exist.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.servingConfigs.patch(
         *       {
         *         // Immutable. Fully qualified name `projects/{project\}/locations/{location\}/collections/{collection_id\}/engines/{engine_id\}/servingConfigs/{serving_config_id\}`
         *         name: 'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/servingConfigs/my-servingConfig',
         *         // Indicates which fields in the provided ServingConfig to update. The following are NOT supported: * ServingConfig.name If not set, all supported fields are updated.
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "answerGenerationSpec": {},
         *           //   "boostControlIds": [],
         *           //   "createTime": "my_createTime",
         *           //   "displayName": "my_displayName",
         *           //   "dissociateControlIds": [],
         *           //   "diversityLevel": "my_diversityLevel",
         *           //   "filterControlIds": [],
         *           //   "genericConfig": {},
         *           //   "ignoreControlIds": [],
         *           //   "mediaConfig": {},
         *           //   "modelId": "my_modelId",
         *           //   "name": "my_name",
         *           //   "onewaySynonymsControlIds": [],
         *           //   "promoteControlIds": [],
         *           //   "rankingExpression": "my_rankingExpression",
         *           //   "redirectControlIds": [],
         *           //   "replacementControlIds": [],
         *           //   "solutionType": "my_solutionType",
         *           //   "synonymsControlIds": [],
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "answerGenerationSpec": {},
         *   //   "boostControlIds": [],
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "dissociateControlIds": [],
         *   //   "diversityLevel": "my_diversityLevel",
         *   //   "filterControlIds": [],
         *   //   "genericConfig": {},
         *   //   "ignoreControlIds": [],
         *   //   "mediaConfig": {},
         *   //   "modelId": "my_modelId",
         *   //   "name": "my_name",
         *   //   "onewaySynonymsControlIds": [],
         *   //   "promoteControlIds": [],
         *   //   "rankingExpression": "my_rankingExpression",
         *   //   "redirectControlIds": [],
         *   //   "replacementControlIds": [],
         *   //   "solutionType": "my_solutionType",
         *   //   "synonymsControlIds": [],
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1ServingConfig>>;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ServingConfig>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ServingConfig>): void;
        patch(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ServingConfig>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1ServingConfig>): void;
        /**
         * Makes a recommendation, which requires a contextual user event.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.servingConfigs.recommend(
         *       {
         *         // Required. Full resource name of a ServingConfig: `projects/x/locations/global/collections/x/engines/x/servingConfigs/x`, or `projects/x/locations/global/collections/x/dataStores/x/servingConfigs/x` One default serving config is created along with your recommendation engine creation. The engine ID is used as the ID of the default serving config. For example, for Engine `projects/x/locations/global/collections/x/engines/my-engine`, you can use `projects/x/locations/global/collections/x/engines/my-engine/servingConfigs/my-engine` for your RecommendationService.Recommend requests.
         *         servingConfig:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/servingConfigs/my-servingConfig',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "filter": "my_filter",
         *           //   "pageSize": 0,
         *           //   "params": {},
         *           //   "userEvent": {},
         *           //   "userLabels": {},
         *           //   "validateOnly": false
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "attributionToken": "my_attributionToken",
         *   //   "missingIds": [],
         *   //   "results": [],
         *   //   "validateOnly": false
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        recommend(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Recommend, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        recommend(params?: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Recommend, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1RecommendResponse>>;
        recommend(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Recommend, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        recommend(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Recommend, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1RecommendResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1RecommendResponse>): void;
        recommend(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Recommend, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1RecommendResponse>): void;
        recommend(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1RecommendResponse>): void;
        /**
         * Performs a search.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/discoveryengine.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const discoveryengine = google.discoveryengine('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await discoveryengine.projects.locations.collections.dataStores.servingConfigs.search(
         *       {
         *         // Required. The resource name of the Search serving config, such as `projects/x/locations/global/collections/default_collection/engines/x/servingConfigs/default_serving_config`, or `projects/x/locations/global/collections/default_collection/dataStores/default_data_store/servingConfigs/default_serving_config`. This field is used to identify the serving configuration name, set of models used to make the search.
         *         servingConfig:
         *           'projects/my-project/locations/my-location/collections/my-collection/dataStores/my-dataStore/servingConfigs/my-servingConfig',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "boostSpec": {},
         *           //   "branch": "my_branch",
         *           //   "canonicalFilter": "my_canonicalFilter",
         *           //   "contentSearchSpec": {},
         *           //   "dataStoreSpecs": [],
         *           //   "displaySpec": {},
         *           //   "facetSpecs": [],
         *           //   "filter": "my_filter",
         *           //   "imageQuery": {},
         *           //   "languageCode": "my_languageCode",
         *           //   "offset": 0,
         *           //   "oneBoxPageSize": 0,
         *           //   "orderBy": "my_orderBy",
         *           //   "pageSize": 0,
         *           //   "pageToken": "my_pageToken",
         *           //   "params": {},
         *           //   "query": "my_query",
         *           //   "queryExpansionSpec": {},
         *           //   "rankingExpression": "my_rankingExpression",
         *           //   "rankingExpressionBackend": "my_rankingExpressionBackend",
         *           //   "relevanceScoreSpec": {},
         *           //   "relevanceThreshold": "my_relevanceThreshold",
         *           //   "safeSearch": false,
         *           //   "searchAsYouTypeSpec": {},
         *           //   "session": "my_session",
         *           //   "sessionSpec": {},
         *           //   "spellCorrectionSpec": {},
         *           //   "userInfo": {},
         *           //   "userLabels": {},
         *           //   "userPseudoId": "my_userPseudoId"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "attributionToken": "my_attributionToken",
         *   //   "correctedQuery": "my_correctedQuery",
         *   //   "facets": [],
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "queryExpansionInfo": {},
         *   //   "redirectUri": "my_redirectUri",
         *   //   "results": [],
         *   //   "searchLinkPromotions": [],
         *   //   "sessionInfo": {},
         *   //   "summary": {},
         *   //   "totalSize": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        search(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Search, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        search(params?: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Search, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDiscoveryengineV1SearchResponse>>;
        search(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Search, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        search(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Search, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1SearchResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1SearchResponse>): void;
        search(params: Params$Resource$Projects$Locations$Collections$Datastores$Servingconfigs$Search, callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1SearchResponse>): void;
        search(callback: BodyResponseCallback<Schema$GoogleCloudDiscoveryengineV1SearchResponse>): void;
        /**
         * Performs a search. Similar to the SearchService.Search method, but a lite version that allows API key for authentication, where OAuth and IAM checks are not required. Only public website search is supported by this method. If data stores and engines not associated with public website search are specified, a `FAILED_PRECONDITION` error is returned. This method can be used for easy onboarding without having to implement an authentication backend. However, it is strongly recommended to use SearchService.Search instead with 