# WAF Bypass Tester

A powerful GUI tool for testing and bypassing Web Application Firewalls (WAFs).

## Overview

WAF Bypass Tester is a comprehensive penetration testing tool designed to help security professionals identify vulnerabilities in web applications protected by WAFs. With a modern user interface and a wide range of testing capabilities, it provides an efficient way to test various bypass techniques.

## Features

- **Multi-Vector Testing**:
  - SQL Injection bypass testing
  - XSS (Cross-Site Scripting) bypass testing
  - LFI (Local File Inclusion) vulnerability testing
  - 404 bypass techniques with header, IP, and URL payload combinations

- **Advanced Capabilities**:
  - Combined payload generation
  - Multi-threaded scanning for faster results
  - Proxy support for anonymous testing
  - Custom HTTP headers and methods
  - Detailed analysis of scan results

- **User-Friendly Interface**:
  - Modern GitHub Dark theme
  - Intuitive tabbed interface for different attack vectors
  - Real-time scanning progress updates
  - Customizable theme settings
  - Comprehensive logging

## Payload Collection

The tool comes with an extensive collection of payloads organized by category:

- **SQL Injection**:
  - Generic detection payloads
  - Error-based techniques
  - Time-based techniques
  - Union select techniques
  - Blind SQL injection
  - Database-specific payloads (MySQL, MSSQL, Oracle, PostgreSQL, DB2)
  - Authentication bypass techniques

- **XSS Attacks**:
  - Comprehensive XSS payload list

- **404 Bypass Techniques**:
  - URL manipulation payloads
  - IP-based bypass techniques
  - Header manipulation templates

- **LFI Vulnerabilities**:
  - Path traversal techniques
  - Null byte injection
  - Encoding bypass methods

## Requirements

- Python 3.6+
- Tkinter (for GUI)
- Requests library

## Installation

1. Clone this repository
2. Install the required dependencies:
   ```
   pip install requests
   ```
3. Run the application:
   ```
   python "sql parole.py"
   ```

## Usage Guide

### SQL Injection Testing
1. Go to the SQL tab
2. Enter target URL with `{token}` placeholder for injection point
3. Load payloads using the "LOAD PAYLOADS" button
4. Configure headers and proxy settings if needed
5. Click "START SCAN" to begin testing

### 404 Bypass Testing
1. Navigate to the 404 Bypass tab
2. Enter the target URL base with `{payload}` placeholder
3. Load payloads from the 404 directory or generate combined payloads
4. Set 404 detection strings to identify normal 404 pages
5. Start the scan and review results in the tree view

### XSS Testing
1. Select the XSS tab
2. Configure the target URL with `{payload}` placeholder
3. Set a baseline value for comparison
4. Load XSS payloads
5. Start the scan to identify successful XSS bypasses

### LFI Testing
1. Go to the LFI tab
2. Enter the target URL with the injection point
3. Load LFI payloads
4. Configure detection strings to identify successful LFI
5. Run the scan and analyze the results

## Screenshots

(Screenshots will be added soon)

## Disclaimer

This tool is intended for legal penetration testing, educational purposes, and authorized security assessments only. Using this tool against any website or application without explicit permission is illegal. The developers assume no liability for misuse or damage caused by this tool.

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.
