import asyncio
import json
import random
from pyrogram import Client
from pyrogram.errors import FloodWait, UsernameInvalid, PeerIdInvalid
import os
import sys 

# --- KONFIGURASI PENTING ---
# Ganti dengan data Anda sendiri
API_ID = 2139215 
API_HASH = "6332c34a301ca1bd91b67aa2daa89807" 
SESSION_NAME = "user_extractor_session"
INPUT_FILE = "list_u.txt"
OUTPUT_FILE = "user_ids.json"

# Waktu tunggu Anti-Flood yang lebih bervariasi (8 hingga 13 detik)
MIN_WAIT_TIME = 10
MAX_WAIT_TIME = 20
# --------------------------

def read_usernames(filename):
    """Membaca username dari file teks, membersihkan '@', dan mengembalikan daftar unik."""
    try:
        with open(filename, 'r', encoding='utf-8') as f:
            usernames = [line.strip().lstrip('@') for line in f if line.strip()]
        return list(set(usernames))
    except FileNotFoundError:
        print(f"Error: File '{filename}' tidak ditemukan.")
        return []

def load_existing_results(filename):
    """Memuat semua hasil yang sudah ada dari file JSON."""
    if not os.path.exists(filename) or os.stat(filename).st_size == 0:
        return []
    try:
        with open(filename, 'r', encoding='utf-8') as f:
            # Menggunakan json.load untuk memuat seluruh array JSON
            return json.load(f)
    except json.JSONDecodeError:
        print(f"Peringatan: File '{filename}' rusak atau kosong. Memulai dari awal.")
        return []
    except Exception as e:
        print(f"Error saat memuat '{filename}': {e}")
        return []

def rewrite_json(filename, data):
    """Menulis ulang seluruh file JSON dengan data terbaru."""
    try:
        with open(filename, 'w', encoding='utf-8') as f:
            json.dump(data, f, indent=2)
    except Exception as e:
        print(f"Error saat menyimpan ke '{filename}': {e}")

def save_remaining_usernames(filename, remaining_list):
    """Menulis ulang file input hanya dengan username yang tersisa/gagal."""
    print(f"\n--- Menyimpan Progres Input ---")
    try:
        with open(filename, 'w', encoding='utf-8') as f:
            for username in remaining_list:
                f.write(username + '\n')
    except Exception as e:
        print(f"Gagal menulis file input: {e}")
    print(f"Input file '{filename}' telah diperbarui dengan {len(remaining_list)} username yang tersisa.")


async def get_user_ids_slow_mode():
    
    # 1. Muat hasil yang sudah ada
    results = load_existing_results(OUTPUT_FILE)
    
    # 2. Muat daftar username baru
    usernames_list = read_usernames(INPUT_FILE)
    if not usernames_list:
        print("List username kosong. Selesai.")
        return

    # 3. Filter username yang sudah ada di file JSON (agar tidak double)
    existing_usernames = {
        (item.get('username') or '').lstrip('@') 
        for item in results 
        if isinstance(item, dict) and item.get('username')
    }
    
    # Filter list_u.txt: hanya proses yang belum ada di results
    usernames_to_process = [
        name for name in usernames_list if name not in existing_usernames
    ]
    
    if not usernames_to_process:
        print("Semua user di list_u.txt sudah ada di user_ids.json. Selesai.")
        # Simpan list_u.txt yang bersih (kosong)
        save_remaining_usernames(INPUT_FILE, [])
        return

    print(f"Total {len(usernames_list)} username unik di file input.")
    print(f"Memproses {len(usernames_to_process)} username baru (sisanya sudah tersimpan).")
    print(f"Mode Anti-Flood aktif: Jeda {MIN_WAIT_TIME}-{MAX_WAIT_TIME} detik per user.")
    
    successful_usernames = set()
    
    try:
        async with Client(SESSION_NAME, API_ID, API_HASH, sleep_threshold=60) as app:
            await asyncio.sleep(5) 
            
            for index, username in enumerate(usernames_to_process):
                username_with_at = "@" + username 
                
                print(f"\n--- Memproses {index + 1}/{len(usernames_to_process)}: {username_with_at} ---")
                
                new_entry = None
                is_successful = False
                
                try:
                    # --- Proses Pengambilan ID ---
                    user = await app.get_users(username_with_at) 
                    
                    new_entry = {"id": user.id, "username": user.username}
                    print(f"✅ Ditemukan: {username_with_at} -> ID: {user.id}")
                    is_successful = True 
                    
                except FloodWait as e:
                    # Menangani FloodWait dan meminta pengguna untuk mematikan skrip
                    wait_time = e.value
                    print(f"\n⚠️ Sinyal FLOOD_WAIT: Harus menunggu {wait_time} detik.")
                    print("⚠️ Direkomendasikan: Matikan skrip (Ctrl+C) dan coba lagi nanti.")
                    await asyncio.sleep(wait_time + 5) 
                    
                    # Biarkan username ini tetap ada di file input untuk dicoba lagi nanti.

                except (UsernameInvalid, PeerIdInvalid):
                    new_entry = {"username": username, "error": "Username tidak valid/tidak ditemukan."}
                    print(f"❌ Gagal mendapatkan ID: Username tidak valid.")
                    is_successful = True # Dianggap 'selesai' agar dihapus dari list_u.txt

                except Exception as e:
                    new_entry = {"username": username, "error": str(e)}
                    print(f"❌ Gagal mendapatkan ID: {e}")
                    is_successful = True # Dianggap 'selesai' agar dihapus dari list_u.txt
                
                # --- PENYIMPANAN INKREMENTAL DAN CHECKPOINT ---
                if new_entry:
                    results.append(new_entry)
                    rewrite_json(OUTPUT_FILE, results)
                    print(f"💾 Hasil user {username_with_at} berhasil disimpan ke '{OUTPUT_FILE}'.")
                
                if is_successful:
                    successful_usernames.add(username) 
                    
                    # Hapus username yang berhasil/ditandai selesai dari daftar yang akan diproses
                    # dan simpan kembali file input (checkpointing)
                    usernames_list.remove(username)
                    save_remaining_usernames(INPUT_FILE, usernames_list)

                # --- KONTROL KECEPATAN: Jeda Acak ---
                if usernames_list: # Jika masih ada yang harus diproses
                    delay = random.uniform(MIN_WAIT_TIME, MAX_WAIT_TIME)
                    print(f"Menjeda {delay:.2f} detik sebelum memproses user berikutnya...")
                    await asyncio.sleep(delay) 

    except (KeyboardInterrupt, SystemExit):
        print("\nSkrip dihentikan oleh pengguna (Ctrl+C).")
    
    except Exception as e:
        print(f"\nError fatal tidak terduga: {e}")
        
    finally:
        # Finalisasi
        count_processed = len(results) - len(load_existing_results(OUTPUT_FILE))
        print(f"\n--- Sesi Selesai ---")
        print(f"Total user yang diproses di sesi ini: {count_processed}")
        print(f"Total user yang tersisa di '{INPUT_FILE}': {len(usernames_list)}")
        print(f"Total user di '{OUTPUT_FILE}': {len(results)}")


if __name__ == "__main__":
    if API_ID == 1234567 or API_HASH == "ANDA_HARUS_GANTI_INI_DENGAN_HASH_ASLI_ANDA":
        print("MOHON GANTI API_ID dan API_HASH di dalam skrip terlebih dahulu!")
    else:
        asyncio.run(get_user_ids_slow_mode())
