import asyncio
import json
from pyrogram import Client
from pyrogram.errors import FloodWait, UsernameInvalid, PeerIdInvalid, UserNotParticipant

# --- KONFIGURASI PENTING (Pertahankan yang sudah ada) ---
API_ID = 2316947 
API_HASH = "0967acc6bc907f7f694c4ffa8a8e3175" 
SESSION_NAME = "user_extractor_session"
INPUT_FILE = "list_u.txt"
OUTPUT_FILE = "user_ids.json"
# --------------------------------------------------------

def read_usernames(filename):
    """Membaca username dari file teks, membersihkan '@', dan mengembalikan daftar unik."""
    try:
        with open(filename, 'r', encoding='utf-8') as f:
            usernames = [line.strip().lstrip('@') for line in f if line.strip()]
        # Gunakan set() untuk memastikan semua username unik
        return list(set(usernames))
    except FileNotFoundError:
        print(f"Error: File '{filename}' tidak ditemukan.")
        return []

async def get_user_ids_slow_mode():
    usernames_list = read_usernames(INPUT_FILE)
    if not usernames_list:
        return

    print(f"Total {len(usernames_list)} username unik untuk diproses dengan batas 25/menit.")
    
    results = []
    
    # Kunci: Batas 25 username per batch
    BATCH_SIZE = 25 
    
    # Setting sleep_threshold sangat penting untuk penanganan FloodWait yang tidak terduga
    async with Client(SESSION_NAME, API_ID, API_HASH, sleep_threshold=60) as app:
        
        # Jeda awal 5 detik
        await asyncio.sleep(5) 
        
        for i in range(0, len(usernames_list), BATCH_SIZE):
            batch = usernames_list[i:i + BATCH_SIZE]
            batch_number = i // BATCH_SIZE + 1
            start_time = asyncio.get_event_loop().time()
            
            print(f"\n--- Memulai Batch #{batch_number}: ({i+1} sampai {min(i + BATCH_SIZE, len(usernames_list))}) ---")
            
            for username in batch:
                username_with_at = "@" + username 
                
                try:
                    # Ambil satu user per satu
                    user = await app.get_users(username_with_at) 
                    
                    user_info = {
                        "id": user.id,
                        "username": user.username
                    }
                    results.append(user_info)
                    print(f"✅ Ditemukan: {username_with_at} -> ID: {user.id}")
                    
                except FloodWait as e:
                    wait_time = e.value
                    print(f"\n⚠️ Sinyal FLOOD_WAIT: Harus menunggu selama {wait_time} detik. Menjeda...")
                    
                    # Tambahkan waktu tunggu yang disarankan + 5 detik buffer
                    await asyncio.sleep(wait_time + 5) 
                    
                    # Coba ulang username ini setelah jeda panjang
                    try:
                        user = await app.get_users(username_with_at) 
                        user_info = {"id": user.id, "username": user.username}
                        results.append(user_info)
                        print(f"✅ Ditemukan (setelah tunggu): {username_with_at} -> ID: {user.id}")
                    except Exception as retry_e:
                        results.append({"username": username, "error": str(retry_e)})
                        print(f"❌ Gagal (setelah tunggu) untuk {username_with_at}: {retry_e}")

                except (UsernameInvalid, PeerIdInvalid) as e:
                    # Menangani username yang tidak valid/dihapus/tidak ditemukan
                    results.append({"username": username, "error": "Username tidak valid/tidak ditemukan."})
                    print(f"❌ Gagal mendapatkan ID untuk {username_with_at}: Username tidak valid.")
                
                except Exception as e:
                    # Menangani error umum lainnya
                    results.append({"username": username, "error": str(e)})
                    print(f"❌ Gagal mendapatkan ID untuk {username_with_at}: {e}")

            # --- KONTROL KECEPATAN: Jeda 60 detik setelah 25 username ---
            
            end_time = asyncio.get_event_loop().time()
            elapsed_time = end_time - start_time
            
            # Waktu target: 60.0 detik untuk 25 permintaan
            TARGET_WAIT = 60.0
            wait_needed = TARGET_WAIT - elapsed_time
            
            if wait_needed > 0 and (i + BATCH_SIZE) < len(usernames_list):
                print(f"\n⏳ Batch #{batch_number} selesai dalam {elapsed_time:.2f} detik.")
                print(f"Menunggu sisa {wait_needed:.2f} detik untuk mencapai batas 60 detik/batch (25 user/menit)...")
                await asyncio.sleep(wait_needed)
            elif (i + BATCH_SIZE) < len(usernames_list):
                 print(f"\n⏳ Batch #{batch_number} selesai, melanjutkan ke batch berikutnya.")


        # Menyimpan hasil ke file JSON
        # (Pastikan Anda menggunakan kode penyimpanan JSON yang Anda inginkan di sini)
        with open(OUTPUT_FILE, 'w', encoding='utf-8') as f:
            json.dump(results, f, indent=2)
            
        print(f"\n--- Selesai ---")
        print(f"Total {len(results)} entri diproses. Hasil disimpan di '{OUTPUT_FILE}'")
            
if __name__ == "__main__":
    if API_ID == 1234567 or API_HASH == "ANDA_HARUS_GANTI_INI_DENGAN_HASH_ASLI_ANDA":
        print("MOHON GANTI API_ID dan API_HASH di dalam skrip terlebih dahulu!")
    else:
        asyncio.run(get_user_ids_slow_mode())
