import asyncio
import json
from pyrogram import Client
from pyrogram.errors import FloodWait, UsernameInvalid, PeerIdInvalid
import os # Diperlukan untuk operasi file

# --- KONFIGURASI PENTING (Harap Ganti dengan data Anda) ---
API_ID = 2316947 
API_HASH = "0967acc6bc907f7f694c4ffa8a8e3175" 
SESSION_NAME = "user_extractor_session"
INPUT_FILE = "list_u.txt"
OUTPUT_FILE = "user_ids.json"
# --------------------------------------------------------

def read_usernames(filename):
    """Membaca username dari file teks, membersihkan '@', dan mengembalikan daftar unik."""
    try:
        with open(filename, 'r', encoding='utf-8') as f:
            usernames = [line.strip().lstrip('@') for line in f if line.strip()]
        return list(set(usernames))
    except FileNotFoundError:
        print(f"Error: File '{filename}' tidak ditemukan.")
        return []

def save_remaining_usernames(filename, remaining_list):
    """Menulis ulang file input hanya dengan username yang tersisa/gagal."""
    print(f"\n--- Menyimpan Progres ---")
    print(f"Menulis kembali {len(remaining_list)} username yang tersisa ke '{filename}'.")
    try:
        with open(filename, 'w', encoding='utf-8') as f:
            for username in remaining_list:
                f.write(username + '\n')
    except Exception as e:
        print(f"Gagal menulis file input: {e}")
    print("Progres berhasil disimpan.")


async def get_user_ids_slow_mode():
    usernames_list = read_usernames(INPUT_FILE)
    if not usernames_list:
        return

    print(f"Total {len(usernames_list)} username unik untuk diproses.")
    print("Mode lambat aktif: 1 user akan diproses setiap 5 detik.")
    
    # List untuk menyimpan semua hasil JSON
    results = [] 
    # List untuk melacak username yang berhasil agar bisa dihapus dari file input
    successful_usernames = []
    
    # Setting sleep_threshold sangat penting untuk penanganan FloodWait
    async with Client(SESSION_NAME, API_ID, API_HASH, sleep_threshold=60) as app:
        
        await asyncio.sleep(5) 
        
        for index, username in enumerate(usernames_list):
            username_with_at = "@" + username 
            
            print(f"\n--- Memproses #{index + 1} dari {len(usernames_list)}: {username_with_at} ---")
            
            # --- START: Proses Pengambilan ID ---
            is_successful = False
            
            try:
                user = await app.get_users(username_with_at) 
                
                user_info = {
                    "id": user.id,
                    "username": user.username
                }
                results.append(user_info)
                print(f"✅ Ditemukan: {username_with_at} -> ID: {user.id}")
                is_successful = True # Set sukses
                
            except FloodWait as e:
                wait_time = e.value
                print(f"\n⚠️ Sinyal FLOOD_WAIT: Harus menunggu selama {wait_time} detik. Menjeda...")
                
                await asyncio.sleep(wait_time + 5) 
                
                # Coba ulang username ini setelah jeda panjang
                try:
                    user = await app.get_users(username_with_at) 
                    user_info = {"id": user.id, "username": user.username}
                    results.append(user_info)
                    print(f"✅ Ditemukan (setelah tunggu): {username_with_at} -> ID: {user.id}")
                    is_successful = True # Set sukses setelah retry
                except Exception as retry_e:
                    results.append({"username": username, "error": str(retry_e)})
                    print(f"❌ Gagal (setelah tunggu) untuk {username_with_at}: {retry_e}")

            except (UsernameInvalid, PeerIdInvalid) as e:
                results.append({"username": username, "error": "Username tidak valid/tidak ditemukan."})
                print(f"❌ Gagal mendapatkan ID untuk {username_with_at}: Username tidak valid.")
            
            except Exception as e:
                results.append({"username": username, "error": str(e)})
                print(f"❌ Gagal mendapatkan ID untuk {username_with_at}: {e}")
            # --- END: Proses Pengambilan ID ---

            # --- CHECKPOINT: Tandai username berhasil ---
            if is_successful:
                successful_usernames.append(username)
            
            # --- KONTROL KECEPATAN: Jeda 5 detik antar user ---
            if index < len(usernames_list) - 1:
                print("Menjeda 5 detik sebelum memproses user berikutnya...")
                await asyncio.sleep(5) 
            

    # --- FINALISASI DAN CHECKPOINTING ---
    
    # 1. Simpan semua hasil ke file JSON
    with open(OUTPUT_FILE, 'w', encoding='utf-8') as f:
        json.dump(results, f, indent=2)
    print(f"\n--- Selesai ---")
    print(f"Hasil berhasil disimpan di '{OUTPUT_FILE}'.")
    
    # 2. Hitung username yang belum diproses dan hapus yang berhasil dari file input
    usernames_to_keep = [
        name for name in usernames_list if name not in successful_usernames
    ]
    
    save_remaining_usernames(INPUT_FILE, usernames_to_keep)
    print(f"Total {len(successful_usernames)} user berhasil dihapus dari '{INPUT_FILE}'.")


if __name__ == "__main__":
    if API_ID == 1234567 or API_HASH == "ANDA_HARUS_GANTI_INI_DENGAN_HASH_ASLI_ANDA":
        print("MOHON GANTI API_ID dan API_HASH di dalam skrip terlebih dahulu!")
    else:
        # PENTING: Pastikan Anda telah menunggu jeda FLOOD_WAIT sebelumnya!
        asyncio.run(get_user_ids_slow_mode())
